/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.common.core.util;

public final class HashUtil {
    protected static final int CONSTANT = 17;
    protected static final int PRIME = 37;

    private HashUtil() {
    }

    public static int hash(int base, boolean field) {
        return 37 * base + (field ? 0 : 1);
    }

    public static int hash(boolean field) {
        return HashUtil.hash(17, field);
    }

    public static int hash(int base, byte field) {
        return 37 * base + field;
    }

    public static int hash(byte field) {
        return HashUtil.hash(17, field);
    }

    public static int hash(int base, char field) {
        return 37 * base + field;
    }

    public static int hash(char field) {
        return HashUtil.hash(17, field);
    }

    public static int hash(int base, short field) {
        return 37 * base + field;
    }

    public static int hash(short field) {
        return HashUtil.hash(17, field);
    }

    public static int hash(int base, int field) {
        return 37 * base + field;
    }

    public static int hash(int field) {
        return HashUtil.hash(17, field);
    }

    public static int hash(int base, long field) {
        return 37 * base + (int)(field ^ field >>> 32);
    }

    public static int hash(long field) {
        return HashUtil.hash(17, field);
    }

    public static int hash(int base, float field) {
        return 37 * base + Float.floatToIntBits(field);
    }

    public static int hash(float field) {
        return HashUtil.hash(17, field);
    }

    public static int hash(int base, double field) {
        return HashUtil.hash(base, Double.doubleToLongBits(field));
    }

    public static int hash(double field) {
        return HashUtil.hash(17, field);
    }

    public static int hash(int base, Object object) {
        return 37 * base + (object == null ? 0 : object.hashCode());
    }

    public static int hash(Object object) {
        return HashUtil.hash(17, object);
    }
}

