/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.graphdef.editor.part;

import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.gmfgraph.Canvas;
import org.eclipse.gmf.gmfgraph.GMFGraphPackage;
import org.eclipse.gmf.graphdef.editor.part.GMFGraphDiagramEditorPlugin;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;

public class GMFGraphVisualIDRegistry {
    private static final String DEBUG_KEY = String.valueOf(GMFGraphDiagramEditorPlugin.getInstance().getBundle().getSymbolicName()) + "/debug/visualID";

    public static int getVisualID(View view) {
        if (view instanceof Diagram) {
            if ("GMFGraph".equals(view.getType())) {
                return 1000;
            }
            return -1;
        }
        return GMFGraphVisualIDRegistry.getVisualID(view.getType());
    }

    public static String getModelID(View view) {
        Diagram diagram = view.getDiagram();
        while (view != diagram) {
            EAnnotation annotation = view.getEAnnotation("Shortcut");
            if (annotation != null) {
                return (String)annotation.getDetails().get((Object)"modelID");
            }
            view = (View)view.eContainer();
        }
        return diagram != null ? diagram.getType() : null;
    }

    public static int getVisualID(String type) {
        try {
            return Integer.parseInt(type);
        }
        catch (NumberFormatException numberFormatException) {
            if (Boolean.TRUE.toString().equalsIgnoreCase(Platform.getDebugOption((String)DEBUG_KEY))) {
                GMFGraphDiagramEditorPlugin.getInstance().logError("Unable to parse view type as a visualID number: " + type);
            }
            return -1;
        }
    }

    public static String getType(int visualID) {
        return String.valueOf(visualID);
    }

    public static int getDiagramVisualID(EObject domainElement) {
        if (domainElement == null) {
            return -1;
        }
        if (GMFGraphPackage.eINSTANCE.getCanvas().isSuperTypeOf(domainElement.eClass()) && GMFGraphVisualIDRegistry.isDiagram((Canvas)domainElement)) {
            return 1000;
        }
        return -1;
    }

    public static int getNodeVisualID(View containerView, EObject domainElement) {
        if (domainElement == null || !"GMFGraph".equals(GMFGraphVisualIDRegistry.getModelID(containerView))) {
            return -1;
        }
        switch (GMFGraphVisualIDRegistry.getVisualID(containerView)) {
            case 3009: {
                if (GMFGraphPackage.eINSTANCE.getRectangle().isSuperTypeOf(domainElement.eClass())) {
                    return 3010;
                }
                if (GMFGraphPackage.eINSTANCE.getEllipse().isSuperTypeOf(domainElement.eClass())) {
                    return 3015;
                }
                if (GMFGraphPackage.eINSTANCE.getRoundedRectangle().isSuperTypeOf(domainElement.eClass())) {
                    return 3016;
                }
                if (!GMFGraphPackage.eINSTANCE.getPolyline().isSuperTypeOf(domainElement.eClass())) break;
                return 3017;
            }
            case 3010: {
                if (GMFGraphPackage.eINSTANCE.getRectangle().isSuperTypeOf(domainElement.eClass())) {
                    return 3011;
                }
                if (GMFGraphPackage.eINSTANCE.getEllipse().isSuperTypeOf(domainElement.eClass())) {
                    return 3012;
                }
                if (GMFGraphPackage.eINSTANCE.getRoundedRectangle().isSuperTypeOf(domainElement.eClass())) {
                    return 3013;
                }
                if (!GMFGraphPackage.eINSTANCE.getPolyline().isSuperTypeOf(domainElement.eClass())) break;
                return 3014;
            }
            case 3011: {
                if (GMFGraphPackage.eINSTANCE.getRectangle().isSuperTypeOf(domainElement.eClass())) {
                    return 3011;
                }
                if (GMFGraphPackage.eINSTANCE.getEllipse().isSuperTypeOf(domainElement.eClass())) {
                    return 3012;
                }
                if (GMFGraphPackage.eINSTANCE.getRoundedRectangle().isSuperTypeOf(domainElement.eClass())) {
                    return 3013;
                }
                if (!GMFGraphPackage.eINSTANCE.getPolyline().isSuperTypeOf(domainElement.eClass())) break;
                return 3014;
            }
            case 3012: {
                if (GMFGraphPackage.eINSTANCE.getRectangle().isSuperTypeOf(domainElement.eClass())) {
                    return 3011;
                }
                if (GMFGraphPackage.eINSTANCE.getEllipse().isSuperTypeOf(domainElement.eClass())) {
                    return 3012;
                }
                if (GMFGraphPackage.eINSTANCE.getRoundedRectangle().isSuperTypeOf(domainElement.eClass())) {
                    return 3013;
                }
                if (!GMFGraphPackage.eINSTANCE.getPolyline().isSuperTypeOf(domainElement.eClass())) break;
                return 3014;
            }
            case 3013: {
                if (GMFGraphPackage.eINSTANCE.getRectangle().isSuperTypeOf(domainElement.eClass())) {
                    return 3011;
                }
                if (GMFGraphPackage.eINSTANCE.getEllipse().isSuperTypeOf(domainElement.eClass())) {
                    return 3012;
                }
                if (GMFGraphPackage.eINSTANCE.getRoundedRectangle().isSuperTypeOf(domainElement.eClass())) {
                    return 3013;
                }
                if (!GMFGraphPackage.eINSTANCE.getPolyline().isSuperTypeOf(domainElement.eClass())) break;
                return 3014;
            }
            case 3015: {
                if (GMFGraphPackage.eINSTANCE.getRectangle().isSuperTypeOf(domainElement.eClass())) {
                    return 3011;
                }
                if (GMFGraphPackage.eINSTANCE.getEllipse().isSuperTypeOf(domainElement.eClass())) {
                    return 3012;
                }
                if (GMFGraphPackage.eINSTANCE.getRoundedRectangle().isSuperTypeOf(domainElement.eClass())) {
                    return 3013;
                }
                if (!GMFGraphPackage.eINSTANCE.getPolyline().isSuperTypeOf(domainElement.eClass())) break;
                return 3014;
            }
            case 3016: {
                if (GMFGraphPackage.eINSTANCE.getRectangle().isSuperTypeOf(domainElement.eClass())) {
                    return 3011;
                }
                if (GMFGraphPackage.eINSTANCE.getEllipse().isSuperTypeOf(domainElement.eClass())) {
                    return 3012;
                }
                if (GMFGraphPackage.eINSTANCE.getRoundedRectangle().isSuperTypeOf(domainElement.eClass())) {
                    return 3013;
                }
                if (!GMFGraphPackage.eINSTANCE.getPolyline().isSuperTypeOf(domainElement.eClass())) break;
                return 3014;
            }
            case 3018: {
                if (GMFGraphPackage.eINSTANCE.getRectangle().isSuperTypeOf(domainElement.eClass())) {
                    return 3011;
                }
                if (GMFGraphPackage.eINSTANCE.getEllipse().isSuperTypeOf(domainElement.eClass())) {
                    return 3012;
                }
                if (GMFGraphPackage.eINSTANCE.getRoundedRectangle().isSuperTypeOf(domainElement.eClass())) {
                    return 3013;
                }
                if (!GMFGraphPackage.eINSTANCE.getPolyline().isSuperTypeOf(domainElement.eClass())) break;
                return 3014;
            }
            case 3019: {
                if (GMFGraphPackage.eINSTANCE.getRectangle().isSuperTypeOf(domainElement.eClass())) {
                    return 3011;
                }
                if (GMFGraphPackage.eINSTANCE.getEllipse().isSuperTypeOf(domainElement.eClass())) {
                    return 3012;
                }
                if (GMFGraphPackage.eINSTANCE.getRoundedRectangle().isSuperTypeOf(domainElement.eClass())) {
                    return 3013;
                }
                if (!GMFGraphPackage.eINSTANCE.getPolyline().isSuperTypeOf(domainElement.eClass())) break;
                return 3014;
            }
            case 3020: {
                if (GMFGraphPackage.eINSTANCE.getRectangle().isSuperTypeOf(domainElement.eClass())) {
                    return 3011;
                }
                if (GMFGraphPackage.eINSTANCE.getEllipse().isSuperTypeOf(domainElement.eClass())) {
                    return 3012;
                }
                if (GMFGraphPackage.eINSTANCE.getRoundedRectangle().isSuperTypeOf(domainElement.eClass())) {
                    return 3013;
                }
                if (!GMFGraphPackage.eINSTANCE.getPolyline().isSuperTypeOf(domainElement.eClass())) break;
                return 3014;
            }
            case 7008: {
                if (GMFGraphPackage.eINSTANCE.getFigureDescriptor().isSuperTypeOf(domainElement.eClass())) {
                    return 3009;
                }
                if (GMFGraphPackage.eINSTANCE.getRectangle().isSuperTypeOf(domainElement.eClass())) {
                    return 3018;
                }
                if (GMFGraphPackage.eINSTANCE.getEllipse().isSuperTypeOf(domainElement.eClass())) {
                    return 3019;
                }
                if (GMFGraphPackage.eINSTANCE.getRoundedRectangle().isSuperTypeOf(domainElement.eClass())) {
                    return 3020;
                }
                if (!GMFGraphPackage.eINSTANCE.getPolyline().isSuperTypeOf(domainElement.eClass())) break;
                return 3021;
            }
            case 1000: {
                if (GMFGraphPackage.eINSTANCE.getCompartment().isSuperTypeOf(domainElement.eClass())) {
                    return 2005;
                }
                if (GMFGraphPackage.eINSTANCE.getNode().isSuperTypeOf(domainElement.eClass())) {
                    return 2006;
                }
                if (GMFGraphPackage.eINSTANCE.getConnection().isSuperTypeOf(domainElement.eClass())) {
                    return 2007;
                }
                if (!GMFGraphPackage.eINSTANCE.getFigureGallery().isSuperTypeOf(domainElement.eClass())) break;
                return 2008;
            }
        }
        return -1;
    }

    public static boolean canCreateNode(View containerView, int nodeVisualID) {
        int containerVisualID;
        String containerModelID = GMFGraphVisualIDRegistry.getModelID(containerView);
        if (!"GMFGraph".equals(containerModelID) && !"GMFGraph".equals(containerModelID)) {
            return false;
        }
        if ("GMFGraph".equals(containerModelID)) {
            containerVisualID = GMFGraphVisualIDRegistry.getVisualID(containerView);
        } else if (containerView instanceof Diagram) {
            containerVisualID = 1000;
        } else {
            return false;
        }
        switch (containerVisualID) {
            case 2005: {
                if (5005 == nodeVisualID) {
                    return true;
                }
                if (7005 != nodeVisualID) break;
                return true;
            }
            case 2006: {
                if (5006 == nodeVisualID) {
                    return true;
                }
                if (7006 != nodeVisualID) break;
                return true;
            }
            case 2007: {
                if (5007 == nodeVisualID) {
                    return true;
                }
                if (7007 != nodeVisualID) break;
                return true;
            }
            case 2008: {
                if (5009 == nodeVisualID) {
                    return true;
                }
                if (7008 != nodeVisualID) break;
                return true;
            }
            case 3009: {
                if (5008 == nodeVisualID) {
                    return true;
                }
                if (3010 == nodeVisualID) {
                    return true;
                }
                if (3015 == nodeVisualID) {
                    return true;
                }
                if (3016 == nodeVisualID) {
                    return true;
                }
                if (3017 != nodeVisualID) break;
                return true;
            }
            case 3010: {
                if (3011 == nodeVisualID) {
                    return true;
                }
                if (3012 == nodeVisualID) {
                    return true;
                }
                if (3013 == nodeVisualID) {
                    return true;
                }
                if (3014 != nodeVisualID) break;
                return true;
            }
            case 3011: {
                if (3011 == nodeVisualID) {
                    return true;
                }
                if (3012 == nodeVisualID) {
                    return true;
                }
                if (3013 == nodeVisualID) {
                    return true;
                }
                if (3014 != nodeVisualID) break;
                return true;
            }
            case 3012: {
                if (3011 == nodeVisualID) {
                    return true;
                }
                if (3012 == nodeVisualID) {
                    return true;
                }
                if (3013 == nodeVisualID) {
                    return true;
                }
                if (3014 != nodeVisualID) break;
                return true;
            }
            case 3013: {
                if (3011 == nodeVisualID) {
                    return true;
                }
                if (3012 == nodeVisualID) {
                    return true;
                }
                if (3013 == nodeVisualID) {
                    return true;
                }
                if (3014 != nodeVisualID) break;
                return true;
            }
            case 3015: {
                if (3011 == nodeVisualID) {
                    return true;
                }
                if (3012 == nodeVisualID) {
                    return true;
                }
                if (3013 == nodeVisualID) {
                    return true;
                }
                if (3014 != nodeVisualID) break;
                return true;
            }
            case 3016: {
                if (3011 == nodeVisualID) {
                    return true;
                }
                if (3012 == nodeVisualID) {
                    return true;
                }
                if (3013 == nodeVisualID) {
                    return true;
                }
                if (3014 != nodeVisualID) break;
                return true;
            }
            case 3018: {
                if (3011 == nodeVisualID) {
                    return true;
                }
                if (3012 == nodeVisualID) {
                    return true;
                }
                if (3013 == nodeVisualID) {
                    return true;
                }
                if (3014 != nodeVisualID) break;
                return true;
            }
            case 3019: {
                if (3011 == nodeVisualID) {
                    return true;
                }
                if (3012 == nodeVisualID) {
                    return true;
                }
                if (3013 == nodeVisualID) {
                    return true;
                }
                if (3014 != nodeVisualID) break;
                return true;
            }
            case 3020: {
                if (3011 == nodeVisualID) {
                    return true;
                }
                if (3012 == nodeVisualID) {
                    return true;
                }
                if (3013 == nodeVisualID) {
                    return true;
                }
                if (3014 != nodeVisualID) break;
                return true;
            }
            case 7008: {
                if (3009 == nodeVisualID) {
                    return true;
                }
                if (3018 == nodeVisualID) {
                    return true;
                }
                if (3019 == nodeVisualID) {
                    return true;
                }
                if (3020 == nodeVisualID) {
                    return true;
                }
                if (3021 != nodeVisualID) break;
                return true;
            }
            case 1000: {
                if (2005 == nodeVisualID) {
                    return true;
                }
                if (2006 == nodeVisualID) {
                    return true;
                }
                if (2007 == nodeVisualID) {
                    return true;
                }
                if (2008 != nodeVisualID) break;
                return true;
            }
        }
        return false;
    }

    public static int getLinkWithClassVisualID(EObject domainElement) {
        if (domainElement == null) {
            return -1;
        }
        if (GMFGraphPackage.eINSTANCE.getChildAccess().isSuperTypeOf(domainElement.eClass())) {
            return 4002;
        }
        return -1;
    }

    private static boolean isDiagram(Canvas element) {
        return true;
    }
}

