/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.graphdef.editor.edit.parts;

import java.util.Collections;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Ellipse;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.FreeformLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.StackLayout;
import org.eclipse.draw2d.XYLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.workspace.AbstractEMFOperation;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.editpolicies.LayoutEditPolicy;
import org.eclipse.gmf.gmfgraph.AbstractFigure;
import org.eclipse.gmf.gmfgraph.Color;
import org.eclipse.gmf.gmfgraph.ConstantColor;
import org.eclipse.gmf.gmfgraph.GMFGraphFactory;
import org.eclipse.gmf.gmfgraph.GMFGraphPackage;
import org.eclipse.gmf.gmfgraph.LayoutData;
import org.eclipse.gmf.gmfgraph.Layoutable;
import org.eclipse.gmf.gmfgraph.Point;
import org.eclipse.gmf.gmfgraph.RGBColor;
import org.eclipse.gmf.gmfgraph.XYLayoutData;
import org.eclipse.gmf.graphdef.editor.edit.parts.AbstractFigureEditPart;
import org.eclipse.gmf.graphdef.editor.edit.policies.Ellipse2CanonicalEditPolicy;
import org.eclipse.gmf.graphdef.editor.edit.policies.Ellipse2ItemSemanticEditPolicy;
import org.eclipse.gmf.graphdef.editor.part.GMFGraphDiagramEditorPlugin;
import org.eclipse.gmf.runtime.diagram.core.listener.NotificationListener;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.CreationEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.DragDropEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.ResizableShapeEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.XYLayoutEditPolicy;
import org.eclipse.gmf.runtime.gef.ui.figures.DefaultSizeNodeFigure;
import org.eclipse.gmf.runtime.gef.ui.figures.NodeFigure;
import org.eclipse.gmf.runtime.notation.Bounds;
import org.eclipse.gmf.runtime.notation.FillStyle;
import org.eclipse.gmf.runtime.notation.LineStyle;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;

public class Ellipse2EditPart
extends AbstractFigureEditPart {
    public static final int VISUAL_ID = 3015;
    protected IFigure contentPane;
    protected IFigure primaryShape;
    private EllipseFigure myFigure;
    protected Figure myNodeFigure;

    public Ellipse2EditPart(View view) {
        super(view);
    }

    protected void createDefaultEditPolicies() {
        this.installEditPolicy("CreationPolicy", (EditPolicy)new CreationEditPolicy());
        super.createDefaultEditPolicies();
        this.installEditPolicy("SemanticPolicy", (EditPolicy)new Ellipse2ItemSemanticEditPolicy());
        this.installEditPolicy("DragDropPolicy", (EditPolicy)new DragDropEditPolicy());
        this.installEditPolicy("Canonical", (EditPolicy)new Ellipse2CanonicalEditPolicy());
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)this.createLayoutEditPolicy());
    }

    protected LayoutEditPolicy createLayoutEditPolicy() {
        XYLayoutEditPolicy lep = new XYLayoutEditPolicy(){

            protected EditPolicy createChildEditPolicy(EditPart child) {
                EditPolicy result = super.createChildEditPolicy(child);
                if (result == null) {
                    return new ResizableShapeEditPolicy();
                }
                return result;
            }

            protected org.eclipse.draw2d.geometry.Point getLayoutOrigin() {
                return ((org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart)this.getHost()).getContentPane().getClientArea().getLocation();
            }

            protected Rectangle getCurrentConstraintFor(GraphicalEditPart child) {
                Rectangle result = super.getCurrentConstraintFor(child);
                if (result == null) {
                    IFigure fig = child.getFigure();
                    result = fig.getBounds().getCopy();
                }
                return result;
            }
        };
        return lep;
    }

    protected IFigure createNodeShape() {
        EllipseFigure figure = new EllipseFigure();
        figure.setUseLocalCoordinates(true);
        this.myFigure = figure;
        org.eclipse.gmf.gmfgraph.Ellipse modelElement = (org.eclipse.gmf.gmfgraph.Ellipse)((View)this.getModel()).getElement();
        if (modelElement != null) {
            this.layoutDataChanged(modelElement.getLayoutData());
            this.layoutChanged(modelElement.getLayout());
            this.myFigure.setOutline(modelElement.isOutline());
            this.myFigure.setFill(modelElement.isFill());
            this.myFigure.setLineWidth(modelElement.getLineWidth());
            this.myFigure.setLineStyle(this.getLineStyle(modelElement.getLineKind()));
            this.myFigure.setFillXOR(modelElement.isXorFill());
            this.myFigure.setOutlineXOR(modelElement.isXorOutline());
        }
        this.primaryShape = figure;
        return this.primaryShape;
    }

    public EllipseFigure getPrimaryShape() {
        return (EllipseFigure)this.primaryShape;
    }

    protected NodeFigure createNodePlate() {
        DefaultSizeNodeFigure result = new DefaultSizeNodeFigure(this.getMapMode().DPtoLP(40), this.getMapMode().DPtoLP(40));
        this.myNodeFigure = result;
        return result;
    }

    protected NodeFigure createNodeFigure() {
        NodeFigure figure = this.createNodePlate();
        figure.setLayoutManager((LayoutManager)new StackLayout());
        IFigure shape = this.createNodeShape();
        figure.add(shape);
        this.contentPane = this.setupContentPane(shape);
        return figure;
    }

    protected IFigure setupContentPane(IFigure nodeShape) {
        if (nodeShape.getLayoutManager() == null) {
            nodeShape.setLayoutManager((LayoutManager)new FreeformLayout(){

                public Object getConstraint(IFigure figure) {
                    Object result = this.constraints.get(figure);
                    if (result == null) {
                        result = new Rectangle(0, 0, -1, -1);
                    }
                    return result;
                }
            });
        }
        return nodeShape;
    }

    public IFigure getContentPane() {
        if (this.contentPane != null) {
            return this.contentPane;
        }
        return super.getContentPane();
    }

    public void activate() {
        int locationY;
        int locationX;
        int sizeY;
        int sizeX;
        if (this.isActive()) {
            return;
        }
        View view = (View)this.getModel();
        if (view.getElement() == null) {
            super.activate();
            return;
        }
        final org.eclipse.gmf.gmfgraph.Ellipse modelElement = (org.eclipse.gmf.gmfgraph.Ellipse)view.getElement();
        final NotificationListener Layoutable_LayoutData_PropertiesListener = new NotificationListener(){

            public void notifyChanged(Notification notification) {
                Ellipse2EditPart.this.layoutDataChanged(modelElement.getLayoutData());
            }
        };
        if (modelElement.getLayoutData() != null) {
            this.addListenerFilter("Layoutable_LayoutData_PropertiesListener", Layoutable_LayoutData_PropertiesListener, (EObject)modelElement.getLayoutData());
        }
        this.addListenerFilter("Layoutable_LayoutData_Listener", new NotificationListener(){

            public void notifyChanged(Notification notification) {
                Ellipse2EditPart.this.removeListenerFilter("Layoutable_LayoutData_PropertiesListener");
                if (modelElement.getLayoutData() != null) {
                    Ellipse2EditPart.this.addListenerFilter("Layoutable_LayoutData_PropertiesListener", Layoutable_LayoutData_PropertiesListener, (EObject)modelElement.getLayoutData());
                }
                Ellipse2EditPart.this.layoutDataChanged(modelElement.getLayoutData());
            }
        }, (EObject)modelElement, (EStructuralFeature)GMFGraphPackage.eINSTANCE.getLayoutable_LayoutData());
        final NotificationListener Layoutable_Layout_PropertiesListener = new NotificationListener(){

            public void notifyChanged(Notification notification) {
                Ellipse2EditPart.this.layoutChanged(modelElement.getLayout());
            }
        };
        if (modelElement.getLayout() != null) {
            this.addListenerFilter("Layoutable_Layout_PropertiesListener", Layoutable_Layout_PropertiesListener, (EObject)modelElement.getLayout());
        }
        this.addListenerFilter("Layoutable_Layout_Listener", new NotificationListener(){

            public void notifyChanged(Notification notification) {
                Ellipse2EditPart.this.removeListenerFilter("Layoutable_Layout_PropertiesListener");
                if (modelElement.getLayout() != null) {
                    Ellipse2EditPart.this.addListenerFilter("Layoutable_Layout_PropertiesListener", Layoutable_Layout_PropertiesListener, (EObject)modelElement.getLayout());
                }
                Ellipse2EditPart.this.layoutChanged(modelElement.getLayout());
            }
        }, (EObject)modelElement, (EStructuralFeature)GMFGraphPackage.eINSTANCE.getLayoutable_Layout());
        this.addListenerFilter("Shape_Outline_Listener", new NotificationListener(){

            public void notifyChanged(Notification notification) {
                Ellipse2EditPart.this.myFigure.setOutline(modelElement.isOutline());
            }
        }, (EObject)modelElement, (EStructuralFeature)GMFGraphPackage.eINSTANCE.getShape_Outline());
        this.addListenerFilter("Shape_Fill_Listener", new NotificationListener(){

            public void notifyChanged(Notification notification) {
                Ellipse2EditPart.this.myFigure.setFill(modelElement.isFill());
            }
        }, (EObject)modelElement, (EStructuralFeature)GMFGraphPackage.eINSTANCE.getShape_Fill());
        this.addListenerFilter("Shape_LineWidth_Listener", new NotificationListener(){

            public void notifyChanged(Notification notification) {
                Ellipse2EditPart.this.myFigure.setLineWidth(modelElement.getLineWidth());
            }
        }, (EObject)modelElement, (EStructuralFeature)GMFGraphPackage.eINSTANCE.getShape_LineWidth());
        this.addListenerFilter("Shape_LineKind_Listener", new NotificationListener(){

            public void notifyChanged(Notification notification) {
                Ellipse2EditPart.this.myFigure.setLineStyle(Ellipse2EditPart.this.getLineStyle(modelElement.getLineKind()));
            }
        }, (EObject)modelElement, (EStructuralFeature)GMFGraphPackage.eINSTANCE.getShape_LineKind());
        this.addListenerFilter("Shape_XorFill_Listener", new NotificationListener(){

            public void notifyChanged(Notification notification) {
                Ellipse2EditPart.this.myFigure.setFillXOR(modelElement.isXorFill());
            }
        }, (EObject)modelElement, (EStructuralFeature)GMFGraphPackage.eINSTANCE.getShape_XorFill());
        this.addListenerFilter("Shape_XorOutline_Listener", new NotificationListener(){

            public void notifyChanged(Notification notification) {
                Ellipse2EditPart.this.myFigure.setOutlineXOR(modelElement.isXorOutline());
            }
        }, (EObject)modelElement, (EStructuralFeature)GMFGraphPackage.eINSTANCE.getShape_XorOutline());
        final Bounds bounds = (Bounds)((Node)view).getLayoutConstraint();
        if (modelElement.getPreferredSize() != null) {
            sizeX = this.getMapMode().DPtoLP(modelElement.getPreferredSize().getDx());
            sizeY = this.getMapMode().DPtoLP(modelElement.getPreferredSize().getDy());
        } else {
            sizeX = this.getMapMode().DPtoLP(20);
            sizeY = this.getMapMode().DPtoLP(20);
        }
        if (modelElement.getLocation() != null) {
            locationX = this.getMapMode().DPtoLP(modelElement.getLocation().getX());
            locationY = this.getMapMode().DPtoLP(modelElement.getLocation().getY());
        } else {
            locationX = bounds.getX();
            locationY = bounds.getY();
        }
        if (sizeX != bounds.getWidth() || sizeY != bounds.getHeight() || locationX != bounds.getX() || locationY != bounds.getY()) {
            try {
                new AbstractEMFOperation(this.getEditingDomain(), "Synchronizing view size with the model", Collections.singletonMap("unprotected", Boolean.TRUE)){

                    protected IStatus doExecute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                        bounds.setX(locationX);
                        bounds.setY(locationY);
                        bounds.setWidth(sizeX);
                        bounds.setHeight(sizeY);
                        return Status.OK_STATUS;
                    }
                }.execute((IProgressMonitor)new NullProgressMonitor(), null);
            }
            catch (ExecutionException e) {
                GMFGraphDiagramEditorPlugin.getInstance().logError("Unable to synchronize view size with the model", e);
            }
        }
        this.addListenerFilter("BoundsListener", new NotificationListener(){

            public void notifyChanged(final Notification notification) {
                try {
                    new AbstractEMFOperation(Ellipse2EditPart.this.getEditingDomain(), "Synchronizing model size with the view", Collections.singletonMap("unprotected", Boolean.TRUE)){

                        protected IStatus doExecute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                            Point location;
                            Bounds bounds = (Bounds)notification.getNotifier();
                            org.eclipse.gmf.gmfgraph.Dimension dim = modelElement.getPreferredSize();
                            if (dim == null) {
                                dim = GMFGraphFactory.eINSTANCE.createDimension();
                                modelElement.setPreferredSize(dim);
                            }
                            if ((location = modelElement.getLocation()) == null) {
                                location = GMFGraphFactory.eINSTANCE.createPoint();
                                modelElement.setLocation(location);
                            }
                            int x = Ellipse2EditPart.this.getMapMode().LPtoDP(bounds.getX());
                            int y = Ellipse2EditPart.this.getMapMode().LPtoDP(bounds.getY());
                            int width = Ellipse2EditPart.this.getMapMode().LPtoDP(bounds.getWidth());
                            int height = Ellipse2EditPart.this.getMapMode().LPtoDP(bounds.getHeight());
                            if (location.getX() != x || location.getY() != y) {
                                location.setX(x);
                                location.setY(y);
                            }
                            if (dim.getDx() != width || dim.getDy() != height) {
                                dim.setDx(width);
                                dim.setDy(height);
                            }
                            (this).Ellipse2EditPart.this.myNodeFigure.setPreferredSize(bounds.getWidth(), bounds.getHeight());
                            (this).Ellipse2EditPart.this.myNodeFigure.setLocation(new org.eclipse.draw2d.geometry.Point(bounds.getX(), bounds.getY()));
                            if (modelElement.getLayoutData() instanceof XYLayoutData || modelElement.eContainer() instanceof Layoutable && ((Layoutable)modelElement.eContainer()).getLayout() instanceof org.eclipse.gmf.gmfgraph.XYLayout) {
                                org.eclipse.gmf.gmfgraph.Dimension size;
                                Point topLeft;
                                XYLayoutData xyLayoutData = (XYLayoutData)modelElement.getLayoutData();
                                if (xyLayoutData == null) {
                                    xyLayoutData = GMFGraphFactory.eINSTANCE.createXYLayoutData();
                                    modelElement.setLayoutData((LayoutData)xyLayoutData);
                                    xyLayoutData.setTopLeft(GMFGraphFactory.eINSTANCE.createPoint());
                                    xyLayoutData.getTopLeft().setX(0);
                                    xyLayoutData.getTopLeft().setY(0);
                                    xyLayoutData.setSize(GMFGraphFactory.eINSTANCE.createDimension());
                                    xyLayoutData.getSize().setDx(40);
                                    xyLayoutData.getSize().setDy(40);
                                }
                                if (xyLayoutData.getTopLeft() != null) {
                                    topLeft = xyLayoutData.getTopLeft();
                                } else {
                                    topLeft = GMFGraphFactory.eINSTANCE.createPoint();
                                    xyLayoutData.setTopLeft(topLeft);
                                }
                                if (topLeft.getX() != location.getX() || topLeft.getY() != location.getY()) {
                                    topLeft.setX(location.getX());
                                    topLeft.setY(location.getY());
                                }
                                if (xyLayoutData.getSize() != null) {
                                    size = xyLayoutData.getSize();
                                } else {
                                    size = GMFGraphFactory.eINSTANCE.createDimension();
                                    xyLayoutData.setSize(size);
                                }
                                if (size.getDx() != dim.getDx() || size.getDy() != dim.getDy()) {
                                    size.setDx(dim.getDx());
                                    size.setDy(dim.getDy());
                                }
                            }
                            return Status.OK_STATUS;
                        }
                    }.execute((IProgressMonitor)new NullProgressMonitor(), null);
                }
                catch (ExecutionException e) {
                    GMFGraphDiagramEditorPlugin.getInstance().logError("Unable to synchronize model size with the view", e);
                }
                if (Ellipse2EditPart.this.getRoot() != null) {
                    Ellipse2EditPart.this.handleMajorSemanticChange();
                }
            }
        }, (EObject)bounds);
        final FillStyle theFillStyle = (FillStyle)view.getStyle(NotationPackage.eINSTANCE.getFillStyle());
        if (modelElement.getBackgroundColor() != null) {
            int rgbColor;
            RGBColor modelColor;
            if (modelElement.getBackgroundColor() instanceof RGBColor) {
                modelColor = (RGBColor)modelElement.getBackgroundColor();
                rgbColor = modelColor.getRed() & 0xFF | (modelColor.getGreen() & 0xFF) << 8 | (modelColor.getBlue() & 0xFF) << 16;
            } else {
                modelColor = (ConstantColor)modelElement.getBackgroundColor();
                rgbColor = Ellipse2EditPart.getRgbColor((ConstantColor)modelColor);
            }
            if (rgbColor != -1 && theFillStyle.getFillColor() != rgbColor) {
                AbstractEMFOperation setColorOperation = new AbstractEMFOperation(this.getEditingDomain(), "Synchronizing view Background color with the model", Collections.singletonMap("unprotected", Boolean.TRUE)){

                    protected IStatus doExecute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                        theFillStyle.setFillColor(rgbColor);
                        return Status.OK_STATUS;
                    }
                };
                try {
                    setColorOperation.execute((IProgressMonitor)new NullProgressMonitor(), null);
                }
                catch (ExecutionException e) {
                    GMFGraphDiagramEditorPlugin.getInstance().logError("Unable to synchronize view Background color with the model", e);
                }
            }
        }
        final LineStyle theLineStyle = (LineStyle)view.getStyle(NotationPackage.eINSTANCE.getLineStyle());
        if (modelElement.getForegroundColor() != null) {
            int rgbColor;
            RGBColor modelColor;
            if (modelElement.getForegroundColor() instanceof RGBColor) {
                modelColor = (RGBColor)modelElement.getForegroundColor();
                rgbColor = modelColor.getRed() & 0xFF | (modelColor.getGreen() & 0xFF) << 8 | (modelColor.getBlue() & 0xFF) << 16;
            } else {
                modelColor = (ConstantColor)modelElement.getForegroundColor();
                rgbColor = Ellipse2EditPart.getRgbColor((ConstantColor)modelColor);
            }
            if (rgbColor != -1 && theLineStyle.getLineColor() != rgbColor) {
                AbstractEMFOperation setColorOperation = new AbstractEMFOperation(this.getEditingDomain(), "Synchronizing view Foreground color with the model", Collections.singletonMap("unprotected", Boolean.TRUE)){

                    protected IStatus doExecute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                        theLineStyle.setLineColor(rgbColor);
                        return Status.OK_STATUS;
                    }
                };
                try {
                    setColorOperation.execute((IProgressMonitor)new NullProgressMonitor(), null);
                }
                catch (ExecutionException e) {
                    GMFGraphDiagramEditorPlugin.getInstance().logError("Unable to synchronize view Foreground color with the model", e);
                }
            }
        }
        FillStyle theFillStyle1 = (FillStyle)view.getStyle(NotationPackage.eINSTANCE.getFillStyle());
        this.addListenerFilter("FillStyleListener", new NotificationListener(){

            public void notifyChanged(final Notification notification) {
                try {
                    new AbstractEMFOperation(Ellipse2EditPart.this.getEditingDomain(), "Synchronizing model Background color with the view", Collections.singletonMap("unprotected", Boolean.TRUE)){

                        protected IStatus doExecute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                            FillStyle theFillStyle = (FillStyle)notification.getNotifier();
                            if (notification.getFeatureID(FillStyle.class) == 0) {
                                RGBColor modelColor;
                                int color = theFillStyle.getFillColor();
                                if (modelElement.getBackgroundColor() instanceof RGBColor) {
                                    modelColor = (RGBColor)modelElement.getBackgroundColor();
                                } else {
                                    modelColor = GMFGraphFactory.eINSTANCE.createRGBColor();
                                    modelElement.setBackgroundColor((Color)modelColor);
                                }
                                if (modelColor.getRed() != (color & 0xFF) || modelColor.getGreen() != (color & 0xFF00) >> 8 || modelColor.getBlue() != (color & 0xFF0000) >> 16) {
                                    modelColor.setRed(color & 0xFF);
                                    modelColor.setGreen((color & 0xFF00) >> 8);
                                    modelColor.setBlue((color & 0xFF0000) >> 16);
                                }
                            }
                            return Status.OK_STATUS;
                        }
                    }.execute((IProgressMonitor)new NullProgressMonitor(), null);
                }
                catch (ExecutionException e) {
                    GMFGraphDiagramEditorPlugin.getInstance().logError("Unable to synchronize model Background color with the view", e);
                }
            }
        }, (EObject)theFillStyle1);
        LineStyle theLineStyle1 = (LineStyle)view.getStyle(NotationPackage.eINSTANCE.getLineStyle());
        this.addListenerFilter("LineStyleListener", new NotificationListener(){

            public void notifyChanged(final Notification notification) {
                try {
                    new AbstractEMFOperation(Ellipse2EditPart.this.getEditingDomain(), "Synchronizing model Foreground color with the view", Collections.singletonMap("unprotected", Boolean.TRUE)){

                        protected IStatus doExecute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                            LineStyle theLineStyle = (LineStyle)notification.getNotifier();
                            if (notification.getFeatureID(LineStyle.class) == 0) {
                                RGBColor modelColor;
                                int color = theLineStyle.getLineColor();
                                if (modelElement.getForegroundColor() instanceof RGBColor) {
                                    modelColor = (RGBColor)modelElement.getForegroundColor();
                                } else {
                                    modelColor = GMFGraphFactory.eINSTANCE.createRGBColor();
                                    modelElement.setForegroundColor((Color)modelColor);
                                }
                                if (modelColor.getRed() != (color & 0xFF) || modelColor.getGreen() != (color & 0xFF00) >> 8 || modelColor.getBlue() != (color & 0xFF0000) >> 16) {
                                    modelColor.setRed(color & 0xFF);
                                    modelColor.setGreen((color & 0xFF00) >> 8);
                                    modelColor.setBlue((color & 0xFF0000) >> 16);
                                }
                            }
                            return Status.OK_STATUS;
                        }
                    }.execute((IProgressMonitor)new NullProgressMonitor(), null);
                }
                catch (ExecutionException e) {
                    GMFGraphDiagramEditorPlugin.getInstance().logError("Unable to synchronize model Foreground color with the view", e);
                }
            }
        }, (EObject)theLineStyle1);
        super.activate();
    }

    protected LayoutManager getFigureLayoutManager() {
        return this.myFigure.getLayoutManager();
    }

    protected void setFigureLayoutManager(LayoutManager layoutManager) {
        this.myFigure.setLayoutManager(layoutManager);
    }

    protected void refreshBounds() {
        if (((View)this.getParent().getModel()).getElement() instanceof AbstractFigure) {
            int width = (Integer)this.getStructuralFeatureValue((EStructuralFeature)NotationPackage.eINSTANCE.getSize_Width());
            int height = (Integer)this.getStructuralFeatureValue((EStructuralFeature)NotationPackage.eINSTANCE.getSize_Height());
            this.myNodeFigure.setPreferredSize(new Dimension(width, height));
        } else {
            super.refreshBounds();
        }
    }

    public static int getRgbColor(ConstantColor modelColor) {
        int rgbColor;
        switch (modelColor.getValue().getValue()) {
            case 0: {
                rgbColor = ColorConstants.white.getRGB().hashCode();
                break;
            }
            case 1: {
                rgbColor = ColorConstants.black.getRGB().hashCode();
                break;
            }
            case 2: {
                rgbColor = ColorConstants.lightGray.getRGB().hashCode();
                break;
            }
            case 3: {
                rgbColor = ColorConstants.gray.getRGB().hashCode();
                break;
            }
            case 4: {
                rgbColor = ColorConstants.darkGray.getRGB().hashCode();
                break;
            }
            case 5: {
                rgbColor = ColorConstants.red.getRGB().hashCode();
                break;
            }
            case 6: {
                rgbColor = ColorConstants.orange.getRGB().hashCode();
                break;
            }
            case 7: {
                rgbColor = ColorConstants.yellow.getRGB().hashCode();
                break;
            }
            case 8: {
                rgbColor = ColorConstants.green.getRGB().hashCode();
                break;
            }
            case 9: {
                rgbColor = ColorConstants.lightGreen.getRGB().hashCode();
                break;
            }
            case 10: {
                rgbColor = ColorConstants.darkGreen.getRGB().hashCode();
                break;
            }
            case 11: {
                rgbColor = ColorConstants.cyan.getRGB().hashCode();
                break;
            }
            case 12: {
                rgbColor = ColorConstants.lightBlue.getRGB().hashCode();
                break;
            }
            case 13: {
                rgbColor = ColorConstants.blue.getRGB().hashCode();
                break;
            }
            case 14: {
                rgbColor = ColorConstants.darkBlue.getRGB().hashCode();
                break;
            }
            default: {
                rgbColor = -1;
            }
        }
        return rgbColor;
    }

    public class EllipseFigure
    extends Ellipse {
        private boolean myUseLocalCoordinates = false;

        public EllipseFigure() {
            this.setLayoutManager((LayoutManager)new XYLayout());
        }

        protected boolean useLocalCoordinates() {
            return this.myUseLocalCoordinates;
        }

        protected void setUseLocalCoordinates(boolean useLocalCoordinates) {
            this.myUseLocalCoordinates = useLocalCoordinates;
        }
    }
}

