/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.commands;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.emf.workspace.AbstractEMFOperation;
import org.eclipse.gef.commands.Command;
import org.eclipse.gmf.runtime.common.core.util.Log;
import org.eclipse.gmf.runtime.common.core.util.Trace;
import org.eclipse.gmf.runtime.diagram.ui.internal.DiagramUIDebugOptions;
import org.eclipse.gmf.runtime.diagram.ui.internal.DiagramUIPlugin;
import org.eclipse.gmf.runtime.diagram.ui.l10n.DiagramUIMessages;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.util.Assert;

public class SetViewMutabilityCommand
extends Command {
    private List _viewAdapters = Collections.EMPTY_LIST;
    private boolean _immutable = true;
    static /* synthetic */ Class class$0;

    public SetViewMutabilityCommand(IAdaptable viewAdapter, boolean immutable) {
        this(Collections.singletonList(viewAdapter), immutable);
    }

    public SetViewMutabilityCommand(List viewAdapters, boolean immutable) {
        super(DiagramUIMessages.SetViewMutabilityCommand_Label);
        Assert.isNotNull((Object)viewAdapters);
        this._viewAdapters = viewAdapters;
        this._immutable = immutable;
    }

    public static SetViewMutabilityCommand makeMutable(List viewAdapters) {
        return new SetViewMutabilityCommand(viewAdapters, false);
    }

    public static SetViewMutabilityCommand makeMutable(IAdaptable viewAdapter) {
        return new SetViewMutabilityCommand(viewAdapter, false);
    }

    public static SetViewMutabilityCommand makeImmutable(List viewAdapters) {
        return new SetViewMutabilityCommand(viewAdapters, true);
    }

    public static SetViewMutabilityCommand makeImmutable(IAdaptable viewAdapter) {
        return new SetViewMutabilityCommand(viewAdapter, true);
    }

    protected List getViewAdapters() {
        return Collections.unmodifiableList(this._viewAdapters);
    }

    public void execute() {
        this.setMutability(this._immutable);
    }

    private void setMutability(final boolean immutable) {
        if (!this._viewAdapters.isEmpty()) {
            TransactionalEditingDomain editingDomain;
            IAdaptable iAdaptable = (IAdaptable)this._viewAdapters.get(0);
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.gmf.runtime.notation.View");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((editingDomain = TransactionUtil.getEditingDomain((Object)iAdaptable.getAdapter((Class)clazz))) != null) {
                Map<String, Boolean> options = Collections.singletonMap("unprotected", Boolean.TRUE);
                AbstractEMFOperation operation = new AbstractEMFOperation(editingDomain, "", options){

                    protected IStatus doExecute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                        Iterator adapters = SetViewMutabilityCommand.this._viewAdapters.iterator();
                        while (adapters.hasNext()) {
                            View notationView;
                            IAdaptable adapter = (IAdaptable)adapters.next();
                            Class<?> clazz = class$0;
                            if (clazz == null) {
                                try {
                                    clazz = Class.forName("org.eclipse.gmf.runtime.notation.View");
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                }
                            }
                            if ((notationView = (View)adapter.getAdapter((Class)clazz)) == null) continue;
                            notationView.setMutable(!immutable);
                        }
                        return Status.OK_STATUS;
                    }
                };
                try {
                    operation.execute((IProgressMonitor)new NullProgressMonitor(), null);
                }
                catch (ExecutionException e) {
                    Trace.catching((Plugin)DiagramUIPlugin.getInstance(), (String)DiagramUIDebugOptions.EXCEPTIONS_CATCHING, ((Object)((Object)this)).getClass(), (String)"setMutability", (Throwable)e);
                    Log.warning((Plugin)DiagramUIPlugin.getInstance(), (int)9, (String)"setMutability", (Throwable)e);
                }
            }
        }
    }

    public Collection getAffectedObjects() {
        return this.getViewAdapters();
    }

    public void redo() {
        this.setMutability(this._immutable);
    }

    public void undo() {
        this.setMutability(!this._immutable);
    }
}

