/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.emf.clipboard.core;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.gmf.runtime.emf.clipboard.core.ClipboardSupportUtil;
import org.eclipse.gmf.runtime.emf.clipboard.core.CopyOperation;
import org.eclipse.gmf.runtime.emf.clipboard.core.IClipboardSupport;
import org.eclipse.gmf.runtime.emf.clipboard.core.IClipboardSupportFactory;
import org.eclipse.gmf.runtime.emf.clipboard.core.PasteTarget;
import org.eclipse.gmf.runtime.emf.clipboard.core.internal.ClipboardPlugin;
import org.eclipse.gmf.runtime.emf.clipboard.core.internal.ClipboardSupportManager;
import org.eclipse.gmf.runtime.emf.clipboard.core.internal.DefaultClipboardSupport;
import org.eclipse.gmf.runtime.emf.clipboard.core.internal.PasteOperation;
import org.eclipse.gmf.runtime.emf.clipboard.core.internal.SerializationEMFResource;

public class ClipboardUtil {
    public static final String MERGE_HINT_WEAK = "*merge=weak";
    public static final String MERGE_HINT_STRONG = "*merge=strong";
    public static final String RECYCLE_HINT_ID = "*recycle=id";
    public static final String IGNORE_RECYCLE_HINT_ID = "*ignore_recycle=id";
    public static final String PASTE_TO_TARGET_PARENT = "*paste=parent";
    public static final String HARVESTED_ELEMENT = "*paste=harvest";
    private static final String PASTE_SELECTION_FROM_STRING = "pasteElementsFromString";
    private static final String COPY_SELECTION_TO_STRING = "copyElementsToString";

    private ClipboardUtil() {
    }

    public static String copyElementsToString(Collection eObjects, Map hints, IProgressMonitor monitor) {
        try {
            if (monitor == null) {
                monitor = new NullProgressMonitor();
            }
            monitor.beginTask("copy", 100);
            EObject first = eObjects.isEmpty() ? null : (EObject)eObjects.iterator().next();
            eObjects = ClipboardSupportUtil.getCopyElements(eObjects);
            if (!eObjects.isEmpty()) {
                if (hints == null) {
                    hints = new HashMap();
                }
                CopyOperation copyOperation = new CopyOperation(monitor, ClipboardUtil.createClipboardSupport(first.eClass()), eObjects, hints);
                String string = copyOperation.copy();
                return string;
            }
        }
        catch (Exception ex) {
            ClipboardUtil.handleException(ex, COPY_SELECTION_TO_STRING);
        }
        finally {
            monitor.done();
        }
        return null;
    }

    public static Collection pasteElementsFromString(String string, EObject targetElement, Map hints, IProgressMonitor monitor) {
        return ClipboardUtil.pasteElementsFromStringDelagate(string, new PasteTarget(targetElement), hints, monitor);
    }

    public static Collection pasteElementsFromString(String string, Resource targetElement, Map hints, IProgressMonitor monitor) {
        return ClipboardUtil.pasteElementsFromStringDelagate(string, new PasteTarget(targetElement), hints, monitor);
    }

    private static Collection pasteElementsFromStringDelagate(String string, PasteTarget targetElement, Map hints, IProgressMonitor monitor) {
        Set result = null;
        try {
            IClipboardSupport helper;
            if (monitor == null) {
                monitor = new NullProgressMonitor();
            }
            monitor.beginTask("paste", 100);
            IClipboardSupport iClipboardSupport = helper = targetElement.isResource() ? DefaultClipboardSupport.getInstance() : ClipboardUtil.createClipboardSupport(((EObject)targetElement.getObject()).eClass());
            if (string.length() == 0) {
                Set set = Collections.EMPTY_SET;
                return set;
            }
            try {
                PasteOperation pasteProcess = new PasteOperation(monitor, helper, string, targetElement, SerializationEMFResource.LOAD_OPTIONS, hints);
                pasteProcess.paste();
                result = pasteProcess.getPastedElementSet();
                helper.performPostPasteProcessing(result);
            }
            catch (Exception ex) {
                ClipboardUtil.handleException(ex, PASTE_SELECTION_FROM_STRING);
            }
        }
        finally {
            monitor.done();
        }
        return result;
    }

    private static void handleException(Exception ex, String methodname) {
        if (!(ex instanceof OperationCanceledException)) {
            ClipboardPlugin.throwing(ClipboardUtil.class, methodname, ex);
            throw ex instanceof RuntimeException ? (RuntimeException)ex : new RuntimeException("Copy-Paste General Error", ex);
        }
        ClipboardPlugin.catching(ClipboardUtil.class, methodname, ex);
    }

    public static IClipboardSupport createClipboardSupport(EClass eClass) {
        IClipboardSupport result = DefaultClipboardSupport.getInstance();
        EPackage ePackage = eClass.getEPackage();
        IClipboardSupportFactory factory = ClipboardSupportManager.lookup(ePackage);
        if (factory != null) {
            result = factory.newClipboardSupport(ePackage);
        }
        return result;
    }
}

