/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.tools;

import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewRequestFactory;
import org.eclipse.gmf.runtime.diagram.ui.requests.EditCommandRequestWrapper;
import org.eclipse.gmf.runtime.diagram.ui.tools.AbstractPopupBarTool;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.notation.View;

public class PopupBarTool
extends AbstractPopupBarTool
implements DragTracker {
    private static int Y_OFFSET = 32;

    public PopupBarTool(EditPart epHost, IElementType elementType) {
        super(epHost, elementType);
    }

    public PopupBarTool(EditPart epHost, CreateRequest theRequest) {
        super(epHost, theRequest);
    }

    protected Request createTargetRequest() {
        if (this.getCreateRequest() != null) {
            return this.getCreateRequest();
        }
        return CreateViewRequestFactory.getCreateShapeRequest(this.getElementType(), this.getPreferencesHint());
    }

    protected Command getCommand() {
        Command theCmd;
        Request theRequest = this.getTargetRequest();
        if (theRequest instanceof CreateRequest) {
            Point thePoint = this.getCurrentInput().getMouseLocation();
            thePoint.y += Y_OFFSET;
            ((CreateRequest)theRequest).setLocation(thePoint);
        }
        if ((theCmd = this.getHost().getCommand(theRequest)) != null && theCmd.canExecute()) {
            return theCmd;
        }
        return this.getCommandToCreateElementOnly();
    }

    private Command getCommandToCreateElementOnly() {
        EObject hostElement = ViewUtil.resolveSemanticElement((View)((View)this.getHost().getModel()));
        if (hostElement != null && this.getElementType() != null) {
            CreateElementRequest theReq = new CreateElementRequest(TransactionUtil.getEditingDomain((EObject)hostElement), hostElement, this.getElementType());
            EditCommandRequestWrapper semReq = new EditCommandRequestWrapper((IEditCommandRequest)theReq);
            Command theRealCmd = ((IGraphicalEditPart)this.getHost()).getCommand(semReq);
            if (theRealCmd != null && theRealCmd.canExecute()) {
                return theRealCmd;
            }
        }
        return null;
    }

    protected void showTargetFeedback() {
    }
}

