/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.mappings.presentation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.gmf.mappings.CanvasMapping;
import org.eclipse.gmf.mappings.ChildReference;
import org.eclipse.gmf.mappings.CompartmentMapping;
import org.eclipse.gmf.mappings.FeatureInitializer;
import org.eclipse.gmf.mappings.FeatureSeqInitializer;
import org.eclipse.gmf.mappings.LinkMapping;
import org.eclipse.gmf.mappings.Mapping;
import org.eclipse.gmf.mappings.MappingEntry;
import org.eclipse.gmf.mappings.NodeMapping;
import org.eclipse.gmf.mappings.NodeReference;
import org.eclipse.gmf.mappings.TopNodeReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilterUtil {
    public static <T> List<T> sort(Collection<T> eObjects) {
        ArrayList<T> result = new ArrayList<T>(eObjects);
        Collections.sort(result, new EObjectsComparator());
        return result;
    }

    public static <T extends EObject> List<T> filterByResourceSet(Collection<T> eClasses, ResourceSet resourceSet) {
        return FilterUtil.sort(FilterUtil.filterValidEObjectsFrom(eClasses, resourceSet));
    }

    public static List<EClass> filterByContainmentFeature(Collection<EClass> eClasses, MappingEntry mappingEntry) {
        EClass superType = null;
        if (mappingEntry instanceof NodeMapping) {
            NodeReference nodeReference = (NodeReference)mappingEntry.eContainer();
            if (nodeReference != null) {
                EReference modelReference;
                EReference eReference = modelReference = nodeReference.getChildrenFeature() != null ? nodeReference.getChildrenFeature() : nodeReference.getContainmentFeature();
                if (modelReference != null) {
                    superType = modelReference.getEReferenceType();
                }
            }
        } else if (mappingEntry instanceof LinkMapping && ((LinkMapping)mappingEntry).getContainmentFeature() != null) {
            superType = ((LinkMapping)mappingEntry).getContainmentFeature().getEReferenceType();
        }
        return FilterUtil.sort(FilterUtil.getConcreteEClasses(FilterUtil.getSubtypesOf(FilterUtil.filterValidEObjectsFrom(eClasses, mappingEntry.eResource().getResourceSet()), superType)));
    }

    public static List<EStructuralFeature> filterByContainerMetaclass(Collection<EStructuralFeature> eReferences, MappingEntry mappingEntry) {
        EClass containerMetaClass = mappingEntry.getDomainMetaElement();
        return FilterUtil.sort(FilterUtil.getEStructuralFeaturesOf(eReferences, containerMetaClass));
    }

    public static List<EReference> filterByContainerMetaclass(Collection<EReference> eReferences, NodeReference nodeReference, boolean containmentOnly) {
        CanvasMapping diagram;
        EClass containerMetaClass = null;
        EClass targetMetaClass = null;
        if (nodeReference instanceof ChildReference) {
            containerMetaClass = ((ChildReference)nodeReference).getParentNode().getDomainMetaElement();
        } else if (nodeReference instanceof TopNodeReference && (diagram = ((Mapping)nodeReference.eContainer()).getDiagram()) != null) {
            containerMetaClass = diagram.getDomainMetaElement();
        }
        if (nodeReference.isSetChild()) {
            targetMetaClass = nodeReference.getChild().getDomainMetaElement();
        }
        List<EReference> fromHierarchy = FilterUtil.sort(FilterUtil.getEReferences(FilterUtil.getEStructuralFeaturesOf(eReferences, containerMetaClass), containmentOnly));
        if (targetMetaClass == null) {
            return fromHierarchy;
        }
        List<EReference> targetsToChild = FilterUtil.sort(FilterUtil.getEReferences(FilterUtil.getEReferencesOfType(eReferences, targetMetaClass), containmentOnly));
        Iterator<EReference> it = targetsToChild.iterator();
        while (it.hasNext()) {
            if (!fromHierarchy.contains(it.next())) continue;
            it.remove();
        }
        ArrayList<EReference> rv = new ArrayList<EReference>(fromHierarchy.size() + targetsToChild.size());
        rv.addAll(fromHierarchy);
        rv.addAll(targetsToChild);
        return rv;
    }

    public static List<EReference> filterByReferenceType(Collection<EReference> eReferences, LinkMapping linkMapping) {
        EClass referenceType = linkMapping.getDomainMetaElement();
        return FilterUtil.sort(FilterUtil.getEReferences(FilterUtil.getEReferencesOfType(eReferences, referenceType), true));
    }

    public static Collection<EObject> filterByNodeMapping(Collection<EObject> childReferences, CompartmentMapping mapping) {
        return FilterUtil.sort(FilterUtil.getChildrenOf(childReferences, (EObject)mapping.getParentNode(), false));
    }

    public static Collection<EObject> filterByNodeMapping(Collection<EObject> compartments, ChildReference childReference) {
        return FilterUtil.getChildrenOf(compartments, (EObject)childReference.getParentNode(), true);
    }

    public static Collection<?> filterBySuperClasses(Collection<?> instances, Class<?>[] classes) {
        return FilterUtil.sort(FilterUtil.getSubClassesOf(instances, classes));
    }

    public static Collection<EStructuralFeature> filterByFeatureInitializer(Collection<EStructuralFeature> features, FeatureInitializer featureInitializer) {
        if (featureInitializer.getFeatureSeqInitializer() == null || featureInitializer.getFeatureSeqInitializer().getElementClass() == null) {
            return features;
        }
        EClass eClass = featureInitializer.getFeatureSeqInitializer().getElementClass();
        ArrayList<EStructuralFeature> result = new ArrayList<EStructuralFeature>(FilterUtil.getEStructuralFeaturesOf(features, eClass));
        Iterator it = result.iterator();
        while (it.hasNext()) {
            EStructuralFeature nextFeature = (EStructuralFeature)it.next();
            if (nextFeature != null && nextFeature.isChangeable()) continue;
            it.remove();
        }
        return result;
    }

    public static Collection<EClass> filterByFeatureSeqInitializer(Collection<EClass> eClasses, FeatureSeqInitializer featureSeqInitializer) {
        if (featureSeqInitializer.getCreatingInitializer() != null) {
            EStructuralFeature feature = featureSeqInitializer.getCreatingInitializer().getFeature();
            if (feature != null && feature.getEType() instanceof EClass) {
                Iterator<EClass> it = eClasses.iterator();
                while (it.hasNext()) {
                    EClass nextEClass = it.next();
                    EClass typeEClass = (EClass)feature.getEType();
                    if (nextEClass != null && !nextEClass.isAbstract() && !nextEClass.isInterface() && typeEClass.isSuperTypeOf(nextEClass)) continue;
                    it.remove();
                }
            }
        } else if (featureSeqInitializer.getElementClass() != null) {
            return Collections.singleton(featureSeqInitializer.getElementClass());
        }
        return eClasses;
    }

    private static Collection<EClass> getSubtypesOf(Collection<EClass> eClasses, EClass superType) {
        if (superType == null) {
            return eClasses;
        }
        Iterator<EClass> it = eClasses.iterator();
        while (it.hasNext()) {
            EClass nextEClass = it.next();
            if (nextEClass == null || superType.isSuperTypeOf(nextEClass)) continue;
            it.remove();
        }
        return eClasses;
    }

    private static Collection<EClass> getConcreteEClasses(Collection<EClass> eClasses) {
        Iterator<EClass> it = eClasses.iterator();
        while (it.hasNext()) {
            EClass nextEClass = it.next();
            if (nextEClass == null || !nextEClass.isAbstract() && !nextEClass.isInterface()) continue;
            it.remove();
        }
        return eClasses;
    }

    private static Collection<EReference> getEReferences(Collection<EReference> eReferences, boolean containmentOnly) {
        if (!containmentOnly) {
            return eReferences;
        }
        Iterator<EReference> it = eReferences.iterator();
        while (it.hasNext()) {
            EReference nextReference = it.next();
            if (nextReference == null || nextReference.isContainment()) continue;
            it.remove();
        }
        return eReferences;
    }

    private static <T extends EStructuralFeature> Collection<T> getEStructuralFeaturesOf(Collection<T> structuralFeatures, EClass featureContainerEClass) {
        Collection<T> result = FilterUtil.getValidEStructuralFeatures(structuralFeatures);
        if (featureContainerEClass == null) {
            return result;
        }
        Iterator<T> it = result.iterator();
        while (it.hasNext()) {
            EStructuralFeature nextFeature = (EStructuralFeature)it.next();
            if (nextFeature == null || nextFeature.getEContainingClass().isSuperTypeOf(featureContainerEClass)) continue;
            it.remove();
        }
        return result;
    }

    private static Collection<EReference> getEReferencesOfType(Collection<EReference> references, EClass referenceType) {
        Collection<EReference> result = FilterUtil.getValidEStructuralFeatures(references);
        if (referenceType == null) {
            return result;
        }
        Iterator<EReference> it = result.iterator();
        while (it.hasNext()) {
            EReference nextFeature = it.next();
            if (nextFeature == null || nextFeature.getEReferenceType().isSuperTypeOf(referenceType)) continue;
            it.remove();
        }
        return result;
    }

    private static <T extends EStructuralFeature> Collection<T> getValidEStructuralFeatures(Collection<T> structuralFeatures) {
        Collection<T> result = FilterUtil.getValidEObjects(structuralFeatures);
        Iterator<T> it = result.iterator();
        while (it.hasNext()) {
            EStructuralFeature nextFeature = (EStructuralFeature)it.next();
            if (nextFeature == null || nextFeature.getEContainingClass() != null) continue;
            it.remove();
        }
        return result;
    }

    private static <T extends EObject> Collection<T> filterValidEObjectsFrom(Collection<T> eClasses, ResourceSet resourceSet) {
        Collection<T> result = FilterUtil.getValidEObjects(eClasses);
        Iterator<T> it = result.iterator();
        while (it.hasNext()) {
            EObject nextEClass = (EObject)it.next();
            if (nextEClass == null || nextEClass.eResource().getResourceSet() == resourceSet) continue;
            it.remove();
        }
        return result;
    }

    private static <T extends EObject> Collection<T> getValidEObjects(Collection<T> eObjects) {
        LinkedList<EObject> result = new LinkedList<EObject>();
        for (EObject nextEObject : eObjects) {
            if (nextEObject != null && nextEObject.eContainer() == null) continue;
            result.add(nextEObject);
        }
        return result;
    }

    private static <T extends EObject> Collection<T> getChildrenOf(Collection<T> elements, EObject container, boolean addNull) {
        LinkedList<EObject> result = new LinkedList<EObject>();
        for (EObject nextEObject : elements) {
            if (!(nextEObject == null ? addNull : nextEObject.eContainer() == container)) continue;
            result.add(nextEObject);
        }
        return result;
    }

    private static Collection<?> getSubClassesOf(Collection<?> instances, Class<?>[] classes) {
        LinkedList result = new LinkedList();
        block0: for (Object nextInstance : instances) {
            int i = 0;
            while (i < classes.length) {
                if (nextInstance == null || classes[i].isAssignableFrom(nextInstance.getClass())) {
                    result.add(nextInstance);
                    continue block0;
                }
                ++i;
            }
        }
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class EObjectsComparator
    implements Comparator<Object> {
        private EObjectsComparator() {
        }

        @Override
        public int compare(Object o1, Object o2) {
            if (o1 instanceof EObject && o2 instanceof EObject) {
                EObject firstEObject = (EObject)o1;
                EObject secondEObject = (EObject)o2;
                return this.compareLabels(firstEObject, secondEObject);
            }
            return this.compareObjects(o1, o2);
        }

        private int compareObjects(Object o1, Object o2) {
            if (o1 == null) {
                return o2 == null ? 0 : 1;
            }
            return o2 == null ? -1 : 0;
        }

        private int compareLabels(EObject firstEObject, EObject secondEObject) {
            String firstLabel = this.getLabel(firstEObject);
            String secondLabel = this.getLabel(secondEObject);
            return firstLabel == null ? (secondLabel == null ? 0 : 1) : (secondLabel == null ? -1 : firstLabel.compareTo(secondLabel));
        }

        private String getLabel(EObject eObject) {
            AdapterFactory adapterFactory = this.getAdapterFactory(eObject);
            if (adapterFactory == null) {
                return "";
            }
            IItemLabelProvider itemLabelProvider = (IItemLabelProvider)adapterFactory.adapt((Notifier)eObject, IItemLabelProvider.class);
            return itemLabelProvider != null ? itemLabelProvider.getText((Object)eObject) : (eObject == null ? "" : eObject.toString());
        }

        private AdapterFactory getAdapterFactory(EObject eObject) {
            EditingDomain editingDomain = AdapterFactoryEditingDomain.getEditingDomainFor((EObject)eObject);
            if (editingDomain instanceof AdapterFactoryEditingDomain) {
                return ((AdapterFactoryEditingDomain)editingDomain).getAdapterFactory();
            }
            return null;
        }
    }
}

