/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.mappings.presentation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.gmf.mappings.CanvasMapping;
import org.eclipse.gmf.mappings.ChildReference;
import org.eclipse.gmf.mappings.CompartmentMapping;
import org.eclipse.gmf.mappings.FeatureInitializer;
import org.eclipse.gmf.mappings.FeatureSeqInitializer;
import org.eclipse.gmf.mappings.LabelMapping;
import org.eclipse.gmf.mappings.LinkMapping;
import org.eclipse.gmf.mappings.Mapping;
import org.eclipse.gmf.mappings.MappingEntry;
import org.eclipse.gmf.mappings.NodeMapping;
import org.eclipse.gmf.mappings.NodeReference;
import org.eclipse.gmf.mappings.TopNodeReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilterUtil {
    private static Comparator EOBJECTS_COMPARATOR = new EObjectsComparator();

    public static List sort(Collection eObjects) {
        ArrayList result = new ArrayList(eObjects);
        Collections.sort(result, EOBJECTS_COMPARATOR);
        return result;
    }

    public static List filterByResourceSet(Collection eClasses, ResourceSet resourceSet) {
        return FilterUtil.sort(FilterUtil.getValidEClassesFrom(eClasses, resourceSet));
    }

    public static List filterByContainmentFeature(Collection eClasses, MappingEntry mappingEntry) {
        EClass superType = null;
        if (mappingEntry instanceof NodeMapping) {
            NodeReference nodeReference = (NodeReference)mappingEntry.eContainer();
            if (nodeReference != null) {
                EReference modelReference;
                EReference eReference = modelReference = nodeReference.getChildrenFeature() != null ? nodeReference.getChildrenFeature() : nodeReference.getContainmentFeature();
                if (modelReference != null) {
                    superType = modelReference.getEReferenceType();
                }
            }
        } else if (mappingEntry instanceof LinkMapping && ((LinkMapping)mappingEntry).getContainmentFeature() != null) {
            superType = ((LinkMapping)mappingEntry).getContainmentFeature().getEReferenceType();
        }
        return FilterUtil.sort(FilterUtil.getSubtypesOf(FilterUtil.getValidEClassesFrom(eClasses, mappingEntry.eResource().getResourceSet()), superType));
    }

    public static List filterByContainerMetaclass(Collection eReferences, LinkMapping mappingEntry) {
        EClass containerMetaClass = mappingEntry.getDomainMetaElement();
        return FilterUtil.sort(FilterUtil.getEStructuralFeaturesOf(eReferences, containerMetaClass));
    }

    public static List filterByContainerMetaclass(Collection eAttributes, LabelMapping labelMapping) {
        EClass containerMetaClass = labelMapping.getMapEntry().getDomainMetaElement();
        return FilterUtil.sort(FilterUtil.getEStructuralFeaturesOf(eAttributes, containerMetaClass));
    }

    public static List filterByContainerMetaclass(Collection eAttributes, MappingEntry mappingEntry) {
        EClass containerMetaClass = mappingEntry.getDomainMetaElement();
        return FilterUtil.sort(FilterUtil.getEStructuralFeaturesOf(eAttributes, containerMetaClass));
    }

    public static List filterByContainerMetaclass(Collection eReferences, NodeReference nodeReference, boolean containmentOnly) {
        CanvasMapping diagram;
        EClass containerMetaClass = null;
        EClass targetMetaClass = null;
        if (nodeReference instanceof ChildReference) {
            containerMetaClass = ((ChildReference)nodeReference).getParentNode().getDomainMetaElement();
        } else if (nodeReference instanceof TopNodeReference && (diagram = ((Mapping)nodeReference.eContainer()).getDiagram()) != null) {
            containerMetaClass = diagram.getDomainMetaElement();
        }
        if (nodeReference.isSetChild()) {
            targetMetaClass = nodeReference.getChild().getDomainMetaElement();
        }
        List fromHierarchy = FilterUtil.sort(FilterUtil.getEReferences(FilterUtil.getEStructuralFeaturesOf(eReferences, containerMetaClass), containmentOnly));
        if (targetMetaClass == null) {
            return fromHierarchy;
        }
        List targetsToChild = FilterUtil.sort(FilterUtil.getEReferences(FilterUtil.getEReferencesOfType(eReferences, targetMetaClass), containmentOnly));
        Iterator it = targetsToChild.iterator();
        while (it.hasNext()) {
            if (!fromHierarchy.contains(it.next())) continue;
            it.remove();
        }
        ArrayList rv = new ArrayList(fromHierarchy.size() + targetsToChild.size());
        rv.addAll(fromHierarchy);
        rv.addAll(targetsToChild);
        return rv;
    }

    public static List filterByReferenceType(Collection eReferences, LinkMapping linkMapping) {
        EClass referenceType = linkMapping.getDomainMetaElement();
        return FilterUtil.sort(FilterUtil.getEReferences(FilterUtil.getEReferencesOfType(eReferences, referenceType), true));
    }

    public static Collection filterByNodeMapping(Collection childReferences, CompartmentMapping mapping) {
        return FilterUtil.sort(FilterUtil.getChildrenOf(childReferences, (EObject)mapping.getParentNode(), false));
    }

    public static Collection filterByNodeMapping(Collection compartments, ChildReference childReference) {
        return FilterUtil.getChildrenOf(compartments, (EObject)childReference.getParentNode(), true);
    }

    public static Collection filterBySuperClasses(Collection instances, Class[] classes) {
        return FilterUtil.sort(FilterUtil.getSubClassesOf(instances, classes));
    }

    public static Collection<EStructuralFeature> filterByFeatureInitializer(Collection<EStructuralFeature> features, FeatureInitializer featureInitializer) {
        if (featureInitializer.getFeatureSeqInitializer() == null || featureInitializer.getFeatureSeqInitializer().getElementClass() == null) {
            return features;
        }
        EClass eClass = featureInitializer.getFeatureSeqInitializer().getElementClass();
        ArrayList<EStructuralFeature> result = new ArrayList<EStructuralFeature>(FilterUtil.getEStructuralFeaturesOf(features, eClass));
        Iterator it = result.iterator();
        while (it.hasNext()) {
            EStructuralFeature nextFeature = (EStructuralFeature)it.next();
            if (nextFeature != null && nextFeature.isChangeable()) continue;
            it.remove();
        }
        return result;
    }

    public static Collection<EClass> filterByFeatureSeqInitializer(Collection<EClass> eClasses, FeatureSeqInitializer featureSeqInitializer) {
        if (featureSeqInitializer.getCreatingInitializer() != null) {
            EStructuralFeature feature = featureSeqInitializer.getCreatingInitializer().getFeature();
            if (feature != null && feature.getEType() instanceof EClass) {
                Iterator<EClass> it = eClasses.iterator();
                while (it.hasNext()) {
                    EClass nextEClass = it.next();
                    EClass typeEClass = (EClass)feature.getEType();
                    if (nextEClass != null && !nextEClass.isAbstract() && !nextEClass.isInterface() && typeEClass.isSuperTypeOf(nextEClass)) continue;
                    it.remove();
                }
            }
        } else if (featureSeqInitializer.getElementClass() != null) {
            return Collections.singleton(featureSeqInitializer.getElementClass());
        }
        return eClasses;
    }

    private static Collection getSubtypesOf(Collection eClasses, EClass superType) {
        if (superType == null) {
            return eClasses;
        }
        Iterator it = eClasses.iterator();
        while (it.hasNext()) {
            EClass nextEClass = (EClass)it.next();
            if (nextEClass == null || superType.isSuperTypeOf(nextEClass)) continue;
            it.remove();
        }
        return eClasses;
    }

    private static Collection getEReferences(Collection eReferences, boolean containmentOnly) {
        if (!containmentOnly) {
            return eReferences;
        }
        Iterator it = eReferences.iterator();
        while (it.hasNext()) {
            EReference nextReference = (EReference)it.next();
            if (nextReference == null || nextReference.isContainment()) continue;
            it.remove();
        }
        return eReferences;
    }

    private static Collection getEStructuralFeaturesOf(Collection structuralFeatures, EClass featureContainerEClass) {
        Collection result = FilterUtil.getValidEStructuralFeatures(structuralFeatures);
        if (featureContainerEClass == null) {
            return result;
        }
        Iterator it = result.iterator();
        while (it.hasNext()) {
            EStructuralFeature nextFeature = (EStructuralFeature)it.next();
            if (nextFeature == null || nextFeature.getEContainingClass().isSuperTypeOf(featureContainerEClass)) continue;
            it.remove();
        }
        return result;
    }

    private static Collection getEReferencesOfType(Collection references, EClass referenceType) {
        Collection result = FilterUtil.getValidEStructuralFeatures(references);
        if (referenceType == null) {
            return result;
        }
        Iterator it = result.iterator();
        while (it.hasNext()) {
            EReference nextFeature = (EReference)it.next();
            if (nextFeature == null || nextFeature.getEReferenceType().isSuperTypeOf(referenceType)) continue;
            it.remove();
        }
        return result;
    }

    private static Collection getValidEStructuralFeatures(Collection structuralFeatures) {
        Collection result = FilterUtil.getValidEObjects(structuralFeatures);
        Iterator it = result.iterator();
        while (it.hasNext()) {
            EStructuralFeature nextFeature = (EStructuralFeature)it.next();
            if (nextFeature == null || nextFeature.getEContainingClass() != null) continue;
            it.remove();
        }
        return result;
    }

    private static Collection getValidEClassesFrom(Collection eClasses, ResourceSet resourceSet) {
        Collection result = FilterUtil.getValidEObjects(eClasses);
        Iterator it = result.iterator();
        while (it.hasNext()) {
            EClass nextEClass = (EClass)it.next();
            if (nextEClass == null || nextEClass.eResource().getResourceSet() == resourceSet) continue;
            it.remove();
        }
        return result;
    }

    private static Collection getValidEObjects(Collection eObjects) {
        ArrayList<EObject> result = new ArrayList<EObject>();
        for (EObject nextEObject : eObjects) {
            if (nextEObject != null && nextEObject.eContainer() == null) continue;
            result.add(nextEObject);
        }
        return result;
    }

    private static Collection getChildrenOf(Collection elements, EObject container, boolean addNull) {
        ArrayList<EObject> result = new ArrayList<EObject>();
        for (EObject nextEObject : elements) {
            if (!(nextEObject == null ? addNull : nextEObject.eContainer() == container)) continue;
            result.add(nextEObject);
        }
        return result;
    }

    private static Collection getSubClassesOf(Collection instances, Class[] classes) {
        ArrayList result = new ArrayList();
        block0: for (Object nextInstance : instances) {
            int i = 0;
            while (i < classes.length) {
                if (nextInstance == null || classes[i].isAssignableFrom(nextInstance.getClass())) {
                    result.add(nextInstance);
                    continue block0;
                }
                ++i;
            }
        }
        return result;
    }

    private static class EObjectsComparator
    implements Comparator {
        private EObjectsComparator() {
        }

        public int compare(Object o1, Object o2) {
            if (o1 instanceof EObject && o2 instanceof EObject) {
                EObject firstEObject = (EObject)o1;
                EObject secondEObject = (EObject)o2;
                return this.compareLabels(firstEObject, secondEObject);
            }
            return this.compareObjects(o1, o2);
        }

        private int compareObjects(Object o1, Object o2) {
            if (o1 == null) {
                return o2 == null ? 0 : 1;
            }
            return o2 == null ? -1 : 0;
        }

        private int compareLabels(EObject firstEObject, EObject secondEObject) {
            String firstLabel = this.getLabel(firstEObject);
            String secondLabel = this.getLabel(secondEObject);
            return firstLabel == null ? (secondLabel == null ? 0 : 1) : (secondLabel == null ? -1 : firstLabel.compareTo(secondLabel));
        }

        private String getLabel(EObject eObject) {
            AdapterFactory adapterFactory = this.getAdapterFactory(eObject);
            if (adapterFactory == null) {
                return "";
            }
            IItemLabelProvider itemLabelProvider = (IItemLabelProvider)adapterFactory.adapt((Notifier)eObject, IItemLabelProvider.class);
            return itemLabelProvider != null ? itemLabelProvider.getText((Object)eObject) : (eObject == null ? "" : eObject.toString());
        }

        private AdapterFactory getAdapterFactory(EObject eObject) {
            EditingDomain editingDomain = AdapterFactoryEditingDomain.getEditingDomainFor((EObject)eObject);
            if (editingDomain instanceof AdapterFactoryEditingDomain) {
                return ((AdapterFactoryEditingDomain)editingDomain).getAdapterFactory();
            }
            return null;
        }
    }
}

