/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.search.ocl.ui.widget;

import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.search.core.engine.DelegatingPackageRegistry;
import org.eclipse.emf.search.ocl.engine.IOCLFactory;
import org.eclipse.emf.search.ocl.engine.ModelingLevel;
import org.eclipse.emf.search.ocl.engine.TargetMetamodel;
import org.eclipse.emf.search.ocl.ui.viewer.ColorManager;
import org.eclipse.emf.search.ocl.ui.viewer.OCLDocument;
import org.eclipse.emf.search.ocl.ui.viewer.OCLSourceViewer;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.ocl.AbstractEnvironmentFactory;
import org.eclipse.ocl.EnvironmentFactory;
import org.eclipse.ocl.OCL;
import org.eclipse.ocl.Query;
import org.eclipse.ocl.ecore.EcoreEnvironmentFactory;
import org.eclipse.ocl.expressions.OCLExpression;
import org.eclipse.ocl.helper.ConstraintKind;
import org.eclipse.ocl.helper.OCLHelper;
import org.eclipse.ocl.uml.UMLEnvironmentFactory;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.uml2.uml.NamedElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class OCLExpressionWidget
extends Composite {
    private final OCLSourceViewer viewer;
    private final OCLDocument document;
    private EObject context;
    private TargetMetamodel targetMetaModel = TargetMetamodel.Ecore;
    private AbstractEnvironmentFactory<?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?> environmentFactory;
    private final IOCLFactory<Object> ocl4EcoreFactory = new EcoreOCLFactory();
    private final IOCLFactory<Object> ocl4UmlFactory = new UMLOCLFactory();
    private ModelingLevel modelingLevel = ModelingLevel.M2;

    public TargetMetamodel getTargetMetamodel() {
        return this.targetMetaModel;
    }

    public void setTargetMetamodel(TargetMetamodel metamodel) {
        this.targetMetaModel = metamodel;
        this.document.setOCLFactory(this.getOCLFactory());
    }

    public ModelingLevel getModelingLevel() {
        return this.modelingLevel;
    }

    public void setModelingLevel(ModelingLevel level) {
        this.modelingLevel = level;
    }

    public EObject getContext() {
        return this.context;
    }

    public void setContext(EObject ctx) {
        this.context = ctx;
        this.document.setOCLContext(ctx);
    }

    public AbstractEnvironmentFactory<?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?> getEnvironmentFactory() {
        return this.environmentFactory;
    }

    public void setEnvironmentFactory(AbstractEnvironmentFactory<?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?> envFactory) {
        this.environmentFactory = envFactory;
    }

    private OCL<?, Object, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?> createOCL() {
        switch (this.targetMetaModel) {
            case Ecore: {
                return this.ocl4EcoreFactory.createOCL();
            }
            case UML: {
                return this.ocl4UmlFactory.createOCL();
            }
        }
        return this.ocl4EcoreFactory.createOCL();
    }

    private IOCLFactory<Object> getOCLFactory() {
        switch (this.getTargetMetamodel()) {
            case Ecore: {
                return this.ocl4EcoreFactory;
            }
            case UML: {
                return this.ocl4UmlFactory;
            }
        }
        return this.ocl4EcoreFactory;
    }

    boolean evaluate(String expression) {
        boolean result = true;
        if (this.context == null) {
            result = false;
        } else {
            OCL<?, Object, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?> ocl = this.createOCL();
            OCLHelper helper = ocl.createOCLHelper();
            ConstraintKind kind = this.modelingLevel.setContext(helper, this.context, this.getOCLFactory());
            try {
                switch (this.modelingLevel) {
                    case M2: {
                        OCLExpression parsed = helper.createQuery(expression);
                        Query query = ocl.createQuery(parsed);
                        System.out.println(query.evaluate((Object)this.context));
                        break;
                    }
                    case M1: {
                        helper.createConstraint(kind, expression);
                    }
                }
            }
            catch (Exception e) {
                result = false;
                System.out.println(e.getLocalizedMessage());
            }
        }
        return result;
    }

    public OCLExpressionWidget(Composite parent) {
        super(parent, 0);
        this.viewer = new OCLSourceViewer(parent, new ColorManager(), 2050);
        this.document = new OCLDocument();
        this.document.setModelingLevel(this.modelingLevel);
        this.viewer.setDocument((IDocument)this.document);
        this.viewer.getTextWidget().addKeyListener((KeyListener)new InputKeyListener());
        this.viewer.getTextWidget().setLayout((Layout)new GridLayout());
        GridData gd1 = new GridData(1808);
        gd1.minimumHeight = 150;
        gd1.heightHint = 150;
        this.viewer.getTextWidget().setLayoutData((Object)gd1);
        GridData gd2 = new GridData(1808);
        gd2.minimumHeight = 150;
        gd2.heightHint = 150;
        this.viewer.getControl().setLayoutData((Object)gd2);
    }

    public boolean evaluate() {
        return this.evaluate(this.getExpression());
    }

    public String getExpression() {
        return this.document.get();
    }

    public void setExpression(String expr) {
        this.document.set(expr);
    }

    public SourceViewer getViewer() {
        return this.viewer;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EcoreOCLFactory
    implements IOCLFactory<Object> {
        private EcoreOCLFactory() {
        }

        public TargetMetamodel getTargetMetamodel() {
            return OCLExpressionWidget.this.targetMetaModel;
        }

        public OCL<?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?> createOCL() {
            return OCL.newInstance((EnvironmentFactory)new EcoreEnvironmentFactory());
        }

        public OCL<?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?> createOCL(Resource res) {
            return OCL.newInstance((EnvironmentFactory)new EcoreEnvironmentFactory((EPackage.Registry)new DelegatingPackageRegistry(OCLExpressionWidget.this.context.eResource().getResourceSet().getPackageRegistry(), EPackage.Registry.INSTANCE)), (Resource)res);
        }

        public Object getContextClassifier(EObject object) {
            return OCLExpressionWidget.this.context.eClass();
        }

        public String getName(Object modelElement) {
            return ((ENamedElement)modelElement).getName();
        }
    }

    private class InputKeyListener
    implements KeyListener {
        private boolean evaluationSuccess = false;

        private InputKeyListener() {
        }

        public void keyPressed(KeyEvent e) {
            switch (e.keyCode) {
                case 13: {
                    if (OCLExpressionWidget.this.viewer.isContentAssistActive() || (e.stateMask & 0x60000) != 0) break;
                    String text = OCLExpressionWidget.this.document.get();
                    this.evaluationSuccess = OCLExpressionWidget.this.evaluate(text);
                }
            }
        }

        public void keyReleased(KeyEvent e) {
            switch (e.keyCode) {
                case 13: {
                    if ((e.stateMask & 0x40000) != 0) break;
                    if (this.evaluationSuccess) {
                        OCLExpressionWidget.this.document.set("");
                    }
                    this.evaluationSuccess = false;
                    break;
                }
                case 32: {
                    if ((e.stateMask & 0x40000) != 262144) break;
                    OCLExpressionWidget.this.viewer.getContentAssistant().showPossibleCompletions();
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class UMLOCLFactory
    implements IOCLFactory<Object> {
        private UMLOCLFactory() {
        }

        public TargetMetamodel getTargetMetamodel() {
            return OCLExpressionWidget.this.targetMetaModel;
        }

        public OCL<?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?> createOCL() {
            return OCL.newInstance((EnvironmentFactory)new UMLEnvironmentFactory());
        }

        public OCL<?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?> createOCL(Resource res) {
            return OCL.newInstance((EnvironmentFactory)new UMLEnvironmentFactory((EPackage.Registry)new DelegatingPackageRegistry(OCLExpressionWidget.this.context.eResource().getResourceSet().getPackageRegistry(), EPackage.Registry.INSTANCE), res.getResourceSet()));
        }

        public Object getContextClassifier(EObject object) {
            return OCLExpressionWidget.this.context;
        }

        public String getName(Object modelElement) {
            return ((NamedElement)modelElement).getName();
        }
    }
}

