/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecoretools.diagram.part;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.provider.EcoreItemProviderAdapterFactory;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.ecoretools.diagram.Messages;
import org.eclipse.emf.ecoretools.diagram.part.EcoreDiagramEditorUtil;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IWrapperItemProvider;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.edit.provider.resource.ResourceItemProviderAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ContainerSelectionDialog;
import org.eclipse.ui.dialogs.ResourceSelectionDialog;

public class EcoreCreationWizardPage
extends WizardPage {
    private static final String BROWSE_TEXT = Messages.EcoreCreationWizardPage_Browse;
    private static final String DOMAIN_EXT = "ecore";
    private static final String DIAGRAM_EXT = "diag";
    private IResource selectedResource;
    private Button existingModelBt;
    private Button newModelBt;
    private Group newModelGrp;
    private Text directoryFd;
    private Button directoryBt;
    private Text nameFd;
    private Group existingModelGrp;
    private Text modelFd;
    private Button modelBt;
    private TreeViewer viewer;
    private Button initializeBt;
    private ModifyListener validationListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            EcoreCreationWizardPage.this.setPageComplete(EcoreCreationWizardPage.this.validatePage());
        }
    };

    public EcoreCreationWizardPage(String pageName, IStructuredSelection selection) {
        super(pageName);
        this.setPageComplete(false);
        Object sel = selection.getFirstElement();
        this.selectedResource = sel != null && sel instanceof IResource ? (sel instanceof IFile ? (DOMAIN_EXT.equals(((IFile)sel).getFileExtension()) ? (IFile)sel : ((IResource)sel).getParent()) : (IResource)sel) : ResourcesPlugin.getWorkspace().getRoot();
    }

    public void createControl(Composite parent) {
        Composite mainComp = new Composite(parent, 0);
        mainComp.setLayout((Layout)new GridLayout());
        mainComp.setLayoutData((Object)new GridData(1808));
        mainComp.setFont(parent.getFont());
        this.createDestinationGroup(mainComp);
        this.loadData();
        this.hookListeners();
        this.setErrorMessage(null);
        this.setMessage(null);
        this.setControl((Control)mainComp);
        this.setPageComplete(this.validatePage());
    }

    protected void createDestinationGroup(Composite parent) {
        this.newModelBt = new Button(parent, 16);
        this.newModelBt.setText(Messages.EcoreCreationWizardPage_CreateNewModel);
        this.newModelBt.setLayoutData((Object)new GridData(768));
        this.createNewModelGroup(parent);
        this.existingModelBt = new Button(parent, 16);
        this.existingModelBt.setText(Messages.EcoreCreationWizardPage_CreateFromExistingModel);
        GridData gd = new GridData(768);
        gd.verticalIndent = 20;
        this.existingModelBt.setLayoutData((Object)gd);
        this.createExistingModelGroup(parent);
    }

    private void createNewModelGroup(Composite parent) {
        this.newModelGrp = new Group(parent, 0);
        this.newModelGrp.setLayout((Layout)new GridLayout(3, false));
        this.newModelGrp.setLayoutData((Object)new GridData(768));
        Label directoryLbl = new Label((Composite)this.newModelGrp, 0);
        directoryLbl.setText(Messages.EcoreCreationWizardPage_Directory);
        this.directoryFd = new Text((Composite)this.newModelGrp, 2048);
        this.directoryFd.setLayoutData((Object)new GridData(768));
        this.directoryFd.setEnabled(false);
        this.directoryBt = new Button((Composite)this.newModelGrp, 8);
        this.directoryBt.setText(BROWSE_TEXT);
        Label nameLbl = new Label((Composite)this.newModelGrp, 0);
        nameLbl.setText(Messages.EcoreCreationWizardPage_DomainFileName);
        this.nameFd = new Text((Composite)this.newModelGrp, 2048);
        GridData layoutNameFd = new GridData(768);
        layoutNameFd.horizontalSpan = 2;
        this.nameFd.setLayoutData((Object)layoutNameFd);
    }

    private void createExistingModelGroup(Composite parent) {
        this.existingModelGrp = new Group(parent, 0);
        this.existingModelGrp.setLayout((Layout)new GridLayout(3, false));
        this.existingModelGrp.setLayoutData((Object)new GridData(1808));
        Label modelLbl = new Label((Composite)this.existingModelGrp, 0);
        modelLbl.setText(Messages.EcoreCreationWizardPage_DomainModel);
        this.modelFd = new Text((Composite)this.existingModelGrp, 2048);
        this.modelFd.setLayoutData((Object)new GridData(768));
        this.modelFd.setEnabled(false);
        this.modelBt = new Button((Composite)this.existingModelGrp, 8);
        this.modelBt.setText(BROWSE_TEXT);
        Label viewerLbl = new Label((Composite)this.existingModelGrp, 0);
        viewerLbl.setText(Messages.EcoreCreationWizardPage_Select);
        this.viewer = new TreeViewer((Composite)this.existingModelGrp, 2052);
        GridData gdViewer = new GridData(1808);
        gdViewer.horizontalSpan = 2;
        gdViewer.minimumHeight = 100;
        this.viewer.getTree().setLayoutData((Object)gdViewer);
        this.initializeBt = new Button((Composite)this.existingModelGrp, 32);
        this.initializeBt.setText(Messages.EcoreCreationWizardPage_InitializeWithExistingElements);
        GridData gdInit = new GridData(768);
        gdInit.horizontalSpan = 3;
        this.initializeBt.setLayoutData((Object)gdInit);
    }

    private void loadData() {
        if (this.selectedResource instanceof IFile) {
            this.existingModelBt.setSelection(true);
            this.newModelGrp.setEnabled(false);
            this.modelFd.setText(this.selectedResource.getFullPath().toString());
            if (this.loadModelFile()) {
                this.existingModelBt.setFocus();
            }
        } else {
            this.newModelBt.setSelection(true);
            this.existingModelGrp.setEnabled(false);
            this.directoryFd.setText(this.selectedResource.getFullPath().toString());
            this.nameFd.setText(EcoreDiagramEditorUtil.getUniqueFileName(this.selectedResource.getFullPath(), "DefaultName", DOMAIN_EXT));
            this.nameFd.setFocus();
        }
        this.initializeBt.setSelection(true);
    }

    private void hookListeners() {
        this.directoryFd.addModifyListener(this.validationListener);
        this.nameFd.addModifyListener(this.validationListener);
        this.modelFd.addModifyListener(this.validationListener);
        this.directoryBt.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EcoreCreationWizardPage.this.handleDirectoryChoose();
            }
        });
        this.modelBt.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EcoreCreationWizardPage.this.handleModelChoose();
            }
        });
        this.existingModelBt.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (EcoreCreationWizardPage.this.existingModelBt.getSelection()) {
                    EcoreCreationWizardPage.this.newModelGrp.setEnabled(false);
                    EcoreCreationWizardPage.this.existingModelGrp.setEnabled(true);
                }
                EcoreCreationWizardPage.this.setPageComplete(EcoreCreationWizardPage.this.validatePage());
            }
        });
        this.newModelBt.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (EcoreCreationWizardPage.this.newModelBt.getSelection()) {
                    EcoreCreationWizardPage.this.newModelGrp.setEnabled(true);
                    EcoreCreationWizardPage.this.existingModelGrp.setEnabled(false);
                }
                EcoreCreationWizardPage.this.setPageComplete(EcoreCreationWizardPage.this.validatePage());
            }
        });
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                EcoreCreationWizardPage.this.setPageComplete(EcoreCreationWizardPage.this.validatePage());
            }
        });
    }

    protected void handleDirectoryChoose() {
        Object[] results;
        ContainerSelectionDialog dialog = new ContainerSelectionDialog(this.getShell(), (IContainer)ResourcesPlugin.getWorkspace().getRoot().findMember(this.directoryFd.getText()), false, Messages.EcoreCreationWizardPage_ChooseDestinationDirectory);
        if (dialog.open() == 0 && (results = dialog.getResult()).length == 1 && results[0] instanceof IPath) {
            IPath newPath = (IPath)results[0];
            this.directoryFd.setText(newPath.toString());
        }
    }

    protected void handleModelChoose() {
        Object[] results;
        String initialDirectory = ResourcesPlugin.getWorkspace().getRoot().getFullPath().toString();
        ResourceSelectionDialog dialog = new ResourceSelectionDialog(this.getShell(), (IAdaptable)ResourcesPlugin.getWorkspace().getRoot().findMember(initialDirectory), Messages.EcoreCreationWizardPage_ChooseAnExistingDomainFile);
        if (dialog.open() == 0 && (results = dialog.getResult()).length == 1 && results[0] instanceof IFile) {
            this.modelFd.setText(((IFile)results[0]).getFullPath().toString());
            this.loadModelFile();
        }
    }

    protected boolean loadModelFile() {
        URI uri = URI.createPlatformResourceURI((String)this.modelFd.getText(), (boolean)true);
        Resource resource = this.getResourceSet().getResource(uri, true);
        if (resource != null) {
            ComposedAdapterFactory adapterFactory = this.getAdapterFactory();
            AdapterFactoryContentProvider adapterContentProvider = new AdapterFactoryContentProvider((AdapterFactory)adapterFactory);
            adapterContentProvider.inputChanged((Viewer)this.viewer, null, null);
            this.viewer.setContentProvider((IContentProvider)new WizardContentProvider((ITreeContentProvider)adapterContentProvider));
            this.viewer.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider((AdapterFactory)adapterFactory));
            this.viewer.setInput((Object)resource.getContents());
            this.viewer.refresh();
            this.viewer.setSelection((ISelection)new StructuredSelection((List)resource.getContents()), true);
            return true;
        }
        return false;
    }

    public ComposedAdapterFactory getAdapterFactory() {
        ArrayList<Object> factories = new ArrayList<Object>();
        factories.add(new EcoreItemProviderAdapterFactory());
        factories.add(new ResourceItemProviderAdapterFactory());
        factories.add(new ReflectiveItemProviderAdapterFactory());
        return new ComposedAdapterFactory(factories);
    }

    protected ResourceSet getResourceSet() {
        return new ResourceSetImpl();
    }

    protected boolean validatePage() {
        this.setMessage(null);
        this.setErrorMessage(null);
        if (this.isNewModel()) {
            return this.validateNewModelGroup();
        }
        return this.validateExistingModel();
    }

    private boolean validateNewModelGroup() {
        IContainer container = this.getSelectedIContainer();
        if (container == null || container instanceof IWorkspaceRoot) {
            this.setErrorMessage(Messages.EcoreCreationWizardPage_UnvalidDestinationContainer);
            return false;
        }
        if (this.getFileName() == null || "".equals(this.getFileName())) {
            this.setErrorMessage(Messages.EcoreCreationWizardPage_DomainFileNotEmpty);
            return false;
        }
        if (!this.getFileName().endsWith(".ecore")) {
            this.setErrorMessage(NLS.bind((String)Messages.EcoreCreationWizardPageExtensionError, (Object)DOMAIN_EXT));
            return false;
        }
        this.validateExistingFiles();
        return true;
    }

    private void validateExistingFiles() {
        if (this.modelFileExist()) {
            if (this.diagramFileExist()) {
                this.setMessage(Messages.EcoreCreationWizardPage_FilesAlreadyExist, 2);
            } else {
                this.setMessage(Messages.EcoreCreationWizardPage_DomainFileAlreadyExists, 2);
            }
        } else if (this.diagramFileExist()) {
            this.setMessage(Messages.EcoreCreationWizardPage_DiagramFileAlreadyExists, 2);
        }
    }

    private boolean modelFileExist() {
        return this.isNewModel() ? ResourcesPlugin.getWorkspace().getRoot().findMember(String.valueOf(this.directoryFd.getText()) + File.separator + this.nameFd.getText()) != null : ResourcesPlugin.getWorkspace().getRoot().findMember(this.modelFd.getText()) != null;
    }

    private boolean diagramFileExist() {
        return this.isNewModel() ? ResourcesPlugin.getWorkspace().getRoot().findMember(this.directoryFd.getText().concat(File.separator).concat(this.nameFd.getText()).concat(DIAGRAM_EXT)) != null : ResourcesPlugin.getWorkspace().getRoot().findMember(this.modelFd.getText().concat(DIAGRAM_EXT)) != null;
    }

    private boolean validateExistingModel() {
        if (this.modelFd.getText() == null || "".equals(this.modelFd.getText())) {
            this.setErrorMessage(Messages.EcoreCreationWizardPage_ChooseExistingDomainFile);
            return false;
        }
        if (!DOMAIN_EXT.equals(((IFile)ResourcesPlugin.getWorkspace().getRoot().findMember(this.modelFd.getText())).getFileExtension())) {
            this.setErrorMessage(NLS.bind((String)Messages.EcoreCreationWizardPageExtensionError, (Object)DOMAIN_EXT));
            return false;
        }
        if (this.diagramFileExist()) {
            this.setMessage(Messages.EcoreCreationWizardPage_DiagramFileAlreadyExists, 2);
        }
        if (!(this.getDiagramEObject() instanceof EPackage)) {
            this.setErrorMessage(Messages.EcoreCreationWizardPage_ChooseAnEPackageElement);
            return false;
        }
        return true;
    }

    public IContainer getSelectedIContainer() {
        if (this.isNewModel()) {
            return (IContainer)ResourcesPlugin.getWorkspace().getRoot().findMember(this.directoryFd.getText());
        }
        return ((IFile)ResourcesPlugin.getWorkspace().getRoot().findMember(this.modelFd.getText())).getParent();
    }

    public String getFileName() {
        if (this.isNewModel()) {
            if (this.nameFd != null && !this.nameFd.isDisposed()) {
                return this.nameFd.getText();
            }
        } else if (this.modelFd != null && !this.modelFd.isDisposed()) {
            IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember(this.modelFd.getText());
            return resource.getName();
        }
        return null;
    }

    public EObject getDiagramEObject() {
        if (((IStructuredSelection)this.viewer.getSelection()).getFirstElement() == null) {
            if (this.viewer.getInput() != null) {
                return (EObject)((EList)this.viewer.getInput()).get(0);
            }
            return null;
        }
        return (EObject)AdapterFactoryEditingDomain.unwrap((Object)((IStructuredSelection)this.viewer.getSelection()).getFirstElement());
    }

    public String getEditorID() {
        return "org.eclipse.emf.ecoretools.diagram.part.EcoreDiagramEditorID";
    }

    public URI getDomainModelURI() {
        if (this.isNewModel()) {
            return URI.createPlatformResourceURI((String)this.directoryFd.getText().concat(File.separator).concat(this.getFileName()), (boolean)false);
        }
        return URI.createPlatformResourceURI((String)this.modelFd.getText(), (boolean)false);
    }

    public URI getDiagramModelURI() {
        if (this.isNewModel()) {
            return URI.createPlatformResourceURI((String)this.directoryFd.getText().concat(File.separator).concat(this.getFileName()).concat(DIAGRAM_EXT), (boolean)false);
        }
        return URI.createPlatformResourceURI((String)this.modelFd.getText().concat(DIAGRAM_EXT), (boolean)false);
    }

    public boolean isNewModel() {
        return this.newModelBt.getSelection();
    }

    public boolean isInitialized() {
        return this.initializeBt.getSelection();
    }

    public static class WizardContentProvider
    implements ITreeContentProvider {
        private static final Object[] NO_CHILDREN = new Object[0];
        private ITreeContentProvider delegatedModelProvider;

        public WizardContentProvider(ITreeContentProvider delegatedProvider) {
            this.delegatedModelProvider = delegatedProvider;
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof List) {
                return new Object[]{((List)parentElement).get(0)};
            }
            if (parentElement instanceof IWrapperItemProvider || parentElement instanceof FeatureMap.Entry || parentElement instanceof EObject) {
                ArrayList<Object> children = new ArrayList<Object>();
                Object[] modelChildren = this.delegatedModelProvider.getChildren(AdapterFactoryEditingDomain.unwrap((Object)parentElement));
                int i = 0;
                while (i < modelChildren.length) {
                    children.add(modelChildren[i]);
                    ++i;
                }
                return children.toArray(new Object[children.size()]);
            }
            return NO_CHILDREN;
        }

        public Object getParent(Object element) {
            if (element instanceof IWrapperItemProvider || element instanceof FeatureMap.Entry || element instanceof EObject) {
                return this.delegatedModelProvider.getParent(AdapterFactoryEditingDomain.unwrap((Object)element));
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            if (element instanceof IWrapperItemProvider || element instanceof FeatureMap.Entry || element instanceof EObject) {
                return this.getChildren(AdapterFactoryEditingDomain.unwrap((Object)element)).length > 0;
            }
            return false;
        }

        public Object[] getElements(Object inputElement) {
            return this.getChildren(inputElement);
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }
}

