/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.mwe2.language.serializer;

import com.google.inject.Inject;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.mwe2.language.mwe2.Assignment;
import org.eclipse.emf.mwe2.language.mwe2.BooleanLiteral;
import org.eclipse.emf.mwe2.language.mwe2.Component;
import org.eclipse.emf.mwe2.language.mwe2.DeclaredProperty;
import org.eclipse.emf.mwe2.language.mwe2.DoubleLiteral;
import org.eclipse.emf.mwe2.language.mwe2.Import;
import org.eclipse.emf.mwe2.language.mwe2.IntegerLiteral;
import org.eclipse.emf.mwe2.language.mwe2.Module;
import org.eclipse.emf.mwe2.language.mwe2.Mwe2Package;
import org.eclipse.emf.mwe2.language.mwe2.NullLiteral;
import org.eclipse.emf.mwe2.language.mwe2.PlainString;
import org.eclipse.emf.mwe2.language.mwe2.PropertyReference;
import org.eclipse.emf.mwe2.language.mwe2.Reference;
import org.eclipse.emf.mwe2.language.mwe2.StringLiteral;
import org.eclipse.emf.mwe2.language.services.Mwe2GrammarAccess;
import org.eclipse.xtext.Action;
import org.eclipse.xtext.ParserRule;
import org.eclipse.xtext.serializer.ISerializationContext;
import org.eclipse.xtext.serializer.acceptor.SequenceFeeder;
import org.eclipse.xtext.serializer.sequencer.AbstractDelegatingSemanticSequencer;
import org.eclipse.xtext.serializer.sequencer.ITransientValueService;

public abstract class AbstractMwe2SemanticSequencer
extends AbstractDelegatingSemanticSequencer {
    @Inject
    private Mwe2GrammarAccess grammarAccess;

    public void sequence(ISerializationContext context, EObject semanticObject) {
        EPackage epackage = semanticObject.eClass().getEPackage();
        ParserRule rule = context.getParserRule();
        Action action = context.getAssignedAction();
        Set parameters = context.getEnabledBooleanParameters();
        if (epackage == Mwe2Package.eINSTANCE) {
            switch (semanticObject.eClass().getClassifierID()) {
                case 5: {
                    this.sequence_Assignment(context, (Assignment)semanticObject);
                    return;
                }
                case 7: {
                    this.sequence_BooleanLiteral(context, (BooleanLiteral)semanticObject);
                    return;
                }
                case 3: {
                    if (rule == this.grammarAccess.getComponentRule() || rule == this.grammarAccess.getValueRule()) {
                        this.sequence_Component(context, (Component)semanticObject);
                        return;
                    }
                    if (rule != this.grammarAccess.getRootComponentRule()) break;
                    this.sequence_RootComponent(context, (Component)semanticObject);
                    return;
                }
                case 2: {
                    this.sequence_DeclaredProperty(context, (DeclaredProperty)semanticObject);
                    return;
                }
                case 15: {
                    this.sequence_DoubleLiteral(context, (DoubleLiteral)semanticObject);
                    return;
                }
                case 4: {
                    this.sequence_Import(context, (Import)semanticObject);
                    return;
                }
                case 16: {
                    this.sequence_IntegerLiteral(context, (IntegerLiteral)semanticObject);
                    return;
                }
                case 0: {
                    this.sequence_Module(context, (Module)semanticObject);
                    return;
                }
                case 14: {
                    this.sequence_NullLiteral(context, (NullLiteral)semanticObject);
                    return;
                }
                case 12: {
                    this.sequence_PlainString(context, (PlainString)semanticObject);
                    return;
                }
                case 11: {
                    this.sequence_PropertyReferenceImpl(context, (PropertyReference)semanticObject);
                    return;
                }
                case 8: {
                    this.sequence_Reference(context, (Reference)semanticObject);
                    return;
                }
                case 9: {
                    this.sequence_StringLiteral(context, (StringLiteral)semanticObject);
                    return;
                }
            }
        }
        if (this.errorAcceptor != null) {
            this.errorAcceptor.accept(this.diagnosticProvider.createInvalidContextOrTypeDiagnostic(semanticObject, context));
        }
    }

    protected void sequence_Assignment(ISerializationContext context, Assignment semanticObject) {
        if (this.errorAcceptor != null) {
            if (this.transientValues.isValueTransient((EObject)semanticObject, (EStructuralFeature)Mwe2Package.Literals.ASSIGNMENT__FEATURE) == ITransientValueService.ValueTransient.YES) {
                this.errorAcceptor.accept(this.diagnosticProvider.createFeatureValueMissing((EObject)semanticObject, (EStructuralFeature)Mwe2Package.Literals.ASSIGNMENT__FEATURE));
            }
            if (this.transientValues.isValueTransient((EObject)semanticObject, (EStructuralFeature)Mwe2Package.Literals.ASSIGNMENT__VALUE) == ITransientValueService.ValueTransient.YES) {
                this.errorAcceptor.accept(this.diagnosticProvider.createFeatureValueMissing((EObject)semanticObject, (EStructuralFeature)Mwe2Package.Literals.ASSIGNMENT__VALUE));
            }
        }
        SequenceFeeder feeder = this.createSequencerFeeder(context, semanticObject);
        feeder.accept(this.grammarAccess.getAssignmentAccess().getFeatureJvmIdentifiableElementFQNParserRuleCall_0_0_1(), semanticObject.eGet((EStructuralFeature)Mwe2Package.Literals.ASSIGNMENT__FEATURE, false));
        feeder.accept(this.grammarAccess.getAssignmentAccess().getValueValueParserRuleCall_2_0(), (Object)semanticObject.getValue());
        feeder.finish();
    }

    protected void sequence_BooleanLiteral(ISerializationContext context, BooleanLiteral semanticObject) {
        this.genericSequencer.createSequence(context, (EObject)semanticObject);
    }

    protected void sequence_Component(ISerializationContext context, Component semanticObject) {
        this.genericSequencer.createSequence(context, (EObject)semanticObject);
    }

    protected void sequence_DeclaredProperty(ISerializationContext context, DeclaredProperty semanticObject) {
        this.genericSequencer.createSequence(context, (EObject)semanticObject);
    }

    protected void sequence_DoubleLiteral(ISerializationContext context, DoubleLiteral semanticObject) {
        if (this.errorAcceptor != null && this.transientValues.isValueTransient((EObject)semanticObject, (EStructuralFeature)Mwe2Package.Literals.DOUBLE_LITERAL__VALUE) == ITransientValueService.ValueTransient.YES) {
            this.errorAcceptor.accept(this.diagnosticProvider.createFeatureValueMissing((EObject)semanticObject, (EStructuralFeature)Mwe2Package.Literals.DOUBLE_LITERAL__VALUE));
        }
        SequenceFeeder feeder = this.createSequencerFeeder(context, semanticObject);
        feeder.accept(this.grammarAccess.getDoubleLiteralAccess().getValueDoubleValueParserRuleCall_0(), (Object)semanticObject.getValue());
        feeder.finish();
    }

    protected void sequence_Import(ISerializationContext context, Import semanticObject) {
        if (this.errorAcceptor != null && this.transientValues.isValueTransient((EObject)semanticObject, (EStructuralFeature)Mwe2Package.Literals.IMPORT__IMPORTED_NAMESPACE) == ITransientValueService.ValueTransient.YES) {
            this.errorAcceptor.accept(this.diagnosticProvider.createFeatureValueMissing((EObject)semanticObject, (EStructuralFeature)Mwe2Package.Literals.IMPORT__IMPORTED_NAMESPACE));
        }
        SequenceFeeder feeder = this.createSequencerFeeder(context, semanticObject);
        feeder.accept(this.grammarAccess.getImportAccess().getImportedNamespaceImportedFQNParserRuleCall_1_0(), (Object)semanticObject.getImportedNamespace());
        feeder.finish();
    }

    protected void sequence_IntegerLiteral(ISerializationContext context, IntegerLiteral semanticObject) {
        if (this.errorAcceptor != null && this.transientValues.isValueTransient((EObject)semanticObject, (EStructuralFeature)Mwe2Package.Literals.INTEGER_LITERAL__VALUE) == ITransientValueService.ValueTransient.YES) {
            this.errorAcceptor.accept(this.diagnosticProvider.createFeatureValueMissing((EObject)semanticObject, (EStructuralFeature)Mwe2Package.Literals.INTEGER_LITERAL__VALUE));
        }
        SequenceFeeder feeder = this.createSequencerFeeder(context, semanticObject);
        feeder.accept(this.grammarAccess.getIntegerLiteralAccess().getValueIntValueParserRuleCall_0(), (Object)semanticObject.getValue());
        feeder.finish();
    }

    protected void sequence_Module(ISerializationContext context, Module semanticObject) {
        this.genericSequencer.createSequence(context, (EObject)semanticObject);
    }

    protected void sequence_NullLiteral(ISerializationContext context, NullLiteral semanticObject) {
        this.genericSequencer.createSequence(context, (EObject)semanticObject);
    }

    protected void sequence_PlainString(ISerializationContext context, PlainString semanticObject) {
        if (this.errorAcceptor != null && this.transientValues.isValueTransient((EObject)semanticObject, (EStructuralFeature)Mwe2Package.Literals.PLAIN_STRING__VALUE) == ITransientValueService.ValueTransient.YES) {
            this.errorAcceptor.accept(this.diagnosticProvider.createFeatureValueMissing((EObject)semanticObject, (EStructuralFeature)Mwe2Package.Literals.PLAIN_STRING__VALUE));
        }
        SequenceFeeder feeder = this.createSequencerFeeder(context, semanticObject);
        feeder.accept(this.grammarAccess.getPlainStringAccess().getValueConstantValueParserRuleCall_0(), (Object)semanticObject.getValue());
        feeder.finish();
    }

    protected void sequence_PropertyReferenceImpl(ISerializationContext context, PropertyReference semanticObject) {
        if (this.errorAcceptor != null && this.transientValues.isValueTransient((EObject)semanticObject, (EStructuralFeature)Mwe2Package.Literals.ABSTRACT_REFERENCE__REFERABLE) == ITransientValueService.ValueTransient.YES) {
            this.errorAcceptor.accept(this.diagnosticProvider.createFeatureValueMissing((EObject)semanticObject, (EStructuralFeature)Mwe2Package.Literals.ABSTRACT_REFERENCE__REFERABLE));
        }
        SequenceFeeder feeder = this.createSequencerFeeder(context, semanticObject);
        feeder.accept(this.grammarAccess.getPropertyReferenceImplAccess().getReferableDeclaredPropertyFQNParserRuleCall_0_1(), semanticObject.eGet((EStructuralFeature)Mwe2Package.Literals.ABSTRACT_REFERENCE__REFERABLE, false));
        feeder.finish();
    }

    protected void sequence_Reference(ISerializationContext context, Reference semanticObject) {
        if (this.errorAcceptor != null && this.transientValues.isValueTransient((EObject)semanticObject, (EStructuralFeature)Mwe2Package.Literals.ABSTRACT_REFERENCE__REFERABLE) == ITransientValueService.ValueTransient.YES) {
            this.errorAcceptor.accept(this.diagnosticProvider.createFeatureValueMissing((EObject)semanticObject, (EStructuralFeature)Mwe2Package.Literals.ABSTRACT_REFERENCE__REFERABLE));
        }
        SequenceFeeder feeder = this.createSequencerFeeder(context, semanticObject);
        feeder.accept(this.grammarAccess.getReferenceAccess().getReferableReferrableFQNParserRuleCall_0_1(), semanticObject.eGet((EStructuralFeature)Mwe2Package.Literals.ABSTRACT_REFERENCE__REFERABLE, false));
        feeder.finish();
    }

    protected void sequence_RootComponent(ISerializationContext context, Component semanticObject) {
        this.genericSequencer.createSequence(context, (EObject)semanticObject);
    }

    protected void sequence_StringLiteral(ISerializationContext context, StringLiteral semanticObject) {
        this.genericSequencer.createSequence(context, (EObject)semanticObject);
    }
}

