/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.interpreter.ui.wizard;

import org.eclipse.emf.henshin.interpreter.ui.HenshinInterpreterUIPlugin;
import org.eclipse.emf.henshin.interpreter.ui.wizard.HenshinWizard;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class HenshinWizardDialog
extends WizardDialog {
    protected Button previewButton;

    public HenshinWizardDialog(Shell parentShell, HenshinWizard wizard) {
        super(parentShell, (IWizard)wizard);
        wizard.addCompletionListener(new HenshinWizard.CompletionListener(){

            @Override
            public void completionChanged() {
                HenshinWizardDialog.this.updateButtons();
            }
        });
    }

    protected HenshinWizard getWizard() {
        return (HenshinWizard)super.getWizard();
    }

    protected void createButtonsForButtonBar(Composite parent) {
        ((GridLayout)parent.getLayout()).numColumns += 2;
        final Button saveOnCancelButton = new Button(parent, 32);
        GridData data = new GridData();
        data.horizontalSpan = 4;
        data.horizontalAlignment = 3;
        saveOnCancelButton.setLayoutData((Object)data);
        saveOnCancelButton.setText(HenshinInterpreterUIPlugin.LL("_UI_SaveConfigurationOnCancel"));
        saveOnCancelButton.setSelection(HenshinInterpreterUIPlugin.getPlugin().getPreferenceStore().getBoolean("saveOnCancel"));
        saveOnCancelButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                HenshinInterpreterUIPlugin.getPlugin().getPreferenceStore().setValue("saveOnCancel", saveOnCancelButton.getSelection());
            }
        });
        this.previewButton = new Button(parent, 8);
        this.previewButton.setText(HenshinInterpreterUIPlugin.LL("_UI_ShowPreview"));
        this.previewButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                HenshinWizardDialog.this.getWizard().performPreview();
            }
        });
        this.setButtonLayoutData(this.previewButton);
        super.createButtonsForButtonBar(parent);
        Control[] controlArray = parent.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Button b;
            Control ctrl = controlArray[n2];
            if (ctrl instanceof Button && (b = (Button)ctrl).getText().equals(IDialogConstants.FINISH_LABEL)) {
                b.setText(HenshinInterpreterUIPlugin.LL("_UI_ApplyTransformation"));
            }
            ++n2;
        }
    }

    public void updateButtons() {
        super.updateButtons();
        this.previewButton.setEnabled(this.getWizard().canFinish());
    }
}

