/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfindex.ui;

import com.google.inject.Inject;
import com.google.inject.Injector;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.emfindex.EmfIndexPlugin;
import org.eclipse.emf.emfindex.Logger;
import org.eclipse.emf.emfindex.store.UpdateableIndex;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchListener;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class EmfIndexUIPlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.eclipse.emf.emfindex.ui";
    private static EmfIndexUIPlugin plugin;
    @Inject
    private UpdateableIndex index;
    @Inject
    private Logger logger;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        this.getInjector().injectMembers((Object)this);
        this.initializeIndex();
        this.registerSaveOnExitListener();
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public void initializeIndex() {
        if (this.index != null) {
            this.loadIndex();
            this.indexWorkspace();
        }
    }

    private void loadIndex() {
        try {
            this.index.load();
        }
        catch (Exception e) {
            this.logger.logError("Error loading EMF index", (Throwable)e);
        }
    }

    public static EmfIndexUIPlugin getDefault() {
        return plugin;
    }

    public Injector getInjector() {
        return EmfIndexPlugin.getDefault().getInjector();
    }

    private void indexWorkspace() {
        IProject[] iProjectArray = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            final IProject project = iProjectArray[n2];
            try {
                IProjectDescription description;
                if (project.isAccessible() && (description = project.getDescription()).hasNature("org.eclipse.emf.emfindex.ui.emfIndexNature")) {
                    Job builderJob = new Job("EMF Index: indexing " + project.getName()){

                        protected IStatus run(IProgressMonitor monitor) {
                            try {
                                project.build(15, "org.eclipse.emf.emfindex.ui.emfIndexBuilder", null, monitor);
                            }
                            catch (CoreException e) {
                                EmfIndexUIPlugin.this.logger.logError(e.getMessage(), (Throwable)e);
                                Status status = new Status(4, EmfIndexUIPlugin.PLUGIN_ID, "Error indexing project " + project.getName(), (Throwable)e);
                                return status;
                            }
                            return Status.OK_STATUS;
                        }
                    };
                    builderJob.schedule();
                }
            }
            catch (CoreException ce) {
                this.logger.logError("Error getting project description of " + project.getName(), (Throwable)ce);
            }
            ++n2;
        }
    }

    private void registerSaveOnExitListener() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench != null) {
            workbench.addWorkbenchListener(new IWorkbenchListener(){

                public boolean preShutdown(IWorkbench workbench, boolean forced) {
                    try {
                        EmfIndexUIPlugin.this.index.save();
                    }
                    catch (Exception e) {
                        EmfIndexUIPlugin.this.logger.logError("Error saving EMF index", (Throwable)e);
                    }
                    return true;
                }

                public void postShutdown(IWorkbench workbench) {
                }
            });
        }
    }
}

