/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.event;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import org.eclipse.net4j.internal.util.bundle.OM;
import org.eclipse.net4j.util.CheckUtil;
import org.eclipse.net4j.util.event.IEvent;
import org.eclipse.net4j.util.event.IListener;
import org.eclipse.net4j.util.event.INotifier;

public class Notifier
implements INotifier.Introspection {
    private List<IListener> listeners = new ArrayList<IListener>(0);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(IListener listener) {
        boolean isNotEmpty;
        boolean wasNotEmpty;
        CheckUtil.checkArg(listener, "listener");
        List<IListener> list = this.listeners;
        synchronized (list) {
            wasNotEmpty = !this.listeners.isEmpty();
            this.listeners.add(listener);
            isNotEmpty = !this.listeners.isEmpty();
        }
        if (wasNotEmpty ^ isNotEmpty) {
            this.listenersEmptyChanged(!isNotEmpty);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(IListener listener) {
        boolean isEmpty;
        boolean wasEmpty;
        List<IListener> list = this.listeners;
        synchronized (list) {
            wasEmpty = this.listeners.isEmpty();
            this.listeners.remove(listener);
            isEmpty = this.listeners.isEmpty();
        }
        if (wasEmpty ^ isEmpty) {
            this.listenersEmptyChanged(isEmpty);
        }
    }

    public boolean hasListeners() {
        return !this.listeners.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IListener[] getListeners() {
        List<IListener> list = this.listeners;
        synchronized (list) {
            return this.listeners.toArray(new IListener[this.listeners.size()]);
        }
    }

    public void fireEvent(IEvent event) {
        FireEventRunnable runnable = new FireEventRunnable(this.getListeners(), event);
        ExecutorService executorService = this.getNotificationExecutorService();
        if (executorService == null) {
            runnable.run();
        } else {
            executorService.execute(runnable);
        }
    }

    protected ExecutorService getNotificationExecutorService() {
        return null;
    }

    protected void listenersEmptyChanged(boolean empty) {
    }

    private static final class FireEventRunnable
    implements Runnable {
        private IListener[] listeners;
        private IEvent event;

        public FireEventRunnable(IListener[] listeners, IEvent event) {
            this.listeners = listeners;
            this.event = event;
        }

        public void run() {
            IListener[] iListenerArray = this.listeners;
            int n = this.listeners.length;
            int n2 = 0;
            while (n2 < n) {
                IListener listener = iListenerArray[n2];
                try {
                    listener.notifyEvent(this.event);
                }
                catch (Exception ex) {
                    OM.LOG.error(ex);
                }
                ++n2;
            }
        }
    }
}

