/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.concurrent;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import org.eclipse.net4j.internal.util.bundle.OM;
import org.eclipse.net4j.util.WrappedException;
import org.eclipse.net4j.util.concurrent.ConcurrencyUtil;

public abstract class MonitoredThread
extends Thread {
    private ThreadMonitor monitor;
    private long timeStamp;
    private boolean shutdown;

    public MonitoredThread(String name, ThreadMonitor monitor) {
        super(name);
        this.monitor = monitor;
    }

    public long getTimeStamp() {
        return this.timeStamp;
    }

    public boolean isIdleTimeoutExpired(long idleTimeOut) {
        if (this.timeStamp != 0L) {
            long idle = System.currentTimeMillis() - this.timeStamp;
            return idle > idleTimeOut;
        }
        return false;
    }

    public void heartBeat() {
        if (this.shutdown) {
            throw new ShutdownException();
        }
        this.timeStamp = System.currentTimeMillis();
    }

    public void shutdown() {
        this.shutdown = true;
    }

    public void run() {
        this.monitor.handleStarting(this);
        try {
            try {
                this.doRun();
            }
            catch (ShutdownException shutdownException) {
                this.monitor.handleFinished(this);
                return;
            }
            catch (Exception ex) {
                OM.LOG.error(ex);
                throw WrappedException.wrap(ex);
            }
        }
        finally {
            this.monitor.handleFinished(this);
        }
    }

    protected abstract void doRun() throws Exception;

    public static class MultiThreadMonitor
    implements ThreadMonitor,
    Runnable {
        public static final long SYNCED_START = -1L;
        private long idleTimeOut;
        private long startOffset;
        private CountDownLatch startLatch;
        private List<MonitoredThread> threads = new ArrayList<MonitoredThread>();

        public MultiThreadMonitor(long idleTimeOut, long startOffset) {
            this.idleTimeOut = idleTimeOut;
            this.startOffset = startOffset;
            if (startOffset == -1L) {
                this.startLatch = new CountDownLatch(1);
            }
        }

        public MultiThreadMonitor(long timeOut) {
            this(timeOut, -1L);
        }

        public long getIdleTimeOut() {
            return this.idleTimeOut;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addThread(MonitoredThread thread) {
            List<MonitoredThread> list = this.threads;
            synchronized (list) {
                this.threads.add(thread);
            }
        }

        public void handleStarting(MonitoredThread thread) {
            if (this.startLatch != null) {
                try {
                    this.startLatch.await();
                }
                catch (InterruptedException ex) {
                    throw WrappedException.wrap(ex);
                }
            } else if (this.startOffset > 0L) {
                ConcurrencyUtil.sleep(this.startOffset);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleFinished(MonitoredThread thread) {
            List<MonitoredThread> list = this.threads;
            synchronized (list) {
                this.threads.remove(thread);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            this.startupThreads();
            block3: while (true) {
                ArrayList<MonitoredThread> idleThreads = new ArrayList<MonitoredThread>();
                List<MonitoredThread> list = this.threads;
                synchronized (list) {
                    if (this.threads.isEmpty()) {
                        break;
                    }
                    for (MonitoredThread thread : this.threads) {
                        if (!thread.isIdleTimeoutExpired(this.idleTimeOut)) continue;
                        idleThreads.add(thread);
                    }
                }
                Iterator iterator = idleThreads.iterator();
                while (true) {
                    if (!iterator.hasNext()) continue block3;
                    MonitoredThread thread = (MonitoredThread)iterator.next();
                    this.handleTimeoutExpiration(thread);
                }
                break;
            }
            ConcurrencyUtil.sleep(10L);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void handleTimeoutExpiration(MonitoredThread thread) {
            List<MonitoredThread> list = this.threads;
            synchronized (list) {
                this.threads.remove(thread);
            }
            this.shutdownThreads();
            throw new RuntimeException("Idle timeout expired: " + thread.getName());
        }

        private void startupThreads() {
            for (MonitoredThread thread : this.threads) {
                thread.start();
            }
            if (this.startLatch != null) {
                this.startLatch.countDown();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void shutdownThreads() {
            List<MonitoredThread> list = this.threads;
            synchronized (list) {
                for (MonitoredThread t : this.threads) {
                    t.shutdown();
                }
            }
        }
    }

    private static final class ShutdownException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        private ShutdownException() {
        }
    }

    public static interface ThreadMonitor {
        public void handleStarting(MonitoredThread var1);

        public void handleFinished(MonitoredThread var1);
    }
}

