/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.epatch.util;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.eclipse.emf.compare.epatch.Assignment;
import org.eclipse.emf.compare.epatch.AssignmentValue;
import org.eclipse.emf.compare.epatch.CreatedObject;
import org.eclipse.emf.compare.epatch.ListAssignment;
import org.eclipse.emf.compare.epatch.NamedObject;
import org.eclipse.emf.compare.epatch.ObjectRef;
import org.eclipse.emf.compare.epatch.SingleAssignment;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EpatchUtil {
    public static final AssSorter ASS_SORTER = new AssSorter();
    public static AssValSorter ASS_VAL_SORTER_ASC = new AssValSorter(true);
    public static AssValSorter ASS_VAL_SORTER_DESC = new AssValSorter(false);
    public static ObjSorter NAMED_OBJECT_SORTER = new ObjSorter();

    public static List<CreatedObject> getAllLeftValues(NamedObject obj) {
        return EpatchUtil.getAllValues(obj, new ArrayList<CreatedObject>(), true);
    }

    private static List<CreatedObject> getAllValues(NamedObject obj, List<CreatedObject> list, boolean isLeft) {
        boolean left = isLeft || obj instanceof CreatedObject;
        for (Assignment a : obj.getAssignments()) {
            AssignmentValue v2;
            if (a instanceof ListAssignment) {
                ListAssignment la = (ListAssignment)a;
                for (AssignmentValue v2 : left ? la.getLeftValues() : la.getRightValues()) {
                    if (v2.getNewObject() == null) continue;
                    list.add(v2.getNewObject());
                    EpatchUtil.getAllValues(v2.getNewObject(), list, isLeft);
                }
                continue;
            }
            if (!(a instanceof SingleAssignment)) continue;
            SingleAssignment si = (SingleAssignment)a;
            AssignmentValue assignmentValue = v2 = left ? si.getLeftValue() : si.getRightValue();
            if (v2 == null || v2.getNewObject() == null) continue;
            list.add(v2.getNewObject());
            EpatchUtil.getAllValues(v2.getNewObject(), list, isLeft);
        }
        return list;
    }

    public static List<CreatedObject> getAllRightValues(NamedObject obj) {
        return EpatchUtil.getAllValues(obj, new ArrayList<CreatedObject>(), false);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AssSorter
    implements Comparator<Assignment> {
        @Override
        public int compare(Assignment o1, Assignment o2) {
            return o1.getFeature().compareToIgnoreCase(o2.getFeature());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AssValSorter
    implements Comparator<AssignmentValue> {
        private int down;
        private int up;

        public AssValSorter(boolean asc) {
            this.up = asc ? -1 : 1;
            this.down = asc ? 1 : -1;
        }

        @Override
        public int compare(AssignmentValue o1, AssignmentValue o2) {
            return o1.getIndex() < o2.getIndex() ? this.up : (o1.getIndex() == o2.getIndex() ? 0 : this.down);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ObjSorter
    implements Comparator<NamedObject> {
        @Override
        public int compare(NamedObject o1, NamedObject o2) {
            int r = 0;
            if (o1.getName() != null && o2.getName() != null) {
                r = o1.getName().compareToIgnoreCase(o2.getName());
            } else if (o1.getName() == null != (o2.getName() == null)) {
                return o1.getName() != null ? 1 : -1;
            }
            if (r != 0) {
                return r;
            }
            if (o1 instanceof ObjectRef && o2 instanceof ObjectRef) {
                ObjectRef r1 = (ObjectRef)o1;
                ObjectRef r2 = (ObjectRef)o2;
                if (r1.getLeftRes() != null && r2.getLeftRes() != null) {
                    r = r1.getLeftRes().getName().compareTo(r2.getLeftRes().getName());
                    return r != 0 ? r : r1.getLeftFrag().compareTo(r2.getLeftFrag());
                }
            }
            return 0;
        }
    }
}

