/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecore.xmi.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.emf.ecore.xmi.XMLParserPool;
import org.xml.sax.SAXException;

public class XMLParserPoolImpl
implements XMLParserPool {
    private final HashMap parserCache = new HashMap();

    public synchronized SAXParser get(Map features, Map properties, boolean useLexicalHandler) throws ParserConfigurationException, SAXException {
        HashMap<String, Boolean> map = new HashMap<String, Boolean>();
        map.putAll(features);
        map.putAll(properties);
        map.put("USE_LEXICAL_HANDLER", useLexicalHandler ? Boolean.TRUE : Boolean.FALSE);
        Object o = this.parserCache.get(map);
        if (o != null) {
            ArrayList list = (ArrayList)o;
            int size = list.size();
            if (size > 0) {
                return (SAXParser)list.remove(size - 1);
            }
            return this.makeParser(features, properties);
        }
        this.parserCache.put(map, new ArrayList());
        return this.makeParser(features, properties);
    }

    public synchronized void release(SAXParser parser, Map features, Map properties, boolean useLexicalHandler) {
        HashMap<String, Boolean> map = new HashMap<String, Boolean>();
        map.putAll(features);
        map.putAll(properties);
        map.put("USE_LEXICAL_HANDLER", useLexicalHandler ? Boolean.TRUE : Boolean.FALSE);
        ArrayList list = (ArrayList)this.parserCache.get(map);
        list.add(parser);
    }

    private SAXParser makeParser(Map features, Map properties) throws ParserConfigurationException, SAXException {
        Iterator i;
        SAXParserFactory factory = SAXParserFactory.newInstance();
        SAXParser parser = factory.newSAXParser();
        if (features != null) {
            i = features.keySet().iterator();
            while (i.hasNext()) {
                String feature = (String)i.next();
                parser.getXMLReader().setFeature(feature, (Boolean)features.get(feature));
            }
        }
        if (properties != null) {
            i = properties.keySet().iterator();
            while (i.hasNext()) {
                String property = (String)i.next();
                parser.getXMLReader().setProperty(property, properties.get(property));
            }
        }
        return parser;
    }
}

