/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.query.conditions.eobjects.structuralfeatures;

import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.FeatureMapUtil;
import org.eclipse.emf.query.conditions.Condition;
import org.eclipse.emf.query.conditions.ConditionPolicy;
import org.eclipse.emf.query.conditions.ObjectInstanceCondition;
import org.eclipse.emf.query.conditions.eobjects.EObjectCondition;
import org.eclipse.emf.query.conditions.eobjects.EObjectInstanceCondition;
import org.eclipse.emf.query.conditions.eobjects.structuralfeatures.EObjectStructuralFeatureCondition;
import org.eclipse.emf.query.conditions.eobjects.structuralfeatures.IEStructuralFeatureValueGetter;
import org.eclipse.emf.query.handlers.PruneHandler;

public abstract class EObjectStructuralFeatureValueCondition
extends EObjectStructuralFeatureCondition {
    private StructuralFeatureValueEvaluator evaluator;
    private EObjectCondition featureCondition;

    public EObjectStructuralFeatureValueCondition(PruneHandler pruneHandler, EObjectCondition contextEObjectCondition, EStructuralFeature feature, IEStructuralFeatureValueGetter eStructuralFeatureValueGetter, boolean resolve, Condition valueCondition, ConditionPolicy policy) {
        super(pruneHandler, feature);
        this.evaluator = feature.getUpperBound() == -2 ? new UnspecifiedStructuralFeatureValueEvaluator(valueCondition, policy, feature, eStructuralFeatureValueGetter, resolve) : (feature.isMany() ? new MultipleStructuralFeatureValueEvaluator(valueCondition, policy, feature, eStructuralFeatureValueGetter, resolve) : new StructuralFeatureValueEvaluator(valueCondition, policy, feature, eStructuralFeatureValueGetter, resolve));
        this.featureCondition = contextEObjectCondition == null ? this.evaluator : contextEObjectCondition.AND(this.evaluator);
    }

    public boolean isSatisfied(EObject eObject) {
        if (super.isSatisfied(eObject)) {
            return this.featureCondition.isSatisfied(eObject);
        }
        return false;
    }

    protected final EObjectCondition getStructuralFeatureCondition() {
        return this.featureCondition;
    }

    protected final boolean isResolve() {
        return this.evaluator.resolve;
    }

    public final ConditionPolicy getPolicy() {
        return this.evaluator.policy;
    }

    private static class MultipleStructuralFeatureValueEvaluator
    extends StructuralFeatureValueEvaluator {
        MultipleStructuralFeatureValueEvaluator(Condition valueCondition, ConditionPolicy policy, EStructuralFeature feature, IEStructuralFeatureValueGetter eStructuralFeatureValueGetter, boolean resolve) {
            super(valueCondition, policy, feature, eStructuralFeatureValueGetter, resolve);
        }

        public boolean isSatisfied(EObject eObject) {
            List list = null;
            if (eObject.eIsSet(this.feature)) {
                list = (List)this.eStructuralFeatureValueGetter.eGet(eObject, this.feature, this.resolve);
            } else if (this.feature.getDefaultValue() != null) {
                list = (List)this.feature.getDefaultValue();
            }
            return list == null || list.isEmpty() ? false : this.policy.isSatisfied(this.valueCondition, list);
        }
    }

    private static class StructuralFeatureValueEvaluator
    extends EObjectCondition {
        Condition valueCondition;
        ConditionPolicy policy;
        EStructuralFeature feature;
        IEStructuralFeatureValueGetter eStructuralFeatureValueGetter;
        boolean resolve;

        StructuralFeatureValueEvaluator(Condition valueCondition, ConditionPolicy policy, EStructuralFeature feature, IEStructuralFeatureValueGetter eStructuralFeatureValueGetter, boolean resolve) {
            this.valueCondition = valueCondition;
            this.policy = policy;
            this.feature = feature;
            this.eStructuralFeatureValueGetter = eStructuralFeatureValueGetter;
            this.resolve = resolve;
        }

        public boolean isSatisfied(EObject eObject) {
            Object featureValue = null;
            if (eObject.eIsSet(this.feature)) {
                featureValue = this.eStructuralFeatureValueGetter.eGet(eObject, this.feature, this.resolve);
            } else if (this.feature.getDefaultValue() != null) {
                featureValue = this.feature.getDefaultValue();
            }
            if (featureValue == null) {
                if (this.isNullSearchCondition(this.valueCondition)) {
                    return this.policy.isSatisfied(this.valueCondition, featureValue);
                }
                return false;
            }
            return this.policy.isSatisfied(this.valueCondition, featureValue);
        }

        private boolean isNullSearchCondition(Condition cond) {
            return cond == ObjectInstanceCondition.IS_NULL || cond == EObjectInstanceCondition.IS_NULL;
        }
    }

    private static class UnspecifiedStructuralFeatureValueEvaluator
    extends StructuralFeatureValueEvaluator {
        private MultipleStructuralFeatureValueEvaluator multipleEvaluator;
        private StructuralFeatureValueEvaluator singleEvaluator;

        UnspecifiedStructuralFeatureValueEvaluator(Condition valueCondition, ConditionPolicy policy, EStructuralFeature feature, IEStructuralFeatureValueGetter eStructuralFeatureValueGetter, boolean resolve) {
            super(valueCondition, policy, feature, eStructuralFeatureValueGetter, resolve);
            this.multipleEvaluator = new MultipleStructuralFeatureValueEvaluator(valueCondition, policy, feature, eStructuralFeatureValueGetter, resolve);
            this.singleEvaluator = new StructuralFeatureValueEvaluator(valueCondition, policy, feature, eStructuralFeatureValueGetter, resolve);
        }

        public boolean isSatisfied(EObject eObject) {
            if (FeatureMapUtil.isMany((EObject)eObject, (EStructuralFeature)this.feature)) {
                return this.multipleEvaluator.isSatisfied(eObject);
            }
            return this.singleEvaluator.isSatisfied(eObject);
        }
    }
}

