/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.uml2.tests.message.bug507177;

import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.util.Map;
import org.eclipse.emf.common.util.BasicMonitor;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.ide.ui.tests.framework.RuntimeTestRunner;
import org.eclipse.emf.compare.ide.ui.tests.framework.annotations.Compare;
import org.eclipse.emf.compare.merge.BatchMerger;
import org.eclipse.emf.compare.merge.IMergeOptionAware;
import org.eclipse.emf.compare.merge.IMerger;
import org.eclipse.emf.compare.rcp.EMFCompareRCPPlugin;
import org.junit.runner.RunWith;

@RunWith(value=RuntimeTestRunner.class)
public class AddMessageSubDiffTest {
    private static final IMerger.Registry MERGER_REGISTRY = EMFCompareRCPPlugin.getDefault().getMergerRegistry();
    private static final Map<IMergeOptionAware, Object> CACHED_OPTIONS = Maps.newHashMap();

    public void enableCascadingFilter() {
        this.setCascadingFilter(true);
    }

    public void disableCascadingFilter() {
        this.setCascadingFilter(false);
    }

    public void setCascadingFilter(boolean enabled) {
        for (IMergeOptionAware merger : Iterables.filter((Iterable)MERGER_REGISTRY.getMergers(null), IMergeOptionAware.class)) {
            Map mergeOptions = merger.getMergeOptions();
            Object previousValue = mergeOptions.get("subDiffAwareOption");
            CACHED_OPTIONS.put(merger, previousValue);
            mergeOptions.put("subDiffAwareOption", enabled);
        }
    }

    public void restoreCascadingFilter() {
        for (Map.Entry<IMergeOptionAware, Object> entry : CACHED_OPTIONS.entrySet()) {
            IMergeOptionAware merger = entry.getKey();
            merger.getMergeOptions().put("subDiffAwareOption", entry.getValue());
        }
    }

    @Compare(left="data/left.uml", right="data/right.uml")
    public void testNoDuplicateAddition(Comparison comparison) {
        try {
            this.enableCascadingFilter();
            BatchMerger merger = new BatchMerger(MERGER_REGISTRY);
            merger.copyAllLeftToRight((Iterable)comparison.getDifferences(), (Monitor)new BasicMonitor());
        }
        finally {
            this.restoreCascadingFilter();
        }
    }
}

