/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.tests.merge;

import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.compare.ide.ui.tests.git.framework.GitTestRunner;
import org.eclipse.emf.compare.ide.ui.tests.git.framework.annotations.GitInput;
import org.eclipse.emf.compare.ide.ui.tests.git.framework.annotations.GitMerge;
import org.eclipse.jgit.api.Status;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.runner.RunWith;

@RunWith(value=GitTestRunner.class)
public class MultipleAncestorsTest {
    @Ignore
    @GitInput(value="data/multipleancestors/complex.merge.zip")
    @GitMerge(local="assemblage", remote="arthur")
    public void testComplexMerge(Status status, List<IProject> projects) {
        Assert.assertEquals((long)1L, (long)projects.size());
        this.assertFilesExist(projects.get(0), "index.ecore", "Arthur.ecore", "Laurent.ecore", "Stephane.ecore");
        Assert.assertTrue((boolean)status.getConflicting().isEmpty());
        Assert.assertTrue((boolean)status.isClean());
    }

    @Ignore
    @GitInput(value="data/multipleancestors/library.binaryecore.multiple.ancestors.conflicts.zip")
    @GitMerge(local="master", remote="Stephane")
    public void testLibraryTextualConflicts(Status status, List<IProject> projects) {
        Assert.assertEquals((long)1L, (long)projects.size());
        this.assertFilesExist(projects.get(0), "library.ecore", "types.ecore");
        Assert.assertTrue((boolean)status.getConflicting().isEmpty());
        Assert.assertTrue((boolean)status.isClean());
    }

    @GitInput(value="data/multipleancestors/conflict.base.ancestor.zip")
    @GitMerge(local="assemblage", remote="arthur", expected=JGitInternalException.class)
    public void testModelAndTextualConflictInBaseCommits(Status status, List<IProject> projects) {
        Assert.assertEquals((long)1L, (long)projects.size());
        this.assertFilesExist(projects.get(0), "library.uml", "types.uml");
        Assert.assertTrue((boolean)status.getConflicting().isEmpty());
        Assert.assertTrue((boolean)status.isClean());
    }

    @Ignore
    @GitInput(value="data/multipleancestors/library.binaryecore.multiple.ancestors.no.conflict.different.files.zip")
    @GitMerge(local="master", remote="Stephane")
    public void testLibraryNoConflicts(Status status, List<IProject> projects) {
        Assert.assertEquals((long)1L, (long)projects.size());
        this.assertFilesExist(projects.get(0), "library.ecore", "types.ecore");
        Assert.assertTrue((boolean)status.getConflicting().isEmpty());
        Assert.assertTrue((boolean)status.isClean());
    }

    protected void assertFilesExist(IProject project, String ... files) {
        String[] stringArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            String file = stringArray[n2];
            Assert.assertTrue((String)(String.valueOf(file) + " does not exist."), (boolean)project.getFile(file).exists());
            ++n2;
        }
    }
}

