/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.uml2.tests.dependency;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterators;
import java.io.IOException;
import java.util.List;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceKind;
import org.eclipse.emf.compare.uml2.internal.DirectedRelationshipChange;
import org.eclipse.emf.compare.uml2.tests.AbstractUMLInputData;
import org.eclipse.emf.compare.uml2.tests.AbstractUMLTest;
import org.eclipse.emf.compare.uml2.tests.dependency.data.DependencyInputData;
import org.eclipse.emf.compare.utils.EMFComparePredicates;
import org.eclipse.emf.ecore.resource.Resource;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class AddUsageTest
extends AbstractUMLTest {
    private DependencyInputData input = new DependencyInputData();

    @BeforeClass
    public static void setupClass() {
        AddUsageTest.fillRegistries();
    }

    @AfterClass
    public static void teardownClass() {
        AddUsageTest.resetRegistries();
    }

    @Test
    public void testA80UseCase() throws IOException {
        Resource left = this.input.getA8Left();
        Resource right = this.input.getA8Right();
        Comparison comparison = this.compare((Notifier)left, (Notifier)right);
        this.testAB1(AbstractUMLTest.TestKind.ADD, comparison);
        this.testMergeLeftToRight((Notifier)left, (Notifier)right, null);
        this.testMergeRightToLeft((Notifier)left, (Notifier)right, null);
    }

    @Test
    public void testA81UseCase() throws IOException {
        Resource left = this.input.getA8Left();
        Resource right = this.input.getA8Right();
        Comparison comparison = this.compare((Notifier)right, (Notifier)left);
        this.testAB1(AbstractUMLTest.TestKind.DELETE, comparison);
        this.testMergeLeftToRight((Notifier)right, (Notifier)left, null);
        this.testMergeRightToLeft((Notifier)right, (Notifier)left, null);
    }

    @Test
    public void testA80UseCase3way() throws IOException {
        Resource left = this.input.getA8Left();
        Resource right = this.input.getA8Right();
        Comparison comparison = this.compare((Notifier)left, (Notifier)right, (Notifier)right);
        this.testAB1(AbstractUMLTest.TestKind.ADD, comparison);
        this.testMergeLeftToRight((Notifier)left, (Notifier)right, (Notifier)right);
        this.testMergeRightToLeft((Notifier)left, (Notifier)right, (Notifier)right);
    }

    @Test
    public void testA81UseCase3way() throws IOException {
        Resource left = this.input.getA8Left();
        Resource right = this.input.getA8Right();
        Comparison comparison = this.compare((Notifier)left, (Notifier)right, (Notifier)left);
        this.testAB1(AbstractUMLTest.TestKind.DELETE, comparison);
        this.testMergeLeftToRight((Notifier)left, (Notifier)right, (Notifier)left);
        this.testMergeRightToLeft((Notifier)left, (Notifier)right, (Notifier)left);
    }

    protected void testAB1(AbstractUMLTest.TestKind kind, Comparison comparison) {
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)4L, (long)differences.size());
        Predicate addDependencyDescription = null;
        Predicate addRefClass1InDependencyDescription = null;
        Predicate addRefClass0InDependencyDescription = null;
        if (kind.equals((Object)AbstractUMLTest.TestKind.DELETE)) {
            addDependencyDescription = EMFComparePredicates.removed((String)"model.Usage0");
            addRefClass0InDependencyDescription = EMFComparePredicates.removedFromReference((String)"model.Usage0", (String)"client", (String)"model.Class0");
            addRefClass1InDependencyDescription = EMFComparePredicates.removedFromReference((String)"model.Usage0", (String)"supplier", (String)"model.Class1");
        } else {
            addDependencyDescription = EMFComparePredicates.added((String)"model.Usage0");
            addRefClass0InDependencyDescription = EMFComparePredicates.addedToReference((String)"model.Usage0", (String)"client", (String)"model.Class0");
            addRefClass1InDependencyDescription = EMFComparePredicates.addedToReference((String)"model.Usage0", (String)"supplier", (String)"model.Class1");
        }
        Diff addDependency = (Diff)Iterators.find(differences.iterator(), (Predicate)addDependencyDescription);
        Diff addRefClass0InDependency = (Diff)Iterators.find(differences.iterator(), (Predicate)addRefClass0InDependencyDescription);
        Diff addRefClass1InDependency = (Diff)Iterators.find(differences.iterator(), (Predicate)addRefClass1InDependencyDescription);
        Assert.assertNotNull((Object)addDependency);
        Assert.assertNotNull((Object)addRefClass0InDependency);
        Assert.assertNotNull((Object)addRefClass1InDependency);
        Assert.assertEquals((long)1L, (long)AddUsageTest.count((List<Diff>)differences, (Predicate<Object>)Predicates.instanceOf(DirectedRelationshipChange.class)));
        Diff addUMLDependency = null;
        addUMLDependency = kind.equals((Object)AbstractUMLTest.TestKind.ADD) ? (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)Predicates.instanceOf(DirectedRelationshipChange.class), (Predicate)EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.ADD))) : (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)Predicates.instanceOf(DirectedRelationshipChange.class), (Predicate)EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.DELETE)));
        Assert.assertNotNull((Object)addUMLDependency);
        Assert.assertEquals((long)3L, (long)addUMLDependency.getRefinedBy().size());
        Assert.assertTrue((boolean)addUMLDependency.getRefinedBy().contains((Object)addRefClass0InDependency));
        Assert.assertTrue((boolean)addUMLDependency.getRefinedBy().contains((Object)addRefClass1InDependency));
        Assert.assertTrue((boolean)addUMLDependency.getRefinedBy().contains((Object)addDependency));
        if (kind.equals((Object)AbstractUMLTest.TestKind.ADD)) {
            Assert.assertEquals((long)1L, (long)addRefClass0InDependency.getRequires().size());
            Assert.assertTrue((boolean)addRefClass0InDependency.getRequires().contains((Object)addDependency));
            Assert.assertEquals((long)1L, (long)addRefClass1InDependency.getRequires().size());
            Assert.assertTrue((boolean)addRefClass1InDependency.getRequires().contains((Object)addDependency));
            Assert.assertEquals((long)0L, (long)addDependency.getRequires().size());
            Assert.assertEquals((long)0L, (long)addUMLDependency.getRequires().size());
        } else {
            Assert.assertEquals((long)0L, (long)addRefClass0InDependency.getRequires().size());
            Assert.assertEquals((long)0L, (long)addRefClass1InDependency.getRequires().size());
            Assert.assertEquals((long)2L, (long)addDependency.getRequires().size());
            Assert.assertTrue((boolean)addDependency.getRequires().contains((Object)addRefClass0InDependency));
            Assert.assertTrue((boolean)addDependency.getRequires().contains((Object)addRefClass1InDependency));
            Assert.assertEquals((long)0L, (long)addUMLDependency.getRequires().size());
        }
        Assert.assertEquals((long)0L, (long)comparison.getEquivalences().size());
        Assert.assertNull((Object)addRefClass0InDependency.getEquivalence());
        this.testIntersections(comparison);
    }

    @Override
    protected AbstractUMLInputData getInput() {
        return this.input;
    }
}

