/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer.actions;

import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceState;
import org.eclipse.emf.compare.internal.merge.IMergeData;
import org.eclipse.emf.compare.internal.merge.MergeDataImpl;
import org.eclipse.emf.compare.internal.merge.MergeDependenciesUtil;
import org.eclipse.emf.compare.internal.merge.MergeMode;
import org.eclipse.emf.compare.merge.IMerger;
import org.eclipse.emf.ecore.util.EcoreUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMergeRunnable {
    private final boolean isLeftEditable;
    private final boolean isRightEditable;
    private final MergeMode mergeMode;

    public AbstractMergeRunnable(boolean isLeftEditable, boolean isRightEditable, MergeMode mergeMode) {
        this.isLeftEditable = isLeftEditable;
        this.isRightEditable = isRightEditable;
        this.mergeMode = mergeMode;
    }

    protected boolean isLeftEditable() {
        return this.isLeftEditable;
    }

    protected boolean isRightEditable() {
        return this.isRightEditable;
    }

    protected MergeMode getMergeMode() {
        return this.mergeMode;
    }

    protected void markAllAsMerged(Collection<? extends Diff> diffToMarkAsMerged, MergeMode mode, IMerger.Registry mergerRegistry) {
        Iterator<? extends Diff> iterator = diffToMarkAsMerged.iterator();
        while (iterator.hasNext()) {
            Diff diff;
            boolean isLeftToRight = mode.isLeftToRight(diff = iterator.next(), this.isLeftEditable, this.isRightEditable);
            this.markAsMerged(diff, mode, !isLeftToRight, mergerRegistry);
        }
    }

    protected void markAsMerged(Diff diff, MergeMode mode, boolean mergeRightToLeft, IMerger.Registry mergerRegistry) {
        if (diff.getState() == DifferenceState.MERGED) {
            return;
        }
        Set implied = MergeDependenciesUtil.getAllResultingMerges((Diff)diff, (IMerger.Registry)mergerRegistry, (boolean)mergeRightToLeft);
        for (Diff impliedDiff : implied) {
            impliedDiff.setState(DifferenceState.MERGED);
            this.addOrUpdateMergeData(impliedDiff, mode);
        }
        Set rejections = MergeDependenciesUtil.getAllResultingRejections((Diff)diff, (IMerger.Registry)mergerRegistry, (boolean)mergeRightToLeft);
        for (Diff impliedRejection : rejections) {
            impliedRejection.setState(DifferenceState.MERGED);
            if (this.mergeMode == MergeMode.LEFT_TO_RIGHT || this.mergeMode == MergeMode.RIGHT_TO_LEFT) {
                this.addOrUpdateMergeData(impliedRejection, mode);
                continue;
            }
            this.addOrUpdateMergeData(impliedRejection, mode.inverse());
        }
    }

    protected void addOrUpdateMergeData(Collection<Diff> differences, MergeMode mode) {
        for (Diff difference : differences) {
            this.addOrUpdateMergeData(difference, mode);
        }
    }

    private void addOrUpdateMergeData(Diff diff, MergeMode mode) {
        IMergeData mergeData = (IMergeData)EcoreUtil.getExistingAdapter((Notifier)diff, IMergeData.class);
        if (mergeData != null) {
            mergeData.setMergeMode(mode);
            mergeData.setLeftEditable(this.isLeftEditable);
            mergeData.setRightEditable(this.isRightEditable);
        } else {
            mergeData = new MergeDataImpl(mode, this.isLeftEditable, this.isRightEditable);
            diff.eAdapters().add((Object)mergeData);
        }
    }
}

