/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.diagram.ide.ui.papyrus.contentmergeviewer.item;

import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.diagram.ide.ui.papyrus.contentmergeviewer.item.ContentProviderMergeViewerItem;
import org.eclipse.emf.compare.diagram.ide.ui.papyrus.contentmergeviewer.item.PapyrusContentProviderMergeViewerItem;
import org.eclipse.emf.compare.rcp.ui.mergeviewer.item.IMergeViewerItem;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.papyrus.emf.facet.custom.metamodel.v0_2_0.internal.treeproxy.EObjectTreeElement;
import org.eclipse.papyrus.emf.facet.custom.metamodel.v0_2_0.internal.treeproxy.TreeproxyFactory;

public class MergeViewerItemConverter {
    private AdapterFactory adapterFactory;
    private Comparison comparison;

    public MergeViewerItemConverter(AdapterFactory factory, Comparison comparison) {
        this.adapterFactory = factory;
        this.comparison = comparison;
    }

    public IMergeViewerItem convert(IMergeViewerItem item) {
        if (this.isConversionNeeded(item) && this.isConversionAllowed(item)) {
            return this.doConvert(item);
        }
        return item;
    }

    protected boolean isConversionAllowed(IMergeViewerItem item) {
        return !this.isResourceItem(item);
    }

    private boolean isResourceItem(IMergeViewerItem item) {
        return Resource.class.isInstance(item.getLeft()) || Resource.class.isInstance(item.getRight()) || Resource.class.isInstance(item.getAncestor());
    }

    protected boolean isConversionNeeded(IMergeViewerItem item) {
        return !ContentProviderMergeViewerItem.class.isInstance(item);
    }

    protected IMergeViewerItem doConvert(IMergeViewerItem item) {
        Object value = item.getSideValue(item.getSide());
        if (EObject.class.isInstance(value)) {
            EObjectTreeElement treeElement = TreeproxyFactory.eINSTANCE.createEObjectTreeElement();
            treeElement.setEObject((EObject)EObject.class.cast(value));
            return new PapyrusContentProviderMergeViewerItem(this.comparison, item.getDiff(), item.getLeft(), item.getRight(), item.getAncestor(), item.getSide(), this.adapterFactory, treeElement, null);
        }
        return new ContentProviderMergeViewerItem.Container(this.comparison, item.getDiff(), item.getLeft(), item.getRight(), item.getAncestor(), item.getSide(), this.adapterFactory);
    }
}

