/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.diagram.ide.ui.papyrus.internal.context;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.MatchResource;
import org.eclipse.emf.compare.scope.IComparisonScope2;
import org.eclipse.emf.ecore.util.EcoreUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PapyrusContextUtil {
    private static final Predicate<String> ENDS_WITH_PAPYRUS_EXTENSION = new Predicate<String>(){

        public boolean apply(String input) {
            if (input != null) {
                return input.endsWith("di");
            }
            return false;
        }
    };
    private static final Function<URI, String> URI_TO_STRING = new Function<URI, String>(){

        public String apply(URI input) {
            String uriString = null;
            if (input != null && (uriString = input.toPlatformString(true)) == null) {
                uriString = input.toString();
            }
            return uriString;
        }
    };

    private PapyrusContextUtil() {
    }

    public static boolean isPapyrusContext(Comparison comparison) {
        IComparisonScope2 comparisonScope = (IComparisonScope2)EcoreUtil.getAdapter((List)comparison.eAdapters(), IComparisonScope2.class);
        if (comparisonScope != null) {
            return PapyrusContextUtil.containsPapyrusURI(Collections2.transform((Collection)comparisonScope.getAllInvolvedResourceURIs(), URI_TO_STRING));
        }
        return PapyrusContextUtil.containsPapyrusURI((List<MatchResource>)comparison.getMatchedResources());
    }

    private static boolean containsPapyrusURI(List<MatchResource> matchedResources) {
        ImmutableSet.Builder setBuilder = ImmutableSet.builder();
        for (MatchResource res : matchedResources) {
            for (String uri : ImmutableSet.of((Object)res.getLeftURI(), (Object)res.getRightURI(), (Object)res.getOriginURI())) {
                if (uri == null) continue;
                setBuilder.add((Object)uri);
            }
        }
        return PapyrusContextUtil.containsPapyrusURI((Collection<String>)setBuilder.build());
    }

    private static boolean containsPapyrusURI(Collection<String> uris) {
        return Iterables.any(uris, ENDS_WITH_PAPYRUS_EXTENSION);
    }
}

