/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compre.uml2.edit.papyrus.internal.decorator;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Profile;

public final class PapyrusStereotypedElementUtil {
    private static final String PAPYRUS_PROFILE_URI = "http://www.eclipse.org/papyrus.*";

    private PapyrusStereotypedElementUtil() {
    }

    public static boolean isPapyrusStereotypedElement(Object object) {
        EObject eObject = EMFHelper.getEObject((Object)object);
        if (!(eObject instanceof Element)) {
            return false;
        }
        Element element = (Element)eObject;
        Package nearestPackage = element.getNearestPackage();
        if (nearestPackage == null) {
            return false;
        }
        for (Profile profile : nearestPackage.getAllAppliedProfiles()) {
            if (profile.getURI() == null || !profile.getURI().matches(PAPYRUS_PROFILE_URI)) continue;
            return true;
        }
        return false;
    }
}

