/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.uml2.rcp.internal.policy;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.compare.rcp.policy.ILoadOnDemandPolicy;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.ExtensibleURIConverterImpl;
import org.eclipse.uml2.uml.UMLPlugin;

public class UMLLoadOnDemandPolicy
implements ILoadOnDemandPolicy {
    private static final String PLATFORM_UML_METAMODEL_URI = "platform:/plugin/org.eclipse.uml2.uml.resources/metamodels/UML.metamodel.uml";
    protected static final String UML_EXTENSION = "uml";
    private final BiMap<String, URI> profileNsURIToNormalized = HashBiMap.create();

    public boolean isAuthorizing(URI uri) {
        ExtensibleURIConverterImpl uriConverter = new ExtensibleURIConverterImpl();
        URI normalizedURI = uriConverter.normalize(uri);
        return this.isConventionalURIForUMLProfile(normalizedURI) || this.isUMLMetaModel(normalizedURI) || this.isRegisteredUMLProfile(normalizedURI, (URIConverter)uriConverter);
    }

    protected boolean isRegisteredUMLProfile(URI normalizedURI, URIConverter uriConverter) {
        for (Map.Entry entry : UMLPlugin.getEPackageNsURIToProfileLocationMap().entrySet()) {
            if (this.profileNsURIToNormalized.containsKey(entry.getKey())) continue;
            this.profileNsURIToNormalized.put((Object)((String)entry.getKey()), (Object)uriConverter.normalize((URI)entry.getValue()));
        }
        return this.profileNsURIToNormalized.containsValue((Object)normalizedURI);
    }

    protected boolean isConventionalURIForUMLProfile(URI normalizedURI) {
        URI withoutFirstFileExtension;
        String secondFileExtension;
        URI noFragmentURI = normalizedURI.trimFragment();
        String firstFileExtension = noFragmentURI.fileExtension();
        return UML_EXTENSION.equals(firstFileExtension) && "profile".equals(secondFileExtension = (withoutFirstFileExtension = noFragmentURI.trimFileExtension()).fileExtension());
    }

    protected boolean isUMLMetaModel(URI normalizedURI) {
        URI noFragmentURI = normalizedURI.trimFragment();
        return PLATFORM_UML_METAMODEL_URI.equals(noFragmentURI.toString());
    }
}

