/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.uml2.rcp.ui.internal.accessor;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.List;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.ConflictKind;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceKind;
import org.eclipse.emf.compare.DifferenceState;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.internal.utils.DiffUtil;
import org.eclipse.emf.compare.rcp.ui.internal.contentmergeviewer.accessor.impl.ManyStructuralFeatureAccessorImpl;
import org.eclipse.emf.compare.rcp.ui.mergeviewer.IMergeViewer;
import org.eclipse.emf.compare.uml2.internal.StereotypeApplicationChange;
import org.eclipse.emf.compare.uml2.internal.UMLDiff;
import org.eclipse.emf.compare.utils.EMFComparePredicates;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.util.UMLUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UMLStereotypeApplicationChangeFeatureAccessor
extends ManyStructuralFeatureAccessorImpl {
    private static final EReference STEREOTYPE_APPLICATION = EcoreFactory.eINSTANCE.createEReference();

    static {
        STEREOTYPE_APPLICATION.setName("stereotypeApplications");
        STEREOTYPE_APPLICATION.setUpperBound(-1);
        STEREOTYPE_APPLICATION.setEType((EClassifier)UMLPackage.Literals.STEREOTYPE);
    }

    public UMLStereotypeApplicationChangeFeatureAccessor(AdapterFactory adapterFactory, StereotypeApplicationChange diff, IMergeViewer.MergeViewerSide side) {
        super(adapterFactory, (Diff)diff, side);
    }

    protected List<Stereotype> getFeatureValues(IMergeViewer.MergeViewerSide side) {
        EObject eObject = this.getEObject(side);
        if (eObject instanceof Element) {
            return ((Element)eObject).getAppliedStereotypes();
        }
        return ImmutableList.of();
    }

    public EStructuralFeature getStructuralFeature() {
        return STEREOTYPE_APPLICATION;
    }

    protected Object getValueFromDiff(Diff diff, IMergeViewer.MergeViewerSide side) {
        Object superValue = super.getValueFromDiff(diff, side);
        if (superValue instanceof EObject) {
            return UMLUtil.getStereotype((EObject)((EObject)superValue));
        }
        return superValue;
    }

    protected EStructuralFeature getAffectedFeature(Diff diff) {
        if (diff instanceof UMLDiff) {
            return ((UMLDiff)diff).getEReference();
        }
        return super.getAffectedFeature(diff);
    }

    protected Object getDiffValue(Diff diff) {
        if (diff instanceof UMLDiff) {
            return ((UMLDiff)diff).getDiscriminant();
        }
        return super.getDiffValue(diff);
    }

    protected ImmutableList<Diff> computeDifferences() {
        EList siblingDifferences = this.getInitialDiff().getMatch().getDifferences();
        Predicate diffFilter = Predicates.not((Predicate)EMFComparePredicates.hasConflict((ConflictKind[])new ConflictKind[]{ConflictKind.PSEUDO}));
        return ImmutableList.copyOf((Iterable)Iterables.filter((Iterable)Iterables.filter((Iterable)siblingDifferences, (Predicate)diffFilter), this.getInitialDiff().getClass()));
    }

    protected int findInsertionIndex(Diff diff, boolean rightToLeft) {
        StereotypeApplicationChange stereotypeChange = (StereotypeApplicationChange)diff;
        Match match = diff.getMatch();
        Comparison comparison = match.getComparison();
        List<Stereotype> sourceList = match.getOrigin() != null && diff.getKind() == DifferenceKind.DELETE ? this.getFeatureValues(IMergeViewer.MergeViewerSide.ANCESTOR) : (rightToLeft ? this.getFeatureValues(IMergeViewer.MergeViewerSide.RIGHT) : this.getFeatureValues(IMergeViewer.MergeViewerSide.LEFT));
        List<Stereotype> targetList = rightToLeft ? this.getFeatureValues(IMergeViewer.MergeViewerSide.LEFT) : this.getFeatureValues(IMergeViewer.MergeViewerSide.RIGHT);
        Iterable<Object> ignoredElements = comparison.isThreeWay() && diff.getKind() == DifferenceKind.DELETE ? UMLStereotypeApplicationChangeFeatureAccessor.computeIgnoredElements(targetList, stereotypeChange) : Lists.newArrayList();
        Stereotype stereotype = UMLUtil.getStereotype((EObject)stereotypeChange.getDiscriminant());
        return DiffUtil.findInsertionIndex((Comparison)comparison, (Iterable)ignoredElements, sourceList, targetList, (Object)stereotype);
    }

    private static <E> Iterable<E> computeIgnoredElements(Iterable<E> candidates, final StereotypeApplicationChange diff) {
        return Iterables.filter(candidates, (Predicate)new Predicate<Object>(){

            public boolean apply(Object element) {
                if (element instanceof EObject) {
                    Comparison comparison = diff.getMatch().getComparison();
                    Match match = comparison.getMatch((EObject)element);
                    return Iterables.any((Iterable)match.getDifferences(), (Predicate)Predicates.and((Predicate)Predicates.instanceOf(StereotypeApplicationChange.class), (Predicate)EMFComparePredicates.hasState((DifferenceState[])new DifferenceState[]{DifferenceState.UNRESOLVED})));
                }
                return false;
            }
        });
    }
}

