/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.merge;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceSource;
import org.eclipse.emf.compare.MatchResource;
import org.eclipse.emf.compare.ResourceLocationChange;
import org.eclipse.emf.compare.merge.AbstractMerger;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;

public class ResourceLocationChangeMerger
extends AbstractMerger {
    public boolean isMergerFor(Diff target) {
        return target instanceof ResourceLocationChange;
    }

    protected void accept(Diff diff, boolean rightToLeft) {
        ResourceLocationChange resourceLocationChange = (ResourceLocationChange)diff;
        switch (diff.getKind()) {
            case CHANGE: {
                this.change(resourceLocationChange, rightToLeft);
                break;
            }
        }
    }

    protected void reject(Diff diff, boolean rightToLeft) {
        ResourceLocationChange resourceLocationChange = (ResourceLocationChange)diff;
        switch (diff.getKind()) {
            case CHANGE: {
                this.change(resourceLocationChange, rightToLeft);
                break;
            }
        }
    }

    private void change(ResourceLocationChange resourceLocationChange, boolean rightToLeft) {
        EObject container = resourceLocationChange.eContainer();
        if (!(container instanceof MatchResource)) {
            return;
        }
        MatchResource matchResource = (MatchResource)container;
        Resource baseResource = this.getResource(matchResource, resourceLocationChange.getBaseLocation());
        Resource changedResource = this.getResource(matchResource, resourceLocationChange.getChangedLocation());
        if (rightToLeft && DifferenceSource.LEFT == resourceLocationChange.getSource()) {
            Resource newChangedResource = changedResource.getResourceSet().createResource(baseResource.getURI());
            EList changedContents = changedResource.getContents();
            newChangedResource.getContents().addAll((Collection)changedContents);
            newChangedResource.getResourceSet().getResources().remove((Object)changedResource);
            try {
                newChangedResource.save(Collections.emptyMap());
                changedResource.delete(Collections.emptyMap());
            }
            catch (IOException iOException) {}
        } else if (rightToLeft && DifferenceSource.RIGHT == resourceLocationChange.getSource()) {
            Resource newBaseResource = baseResource.getResourceSet().createResource(changedResource.getURI());
            EList baseContents = baseResource.getContents();
            newBaseResource.getContents().addAll((Collection)baseContents);
            newBaseResource.getResourceSet().getResources().remove((Object)baseResource);
            try {
                newBaseResource.save(Collections.emptyMap());
                baseResource.delete(Collections.emptyMap());
            }
            catch (IOException iOException) {}
        }
    }

    private Resource getResource(MatchResource matchResource, String uri) {
        Object resource = uri.equals(matchResource.getLeftURI()) ? matchResource.getLeft() : (uri.equals(matchResource.getRightURI()) ? matchResource.getRight() : (uri.equals(matchResource.getOriginURI()) ? matchResource.getOrigin() : null));
        return resource;
    }
}

