/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.rcp.internal.extension.impl;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.emf.compare.rcp.EMFCompareRCPPlugin;
import org.eclipse.emf.compare.rcp.internal.extension.IItemDescriptor;
import org.eclipse.emf.compare.rcp.internal.extension.IItemRegistry;
import org.osgi.service.prefs.Preferences;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ItemUtil {
    public static final String PREFFERENCE_DELIMITER = ";";

    private ItemUtil() {
    }

    public static <T> T getItem(IItemRegistry<T> registry, String preferenceKey, IEclipsePreferences itemPreferences) {
        IItemDescriptor<T> desc = ItemUtil.getDefaultItemDescriptor(registry, preferenceKey, itemPreferences);
        if (desc != null) {
            return desc.getItem();
        }
        return null;
    }

    public static <T> IItemDescriptor<T> getDefaultItemDescriptor(IItemRegistry<T> registry, String preferenceKey, IEclipsePreferences itemPreferences) {
        IItemDescriptor<T> descriptor;
        IItemDescriptor<T> result = ItemUtil.getItemDescriptorFromPref(registry, itemPreferences, preferenceKey);
        if (result == null && (descriptor = registry.getHighestRankingDescriptor()) != null) {
            result = descriptor;
        }
        return result;
    }

    private static <T> IItemDescriptor<T> getItemDescriptorFromPref(IItemRegistry<T> registry, IEclipsePreferences itemPreferences, String preferenceKey) {
        IItemDescriptor<T> descritpor;
        String itemKey = itemPreferences.get(preferenceKey, null);
        IItemDescriptor<T> result = null;
        if (itemKey != null && (descritpor = registry.getItemDescriptor(itemKey)) != null) {
            result = descritpor;
        }
        return result;
    }

    public static <T> List<IItemDescriptor<T>> getItemsDescriptor(IItemRegistry<T> registry, String preferenceKey, IEclipsePreferences itemPreferences) {
        String diffEngineKey = itemPreferences.get(preferenceKey, null);
        ArrayList<IItemDescriptor<T>> result = null;
        if (diffEngineKey != null) {
            String[] diffEngineKeys;
            String[] stringArray = diffEngineKeys = diffEngineKey.split(PREFFERENCE_DELIMITER);
            int n = diffEngineKeys.length;
            int n2 = 0;
            while (n2 < n) {
                String nonTrimedKey = stringArray[n2];
                String key = nonTrimedKey.trim();
                IItemDescriptor<T> descritpor = registry.getItemDescriptor(key);
                if (descritpor != null) {
                    if (result == null) {
                        result = new ArrayList<IItemDescriptor<T>>();
                    }
                    result.add(descritpor);
                }
                ++n2;
            }
        }
        return result;
    }

    public static Preferences getConfigurationPreferenceNode(String type, String itemId) {
        return EMFCompareRCPPlugin.getDefault().getEMFComparePreferences().node(type).node(itemId);
    }
}

