/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.rcp.internal.extension.impl;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.ILog;
import org.eclipse.emf.compare.rcp.extension.AbstractRegistryEventListener;
import org.eclipse.emf.compare.rcp.internal.EMFCompareRCPMessages;
import org.eclipse.emf.compare.rcp.internal.extension.IItemDescriptor;
import org.eclipse.emf.compare.rcp.internal.extension.IItemRegistry;
import org.eclipse.emf.compare.rcp.internal.extension.impl.ItemDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DescriptorRegistryEventListener<T>
extends AbstractRegistryEventListener {
    public static final String LABEL_DESCRIPTOR_ATTR = "label";
    public static final String DESCRITPION_DESCRIPTOR_ATTR = "description";
    public static final String IMPL_CLASS_DESCRIPTOR_ATTR = "impl";
    public static final String RANK_DESCRIPTOR_ATTR = "ranking";
    public static final String ID_DESCRIPTOR_ATTR = "id";
    public static final String TAG_DESCRIPTOR = "descriptor";
    private static final String EMPTY_STRING = "";
    private final IItemRegistry<T> registry;

    public DescriptorRegistryEventListener(String namespace, String extensionPointID, ILog log, IItemRegistry<T> registry) {
        super(namespace, extensionPointID, log);
        this.registry = registry;
    }

    @Override
    protected boolean validateExtensionElement(IConfigurationElement element) {
        boolean ret;
        if (TAG_DESCRIPTOR.equals(element.getName())) {
            if (element.getAttribute(IMPL_CLASS_DESCRIPTOR_ATTR) == null) {
                this.logMissingAttribute(element, IMPL_CLASS_DESCRIPTOR_ATTR);
                ret = false;
            } else if (element.getAttribute(LABEL_DESCRIPTOR_ATTR) == null) {
                this.logMissingAttribute(element, LABEL_DESCRIPTOR_ATTR);
                ret = false;
            } else if (element.getAttribute(DESCRITPION_DESCRIPTOR_ATTR) == null) {
                this.logMissingAttribute(element, DESCRITPION_DESCRIPTOR_ATTR);
                ret = false;
            } else if (element.getAttribute(RANK_DESCRIPTOR_ATTR) == null) {
                this.logMissingAttribute(element, RANK_DESCRIPTOR_ATTR);
                ret = false;
            } else if (element.getAttribute(ID_DESCRIPTOR_ATTR) == null) {
                this.logMissingAttribute(element, ID_DESCRIPTOR_ATTR);
                ret = false;
            } else if (EMPTY_STRING.equals(element.getAttribute(ID_DESCRIPTOR_ATTR))) {
                this.logMissingAttribute(element, ID_DESCRIPTOR_ATTR);
                ret = false;
            } else if (element.getAttribute(RANK_DESCRIPTOR_ATTR) != null) {
                String rankingStr = element.getAttribute(RANK_DESCRIPTOR_ATTR);
                try {
                    Integer.parseInt(rankingStr);
                }
                catch (NumberFormatException numberFormatException) {
                    this.log(4, element, EMFCompareRCPMessages.getString("malformed.extension.attribute", RANK_DESCRIPTOR_ATTR));
                    return false;
                }
                ret = true;
            } else {
                ret = true;
            }
        } else {
            ret = false;
        }
        return ret;
    }

    @Override
    protected boolean addedValid(IConfigurationElement element) {
        String id;
        String description;
        int rank = Integer.parseInt(element.getAttribute(RANK_DESCRIPTOR_ATTR));
        String label = element.getAttribute(LABEL_DESCRIPTOR_ATTR);
        ItemDescriptor descriptor = new ItemDescriptor(label, description = element.getAttribute(DESCRITPION_DESCRIPTOR_ATTR), rank, element, id = element.getAttribute(ID_DESCRIPTOR_ATTR));
        IItemDescriptor<T> previous = this.registry.add(descriptor);
        if (previous != null) {
            this.log(2, element, EMFCompareRCPMessages.getString("duplicate.extension", this.registry.getClass().getName()));
        }
        return true;
    }

    @Override
    protected boolean removedValid(IConfigurationElement element) {
        return this.registry.remove(element.getAttribute(ID_DESCRIPTOR_ATTR)) != null;
    }
}

