/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.uml2.diff.internal.extension.clazz;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceKind;
import org.eclipse.emf.compare.ReferenceChange;
import org.eclipse.emf.compare.uml2.AssociationChange;
import org.eclipse.emf.compare.uml2.UMLCompareFactory;
import org.eclipse.emf.compare.uml2.UMLDiff;
import org.eclipse.emf.compare.uml2.diff.internal.extension.AbstractDiffExtensionFactory;
import org.eclipse.emf.compare.utils.MatchUtil;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.uml2.uml.Association;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.UMLPackage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UMLAssociationChangeFactory
extends AbstractDiffExtensionFactory {
    @Override
    public Class<? extends UMLDiff> getExtensionKind() {
        return AssociationChange.class;
    }

    @Override
    protected UMLDiff createExtension() {
        return UMLCompareFactory.eINSTANCE.createAssociationChange();
    }

    @Override
    protected EObject getDiscriminantFromDiff(Diff input) {
        EObject container;
        EObject result = null;
        DifferenceKind kind = this.getRelatedExtensionKind(input);
        if (kind == DifferenceKind.ADD || kind == DifferenceKind.DELETE) {
            result = ((ReferenceChange)input).getValue();
        } else if (kind == DifferenceKind.CHANGE && (container = MatchUtil.getContainer((Comparison)input.getMatch().getComparison(), (Diff)input)) instanceof Property) {
            result = ((Property)container).getAssociation();
        }
        return result;
    }

    @Override
    protected List<EObject> getPotentialChangedValuesFromDiscriminant(EObject discriminant) {
        ArrayList<EObject> result = new ArrayList<EObject>();
        if (discriminant instanceof Association) {
            result.add(discriminant);
            result.addAll((Collection<EObject>)((Association)discriminant).getEndTypes());
            for (Property property : ((Association)discriminant).getMemberEnds()) {
                result.add((EObject)property);
                if (property.getLowerValue() != null) {
                    result.add((EObject)property.getLowerValue());
                }
                if (property.getUpperValue() == null) continue;
                result.add((EObject)property.getUpperValue());
            }
        }
        return result;
    }

    @Override
    protected boolean isRelatedToAnExtensionAdd(ReferenceChange input) {
        return input.getReference().isContainment() && input.getKind().equals((Object)DifferenceKind.ADD) && input.getValue() instanceof Association && ((Association)input.getValue()).getEndTypes() != null && ((Association)input.getValue()).getEndTypes().size() > 1;
    }

    @Override
    protected boolean isRelatedToAnExtensionDelete(ReferenceChange input) {
        return input.getReference().isContainment() && input.getKind().equals((Object)DifferenceKind.DELETE) && input.getValue() instanceof Association;
    }

    @Override
    protected boolean isRelatedToAnExtensionChange(ReferenceChange input) {
        EObject diffContainer = MatchUtil.getContainer((Comparison)input.getMatch().getComparison(), (Diff)input);
        return UMLAssociationChangeFactory.isAssociationPropertyChange(input, diffContainer) || UMLAssociationChangeFactory.isAssociationPropertyCardinalityChange(input, diffContainer);
    }

    private static boolean isAssociationPropertyChange(ReferenceChange input, EObject diffContainer) {
        return input.getReference().equals(UMLPackage.Literals.TYPED_ELEMENT__TYPE) && diffContainer instanceof Property && ((Property)diffContainer).getAssociation() != null || input.getReference().equals(UMLPackage.Literals.PROPERTY__ASSOCIATION);
    }

    private static boolean isAssociationPropertyCardinalityChange(ReferenceChange input, EObject diffContainer) {
        return (input.getReference().equals(UMLPackage.Literals.MULTIPLICITY_ELEMENT__LOWER_VALUE) || input.getReference().equals(UMLPackage.Literals.MULTIPLICITY_ELEMENT__UPPER_VALUE)) && diffContainer instanceof Property && ((Property)diffContainer).getAssociation() != null;
    }
}

