/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.extension.merge;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.compare.Diff;

public interface IMerger {
    public boolean isMergerFor(Diff var1);

    public int getRanking();

    public void setRanking(int var1);

    public void copyRightToLeft(Diff var1, Monitor var2);

    public void copyLeftToRight(Diff var1, Monitor var2);

    public void setRegistry(Registry var1);

    public Registry getRegistry();

    public static abstract class AbstractMerger
    implements IMerger {
        private int ranking;
        private Registry registry;

        public int getRanking() {
            return this.ranking;
        }

        public void setRanking(int r) {
            this.ranking = r;
        }

        public Registry getRegistry() {
            return this.registry;
        }

        public void setRegistry(Registry registry) {
            if (this.registry != null && registry != null) {
                throw new IllegalStateException("The registry has to be set only once.");
            }
            this.registry = registry;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Registry {
        public IMerger getHighestRankingMerger(Diff var1);

        public Collection<IMerger> getMergers(Diff var1);

        public IMerger add(IMerger var1);

        public IMerger remove(String var1);

        public void clear();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RegistryImpl
    implements Registry {
        private final Map<String, IMerger> map = new ConcurrentHashMap<String, IMerger>();

        static final Predicate<IMerger> isMergerFor(final Diff target) {
            return new Predicate<IMerger>(){

                public boolean apply(IMerger d) {
                    return d.isMergerFor(target);
                }
            };
        }

        @Override
        public IMerger add(IMerger merger) {
            Preconditions.checkNotNull((Object)merger);
            merger.setRegistry(this);
            return this.map.put(merger.getClass().getName(), merger);
        }

        @Override
        public IMerger remove(String className) {
            IMerger previous = this.map.remove(className);
            if (previous != null) {
                previous.setRegistry(null);
            }
            return previous;
        }

        @Override
        public void clear() {
            this.map.clear();
        }

        @Override
        public IMerger getHighestRankingMerger(Diff target) {
            Iterator<IMerger> mergers = this.getMergers(target).iterator();
            IMerger ret = null;
            if (mergers.hasNext()) {
                IMerger highestRanking = mergers.next();
                while (mergers.hasNext()) {
                    IMerger merger = mergers.next();
                    if (merger.getRanking() <= highestRanking.getRanking()) continue;
                    highestRanking = merger;
                }
                ret = highestRanking;
            }
            return ret;
        }

        @Override
        public Collection<IMerger> getMergers(Diff target) {
            Iterable mergers = Iterables.filter(this.map.values(), RegistryImpl.isMergerFor(target));
            ArrayList ret = Lists.newArrayList();
            for (IMerger merger : mergers) {
                ret.add(merger);
            }
            return ret;
        }
    }
}

