/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.internal.extension;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IRegistryEventListener;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.compare.extension.PostProcessorDescriptor;
import org.eclipse.emf.compare.extension.PostProcessorRegistry;
import org.eclipse.emf.compare.ide.internal.extension.PostProcessorIDEDescriptor;

public class PostProcessorRegistryListener
implements IRegistryEventListener {
    public static final String POST_PROCESSOR_EXTENSION_POINT = "org.eclipse.emf.compare.postProcessor";
    private static final String POST_PROCESSOR_TAG = "postProcessor";
    private final PostProcessorRegistry registry;

    public PostProcessorRegistryListener(PostProcessorRegistry registry) {
        this.registry = registry;
    }

    public void added(IExtension[] extensions) {
        IExtension[] iExtensionArray = extensions;
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension extension = iExtensionArray[n2];
            this.parseExtension(extension);
            ++n2;
        }
    }

    public void added(IExtensionPoint[] extensionPoints) {
    }

    public void parseInitialContributions() {
        IExtensionRegistry extensionRegistry = Platform.getExtensionRegistry();
        IExtension[] iExtensionArray = extensionRegistry.getExtensionPoint(POST_PROCESSOR_EXTENSION_POINT).getExtensions();
        int n = iExtensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension extension = iExtensionArray[n2];
            this.parseExtension(extension);
            ++n2;
        }
    }

    public void removed(IExtension[] extensions) {
        IExtension[] iExtensionArray = extensions;
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement[] configElements;
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = configElements = extension.getConfigurationElements();
            int n3 = configElements.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement elem = iConfigurationElementArray[n4];
                if (POST_PROCESSOR_TAG.equals(elem.getName())) {
                    String postProcessorClassName = elem.getAttribute("class");
                    this.registry.removePostProcessor(postProcessorClassName);
                }
                ++n4;
            }
            ++n2;
        }
    }

    public void removed(IExtensionPoint[] extensionPoints) {
    }

    private void parseExtension(IExtension extension) {
        IConfigurationElement[] configElements;
        IConfigurationElement[] iConfigurationElementArray = configElements = extension.getConfigurationElements();
        int n = configElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            if (POST_PROCESSOR_TAG.equals(element.getName())) {
                this.registry.addPostProcessor((PostProcessorDescriptor)new PostProcessorIDEDescriptor(element));
            }
            ++n2;
        }
    }
}

