/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.compiler;

import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.m2m.internal.qvt.oml.NLS;
import org.eclipse.m2m.internal.qvt.oml.QvtMessage;
import org.eclipse.m2m.internal.qvt.oml.ast.binding.ASTBindingHelper;
import org.eclipse.m2m.internal.qvt.oml.ast.env.QVTParsingOptions;
import org.eclipse.m2m.internal.qvt.oml.ast.env.QvtEnvironmentBase;
import org.eclipse.m2m.internal.qvt.oml.ast.env.QvtOperationalEnv;
import org.eclipse.m2m.internal.qvt.oml.ast.env.QvtOperationalEnvFactory;
import org.eclipse.m2m.internal.qvt.oml.ast.env.QvtOperationalFileEnv;
import org.eclipse.m2m.internal.qvt.oml.ast.env.QvtOperationalModuleEnv;
import org.eclipse.m2m.internal.qvt.oml.ast.parser.ExternalUnitElementsProvider;
import org.eclipse.m2m.internal.qvt.oml.ast.parser.QvtOperationalParser;
import org.eclipse.m2m.internal.qvt.oml.ast.parser.QvtOperationalParserUtil;
import org.eclipse.m2m.internal.qvt.oml.ast.parser.QvtOperationalValidationVisitor;
import org.eclipse.m2m.internal.qvt.oml.ast.parser.QvtOperationalVisitorCS;
import org.eclipse.m2m.internal.qvt.oml.common.MdaException;
import org.eclipse.m2m.internal.qvt.oml.compiler.BasicLineNumberProvider;
import org.eclipse.m2m.internal.qvt.oml.compiler.BlackboxUnitResolver;
import org.eclipse.m2m.internal.qvt.oml.compiler.CompiledUnit;
import org.eclipse.m2m.internal.qvt.oml.compiler.CompilerMessages;
import org.eclipse.m2m.internal.qvt.oml.compiler.CompilerUtils;
import org.eclipse.m2m.internal.qvt.oml.compiler.EmfStandaloneMetamodelRegistryProvider;
import org.eclipse.m2m.internal.qvt.oml.compiler.ExeXMISerializer;
import org.eclipse.m2m.internal.qvt.oml.compiler.ProjectMetamodelRegistryProvider;
import org.eclipse.m2m.internal.qvt.oml.compiler.QvtCompilerOptions;
import org.eclipse.m2m.internal.qvt.oml.compiler.ResolverUtils;
import org.eclipse.m2m.internal.qvt.oml.compiler.UnitContents;
import org.eclipse.m2m.internal.qvt.oml.compiler.UnitProxy;
import org.eclipse.m2m.internal.qvt.oml.compiler.UnitResolver;
import org.eclipse.m2m.internal.qvt.oml.compiler.UnitResolverFactory;
import org.eclipse.m2m.internal.qvt.oml.cst.ImportCS;
import org.eclipse.m2m.internal.qvt.oml.cst.UnitCS;
import org.eclipse.m2m.internal.qvt.oml.cst.parser.AbstractQVTParser;
import org.eclipse.m2m.internal.qvt.oml.emf.util.EmfUtil;
import org.eclipse.m2m.internal.qvt.oml.emf.util.mmregistry.IMetamodelRegistryProvider;
import org.eclipse.m2m.internal.qvt.oml.expressions.ModelType;
import org.eclipse.ocl.ParserException;
import org.eclipse.ocl.SemanticException;
import org.eclipse.ocl.cst.CSTNode;
import org.eclipse.ocl.cst.PathNameCS;
import org.eclipse.ocl.cst.SimpleNameCS;
import org.eclipse.ocl.lpg.AbstractLexer;
import org.eclipse.ocl.parser.AbstractOCLParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QVTOCompiler {
    private static final String NAMESPACE_SEP = String.valueOf('.');
    private final Map<URI, CompiledUnit> fSource2Compiled = new HashMap<URI, CompiledUnit>();
    private final Stack<DependencyPathElement> fDependencyWalkPath = new Stack();
    private final IMetamodelRegistryProvider fMetamodelRegistryProvider;
    private ResourceSetImpl fExeXMIResourceSet;
    private boolean fUseCompiledXMI = false;

    public static QVTOCompiler createCompilerWithHistory(ResourceSet metamodelResourceSet) {
        metamodelResourceSet = metamodelResourceSet == null ? new ResourceSetImpl() : metamodelResourceSet;
        return new QVTOCompiler(QVTOCompiler.createMetamodelRegistryProvider(metamodelResourceSet)){

            protected void afterCompileCleanup() {
            }

            public void cleanup() {
                super.cleanup();
                this.afterCompileCleanup();
            }
        };
    }

    public static CompiledUnit[] compile(Set<URI> unitURIs, EPackage.Registry registry) throws MdaException {
        BasicEList unitProxies = new BasicEList();
        for (URI importURI : unitURIs) {
            UnitProxy unit = UnitResolverFactory.Registry.INSTANCE.getUnit(importURI);
            if (unit == null) continue;
            unitProxies.add((Object)unit);
        }
        if (!unitProxies.isEmpty()) {
            QVTOCompiler compiler = new QVTOCompiler(registry);
            QvtCompilerOptions options = new QvtCompilerOptions();
            options.setGenerateCompletionData(true);
            return compiler.compile((UnitProxy[])unitProxies.toArray((Object[])new UnitProxy[unitProxies.size()]), options, null);
        }
        return new CompiledUnit[0];
    }

    public QVTOCompiler() {
        this(EPackage.Registry.INSTANCE);
    }

    public QVTOCompiler(EPackage.Registry packageRegistry) {
        this((IMetamodelRegistryProvider)(EMFPlugin.IS_ECLIPSE_RUNNING && EMFPlugin.IS_RESOURCES_BUNDLE_AVAILABLE ? new ProjectMetamodelRegistryProvider(packageRegistry) : new EmfStandaloneMetamodelRegistryProvider(packageRegistry)));
    }

    public QVTOCompiler(IMetamodelRegistryProvider metamodelRegistryProvider) {
        Map uriResourceMap;
        this.fMetamodelRegistryProvider = metamodelRegistryProvider;
        this.fExeXMIResourceSet = CompiledUnit.createResourceSet();
        if (this.getResourceSet() instanceof ResourceSetImpl && (uriResourceMap = ((ResourceSetImpl)this.getResourceSet()).getURIResourceMap()) != null) {
            this.fExeXMIResourceSet.setURIResourceMap(new HashMap(uriResourceMap));
        }
    }

    public void setUseCompiledXMI(boolean flag) {
        this.fUseCompiledXMI = flag;
    }

    public CompiledUnit[] compile(UnitProxy[] sources, QvtCompilerOptions options, IProgressMonitor monitor) throws MdaException {
        if (options == null) {
            options = this.getDefaultOptions();
        }
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)"Compile sources", (int)sources.length);
        CompiledUnit[] result = new CompiledUnit[sources.length];
        try {
            int i = 0;
            UnitProxy[] unitProxyArray = sources;
            int n = sources.length;
            int n2 = 0;
            while (n2 < n) {
                UnitProxy nextSource = unitProxyArray[n2];
                if (subMonitor.isCanceled()) {
                    CompilerUtils.throwOperationCanceled();
                }
                result[i++] = this.compileSingleFile(nextSource, options, (IProgressMonitor)subMonitor.newChild(1, 0));
                ++n2;
            }
        }
        finally {
            this.fDependencyWalkPath.clear();
            this.afterCompileCleanup();
            if (monitor != null) {
                monitor.done();
            }
        }
        return result;
    }

    public CompiledUnit compile(UnitProxy source, QvtCompilerOptions options, IProgressMonitor monitor) throws MdaException {
        return this.compile(new UnitProxy[]{source}, options, monitor)[0];
    }

    protected CSTParseResult parse(UnitProxy source, QvtCompilerOptions options) throws ParserException {
        Reader reader = null;
        UnitCS unitCS = null;
        try {
            reader = this.createReader(source);
            EPackage.Registry ePackageRegistry = this.getEPackageRegistry(source.getURI());
            QvtOperationalFileEnv env = new QvtOperationalEnvFactory(ePackageRegistry).createEnvironment(source.getURI());
            if (options.isEnableCSTModelToken()) {
                env.setOption(QVTParsingOptions.ENABLE_CSTMODEL_TOKENS, true);
            }
            QvtOperationalParser qvtParser = new QvtOperationalParser();
            unitCS = qvtParser.parse(reader, source.getName(), env);
            CSTParseResult result = new CSTParseResult();
            result.unitCS = unitCS;
            result.env = env;
            result.parser = qvtParser.getParser();
            CSTParseResult cSTParseResult = result;
            return cSTParseResult;
        }
        catch (IOException e) {
            String ioErrorMessage = NLS.bind(CompilerMessages.sourceReadingIOError, source.getURI());
            throw new ParserException(ioErrorMessage, (Throwable)e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static Reader getContentReader(UnitProxy unit) throws IOException {
        UnitContents contents = unit.getContents();
        if (!(contents instanceof UnitContents.CSTContents)) {
            throw new IllegalArgumentException("unit has no CST stream");
        }
        UnitContents.CSTContents cst = (UnitContents.CSTContents)contents;
        return cst.getContents();
    }

    protected Reader createReader(UnitProxy unit) throws IOException {
        return QVTOCompiler.getContentReader(unit);
    }

    private CSTAnalysisResult analyze(CSTParseResult parseResult, UnitProxy unit, ExternalUnitElementsProvider externalUnitElementsProvider, QvtCompilerOptions options, IProgressMonitor monitor) {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)("Analyze " + unit.getQualifiedName()), (int)10);
        QvtOperationalFileEnv env = parseResult.env;
        env.setQvtCompilerOptions(options);
        CSTAnalysisResult result = new CSTAnalysisResult();
        try {
            QvtOperationalVisitorCS visitor = this.createAnalyzer(parseResult.parser, options, (IProgressMonitor)subMonitor.newChild(9));
            UnitCS unitCS = parseResult.unitCS;
            if (unitCS != null && !unitCS.getModules().isEmpty()) {
                result.moduleEnvs = visitor.visitUnitCS(unitCS, unit, env, externalUnitElementsProvider, this.getResourceSet());
            }
        }
        catch (SemanticException e) {
            env.reportError(e.getLocalizedMessage(), 0, 0);
        }
        if (options.isReportErrors()) {
            subMonitor.setWorkRemaining(result.moduleEnvs.size());
            for (QvtOperationalModuleEnv moduleEnv : result.moduleEnvs) {
                moduleEnv.setCheckForDuplicateErrors(true);
                QvtOperationalValidationVisitor validation = new QvtOperationalValidationVisitor(moduleEnv);
                validation.visitModule(moduleEnv.getModuleContextType());
                moduleEnv.setCheckForDuplicateErrors(false);
                subMonitor.worked(1);
            }
        }
        return result;
    }

    protected QvtOperationalVisitorCS createAnalyzer(AbstractQVTParser parser, QvtCompilerOptions options, IProgressMonitor monitor) {
        return new QvtOperationalVisitorCS((AbstractOCLParser)parser, options, monitor);
    }

    protected void afterCompileCleanup() {
        this.fSource2Compiled.clear();
        this.fDependencyWalkPath.clear();
        this.fExeXMIResourceSet.getResources().clear();
    }

    private CompiledUnit compileSingleFile(UnitProxy source, QvtCompilerOptions options, IProgressMonitor monitor) throws MdaException {
        CompiledUnit nextResult = null;
        try {
            nextResult = this.doCompile(source, options, monitor);
        }
        catch (ParserException e) {
            Throwable cause = e.getCause() != null ? e.getCause() : e;
            throw new MdaException(cause);
        }
        return nextResult;
    }

    private CompiledUnit doCompile(UnitProxy source, QvtCompilerOptions options, IProgressMonitor monitor) throws ParserException {
        try {
            CompiledUnit binXMIUnit;
            List compiledImports = null;
            DependencyPathElement dependencyElement = new DependencyPathElement(source);
            this.fDependencyWalkPath.push(dependencyElement);
            if (this.fSource2Compiled.containsKey(source.getURI())) {
                CompiledUnit compiledUnit = this.fSource2Compiled.get(source.getURI());
                return compiledUnit;
            }
            if (this.fUseCompiledXMI && (binXMIUnit = this.getCompiledExeXMIUnit(source)) != null) {
                this.fSource2Compiled.put(source.getURI(), binXMIUnit);
                CompiledUnit compiledUnit = binXMIUnit;
                return compiledUnit;
            }
            if (source instanceof BlackboxUnitResolver.BlackboxUnitProxy) {
                CompiledUnit blackbox = ((BlackboxUnitResolver.BlackboxUnitProxy)source).load(this.fMetamodelRegistryProvider);
                this.fSource2Compiled.put(source.getURI(), blackbox);
                CompiledUnit compiledUnit = blackbox;
                return compiledUnit;
            }
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)("Compile " + source.getURI().toString()), (int)10);
            subMonitor.subTask("Parsing");
            CSTParseResult parseResult = this.parse(source, options);
            monitor.worked(1);
            QvtOperationalFileEnv env = parseResult.env;
            dependencyElement.importerEnv = env;
            UnitCS unitCS = parseResult.unitCS;
            UnitResolverImpl unitResolver = new UnitResolverImpl(source);
            List<ImportCS> allUnitImportsCS = parseResult.getImports();
            subMonitor.subTask("Processing imports");
            subMonitor.setWorkRemaining(allUnitImportsCS.size() + 1);
            for (ImportCS nextImportCS : allUnitImportsCS) {
                String importQNameStr = QVTOCompiler.getQualifiedName(nextImportCS);
                if (importQNameStr == null || importQNameStr.length() == 0) {
                    subMonitor.worked(1);
                    continue;
                }
                UnitProxy importedUnit = this.resolveImportedUnit(source, importQNameStr);
                if (importedUnit == null) {
                    String notFoundMessage = NLS.bind(CompilerMessages.importedCompilationUnitNotFound, QvtOperationalParserUtil.getStringRepresentation(nextImportCS.getPathNameCS(), NAMESPACE_SEP));
                    env.reportError(notFoundMessage, (CSTNode)nextImportCS.getPathNameCS());
                    subMonitor.worked(1);
                    continue;
                }
                dependencyElement.currentProcessedImport = nextImportCS;
                DependencyPathElement importerDependencyElement = this.findDependencyElement(importedUnit);
                if (importerDependencyElement != null) {
                    ImportCS importedCS = importerDependencyElement.currentProcessedImport;
                    if (env != importerDependencyElement.importerEnv) {
                        QVTOCompiler.reportCyclicImportError(importedUnit.getURI(), source.getURI(), (CSTNode)importedCS.getPathNameCS(), importerDependencyElement.importerEnv);
                    }
                    QVTOCompiler.reportCyclicImportError(source.getURI(), importedUnit.getURI(), (CSTNode)nextImportCS.getPathNameCS(), env);
                    subMonitor.worked(1);
                    continue;
                }
                CompiledUnit compiledImport = this.doCompile(importedUnit, options, (IProgressMonitor)subMonitor.newChild(1, 0));
                if (!compiledImport.getErrors().isEmpty()) {
                    String errorMessage = NLS.bind(CompilerMessages.importHasCompilationError, QvtOperationalParserUtil.getStringRepresentation(nextImportCS.getPathNameCS()));
                    QvtMessage error = env.reportError(errorMessage, (CSTNode)nextImportCS.getPathNameCS());
                    for (Diagnostic diagnostic : compiledImport.getErrors()) {
                        error.add(diagnostic);
                    }
                }
                if (compiledImports == null) {
                    compiledImports = new UniqueEList();
                }
                compiledImports.add(compiledImport);
                List<String> importedUnitQName = QvtOperationalParserUtil.getSequenceOfNames((List<SimpleNameCS>)nextImportCS.getPathNameCS().getSimpleNames());
                unitResolver.addUnit(importedUnitQName, compiledImport);
            }
            CSTAnalysisResult analysisResult = this.analyze(parseResult, source, unitResolver, options, (IProgressMonitor)subMonitor.newChild(1, 0));
            if (options.isSourceLineNumbersEnabled()) {
                this.addSourceLineNumberInfo(parseResult.parser, analysisResult, source);
            }
            this.checkForDupImports(allUnitImportsCS, env);
            env.close();
            for (QvtEnvironmentBase qvtEnvironmentBase : analysisResult.moduleEnvs) {
                qvtEnvironmentBase.close();
            }
            CompiledUnit compiledUnit = this.createCompiledUnit(source, env);
            compiledUnit.fUnitCST = unitCS;
            if (compiledImports != null) {
                compiledUnit.setImports(compiledImports);
            }
            this.fSource2Compiled.put(source.getURI(), compiledUnit);
            CompiledUnit compiledUnit2 = compiledUnit;
            return compiledUnit2;
        }
        finally {
            if (!this.fDependencyWalkPath.empty()) {
                this.fDependencyWalkPath.pop();
            }
        }
    }

    private CompiledUnit getCompiledExeXMIUnit(UnitProxy source) {
        URI xmiURI = ExeXMISerializer.toXMIUnitURI(source.getURI());
        if (URIConverter.INSTANCE.exists(xmiURI, null)) {
            Long srcTStamp = (Long)URIConverter.INSTANCE.getAttributes(source.getURI(), null).get("timeStamp");
            Long binTStamp = (Long)URIConverter.INSTANCE.getAttributes(xmiURI, null).get("timeStamp");
            if (binTStamp == null || srcTStamp != null && binTStamp.equals(srcTStamp)) {
                return new CompiledUnit(this.fExeXMIResourceSet.getResource(xmiURI, true), this.fSource2Compiled);
            }
        }
        return null;
    }

    private CompiledUnit createCompiledUnit(UnitProxy unit, QvtOperationalFileEnv env) {
        Resource resource = env.getTypeResolver().getResource();
        this.fExeXMIResourceSet.getResources().add((Object)resource);
        List<String> qualifiedName = QVTOCompiler.getQualifiedNameSegments(unit);
        ResourceSetImpl resourceSet = new ResourceSetImpl(){

            protected Resource delegatedGetResource(URI uri, boolean loadOnDemand) {
                Resource resource = QVTOCompiler.this.getResourceSet().getResource(uri, false);
                return resource != null ? resource : super.delegatedGetResource(uri, loadOnDemand);
            }
        };
        resourceSet.setPackageRegistry(env.getEPackageRegistry());
        return new CompiledUnit(qualifiedName, unit.getURI(), Collections.singletonList(env), (ResourceSet)resourceSet);
    }

    private static List<String> getQualifiedNameSegments(UnitProxy unit) {
        List<String> qualifiedName = null;
        String namespace = unit.getNamespace();
        if (namespace != null) {
            String[] segments = ResolverUtils.getNameSegments(namespace);
            qualifiedName = new ArrayList<String>(segments.length + 1);
            qualifiedName.addAll(Arrays.asList(segments));
            qualifiedName.add(unit.getName());
        } else {
            qualifiedName = Collections.singletonList(unit.getName());
        }
        return qualifiedName;
    }

    protected final EPackage.Registry getEPackageRegistry(URI context) {
        return CompilerUtils.getEPackageRegistry(context, this.fMetamodelRegistryProvider);
    }

    public ResourceSet getResourceSet() {
        return this.fMetamodelRegistryProvider.getResolutionResourceSet();
    }

    public void cleanup() {
        EmfUtil.cleanupResourceSet((ResourceSet)this.getResourceSet());
    }

    private void addSourceLineNumberInfo(AbstractQVTParser parser, CSTAnalysisResult analysisResult, UnitProxy source) {
        AbstractLexer lexer = parser.getLexer();
        if (lexer != null && source.getURI() != null) {
            for (QvtOperationalModuleEnv moduleEnv : analysisResult.moduleEnvs) {
                ASTBindingHelper.createModuleSourceBinding((EObject)moduleEnv.getModuleContextType(), source.getURI(), new BasicLineNumberProvider(lexer));
            }
        }
    }

    private static String getQualifiedName(ImportCS importCS) {
        if (importCS.getPathNameCS() != null) {
            return QvtOperationalParserUtil.getStringRepresentation(importCS.getPathNameCS(), NAMESPACE_SEP);
        }
        return null;
    }

    private QvtCompilerOptions getDefaultOptions() {
        QvtCompilerOptions options = new QvtCompilerOptions();
        options.setGenerateCompletionData(false);
        return options;
    }

    private UnitProxy resolveImportedUnit(UnitProxy importingUnit, String unitQualifiedName) {
        String namespace;
        UnitResolver resolver = importingUnit.getResolver();
        UnitProxy unit = resolver.resolveUnit(unitQualifiedName);
        if (unit == null && (namespace = importingUnit.getNamespace()) != null && !unitQualifiedName.contains(NAMESPACE_SEP)) {
            unit = resolver.resolveUnit(String.valueOf(namespace) + NAMESPACE_SEP + unitQualifiedName);
        }
        return unit;
    }

    private void checkForDupImports(List<ImportCS> imports, QvtOperationalEnv env) {
        if (imports.size() < 2) {
            return;
        }
        HashSet<Integer> checkedImportTokens = new HashSet<Integer>(imports.size());
        HashSet<Object> checkedImports = new HashSet<Object>(imports.size());
        LinkedList<ImportCS> dupImports = new LinkedList<ImportCS>();
        for (ImportCS nextImportCS : imports) {
            if (nextImportCS.getAst() != null && checkedImports.contains(nextImportCS.getAst()) && !checkedImportTokens.contains(nextImportCS.getStartOffset())) {
                dupImports.add(nextImportCS);
                continue;
            }
            checkedImports.add(nextImportCS.getAst());
            checkedImportTokens.add(nextImportCS.getStartOffset());
        }
        for (ImportCS nextDupImport : dupImports) {
            PathNameCS problemCS = nextDupImport.getPathNameCS();
            env.reportWarning(NLS.bind(CompilerMessages.compilationUnitAlreadyImported, QvtOperationalParserUtil.getStringRepresentation(problemCS, NAMESPACE_SEP)), (CSTNode)problemCS);
        }
    }

    private static void reportCyclicImportError(URI from, URI to, CSTNode cstNode, QvtOperationalEnv env) {
        String message = NLS.bind(CompilerMessages.cyclicImportError, from, to);
        env.reportError(message, cstNode);
    }

    static void clearITokens(CSTNode node) {
        node.setStartToken(null);
        node.setEndToken(null);
        TreeIterator it = node.eAllContents();
        while (it.hasNext()) {
            EObject next = (EObject)it.next();
            if (!(next instanceof CSTNode)) continue;
            CSTNode nextCST = (CSTNode)next;
            nextCST.setStartToken(null);
            nextCST.setEndToken(null);
        }
    }

    private DependencyPathElement findDependencyElement(UnitProxy source) {
        for (DependencyPathElement element : this.fDependencyWalkPath) {
            if (!source.equals(element.importer)) continue;
            return element;
        }
        return null;
    }

    private static IMetamodelRegistryProvider createMetamodelRegistryProvider(ResourceSet metamodelResourceSet) {
        if (EMFPlugin.IS_ECLIPSE_RUNNING && EMFPlugin.IS_RESOURCES_BUNDLE_AVAILABLE) {
            return new ProjectMetamodelRegistryProvider(metamodelResourceSet);
        }
        return new EmfStandaloneMetamodelRegistryProvider(metamodelResourceSet.getPackageRegistry());
    }

    protected static class CSTAnalysisResult {
        List<QvtOperationalModuleEnv> moduleEnvs = Collections.emptyList();
        List<ModelType> modelTypes;

        protected CSTAnalysisResult() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class CSTParseResult {
        public UnitCS unitCS;
        public QvtOperationalFileEnv env;
        public AbstractQVTParser parser;

        List<ImportCS> getImports() {
            if (this.unitCS != null) {
                return QvtOperationalParserUtil.getImports(this.unitCS);
            }
            return Collections.emptyList();
        }
    }

    private static class DependencyPathElement {
        final UnitProxy importer;
        ImportCS currentProcessedImport;
        QvtOperationalEnv importerEnv;

        public DependencyPathElement(UnitProxy importer) {
            this.importer = importer;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class UnitResolverImpl
    implements ExternalUnitElementsProvider {
        private final Map<List<String>, CompiledUnit> qName2CU = new HashMap<List<String>, CompiledUnit>(5);
        private final UnitProxy source;

        private UnitResolverImpl(UnitProxy importer) {
            this.source = importer;
        }

        void addUnit(List<String> qualifiedName, CompiledUnit unit) {
            this.qName2CU.put(qualifiedName, unit);
        }

        @Override
        public URI getImporter() {
            return this.source.getURI();
        }

        @Override
        public List<QvtOperationalModuleEnv> getModules(List<String> importedUnitQualifiedName) {
            if (importedUnitQualifiedName == null) {
                return Collections.emptyList();
            }
            CompiledUnit compiledUnit = this.qName2CU.get(importedUnitQualifiedName);
            if (compiledUnit != null) {
                return compiledUnit.getModuleEnvironments();
            }
            return Collections.emptyList();
        }
    }
}

