/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.evaluator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.AbstractEList;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.m2m.internal.qvt.oml.ast.env.InternalEvaluationEnv;
import org.eclipse.m2m.internal.qvt.oml.ast.env.QvtOperationalEvaluationEnv;
import org.eclipse.m2m.internal.qvt.oml.ast.parser.QvtOperationalParserUtil;
import org.eclipse.m2m.internal.qvt.oml.ast.parser.QvtOperationalUtil;
import org.eclipse.m2m.internal.qvt.oml.evaluator.ModelInstance;
import org.eclipse.m2m.internal.qvt.oml.expressions.DirectionKind;
import org.eclipse.m2m.internal.qvt.oml.expressions.MappingOperation;
import org.eclipse.m2m.internal.qvt.oml.expressions.MappingParameter;
import org.eclipse.m2m.internal.qvt.oml.expressions.Module;
import org.eclipse.m2m.internal.qvt.oml.expressions.VarParameter;
import org.eclipse.m2m.internal.qvt.oml.trace.EDirectionKind;
import org.eclipse.m2m.internal.qvt.oml.trace.EMappingContext;
import org.eclipse.m2m.internal.qvt.oml.trace.EMappingOperation;
import org.eclipse.m2m.internal.qvt.oml.trace.EMappingParameters;
import org.eclipse.m2m.internal.qvt.oml.trace.EMappingResults;
import org.eclipse.m2m.internal.qvt.oml.trace.ETuplePartValue;
import org.eclipse.m2m.internal.qvt.oml.trace.EValue;
import org.eclipse.m2m.internal.qvt.oml.trace.Trace;
import org.eclipse.m2m.internal.qvt.oml.trace.TraceFactory;
import org.eclipse.m2m.internal.qvt.oml.trace.TraceRecord;
import org.eclipse.m2m.internal.qvt.oml.trace.VarParameterValue;
import org.eclipse.m2m.qvt.oml.util.Dictionary;
import org.eclipse.m2m.qvt.oml.util.MutableList;
import org.eclipse.m2m.qvt.oml.util.Utils;
import org.eclipse.ocl.types.TupleType;
import org.eclipse.ocl.util.Bag;
import org.eclipse.ocl.util.Tuple;
import org.eclipse.ocl.utilities.PredefinedType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TraceUtil {
    private TraceUtil() {
    }

    static TraceRecord getTraceRecord(QvtOperationalEvaluationEnv evalEnv, MappingOperation mappingOperation) {
        InternalEvaluationEnv internEnv = evalEnv.getAdapter(InternalEvaluationEnv.class);
        Trace trace = internEnv.getTraces();
        Object selfObj = evalEnv.getValueOf("self");
        Object key = TraceUtil.createKey(selfObj, evalEnv, mappingOperation);
        if (key != null) {
            TraceRecord record = trace.getRecordBySource(mappingOperation, key);
            if (record != null && Boolean.TRUE.equals(TraceUtil.checkResultMatch(record, evalEnv))) {
                return record;
            }
            return null;
        }
        return TraceUtil.getTraceRecordDefault(evalEnv, mappingOperation);
    }

    private static TraceRecord getTraceRecordDefault(QvtOperationalEvaluationEnv evalEnv, MappingOperation mappingOperation) {
        InternalEvaluationEnv internEnv = evalEnv.getAdapter(InternalEvaluationEnv.class);
        Trace trace = internEnv.getTraces();
        Object selfObj = evalEnv.getValueOf("self");
        if (selfObj != null && TraceUtil.isParameterLessContextual(mappingOperation)) {
            TraceRecord record = trace.getRecordBySource(mappingOperation, selfObj);
            if (record != null && Boolean.TRUE.equals(TraceUtil.checkResultMatch(record, evalEnv))) {
                return record;
            }
            return null;
        }
        EMap<MappingOperation, EList<TraceRecord>> allTraceRecordMap = trace.getTraceRecordMap();
        EList traceRecords = (EList)allTraceRecordMap.get((Object)mappingOperation);
        if (traceRecords == null) {
            return null;
        }
        block0: for (TraceRecord nextRecord : traceRecords) {
            VarParameterValue nextContext;
            if (QvtOperationalParserUtil.isContextual(mappingOperation) && ((nextContext = nextRecord.getContext().getContext()) == null || !TraceUtil.isOclEqual(selfObj, nextContext.getValue().getOclObject(), mappingOperation.getContext().getKind(), evalEnv))) continue;
            int candidateParamSize = mappingOperation.getEParameters().size();
            if (nextRecord.getParameters().getParameters().size() != candidateParamSize) continue;
            int i = 0;
            while (i < candidateParamSize) {
                EParameter param = (EParameter)mappingOperation.getEParameters().get(i);
                Object paramValue = evalEnv.getValueOf(param.getName());
                VarParameterValue traceParamVal = (VarParameterValue)nextRecord.getParameters().getParameters().get(i);
                DirectionKind paramKind = DirectionKind.IN;
                if (param instanceof VarParameter) {
                    paramKind = ((VarParameter)param).getKind();
                }
                if (paramKind != DirectionKind.OUT && !TraceUtil.isOclEqual(paramValue, traceParamVal.getValue().getOclObject(), paramKind, evalEnv)) continue block0;
                ++i;
            }
            Boolean checkResult = TraceUtil.checkResultMatch(nextRecord, evalEnv);
            if (checkResult == null || Boolean.FALSE.equals(checkResult)) continue;
            return nextRecord;
        }
        return null;
    }

    static TraceRecord addTraceRecord(QvtOperationalEvaluationEnv evalEnv, MappingOperation mappingOperation) {
        TraceRecord traceRecord = TraceFactory.eINSTANCE.createTraceRecord();
        InternalEvaluationEnv internEnv = evalEnv.getAdapter(InternalEvaluationEnv.class);
        Trace trace = internEnv.getTraces();
        EList<TraceRecord> allRecList = TraceUtil.createOrGetListElementFromMap(trace.getTraceRecordMap(), mappingOperation);
        TraceUtil.addUnique(traceRecord, allRecList);
        EMappingOperation eMappingOperation = TraceFactory.eINSTANCE.createEMappingOperation();
        traceRecord.setMappingOperation(eMappingOperation);
        eMappingOperation.setName(mappingOperation.getName());
        Module module = QvtOperationalParserUtil.getOwningModule(mappingOperation);
        eMappingOperation.setPackage(module.getNsPrefix());
        eMappingOperation.setModule(module.getName());
        eMappingOperation.setRuntimeMappingOperation(mappingOperation);
        EMappingContext eMappingContext = TraceFactory.eINSTANCE.createEMappingContext();
        traceRecord.setContext(eMappingContext);
        if (QvtOperationalParserUtil.isContextual(mappingOperation)) {
            VarParameter operContext = mappingOperation.getContext();
            VarParameterValue contextVPV = TraceUtil.createVarParameterValue(mappingOperation, operContext.getKind(), operContext.getEType(), "self", evalEnv);
            eMappingContext.setContext(contextVPV);
            EList<TraceRecord> contextMappings = TraceUtil.createOrGetListElementFromMap(trace.getSourceToTraceRecordMap(), contextVPV.getValue().getOclObject());
            TraceUtil.addUnique(traceRecord, contextMappings);
        } else if (!mappingOperation.getEParameters().isEmpty()) {
            for (EParameter nextEParam : mappingOperation.getEParameters()) {
                Object firstInVarParam;
                if (!(nextEParam instanceof VarParameter) || (firstInVarParam = (VarParameter)nextEParam).getEType() instanceof PredefinedType || firstInVarParam.getKind() != DirectionKind.IN && firstInVarParam.getKind() != DirectionKind.INOUT) continue;
                Object val = TraceUtil.createVarParameterValue(mappingOperation, firstInVarParam.getKind(), firstInVarParam.getEType(), firstInVarParam.getName(), evalEnv).getValue().getOclObject();
                EList<TraceRecord> sourceMappings = TraceUtil.createOrGetListElementFromMap(trace.getSourceToTraceRecordMap(), val);
                TraceUtil.addUnique(traceRecord, sourceMappings);
                break;
            }
        }
        EMappingParameters eMappingParameters = TraceFactory.eINSTANCE.createEMappingParameters();
        traceRecord.setParameters(eMappingParameters);
        for (EParameter param : mappingOperation.getEParameters()) {
            VarParameter varParameter = (VarParameter)param;
            VarParameterValue paramVPV = TraceUtil.createVarParameterValue(mappingOperation, varParameter.getKind(), varParameter.getEType(), varParameter.getName(), evalEnv);
            eMappingParameters.getParameters().add((Object)paramVPV);
        }
        EMappingResults eMappingResults = TraceFactory.eINSTANCE.createEMappingResults();
        traceRecord.setResult(eMappingResults);
        EList<VarParameter> results = mappingOperation.getResult();
        if (!results.isEmpty()) {
            for (VarParameter resultPar : results) {
                String resultVarName = resultPar.getName();
                EClassifier resultElementType = resultPar.getEType();
                VarParameterValue resultVPV = TraceUtil.createVarParameterValue(mappingOperation, DirectionKind.OUT, resultElementType, resultVarName, evalEnv);
                eMappingResults.getResult().add((Object)resultVPV);
                EList<TraceRecord> resultMappings = TraceUtil.createOrGetListElementFromMap(trace.getTargetToTraceRecordMap(), resultVPV.getValue().getOclObject());
                TraceUtil.addUnique(traceRecord, resultMappings);
            }
        }
        TraceUtil.addUnique(traceRecord, trace.getTraceRecords());
        TraceUtil.addTraceRecordByMapping(evalEnv, mappingOperation, traceRecord, trace);
        return traceRecord;
    }

    private static void addTraceRecordByMapping(QvtOperationalEvaluationEnv evalEnv, MappingOperation mappingOperation, TraceRecord traceRecord, Trace trace) {
        Object key;
        Object selfObj = null;
        if (traceRecord.getContext() != null && traceRecord.getContext().getContext() != null) {
            EValue value = traceRecord.getContext().getContext().getValue();
            selfObj = value.getOclObject();
        }
        if ((key = TraceUtil.createKey(selfObj, evalEnv, mappingOperation)) != null) {
            trace.addRecordBySource(key, mappingOperation, traceRecord);
        }
    }

    private static Object createKey(Object selfObj, QvtOperationalEvaluationEnv evalEnv, MappingOperation mappingOperation) {
        EList eParameters = mappingOperation.getEParameters();
        if (eParameters.isEmpty()) {
            return selfObj;
        }
        ArrayList<Object> key = new ArrayList<Object>(eParameters.size() + 1);
        key.add(selfObj);
        for (EParameter param : eParameters) {
            VarParameter varParam;
            if (param instanceof VarParameter && (varParam = (VarParameter)param).getKind() == DirectionKind.OUT) continue;
            key.add(evalEnv.getValueOf(param.getName()));
        }
        return key;
    }

    static Object fetchResultFromTrace(QvtOperationalEvaluationEnv evalEnv, TraceRecord trace) {
        MappingOperation operation = trace.getMappingOperation().getRuntimeMappingOperation();
        EList<VarParameter> resultParams = operation.getResult();
        if (resultParams.isEmpty()) {
            return null;
        }
        Iterator itParams = operation.getEParameters().iterator();
        ListIterator<Object> itArgument = evalEnv.getOperationArgs().listIterator();
        Iterator itValues = trace.getParameters().getParameters().iterator();
        while (itArgument.hasNext()) {
            MappingParameter mappingParam = (MappingParameter)itParams.next();
            VarParameterValue value = (VarParameterValue)itValues.next();
            itArgument.next();
            if (mappingParam.getKind() != DirectionKind.OUT) continue;
            itArgument.set(value.getValue().getOclObject());
        }
        EList<VarParameterValue> traceResult = trace.getResult().getResult();
        if (resultParams.size() == 1) {
            return ((VarParameterValue)traceResult.get(0)).getValue().getOclObject();
        }
        assert (resultParams.size() > 1 && operation.getEType() instanceof TupleType);
        TupleType tupleType = (TupleType)operation.getEType();
        HashMap<EStructuralFeature, Object> partValues = new HashMap<EStructuralFeature, Object>(2);
        for (EStructuralFeature property : tupleType.oclProperties()) {
            VarParameterValue paramValue = null;
            for (VarParameterValue nextParamValue : traceResult) {
                if (!property.getName().equals(nextParamValue.getName())) continue;
                paramValue = nextParamValue;
                break;
            }
            Object value = null;
            if (paramValue != null && paramValue.getValue() != null) {
                value = paramValue.getValue().getOclObject();
            }
            partValues.put(property, value);
        }
        return evalEnv.createTuple(operation.getEType(), partValues);
    }

    private static VarParameterValue createVarParameterValue(MappingOperation mappingOperation, DirectionKind kind, EClassifier type, String name, QvtOperationalEvaluationEnv evalEnv) {
        VarParameterValue varParameterValue = TraceFactory.eINSTANCE.createVarParameterValue();
        varParameterValue.setKind(TraceUtil.getDirectionKind(kind));
        varParameterValue.setName(name);
        varParameterValue.setType(type.getName());
        Object oclObject = evalEnv.getValueOf(name);
        varParameterValue.setValue(TraceUtil.createEValue(oclObject));
        return varParameterValue;
    }

    public static EValue createEValue(Object oclObject) {
        EValue value = TraceFactory.eINSTANCE.createEValue();
        value.setOclObject(TraceUtil.cloneOclObject(oclObject));
        if (oclObject != null) {
            if (oclObject instanceof Dictionary) {
                Dictionary dict = (Dictionary)oclObject;
                value.setCollectionType("Dictionary");
                for (Object dictKey : dict.keys()) {
                    ETuplePartValue tuplePartValue = TraceFactory.eINSTANCE.createETuplePartValue();
                    tuplePartValue.setName("key");
                    tuplePartValue.setValue(TraceUtil.createEValue(dictKey));
                    value.getCollection().add((Object)tuplePartValue);
                    Object dictValue = dict.get(dictKey);
                    tuplePartValue = TraceFactory.eINSTANCE.createETuplePartValue();
                    tuplePartValue.setName("value");
                    tuplePartValue.setValue(TraceUtil.createEValue(dictValue));
                    value.getCollection().add((Object)tuplePartValue);
                }
            } else if (oclObject instanceof Tuple) {
                Tuple tuple = (Tuple)oclObject;
                value.setCollectionType("Tuple");
                TupleType tupleType = tuple.getTupleType();
                for (EStructuralFeature part : tupleType.oclProperties()) {
                    Object partValue = tuple.getValue((Object)part);
                    ETuplePartValue tuplePartValue = TraceFactory.eINSTANCE.createETuplePartValue();
                    tuplePartValue.setName(part.getName());
                    EValue partEValue = TraceUtil.createEValue(partValue);
                    tuplePartValue.setValue(partEValue);
                    value.getCollection().add((Object)tuplePartValue);
                }
            } else if (oclObject instanceof Collection) {
                Collection oclCollection = (Collection)oclObject;
                value.setCollectionType(TraceUtil.getCollectionTypeName(oclCollection));
                for (Object collectionElement : oclCollection) {
                    value.getCollection().add((Object)TraceUtil.createEValue(collectionElement));
                }
            } else if (oclObject instanceof ModelInstance) {
                value.setCollectionType("ModelType");
                for (EObject collectionElement : ((ModelInstance)oclObject).getExtent().getInitialObjects()) {
                    value.getCollection().add((Object)TraceUtil.createEValue(collectionElement));
                }
            } else if (oclObject instanceof EObject) {
                value.setModelElement((EObject)oclObject);
            } else if (oclObject != null) {
                value.setPrimitiveValue(oclObject.toString());
            }
        }
        return value;
    }

    private static String getCollectionTypeName(Collection<?> c) {
        String result = "OclCollection";
        if (c instanceof MutableList) {
            result = "List";
        } else if (c instanceof Dictionary) {
            result = "Dictionary";
        } else if (c instanceof Bag) {
            result = "Bag";
        } else if (c instanceof LinkedHashSet) {
            result = "OrderedSet";
        } else if (c instanceof Set) {
            result = "Set";
        } else if (c instanceof ArrayList) {
            result = "Sequence";
        }
        return result;
    }

    private static Object cloneOclObject(Object obj) {
        return TraceUtil.cloneOclObjectRec(obj, new IdentityHashMap<Object, Object>());
    }

    private static Object cloneOclObjectRec(Object obj, Map<Object, Object> processed) {
        if (obj instanceof MutableList) {
            if (processed.containsKey(obj)) {
                return processed.get(obj);
            }
            MutableList original = (MutableList)obj;
            MutableList result = Utils.createList();
            processed.put(obj, result);
            for (Object o : original) {
                result.add(TraceUtil.cloneOclObjectRec(o, processed));
            }
            return result;
        }
        if (obj instanceof Dictionary) {
            if (processed.containsKey(obj)) {
                return processed.get(obj);
            }
            Dictionary original = (Dictionary)obj;
            Dictionary<Object, Object> result = Utils.createDictionary();
            processed.put(obj, result);
            for (Object k : original.keys()) {
                result.put(TraceUtil.cloneOclObjectRec(k, processed), TraceUtil.cloneOclObjectRec(original.get(k), processed));
            }
            return result;
        }
        return obj;
    }

    private static EDirectionKind getDirectionKind(DirectionKind kind) {
        if (kind == DirectionKind.IN) {
            return EDirectionKind.IN;
        }
        if (kind == DirectionKind.INOUT) {
            return EDirectionKind.INOUT;
        }
        if (kind == DirectionKind.OUT) {
            return EDirectionKind.OUT;
        }
        throw new RuntimeException("Wrong DirectionKind: " + kind.name());
    }

    private static <K, T> EList<T> createOrGetListElementFromMap(EMap<K, EList<T>> map, K key) {
        EList list = (EList)map.get(key);
        if (list == null) {
            list = new BasicEList();
            map.put(key, (Object)list);
            list = (EList)map.get(key);
        }
        return list;
    }

    private static boolean isOclEqual(Object candidateObject, Object traceObject, DirectionKind directionKind, QvtOperationalEvaluationEnv evalEnv) {
        if (directionKind == DirectionKind.OUT && candidateObject == null) {
            return true;
        }
        if (candidateObject == traceObject) {
            return true;
        }
        if (QvtOperationalUtil.isUndefined(candidateObject, evalEnv)) {
            return QvtOperationalUtil.isUndefined(traceObject, evalEnv);
        }
        if (candidateObject == null || traceObject == null) {
            return false;
        }
        return candidateObject.equals(traceObject);
    }

    private static Boolean checkResultMatch(TraceRecord nextRecord, QvtOperationalEvaluationEnv evalEnv) {
        Object resultValue = evalEnv.getValueOf("result");
        if (resultValue != null) {
            ArrayList<Object> resultValues = new ArrayList<Object>(1);
            if (resultValue instanceof Tuple) {
                Tuple tupleResult = (Tuple)resultValue;
                for (EStructuralFeature tupleFeature : tupleResult.getTupleType().oclProperties()) {
                    resultValues.add(tupleResult.getValue((Object)tupleFeature));
                }
            } else {
                resultValues.add(resultValue);
            }
            if (nextRecord.getResult().getResult().size() != resultValues.size()) {
                return null;
            }
            int i = 0;
            int n = resultValues.size();
            while (i < n) {
                VarParameterValue traceParamVal;
                Object paramValue = resultValues.get(i);
                if (!TraceUtil.isOclEqual(paramValue, (traceParamVal = (VarParameterValue)nextRecord.getResult().getResult().get(i)).getValue().getOclObject(), DirectionKind.OUT, evalEnv)) {
                    return Boolean.FALSE;
                }
                ++i;
            }
        }
        return Boolean.TRUE;
    }

    private static boolean isParameterLessContextual(MappingOperation mappingOperation) {
        return QvtOperationalParserUtil.isContextual(mappingOperation) && mappingOperation.getEParameters().isEmpty();
    }

    private static void addUnique(TraceRecord record, EList<TraceRecord> recordList) {
        if (recordList instanceof AbstractEList) {
            AbstractEList basicRecList = (AbstractEList)recordList;
            basicRecList.addUnique((Object)record);
        } else {
            recordList.add((Object)record);
        }
    }
}

