/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvtm2qvts;

import com.google.common.collect.Iterables;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.CallExp;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.CollectionType;
import org.eclipse.ocl.pivot.CompleteClass;
import org.eclipse.ocl.pivot.DataType;
import org.eclipse.ocl.pivot.Element;
import org.eclipse.ocl.pivot.ExpressionInOCL;
import org.eclipse.ocl.pivot.LanguageExpression;
import org.eclipse.ocl.pivot.NamedElement;
import org.eclipse.ocl.pivot.NavigationCallExp;
import org.eclipse.ocl.pivot.OCLExpression;
import org.eclipse.ocl.pivot.Operation;
import org.eclipse.ocl.pivot.OperationCallExp;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.StandardLibrary;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.TypedElement;
import org.eclipse.ocl.pivot.Variable;
import org.eclipse.ocl.pivot.VariableDeclaration;
import org.eclipse.ocl.pivot.VoidType;
import org.eclipse.ocl.pivot.internal.utilities.EnvironmentFactoryInternal;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.EnvironmentFactory;
import org.eclipse.ocl.pivot.utilities.Nameable;
import org.eclipse.ocl.pivot.utilities.ParserException;
import org.eclipse.ocl.pivot.utilities.PivotUtil;
import org.eclipse.qvtd.compiler.CompilerChain;
import org.eclipse.qvtd.compiler.CompilerOptions;
import org.eclipse.qvtd.compiler.internal.qvtm2qvts.ContainmentAnalysis;
import org.eclipse.qvtd.compiler.internal.qvtm2qvts.DatumCaches;
import org.eclipse.qvtd.compiler.internal.qvtm2qvts.OperationDatum;
import org.eclipse.qvtd.compiler.internal.qvtm2qvts.OperationDependencyAnalysis;
import org.eclipse.qvtd.compiler.internal.qvtm2qvts.OperationDependencyPaths;
import org.eclipse.qvtd.compiler.internal.qvtm2qvts.OperationDependencyStep;
import org.eclipse.qvtd.compiler.internal.qvtm2qvts.OperationRegionHelper;
import org.eclipse.qvtd.compiler.internal.qvtm2qvts.QVTm2QVTs;
import org.eclipse.qvtd.compiler.internal.qvtm2qvts.ScheduleManager;
import org.eclipse.qvtd.compiler.internal.qvtm2qvts.TransformationAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.RegionAnalysis;
import org.eclipse.qvtd.compiler.internal.utilities.CompilerUtil;
import org.eclipse.qvtd.pivot.qvtbase.Rule;
import org.eclipse.qvtd.pivot.qvtbase.Transformation;
import org.eclipse.qvtd.pivot.qvtbase.TypedModel;
import org.eclipse.qvtd.pivot.qvtbase.graphs.DOTStringBuilder;
import org.eclipse.qvtd.pivot.qvtbase.graphs.GraphMLStringBuilder;
import org.eclipse.qvtd.pivot.qvtbase.graphs.GraphStringBuilder;
import org.eclipse.qvtd.pivot.qvtbase.utilities.StandardLibraryHelper;
import org.eclipse.qvtd.pivot.qvtcore.analysis.RootDomainUsageAnalysis;
import org.eclipse.qvtd.pivot.qvtschedule.AbstractDatum;
import org.eclipse.qvtd.pivot.qvtschedule.ClassDatum;
import org.eclipse.qvtd.pivot.qvtschedule.MappingRegion;
import org.eclipse.qvtd.pivot.qvtschedule.NavigableEdge;
import org.eclipse.qvtd.pivot.qvtschedule.Node;
import org.eclipse.qvtd.pivot.qvtschedule.OperationRegion;
import org.eclipse.qvtd.pivot.qvtschedule.PropertyDatum;
import org.eclipse.qvtd.pivot.qvtschedule.QVTscheduleFactory;
import org.eclipse.qvtd.pivot.qvtschedule.Region;
import org.eclipse.qvtd.pivot.qvtschedule.RuleRegion;
import org.eclipse.qvtd.pivot.qvtschedule.ScheduleModel;
import org.eclipse.qvtd.pivot.qvtschedule.ScheduledRegion;
import org.eclipse.qvtd.pivot.qvtschedule.utilities.DomainUsage;
import org.eclipse.qvtd.pivot.qvtschedule.utilities.QVTscheduleUtil;
import org.eclipse.qvtd.pivot.qvtschedule.utilities.ToCallGraphVisitor;
import org.eclipse.qvtd.pivot.qvtschedule.utilities.ToRegionGraphVisitor;

public abstract class AbstractScheduleManager
implements ScheduleManager {
    protected final @NonNull ScheduleModel scheduleModel;
    protected final @NonNull EnvironmentFactory environmentFactory;
    private  @Nullable CompilerOptions.StepOptions schedulerOptions;
    protected final @NonNull RootDomainUsageAnalysis domainUsageAnalysis;
    protected final @NonNull DatumCaches datumCaches;
    protected final @NonNull StandardLibraryHelper standardLibraryHelper;
    private @Nullable ClassDatum oclVoidClassDatum;
    private final @NonNull Set<@NonNull ClassDatum> classDatums = new HashSet<ClassDatum>();
    private final @NonNull Map<Type, Property> type2castProperty = new HashMap<Type, Property>();
    private final @NonNull Map<Type, Property> type2iterateProperty = new HashMap<Type, Property>();
    private final @NonNull Map<String, Property> name2argumentProperty = new HashMap<String, Property>();
    private OperationDependencyAnalysis operationDependencyAnalysis = null;
    private @NonNull Map<@NonNull Region, @NonNull RegionAnalysis> region2regionAnalysis = new HashMap<Region, RegionAnalysis>();
    private Map<@NonNull OperationDatum, @NonNull OperationRegion> operationDatum2operationRegion = new HashMap<OperationDatum, OperationRegion>();
    private final @NonNull Map<@NonNull Transformation, @NonNull TransformationAnalysis> transformation2transformationAnalysis = new HashMap<Transformation, TransformationAnalysis>();
    private final boolean doDotGraphs;
    private final boolean doYedGraphs;

    protected AbstractScheduleManager(@NonNull ScheduleModel scheduleModel, @NonNull EnvironmentFactory environmentFactory,  @Nullable CompilerOptions.StepOptions schedulerOptions) {
        this.scheduleModel = scheduleModel;
        this.environmentFactory = environmentFactory;
        this.schedulerOptions = schedulerOptions;
        this.domainUsageAnalysis = this.createDomainUsageAnalysis();
        this.standardLibraryHelper = new StandardLibraryHelper(environmentFactory.getStandardLibrary());
        this.datumCaches = this.createDatumCaches();
        if (QVTm2QVTs.DEBUG_GRAPHS.isActive()) {
            this.doDotGraphs = true;
            this.doYedGraphs = true;
        } else if (schedulerOptions != null) {
            this.doDotGraphs = schedulerOptions.basicGet(CompilerChain.SCHEDULER_DOT_GRAPHS) == Boolean.TRUE;
            this.doYedGraphs = schedulerOptions.basicGet(CompilerChain.SCHEDULER_YED_GRAPHS) == Boolean.TRUE;
        } else {
            this.doDotGraphs = false;
            this.doYedGraphs = false;
        }
    }

    @Override
    public void addMappingRegion(@NonNull MappingRegion mappingRegion) {
        this.scheduleModel.getOwnedMappingRegions().add((Object)mappingRegion);
    }

    @Override
    public void addRegionError(@NonNull Region region, @NonNull String messageTemplate, Object ... bindings) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addRegionWarning(@NonNull Region region, @NonNull String messageTemplate, Object ... bindings) {
        throw new UnsupportedOperationException();
    }

    @Override
    public @NonNull TransformationAnalysis addTransformation(@NonNull Transformation asTransformation) {
        TransformationAnalysis transformationAnalysis = this.createTransformationAnalysis(asTransformation);
        this.transformation2transformationAnalysis.put(asTransformation, transformationAnalysis);
        return transformationAnalysis;
    }

    private void analyzeCallTree() {
        HashMap<@NonNull Rule, @NonNull ArrayList<@NonNull E>> consumer2producers = new HashMap();
        ArrayList<@NonNull ClassDatum> middleClassDatums = new ArrayList<ClassDatum>();
        StringBuilder s = QVTm2QVTs.CALL_TREE.isActive() ? new StringBuilder() : null;
        for (ClassDatum classDatum : QVTscheduleUtil.getOwnedClassDatums((ScheduleModel)this.scheduleModel)) {
            TypedModel typedModel = QVTscheduleUtil.getReferredTypedModel((ClassDatum)classDatum);
            DomainUsage usage = this.domainUsageAnalysis.getUsage((Element)typedModel);
            if (!usage.isMiddle()) continue;
            middleClassDatums.add(classDatum);
            if (s != null) {
                s.append("middle: " + classDatum.getProducingRegions() + "\n");
            }
            for (RuleRegion consumingRegion : QVTscheduleUtil.getConsumingRegions((AbstractDatum)classDatum)) {
                Rule consumer = QVTscheduleUtil.getReferredRule((RuleRegion)consumingRegion);
                ArrayList<@NonNull Rule> producers = (ArrayList<Rule>)consumer2producers.get(consumer);
                if (producers == null) {
                    producers = new ArrayList<Rule>();
                    consumer2producers.put(consumer, producers);
                }
                for (RuleRegion producingRegion : QVTscheduleUtil.getProducingRegions((AbstractDatum)classDatum)) {
                    Rule producer = QVTscheduleUtil.getReferredRule((RuleRegion)producingRegion);
                    if (producers.contains(producer)) continue;
                    producers.add(producer);
                }
            }
        }
        if (s != null) {
            s.append("consumer2producers: " + consumer2producers);
            QVTm2QVTs.CALL_TREE.println(s.toString());
        }
    }

    @Override
    public @NonNull OperationRegion analyzeOperation(@NonNull OperationCallExp operationCallExp) {
        Operation operation = operationCallExp.getReferredOperation();
        LanguageExpression bodyExpression = operation.getBodyExpression();
        assert (bodyExpression != null);
        try {
            ExpressionInOCL specification = ((EnvironmentFactoryInternal.EnvironmentFactoryInternalExtension)this.environmentFactory).parseSpecification(bodyExpression);
            OperationDatum operationDatum = this.createOperationDatum(operationCallExp);
            OperationRegion operationRegion = this.operationDatum2operationRegion.get(operationDatum);
            if (operationRegion == null) {
                operationRegion = this.createOperationRegion(this, operationCallExp, specification, operationDatum);
                this.operationDatum2operationRegion.put(operationDatum, operationRegion);
                this.writeDebugGraphs((Region)operationRegion, null);
            }
            return operationRegion;
        }
        catch (ParserException e) {
            e.printStackTrace();
            throw new UnsupportedOperationException(e);
        }
    }

    protected void analyzeTransformation(@NonNull TransformationAnalysis transformationAnalysis) {
        this.domainUsageAnalysis.analyzeTransformation(transformationAnalysis.getTransformation());
        transformationAnalysis.analyze();
        this.datumCaches.analyzeTransformation(transformationAnalysis);
    }

    @Override
    public void analyzeTransformations() {
        for (TransformationAnalysis transformationAnalysis : this.transformation2transformationAnalysis.values()) {
            this.analyzeTransformation(transformationAnalysis);
        }
        this.analyzeCallTree();
    }

    @Override
    public @Nullable Property basicGetStatusProperty(@NonNull Node node) {
        if (!this.isMiddle(node)) {
            return null;
        }
        CompleteClass completeClass = node.getCompleteClass();
        return completeClass.getProperty("status");
    }

    protected abstract @NonNull DatumCaches createDatumCaches();

    protected abstract @NonNull RootDomainUsageAnalysis createDomainUsageAnalysis();

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private @NonNull OperationDatum createOperationDatum(@NonNull OperationCallExp operationCallExp) {
        @NonNull List ownedArguments = ClassUtil.nullFree((List)operationCallExp.getOwnedArguments());
        @NonNull ClassDatum[] classDatums = new ClassDatum[1 + ownedArguments.size()];
        int i = 0;
        @NonNull OCLExpression source = operationCallExp.getOwnedSource();
        classDatums[i++] = this.getClassDatum((TypedElement)source);
        for (OCLExpression argument : ownedArguments) {
            classDatums[i++] = this.getClassDatum((TypedElement)argument);
        }
        String operationName = operationCallExp.getReferredOperation().getName();
        assert (operationName != null);
        return new OperationDatum(this, operationName, classDatums);
    }

    private @NonNull Node createOperationParameterNode(@NonNull OperationRegionHelper regionHelper, @NonNull Variable variable, @NonNull String name, @NonNull OCLExpression expression) {
        Class type = (Class)expression.getType();
        assert (type != null);
        TypedModel typedModel = this.getDomainUsage((Element)expression).getTypedModel((Element)expression);
        assert (typedModel != null);
        ClassDatum classDatum = this.getClassDatum(typedModel, type);
        Node parameterNode = regionHelper.createOperationParameterNode(name, classDatum);
        ((OperationRegion)regionHelper.getRegion()).addHeadNode(parameterNode);
        return parameterNode;
    }

    private @NonNull Node createOperationParameterNode(@NonNull OperationRegionHelper regionHelper, @NonNull ClassDatum classDatum, @NonNull String name) {
        Node parameterNode = regionHelper.createOperationParameterNode(name, classDatum);
        ((OperationRegion)regionHelper.getRegion()).addHeadNode(parameterNode);
        return parameterNode;
    }

    protected @NonNull OperationRegion createOperationRegion(@NonNull AbstractScheduleManager scheduleManager, @NonNull OperationCallExp operationCallExp, @NonNull ExpressionInOCL specification, @NonNull OperationDatum operationDatum) {
        HashMap<@NonNull Variable, @NonNull Node> parameter2node = new HashMap<Variable, Node>();
        String operationName = (String)ClassUtil.nonNullState((Object)operationDatum.toString());
        OperationRegion operationRegion = QVTscheduleFactory.eINSTANCE.createOperationRegion();
        scheduleManager.getScheduleModel().getOwnedOperationRegions().add((Object)operationRegion);
        operationRegion.setReferredOperation((Operation)ClassUtil.nonNullState((Object)operationCallExp.getReferredOperation()));
        operationRegion.setName(operationName);
        OperationRegionHelper regionHelper = new OperationRegionHelper((ScheduleManager)scheduleManager, operationRegion);
        Variable selfVariable = specification.getOwnedContext();
        OCLExpression source = operationCallExp.getOwnedSource();
        assert (source != null);
        Node selfNode = this.createOperationParameterNode(regionHelper, selfVariable, (String)ClassUtil.nonNullState((Object)selfVariable.getName()), source);
        parameter2node.put(selfVariable, selfNode);
        Node dependencyNode = selfNode;
        Node resultNode = regionHelper.createStepNode("result", (CallExp)operationCallExp, dependencyNode, false);
        operationRegion.setResultNode(resultNode);
        regionHelper.createExpressionEdge(dependencyNode, "\u00abreturn\u00bb", resultNode);
        List ownedParameters = specification.getOwnedParameters();
        List ownedArguments = operationCallExp.getOwnedArguments();
        int iSize = Math.min(ownedArguments.size(), ownedParameters.size());
        int i = 0;
        while (i < iSize) {
            Variable parameter = (Variable)ownedParameters.get(i);
            Node parameterNode = this.createOperationParameterNode(regionHelper, parameter, (String)ClassUtil.nonNullState((Object)parameter.getName()), (OCLExpression)ClassUtil.nonNullState((Object)((OCLExpression)ownedArguments.get(i))));
            parameter2node.put(parameter, parameterNode);
            ++i;
        }
        OperationDependencyAnalysis operationDependencyAnalysis = scheduleManager.getOperationDependencyAnalysis();
        OperationDependencyPaths paths = operationDependencyAnalysis.analyzeOperation(operationCallExp);
        Iterable<@NonNull List<OperationDependencyStep>> hiddenPaths = paths.getHiddenPaths();
        Iterable<@NonNull List<OperationDependencyStep>> returnPaths = paths.getReturnPaths();
        RootDomainUsageAnalysis domainAnalysis = scheduleManager.getDomainUsageAnalysis();
        HashMap<@NonNull ClassDatum, @NonNull Node> classDatum2node = new HashMap<ClassDatum, Node>();
        for (List steps : Iterables.concat(returnPaths, hiddenPaths)) {
            Node dependencyNode2;
            if (steps.size() <= 0) continue;
            boolean isDirty = false;
            int i2 = 1;
            while (i2 < steps.size()) {
                OperationDependencyStep.PropertyStep step = (OperationDependencyStep.PropertyStep)steps.get(i2);
                Property asProperty = step.getProperty();
                if (domainAnalysis.isDirty(asProperty)) {
                    isDirty = true;
                    break;
                }
                ++i2;
            }
            OperationDependencyStep.ClassStep classStep = (OperationDependencyStep.ClassStep)steps.get(0);
            DomainUsage stepUsage = classStep.getUsage();
            if ((!stepUsage.isOutput() || stepUsage.isInput()) && !isDirty) continue;
            Class stepType = ((OperationDependencyStep)steps.get(0)).getElementalType();
            TypedModel typedModel = stepUsage.getTypedModel(classStep.getElement());
            assert (typedModel != null);
            ClassDatum classDatum = scheduleManager.getClassDatum(typedModel, stepType);
            CompleteClass completeClass = classDatum.getCompleteClass();
            Class primaryClass = completeClass.getPrimaryClass();
            if (primaryClass instanceof DataType || primaryClass instanceof VoidType) continue;
            if (classStep.isParameter()) {
                dependencyNode2 = (Node)parameter2node.get(classStep.getElement());
                assert (dependencyNode2 != null);
            } else {
                dependencyNode2 = (Node)classDatum2node.get(classDatum);
                if (dependencyNode2 == null) {
                    assert (!"OclVoid".equals(stepType.getName()));
                    dependencyNode2 = this.createOperationParameterNode(regionHelper, classDatum, "extra2_" + stepType.getName());
                    classDatum2node.put(classDatum, dependencyNode2);
                    operationRegion.addDependencyNode(dependencyNode2);
                }
            }
            int i3 = 1;
            while (i3 < steps.size()) {
                Node nextNode;
                OperationDependencyStep.PropertyStep step = (OperationDependencyStep.PropertyStep)steps.get(i3);
                Property property = step.getProperty();
                CallExp callExp = step.getCallExp();
                assert (property != null && callExp != null);
                if (primaryClass instanceof CollectionType) {
                    Property iterateProperty = scheduleManager.getIterateProperty((Type)primaryClass);
                    Type elementType = PivotUtil.getElementType((CollectionType)((CollectionType)primaryClass));
                    TypedModel typedModel2 = QVTscheduleUtil.getTypedModel((ClassDatum)classDatum);
                    ClassDatum elementClassDatum = scheduleManager.getClassDatum(typedModel2, (Class)elementType);
                    Node elementNode = regionHelper.createOperationElementNode(operationName, elementClassDatum, dependencyNode2);
                    regionHelper.createNavigationEdge(dependencyNode2, iterateProperty, elementNode, false);
                    dependencyNode2 = elementNode;
                }
                if (callExp instanceof NavigationCallExp) {
                    String name = CompilerUtil.recoverVariableName((NamedElement)callExp);
                    if (name == null) {
                        name = QVTscheduleUtil.getName((Nameable)PivotUtil.getReferredProperty((NavigationCallExp)((NavigationCallExp)callExp)));
                    }
                    nextNode = regionHelper.createDataTypeNode(name, dependencyNode2, (NavigationCallExp)callExp);
                } else {
                    nextNode = regionHelper.createDataTypeNode(dependencyNode2, property);
                }
                regionHelper.createNavigationEdge(dependencyNode2, property, nextNode, false);
                dependencyNode2 = nextNode;
                ++i3;
            }
        }
        operationRegion.toGraph((GraphStringBuilder)new DOTStringBuilder());
        operationRegion.toGraph((GraphStringBuilder)new GraphMLStringBuilder());
        return operationRegion;
    }

    protected @NonNull Property createProperty(@NonNull String name, @NonNull Type type, boolean isRequired) {
        Property property = PivotUtil.createProperty((String)name, (Type)type);
        property.setIsRequired(isRequired);
        return property;
    }

    protected @NonNull TransformationAnalysis createTransformationAnalysis(@NonNull Transformation asTransformation) {
        return new TransformationAnalysis(this, asTransformation);
    }

    @Override
    public @NonNull Iterable<@NonNull PropertyDatum> getAllPropertyDatums(@NonNull ClassDatum classDatum) {
        return this.datumCaches.getAllPropertyDatums(classDatum);
    }

    public @NonNull Property getArgumentProperty(@NonNull String argumentName) {
        Property argumentProperty = this.name2argumentProperty.get(argumentName);
        if (argumentProperty == null) {
            argumentProperty = this.createProperty(argumentName, (Type)this.getStandardLibrary().getOclAnyType(), true);
            this.name2argumentProperty.put(argumentName, argumentProperty);
        }
        return argumentProperty;
    }

    @Override
    public @NonNull Property getCastProperty(@NonNull Type type) {
        Property castProperty = this.type2castProperty.get(type);
        if (castProperty == null) {
            castProperty = this.createProperty("\u00abcast\u00bb\\n" + type.toString(), type, true);
            this.type2castProperty.put(type, castProperty);
        }
        return castProperty;
    }

    @Override
    public @NonNull ClassDatum getClassDatum(@NonNull TypedModel typedModel, @NonNull CompleteClass completeClass) {
        return this.datumCaches.getClassDatum(typedModel, completeClass);
    }

    @Override
    public @NonNull ClassDatum getClassDatum(@NonNull TypedElement asTypedElement) {
        TypedModel typedModel;
        Class asType = (Class)asTypedElement.getType();
        assert (asType != null);
        Type elementType = PivotUtil.getElementalType((Type)asType);
        if (elementType instanceof DataType) {
            typedModel = this.getDomainUsageAnalysis().getPrimitiveTypeModel();
        } else {
            DomainUsage domainUsage = this.getDomainUsage((Element)asTypedElement);
            assert (domainUsage != null);
            typedModel = domainUsage.getTypedModel((Element)asTypedElement);
            assert (typedModel != null);
        }
        return this.datumCaches.getClassDatum(typedModel, asType);
    }

    @Override
    public @NonNull ClassDatum getClassDatum(@NonNull TypedModel typedModel, @NonNull Class asType) {
        return this.datumCaches.getClassDatum(typedModel, asType);
    }

    @Override
    public @NonNull Iterable<@NonNull ClassDatum> getClassDatums() {
        return this.classDatums;
    }

    public @NonNull ContainmentAnalysis getContainmentAnalysis() {
        return this.datumCaches.getContainmentAnalysis();
    }

    @Override
    public @NonNull DomainUsage getDomainUsage(@NonNull Element element) {
        if (element instanceof ClassDatum) {
            return this.getDomainUsage((Element)QVTscheduleUtil.getReferredTypedModel((ClassDatum)((ClassDatum)element)));
        }
        RootDomainUsageAnalysis analysis = this.domainUsageAnalysis;
        Operation operation = PivotUtil.getContainingOperation((EObject)element);
        if (operation != null) {
            analysis = this.domainUsageAnalysis.getAnalysis(operation);
        }
        return (DomainUsage)ClassUtil.nonNullState((Object)analysis.getUsage(element));
    }

    @Override
    public @NonNull RootDomainUsageAnalysis getDomainUsageAnalysis() {
        return this.domainUsageAnalysis;
    }

    @Override
    public @NonNull ClassDatum getElementalClassDatum(@NonNull ClassDatum classDatum) {
        Class type;
        Class elementType = type = classDatum.getCompleteClass().getPrimaryClass();
        while (elementType instanceof CollectionType) {
            elementType = ((CollectionType)elementType).getElementType();
        }
        if (elementType == null || elementType == type || !(elementType instanceof Class)) {
            return classDatum;
        }
        TypedModel typedModel = QVTscheduleUtil.getReferredTypedModel((ClassDatum)classDatum);
        return this.getClassDatum(typedModel, elementType);
    }

    @Override
    public @NonNull EnvironmentFactory getEnvironmentFactory() {
        return this.environmentFactory;
    }

    protected @NonNull URI getGraphsBaseURI() {
        return this.scheduleModel.eResource().getURI().trimSegments(1).appendSegment("graphs").appendSegment("");
    }

    public @NonNull Property getIterateProperty(@NonNull Type type) {
        Property iterateProperty = this.type2iterateProperty.get(type);
        if (iterateProperty == null) {
            iterateProperty = this.createProperty("\u00abiterate\u00bb", type, true);
            this.type2iterateProperty.put(type, iterateProperty);
        }
        return iterateProperty;
    }

    @Override
    public @NonNull ClassDatum getOclVoidClassDatum() {
        ClassDatum oclVoidClassDatum2 = this.oclVoidClassDatum;
        if (oclVoidClassDatum2 == null) {
            TypedModel primitiveTypeModel = this.domainUsageAnalysis.getPrimitiveTypeModel();
            StandardLibrary standardLibrary = this.environmentFactory.getStandardLibrary();
            this.oclVoidClassDatum = oclVoidClassDatum2 = this.getClassDatum(primitiveTypeModel, standardLibrary.getOclVoidType());
        }
        return oclVoidClassDatum2;
    }

    public @NonNull OperationDependencyAnalysis getOperationDependencyAnalysis() {
        OperationDependencyAnalysis operationDependencyAnalysis2 = this.operationDependencyAnalysis;
        if (operationDependencyAnalysis2 == null) {
            this.operationDependencyAnalysis = operationDependencyAnalysis2 = new OperationDependencyAnalysis(this.getContainmentAnalysis(), this.getDomainUsageAnalysis());
        }
        return operationDependencyAnalysis2;
    }

    public @NonNull PropertyDatum getPropertyDatum(@NonNull ClassDatum classDatum, @NonNull Property property) {
        return this.datumCaches.getPropertyDatum(classDatum, property);
    }

    @Override
    public @NonNull RegionAnalysis getRegionAnalysis(@NonNull Region region) {
        RegionAnalysis regionAnalysis = this.region2regionAnalysis.get(region);
        if (regionAnalysis == null) {
            regionAnalysis = new RegionAnalysis(this, region);
            this.region2regionAnalysis.put(region, regionAnalysis);
        }
        return regionAnalysis;
    }

    @Override
    public @NonNull ScheduleModel getScheduleModel() {
        return this.scheduleModel;
    }

    @Override
    public @NonNull StandardLibrary getStandardLibrary() {
        return this.environmentFactory.getStandardLibrary();
    }

    @Override
    public @NonNull StandardLibraryHelper getStandardLibraryHelper() {
        return this.standardLibraryHelper;
    }

    @Override
    public @NonNull PropertyDatum getSuccessPropertyDatum(@NonNull Property successProperty) {
        return this.datumCaches.getSuccessPropertyDatum(successProperty);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Override
    public @NonNull Iterable<@NonNull ClassDatum> getSuperClassDatums(@NonNull ClassDatum classDatum) {
        @NonNull List superClassDatums = QVTscheduleUtil.Internal.getSuperClassDatumsList((ClassDatum)classDatum);
        if (superClassDatums.isEmpty()) {
            DomainUsage domainUsage = this.getDomainUsage((Element)classDatum);
            CompleteClass completeClass = classDatum.getCompleteClass();
            for (CompleteClass completeSuperClass : completeClass.getSuperCompleteClasses()) {
                TypedModel typedModel = (TypedModel)ClassUtil.nonNullState((Object)domainUsage.getTypedModel((Element)completeClass));
                ClassDatum superClassDatum = this.getClassDatum(typedModel, completeSuperClass);
                if (superClassDatums.contains(superClassDatum)) continue;
                superClassDatums.add(superClassDatum);
            }
        }
        return superClassDatums;
    }

    @Override
    public @NonNull Iterable<@NonNull TransformationAnalysis> getTransformationAnalyses() {
        return this.transformation2transformationAnalysis.values();
    }

    @Override
    public @NonNull TransformationAnalysis getTransformationAnalysis(@NonNull Transformation transformation) {
        TransformationAnalysis transformationAnalysis = this.transformation2transformationAnalysis.get(transformation);
        return (TransformationAnalysis)((Object)ClassUtil.nonNullState((Object)((Object)transformationAnalysis)));
    }

    @Override
    public boolean isDirty(@NonNull Property property) {
        return this.domainUsageAnalysis.isDirty(property);
    }

    @Override
    public boolean isElementallyConformantSource(@NonNull NavigableEdge thatEdge, @NonNull NavigableEdge thisEdge) {
        CompleteClass thisType;
        Node thatSource = thatEdge.getEdgeSource();
        CompleteClass thatType = (CompleteClass)ClassUtil.nonNullState((Object)this.getElementalClassDatum(QVTscheduleUtil.getClassDatum((Node)thatSource)).getCompleteClass());
        if (thatType.conformsTo(thisType = (CompleteClass)ClassUtil.nonNullState((Object)this.getElementalClassDatum(QVTscheduleUtil.getClassDatum((Node)thisEdge.getEdgeSource())).getCompleteClass()))) {
            return true;
        }
        if (thatSource.isRealized()) {
            return false;
        }
        return thisType.conformsTo(thatType);
    }

    @Override
    public boolean isMiddle(@NonNull Node node) {
        return this.getDomainUsage((Element)QVTscheduleUtil.getClassDatum((Node)node)).isMiddle();
    }

    @Override
    public boolean isNoEarlyMerge() {
        CompilerOptions.StepOptions schedulerOptions2 = this.schedulerOptions;
        if (schedulerOptions2 == null) {
            return false;
        }
        return schedulerOptions2.basicGet(CompilerChain.SCHEDULER_NO_EARLY_MERGE) == Boolean.TRUE;
    }

    @Override
    public boolean isNoLateConsumerMerge() {
        CompilerOptions.StepOptions schedulerOptions2 = this.schedulerOptions;
        if (schedulerOptions2 == null) {
            return false;
        }
        return schedulerOptions2.basicGet(CompilerChain.SCHEDULER_NO_LATE_CONSUMER_MERGE) == Boolean.TRUE;
    }

    public boolean isKnown(@NonNull VariableDeclaration sourceVariable) {
        if (sourceVariable.eContainer() == null) {
            return false;
        }
        DomainUsage usage = this.getDomainUsage((Element)sourceVariable);
        assert (usage != null);
        return !usage.isOutput();
    }

    @Override
    public void setScheduledRegion(@NonNull MappingRegion mappingRegion, @Nullable ScheduledRegion scheduledRegion) {
        mappingRegion.setScheduledRegion(scheduledRegion);
    }

    public void writeCallDOTfile(@NonNull ScheduledRegion region, @NonNull String suffix) {
        if (this.doDotGraphs) {
            URI baseURI = this.getGraphsBaseURI();
            URI dotURI = URI.createURI((String)(String.valueOf(region.getSymbolName()) + suffix + ".dot")).resolve(baseURI);
            try {
                OutputStream outputStream = this.environmentFactory.getResourceSet().getURIConverter().createOutputStream(dotURI);
                ToCallGraphVisitor visitor = new ToCallGraphVisitor((GraphStringBuilder)new DOTStringBuilder());
                String s = visitor.visit(region);
                outputStream.write(s.getBytes());
                outputStream.close();
            }
            catch (IOException e) {
                System.err.println("Failed to generate '" + dotURI + "' : " + e.getLocalizedMessage());
            }
        }
    }

    public void writeCallGraphMLfile(@NonNull ScheduledRegion region, @NonNull String suffix) {
        if (this.doYedGraphs) {
            URI baseURI = this.getGraphsBaseURI();
            URI dotURI = URI.createURI((String)(String.valueOf(region.getSymbolName()) + suffix + ".graphml")).resolve(baseURI);
            try {
                OutputStream outputStream = this.environmentFactory.getResourceSet().getURIConverter().createOutputStream(dotURI);
                ToCallGraphVisitor visitor = new ToCallGraphVisitor((GraphStringBuilder)new GraphMLStringBuilder());
                String s = visitor.visit(region);
                outputStream.write(s.getBytes());
                outputStream.close();
            }
            catch (IOException e) {
                System.err.println("Failed to generate '" + dotURI + "' : " + e.getLocalizedMessage());
            }
        }
    }

    @Override
    public void writeDebugGraphs(@NonNull String context, boolean doNodesGraph, boolean doRegionGraph, boolean doCallGraph) {
        if (this.doDotGraphs || this.doYedGraphs) {
            for (ScheduledRegion scheduledRegion : QVTscheduleUtil.getOwnedScheduledRegions((ScheduleModel)this.scheduleModel)) {
                String suffix;
                if (doNodesGraph) {
                    this.writeDebugGraphs((Region)scheduledRegion, context);
                }
                if (doRegionGraph) {
                    suffix = "-r-" + context;
                    this.writeRegionDOTfile(scheduledRegion, suffix);
                    this.writeRegionGraphMLfile(scheduledRegion, suffix);
                }
                if (!doCallGraph) continue;
                suffix = "-c-" + context;
                this.writeCallDOTfile(scheduledRegion, suffix);
                this.writeCallGraphMLfile(scheduledRegion, suffix);
            }
        }
    }

    @Override
    public void writeDebugGraphs(@NonNull Region region, @Nullable String context) {
        if (this.doDotGraphs || this.doYedGraphs) {
            String suffix = context != null ? "-" + context : null;
            this.writeDOTfile(region, suffix);
            this.writeGraphMLfile(region, suffix);
        }
    }

    public void writeDOTfile(@NonNull Region region, @Nullable String suffix) {
        if (this.doDotGraphs) {
            URI baseURI = this.getGraphsBaseURI();
            String symbolName = region.getSymbolName();
            if (suffix != null) {
                symbolName = String.valueOf(symbolName) + suffix;
            }
            URI dotURI = URI.createURI((String)(String.valueOf(symbolName) + ".dot")).resolve(baseURI);
            try {
                OutputStream outputStream = this.environmentFactory.getResourceSet().getURIConverter().createOutputStream(dotURI);
                DOTStringBuilder s = new DOTStringBuilder();
                region.toGraph((GraphStringBuilder)s);
                outputStream.write(s.toString().getBytes());
                outputStream.close();
            }
            catch (IOException e) {
                System.err.println("Failed to generate '" + dotURI + "' : " + e.getLocalizedMessage());
            }
        }
    }

    public void writeGraphMLfile(@NonNull Region region, @Nullable String suffix) {
        if (this.doYedGraphs) {
            URI baseURI = this.getGraphsBaseURI();
            String symbolName = region.getSymbolName();
            if (suffix != null) {
                symbolName = String.valueOf(symbolName) + suffix;
            }
            URI dotURI = URI.createURI((String)(String.valueOf(symbolName) + ".graphml")).resolve(baseURI);
            try {
                OutputStream outputStream = this.environmentFactory.getResourceSet().getURIConverter().createOutputStream(dotURI);
                GraphMLStringBuilder s = new GraphMLStringBuilder();
                region.toGraph((GraphStringBuilder)s);
                outputStream.write(s.toString().getBytes());
                outputStream.close();
            }
            catch (IOException e) {
                System.err.println("Failed to generate '" + dotURI + "' : " + e.getLocalizedMessage());
            }
        }
    }

    public void writeRegionDOTfile(@NonNull ScheduledRegion region, @NonNull String suffix) {
        if (this.doDotGraphs) {
            URI baseURI = this.getGraphsBaseURI();
            URI dotURI = URI.createURI((String)(String.valueOf(region.getSymbolName()) + suffix + ".dot")).resolve(baseURI);
            try {
                OutputStream outputStream = this.environmentFactory.getResourceSet().getURIConverter().createOutputStream(dotURI);
                ToRegionGraphVisitor visitor = new ToRegionGraphVisitor((GraphStringBuilder)new DOTStringBuilder());
                String s = visitor.visit(region);
                outputStream.write(s.getBytes());
                outputStream.close();
            }
            catch (IOException e) {
                System.err.println("Failed to generate '" + dotURI + "' : " + e.getLocalizedMessage());
            }
            for (Region nestedRegion : QVTscheduleUtil.getMappingRegions((ScheduledRegion)region)) {
                if (!(nestedRegion instanceof ScheduledRegion)) continue;
                this.writeRegionDOTfile((ScheduledRegion)nestedRegion, suffix);
            }
        }
    }

    public void writeRegionGraphMLfile(@NonNull ScheduledRegion region, @NonNull String suffix) {
        if (this.doYedGraphs) {
            URI baseURI = this.getGraphsBaseURI();
            URI dotURI = URI.createURI((String)(String.valueOf(region.getSymbolName()) + suffix + ".graphml")).resolve(baseURI);
            try {
                OutputStream outputStream = this.environmentFactory.getResourceSet().getURIConverter().createOutputStream(dotURI);
                ToRegionGraphVisitor visitor = new ToRegionGraphVisitor((GraphStringBuilder)new GraphMLStringBuilder());
                String s = visitor.visit(region);
                outputStream.write(s.getBytes());
                outputStream.close();
            }
            catch (IOException e) {
                System.err.println("Failed to generate '" + dotURI + "' : " + e.getLocalizedMessage());
            }
            for (Region nestedRegion : QVTscheduleUtil.getMappingRegions((ScheduledRegion)region)) {
                if (!(nestedRegion instanceof ScheduledRegion)) continue;
                this.writeRegionGraphMLfile((ScheduledRegion)nestedRegion, suffix);
            }
        }
    }
}

