/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.engine.emfvm;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.text.CharacterIterator;
import java.text.StringCharacterIterator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.m2m.atl.common.ATLLogger;
import org.eclipse.m2m.atl.core.IModel;
import org.eclipse.m2m.atl.core.IReferenceModel;
import org.eclipse.m2m.atl.engine.emfvm.ASMOperation;
import org.eclipse.m2m.atl.engine.emfvm.AtlSuperimposeModule;
import org.eclipse.m2m.atl.engine.emfvm.Messages;
import org.eclipse.m2m.atl.engine.emfvm.StackFrame;
import org.eclipse.m2m.atl.engine.emfvm.VMException;
import org.eclipse.m2m.atl.engine.emfvm.adapter.IModelAdapter;
import org.eclipse.m2m.atl.engine.emfvm.launch.ITool;
import org.eclipse.m2m.atl.engine.emfvm.lib.ASMModule;
import org.eclipse.m2m.atl.engine.emfvm.lib.ExecEnv;
import org.eclipse.m2m.atl.engine.emfvm.lib.LibExtension;
import org.eclipse.m2m.atl.engine.emfvm.lib.OclType;
import org.eclipse.m2m.atl.engine.emfvm.lib.Operation;
import org.eclipse.m2m.atl.engine.emfvm.lib.Tuple;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ASM {
    private String version = "1.0";
    private String name;
    private List<ASMOperation> operations = new ArrayList<ASMOperation>();
    private List<String> fields = new ArrayList<String>();
    private ASMOperation mainOperation;

    public void setName(String name) {
        this.name = name;
    }

    public void addField(String fieldName, String type) {
        this.fields.add(fieldName);
    }

    public void addOperation(ASMOperation operation) {
        this.operations.add(operation);
        if (operation.getName().equals("main") && operation.getContext().equals("A")) {
            this.mainOperation = operation;
        }
    }

    public Iterator<ASMOperation> getOperations() {
        return this.operations.iterator();
    }

    public ASMOperation getMainOperation() {
        return this.mainOperation;
    }

    public Object run(ITool[] tools, Map<String, IModel> models, Map<String, ASM> libraries, List<ASM> superimpose, Map<String, Object> options, IProgressMonitor monitor, IModelAdapter modelAdapter) {
        Object ret = null;
        boolean printExecutionTime = "true".equals(options.get("printExecutionTime"));
        long startTime = System.currentTimeMillis();
        ExecEnv execEnv = new ExecEnv(models, tools);
        execEnv.init(modelAdapter);
        if ("true".equals(options.get("step"))) {
            execEnv.setStep(true);
        }
        for (LibExtension extension : this.getAllExtensions(options)) {
            extension.apply(execEnv, options);
        }
        this.addAllTypesExtensions(options);
        ASMModule asmModule = new ASMModule(this.getName());
        ArrayList<Object> localVars = null;
        if (!this.mainOperation.getParameters().isEmpty()) {
            localVars = new ArrayList<Object>();
            localVars.add(asmModule);
            for (String pname : this.mainOperation.getParameters()) {
                pname = this.mainOperation.resolveVariableName(Integer.parseInt(pname), 0);
                localVars.add(options.get(pname));
            }
        }
        StackFrame frame = new StackFrame(execEnv, asmModule, this.mainOperation);
        if (localVars != null) {
            frame.setLocalVars(localVars.toArray());
        }
        for (ASM library : libraries.values()) {
            ASM.registerOperations(execEnv, library.getOperations());
            if (library.mainOperation == null) continue;
            StackFrame rootFrame = new StackFrame(execEnv, asmModule, library.mainOperation);
            library.mainOperation.exec(rootFrame.enter());
            rootFrame.leave();
        }
        ASM.registerOperations(execEnv, this.operations.iterator());
        for (ASM module : superimpose) {
            AtlSuperimposeModule ami = new AtlSuperimposeModule(execEnv, module);
            try {
                ami.adaptModuleOperations();
            }
            catch (AtlSuperimposeModule.AtlSuperimposeModuleException e) {
                throw new VMException(frame, e.getLocalizedMessage(), e);
            }
            ASM.registerOperations(execEnv, module.getOperations());
        }
        ret = this.mainOperation.exec(frame.enter(), monitor);
        frame.leave();
        execEnv.terminated();
        long endTime = System.currentTimeMillis();
        if (printExecutionTime) {
            ATLLogger.info((String)Messages.getString("ASM.EXECUTIONTIME", this.name, new Double((double)(endTime - startTime) / 1000.0)));
        }
        if ("true".equals(options.get("showSummary"))) {
            ATLLogger.info((String)Messages.getString("ASM.INSTRUCTIONSCOUNT", new Double(execEnv.getNbExecutedBytecodes())));
        }
        return ret;
    }

    public static void registerOperations(ExecEnv execEnv, Iterator<ASMOperation> operationsToRegister) {
        while (operationsToRegister.hasNext()) {
            ASMOperation op = operationsToRegister.next();
            String signature = op.getContext();
            if (signature.matches("^(Q|G|C|E|O|N).*$")) {
                ATLLogger.warning((String)Messages.getString("ASM.UNSUPPORTEDREGISTRATION", signature));
                continue;
            }
            try {
                Object type = ASM.parseType(execEnv, new StringCharacterIterator(signature));
                execEnv.registerOperation(type, (Operation)op);
            }
            catch (SignatureParsingException spe) {
                throw new VMException(null, spe.getLocalizedMessage(), spe);
            }
        }
    }

    public String getName() {
        return this.name;
    }

    private List<LibExtension> getAllExtensions(Map<String, Object> options) {
        List extensionObjects;
        ArrayList<LibExtension> res = new ArrayList<LibExtension>();
        String ext = (String)options.get("extensions");
        if (ext != null) {
            ClassLoader cl = this.getClass().getClassLoader();
            String extraClasspath = (String)options.get("extraClasspath");
            if (extraClasspath != null) {
                String[] paths = extraClasspath.split(",");
                URL[] urls = new URL[paths.length];
                String userDir = (String)options.get("user.dir");
                if (userDir == null) {
                    userDir = System.getProperty("user.dir");
                }
                int i = 0;
                while (i < paths.length) {
                    try {
                        urls[i] = new File(userDir, paths[i]).toURI().toURL();
                    }
                    catch (MalformedURLException e) {
                        throw new VMException(null, Messages.getString("ASM.LOADINGERROR", paths[i]), e);
                    }
                    ++i;
                }
                cl = new URLClassLoader(urls, cl);
            }
            String[] extensions = ext.split(",");
            int i = 0;
            while (i < extensions.length) {
                try {
                    LibExtension extension = (LibExtension)cl.loadClass(extensions[i]).newInstance();
                    res.add(extension);
                }
                catch (ClassNotFoundException e) {
                    throw new VMException(null, Messages.getString("ASM.EXTLOADINGERROR", extensions[i]), e);
                }
                catch (InstantiationException e) {
                    throw new VMException(null, Messages.getString("ASM.EXTINSTANTIATEERROR", extensions[i]), e);
                }
                catch (IllegalAccessException e) {
                    throw new VMException(null, Messages.getString("ASM.EXTINSTANTIATEERROR", extensions[i]), e);
                }
                ++i;
            }
        }
        if ((extensionObjects = (List)options.get("extensionObjects")) != null) {
            Iterator i = extensionObjects.iterator();
            while (i.hasNext()) {
                res.add((LibExtension)i.next());
            }
        }
        try {
            IExtension[] extensions = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.m2m.atl.engine.emfvm.libextension").getExtensions();
            int i = 0;
            while (i < extensions.length) {
                IConfigurationElement[] configElements = extensions[i].getConfigurationElements();
                int j = 0;
                while (j < configElements.length) {
                    LibExtension extension = (LibExtension)configElements[j].createExecutableExtension("class");
                    res.add(extension);
                    ++j;
                }
                ++i;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return res;
    }

    private void addAllTypesExtensions(Map<String, Object> options) {
        Map ext = (Map)options.get("typeextensions");
        if (ext != null) {
            for (Map.Entry entry : ext.entrySet()) {
                OclType.addSimpleType((String)entry.getKey(), (Class)entry.getValue());
            }
        }
        try {
            IExtension[] extensions = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.m2m.atl.engine.emfvm.typeextension").getExtensions();
            int i = 0;
            while (i < extensions.length) {
                IConfigurationElement[] configElements = extensions[i].getConfigurationElements();
                int j = 0;
                while (j < configElements.length) {
                    String typeName = configElements[j].getAttribute("name");
                    Class<?> typeClass = configElements[j].createExecutableExtension("class").getClass();
                    OclType.addSimpleType(typeName, typeClass);
                    ++j;
                }
                ++i;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static String readUntil(CharacterIterator ci, char c) throws SignatureParsingException {
        StringBuffer ret = new StringBuffer();
        while (ci.current() != c) {
            ret.append(ci.current());
            ci.next();
        }
        ASM.read(ci, c);
        return ret.toString();
    }

    private static void read(CharacterIterator ci, char c) throws SignatureParsingException {
        if (ci.current() != c) {
            throw new SignatureParsingException(Messages.getString("ASM.PARSINGERROR", new Character(c), new Character(ci.current()), ci.getIndex()));
        }
        ci.next();
    }

    private static Object parseType(ExecEnv execEnv, CharacterIterator ci) throws SignatureParsingException {
        Object ret = ASM.parseTypeInternal(execEnv, ci);
        if (ci.next() != '\uffff') {
            throw new SignatureParsingException(Messages.getString("ASM.SIGNATUREPARSINGERROR", ci.getIndex()));
        }
        return ret;
    }

    private static Object parseTypeInternal(ExecEnv execEnv, CharacterIterator ci) throws SignatureParsingException {
        Object ret = null;
        switch (ci.current()) {
            case 'T': {
                ci.next();
                while (ci.current() != ';') {
                    ASM.readUntil(ci, ';');
                }
                ret = Tuple.class;
                break;
            }
            case 'M': {
                ci.next();
                String mname = ASM.readUntil(ci, '!');
                String modelName = ASM.readUntil(ci, ';');
                IReferenceModel model = (IReferenceModel)execEnv.getModel(mname);
                if (model != null) {
                    Object ec = model.getMetaElementByName(modelName);
                    if (ec == null) {
                        throw new SignatureParsingException(Messages.getString("ASM.MODELELEMENTNOTFOUND", modelName, mname));
                    }
                    ret = ec;
                    break;
                }
                throw new VMException(null, Messages.getString("ASM.MODELNOTFOUND", mname));
            }
            case 'A': {
                ret = ASMModule.class;
                ci.next();
                break;
            }
            case 'J': {
                ret = Object.class;
                ci.next();
                break;
            }
            case 'I': {
                ret = Integer.class;
                ci.next();
                break;
            }
            case 'B': {
                ret = Boolean.class;
                ci.next();
                break;
            }
            case 'S': {
                ret = String.class;
                ci.next();
                break;
            }
            case 'D': {
                ret = Double.class;
                ci.next();
                break;
            }
            case '\uffff': {
                throw new SignatureParsingException(Messages.getString("ASM.SIGNATUREPARSINGERROR", ci.getIndex()));
            }
            default: {
                throw new SignatureParsingException(Messages.getString("ASM.UNKNOWTYPECODE", new Character(ci.current())));
            }
        }
        return ret;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getVersion() {
        return this.version;
    }

    private static class SignatureParsingException
    extends Exception {
        private static final long serialVersionUID = 7488097967558841786L;

        public SignatureParsingException(String msg) {
            super(msg);
        }
    }
}

