/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.adt.ui;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.logging.Level;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.m2m.atl.common.ATLLogger;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class AtlUIPlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.eclipse.m2m.atl.adt.ui";
    private static AtlUIPlugin plugin;
    private static Map<String, Image> path2image;
    private ResourceBundle resourceBundle;

    static {
        path2image = new HashMap<String, Image>();
    }

    public AtlUIPlugin() {
        plugin = this;
        try {
            this.resourceBundle = ResourceBundle.getBundle("atlPerspective.AtlPerspectivePluginResources");
        }
        catch (MissingResourceException missingResourceException) {
            this.resourceBundle = null;
        }
        this.addDebugEventListener();
    }

    private void addDebugEventListener() {
        DebugPlugin.getDefault().addDebugEventListener(new IDebugEventSetListener(){

            public void handleDebugEvents(DebugEvent[] debugEvents) {
                DebugEvent[] debugEventArray = debugEvents;
                int n = debugEvents.length;
                int n2 = 0;
                while (n2 < n) {
                    DebugEvent debugEvent = debugEventArray[n2];
                    if (debugEvent.getKind() == 2) {
                        AtlUIPlugin.this.switchToDebugPerspective();
                        break;
                    }
                    ++n2;
                }
            }
        });
    }

    private void switchToDebugPerspective() {
        try {
            PlatformUI.getWorkbench().showPerspective("org.eclipse.debug.ui.DebugPerspective", PlatformUI.getWorkbench().getActiveWorkbenchWindow());
        }
        catch (WorkbenchException e) {
            ATLLogger.log((Level)Level.SEVERE, (String)e.getMessage(), (Throwable)e);
        }
    }

    public static AtlUIPlugin getDefault() {
        return plugin;
    }

    public static String getResourceString(String key) {
        ResourceBundle bundle = AtlUIPlugin.getDefault().getResourceBundle();
        try {
            return bundle != null ? bundle.getString(key) : key;
        }
        catch (MissingResourceException missingResourceException) {
            return key;
        }
    }

    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    public static Image getImage(String path) {
        ImageDescriptor descriptor;
        Image result = path2image.get(path);
        if (result == null && !path2image.containsKey(path) && (descriptor = AtlUIPlugin.getImageDescriptor(path)) != null) {
            result = descriptor.createImage();
            path2image.put(path, result);
        }
        if (result != null && result.isDisposed()) {
            result = null;
        }
        return result;
    }

    public static ImageDescriptor getImageDescriptor(String name) {
        if (Platform.isRunning()) {
            String pluginDir = plugin.getBundle().getEntry("/").toString();
            String iconPath = "icons/";
            try {
                return ImageDescriptor.createFromURL((URL)new URL(String.valueOf(pluginDir) + iconPath + name));
            }
            catch (MalformedURLException malformedURLException) {
                return ImageDescriptor.getMissingImageDescriptor();
            }
        }
        return null;
    }
}

