/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.adt.ui.common;

import java.util.Collection;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.m2m.atl.adt.ui.Messages;
import org.eclipse.m2m.atl.common.IAtlLexems;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.SelectionStatusDialog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractAtlSelection
extends SelectionStatusDialog {
    protected static final String NAMING_REGEX = "[a-zA-Z0-9]+";
    private IStatus status;

    public AbstractAtlSelection(Shell parent, String title) {
        super(parent);
        this.setTitle(title);
        this.setStatusLineAboveButtons(true);
        this.setShellStyle(67696);
    }

    public void create() {
        this.status = new Status(0, "org.eclipse.m2m.atl.adt.ui", 0, "", null);
        this.updateStatus(this.status);
        super.create();
        this.getOkButton().setEnabled(false);
    }

    protected void nok(String message) {
        if (Platform.isRunning()) {
            this.status = new Status(4, "org.eclipse.m2m.atl.adt.ui", 4, message, null);
            this.updateStatus(this.status);
        }
        this.getOkButton().setEnabled(false);
    }

    protected void ok() {
        this.status = new Status(0, "org.eclipse.m2m.atl.adt.ui", 0, "", null);
        this.updateStatus(this.status);
        this.getOkButton().setEnabled(true);
    }

    protected void warn(String message) {
        this.status = new Status(2, "org.eclipse.m2m.atl.adt.ui", message);
        this.updateStatus(this.status);
        this.getOkButton().setEnabled(true);
    }

    protected String getDefaultName(String prefix, Collection<String> existingEntries) {
        String res = prefix;
        int index = 0;
        while (existingEntries.contains(res)) {
            res = String.valueOf(prefix) + ++index;
        }
        return res;
    }

    public static String checkIdentifier(String identifier) {
        String errorMessage = null;
        if (identifier == null || "".equals(identifier.trim())) {
            errorMessage = Messages.getString("AbstractAtlSelection.NAMING_UNSET");
        } else if (!identifier.matches(NAMING_REGEX)) {
            errorMessage = Messages.getString("AbstractAtlSelection.NAMING_ISSUE", identifier);
        } else {
            String s;
            String[] stringArray = IAtlLexems.CONSTANTS;
            int n = IAtlLexems.CONSTANTS.length;
            int n2 = 0;
            while (n2 < n) {
                s = stringArray[n2];
                if (s.equals(identifier)) {
                    errorMessage = Messages.getString("AbstractAtlSelection.NAMING_CONFLICT", s);
                    break;
                }
                ++n2;
            }
            stringArray = IAtlLexems.KEYWORDS;
            n = IAtlLexems.KEYWORDS.length;
            n2 = 0;
            while (n2 < n) {
                s = stringArray[n2];
                if (s.equals(identifier)) {
                    errorMessage = Messages.getString("AbstractAtlSelection.NAMING_CONFLICT", s);
                    break;
                }
                ++n2;
            }
            stringArray = IAtlLexems.TYPES;
            n = IAtlLexems.TYPES.length;
            n2 = 0;
            while (n2 < n) {
                s = stringArray[n2];
                if (s.equals(identifier)) {
                    errorMessage = Messages.getString("AbstractAtlSelection.NAMING_CONFLICT", s);
                    break;
                }
                ++n2;
            }
        }
        return errorMessage;
    }
}

