/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mita.platform.ui.labeling;

import com.google.inject.Inject;
import java.net.URL;
import java.util.Arrays;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.mita.base.types.EnumerationType;
import org.eclipse.mita.base.types.Enumerator;
import org.eclipse.mita.base.types.Event;
import org.eclipse.mita.base.types.ExceptionTypeDeclaration;
import org.eclipse.mita.base.types.Type;
import org.eclipse.mita.base.types.inferrer.ITypeSystemInferrer;
import org.eclipse.mita.platform.AbstractSystemResource;
import org.eclipse.mita.platform.Bus;
import org.eclipse.mita.platform.ConfigurationItem;
import org.eclipse.mita.platform.Connectivity;
import org.eclipse.mita.platform.Modality;
import org.eclipse.mita.platform.Sensor;
import org.eclipse.mita.platform.Signal;
import org.eclipse.mita.platform.SignalEvent;
import org.eclipse.mita.platform.SystemResourceAlias;
import org.eclipse.mita.platform.SystemResourceEvent;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.ui.label.DefaultEObjectLabelProvider;
import org.eclipse.xtext.xbase.lib.Exceptions;

public class PlatformDSLLabelProvider
extends DefaultEObjectLabelProvider {
    @Inject
    private ITypeSystemInferrer typeInferrer;

    @Inject
    public PlatformDSLLabelProvider(AdapterFactoryLabelProvider delegate) {
        super(delegate);
    }

    protected Object _image(EObject ele) {
        return super.image((Object)ele);
    }

    protected Object _image(Enumerator element) {
        return this.loadImage("enumerator.png");
    }

    protected Object _image(EnumerationType element) {
        return this.loadImage("enumerator.png");
    }

    protected Object _image(Sensor element) {
        return this.loadImage("sensor.png");
    }

    protected Object _image(Connectivity element) {
        return this.loadImage("connectivity.png");
    }

    protected Object _image(Event it) {
        return this.loadImage("event.png");
    }

    protected Object _image(ExceptionTypeDeclaration ele) {
        return this.loadImage("variable.png");
    }

    protected Object _image(SystemResourceAlias it) {
        return this.image((EObject)it.getDelegate());
    }

    public CharSequence text(ConfigurationItem ele) {
        StringConcatenation _builder = new StringConcatenation();
        Boolean _required = ele.getRequired();
        if (_required.booleanValue()) {
            _builder.append("required");
        }
        _builder.append(" configuration ");
        String _name = ele.getName();
        _builder.append(_name);
        _builder.append(" : ");
        Type _type = ele.getType();
        _builder.append((Object)_type);
        return _builder;
    }

    public CharSequence text(Sensor ele) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("sensor ");
        String _name = ele.getName();
        _builder.append(_name);
        return _builder;
    }

    public CharSequence text(SystemResourceAlias ele) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("alias ");
        String _label = this.getLabel((EObject)ele);
        _builder.append(_label);
        _builder.append(" ");
        String _name = ele.getName();
        _builder.append(_name);
        _builder.append(" : ");
        AbstractSystemResource _delegate = ele.getDelegate();
        String _name_1 = null;
        if (_delegate != null) {
            _name_1 = _delegate.getName();
        }
        _builder.append(_name_1);
        return _builder;
    }

    protected String _getLabel(SystemResourceAlias alias) {
        return "sensor";
    }

    protected String _getLabel(EObject object) {
        return object.eClass().getName();
    }

    public CharSequence text(SystemResourceEvent ele) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("event ");
        String _name = ele.getName();
        _builder.append(_name);
        return _builder;
    }

    public CharSequence text(SignalEvent ele) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("signal event ");
        String _name = ele.getName();
        _builder.append(_name);
        return _builder;
    }

    public CharSequence text(Modality ele) {
        StringConcatenation _xblockexpression = null;
        ITypeSystemInferrer.InferenceResult _infer = this.typeInferrer.infer((EObject)ele);
        Type _type = null;
        if (_infer != null) {
            _type = _infer.getType();
        }
        Type type = _type;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("modality ");
        String _name = ele.getName();
        _builder.append(_name);
        _builder.append(" : ");
        _builder.append((Object)type);
        _xblockexpression = _builder;
        return _xblockexpression;
    }

    public CharSequence text(Connectivity it) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("connectivity ");
        String _name = it.getName();
        _builder.append(_name);
        return _builder;
    }

    public CharSequence text(Bus it) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("bus ");
        String _name = it.getName();
        _builder.append(_name);
        return _builder;
    }

    public CharSequence text(ExceptionTypeDeclaration it) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("exception ");
        String _name = it.getName();
        _builder.append(_name);
        return _builder;
    }

    public CharSequence text(EnumerationType it) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("enum ");
        String _name = it.getName();
        _builder.append(_name);
        return _builder;
    }

    public CharSequence text(Signal it) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("signal ");
        String _name = it.getName();
        _builder.append(_name);
        return _builder;
    }

    protected String convertToString(Object text) {
        if (text instanceof CharSequence) {
            return ((CharSequence)text).toString();
        }
        return super.convertToString(text);
    }

    protected StyledString convertToStyledString(Object text) {
        if (text instanceof CharSequence) {
            String _string = ((CharSequence)text).toString();
            return new StyledString(_string);
        }
        return super.convertToStyledString(text);
    }

    private ImageDescriptor loadImage(String imageName) {
        try {
            String bundleIconUrl = "platform:/plugin/org.eclipse.mita.program.ui/icons/";
            URL _uRL = new URL("platform:/plugin/org.eclipse.mita.program.ui/icons/" + imageName);
            return ImageDescriptor.createFromURL((URL)_uRL);
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public Object image(EObject element) {
        if (element instanceof EnumerationType) {
            return this._image((EnumerationType)element);
        }
        if (element instanceof Connectivity) {
            return this._image((Connectivity)element);
        }
        if (element instanceof Sensor) {
            return this._image((Sensor)element);
        }
        if (element instanceof SystemResourceAlias) {
            return this._image((SystemResourceAlias)element);
        }
        if (element instanceof Enumerator) {
            return this._image((Enumerator)element);
        }
        if (element instanceof Event) {
            return this._image((Event)element);
        }
        if (element instanceof ExceptionTypeDeclaration) {
            return this._image((ExceptionTypeDeclaration)element);
        }
        if (element != null) {
            return this._image(element);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(element).toString());
    }

    protected String getLabel(EObject alias) {
        if (alias instanceof SystemResourceAlias) {
            return this._getLabel((SystemResourceAlias)alias);
        }
        if (alias != null) {
            return this._getLabel(alias);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(alias).toString());
    }
}

