/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mita.program.ui.builder;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.core.internal.resources.ResourceException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.mita.program.generator.internal.IGeneratorOnResourceSet;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.builder.BuilderParticipant;
import org.eclipse.xtext.builder.EclipseResourceFileSystemAccess2;
import org.eclipse.xtext.builder.IXtextBuilderParticipant;
import org.eclipse.xtext.generator.IFileSystemAccess2;
import org.eclipse.xtext.generator.OutputConfiguration;
import org.eclipse.xtext.resource.IContainer;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.IResourceDescriptions;
import org.eclipse.xtext.resource.impl.ResourceDescriptionsProvider;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class ProgramDslBuilderParticipant
extends BuilderParticipant {
    protected static final Logger logger = Logger.getLogger(BuilderParticipant.class);
    protected ThreadLocal<Boolean> buildSemaphore = new ThreadLocal();
    @Inject(optional=true)
    private IGeneratorOnResourceSet generator;
    @Inject
    private ResourceDescriptionsProvider resourceDescriptionsProvider;
    @Inject
    private IContainer.Manager containerManager;

    public void build(IXtextBuilderParticipant.IBuildContext context, IProgressMonitor monitor) throws CoreException {
        this.buildSemaphore.set(false);
        super.build(context, monitor);
    }

    protected void handleChangedContents(IResourceDescription.Delta delta, IXtextBuilderParticipant.IBuildContext context, EclipseResourceFileSystemAccess2 fileSystemAccess) throws CoreException {
        super.handleChangedContents(delta, context, fileSystemAccess);
        if (!this.buildSemaphore.get().booleanValue() && this.generator != null) {
            this.invokeGenerator(delta, context, (IFileSystemAccess2)fileSystemAccess);
        }
    }

    protected void invokeGenerator(IResourceDescription.Delta delta, IXtextBuilderParticipant.IBuildContext context, IFileSystemAccess2 fileSystemAccess) {
        this.buildSemaphore.set(true);
        Resource resource = context.getResourceSet().getResource(delta.getUri(), true);
        boolean _shouldGenerate = this.shouldGenerate(resource, context);
        if (_shouldGenerate) {
            IResourceDescriptions index = this.resourceDescriptionsProvider.createResourceDescriptions();
            IResourceDescription resDesc = index.getResourceDescription(resource.getURI());
            List visibleContainers = this.containerManager.getVisibleContainers(resDesc, index);
            for (org.eclipse.xtext.resource.IContainer c : visibleContainers) {
                Iterable _resourceDescriptions = c.getResourceDescriptions();
                for (IResourceDescription rd : _resourceDescriptions) {
                    context.getResourceSet().getResource(rd.getURI(), true);
                }
            }
            this.generator.doGenerate(context.getResourceSet(), fileSystemAccess);
        }
    }

    protected void doBuild(List<IResourceDescription.Delta> deltas, Map<String, OutputConfiguration> outputConfigurations, Map<OutputConfiguration, Iterable<IMarker>> generatorMarkers, IXtextBuilderParticipant.IBuildContext context, EclipseResourceFileSystemAccess2 access, IProgressMonitor progressMonitor) throws CoreException {
        NoRebuildBuildContextDecorator _noRebuildBuildContextDecorator = new NoRebuildBuildContextDecorator(context);
        super.doBuild(deltas, outputConfigurations, generatorMarkers, (IXtextBuilderParticipant.IBuildContext)_noRebuildBuildContextDecorator, access, progressMonitor);
    }

    protected void delete(IResource resource, OutputConfiguration config, EclipseResourceFileSystemAccess2 access, IProgressMonitor monitor) {
        try {
            boolean _isCanceled = monitor.isCanceled();
            if (_isCanceled) {
                throw new OperationCanceledException();
            }
            if (resource instanceof IContainer) {
                IResource[] _members;
                IContainer container = (IContainer)resource;
                IResource[] iResourceArray = _members = container.members();
                int n = _members.length;
                int n2 = 0;
                while (n2 < n) {
                    IResource child = iResourceArray[n2];
                    this.delete(child, config, access, monitor);
                    ++n2;
                }
                container.delete(3, monitor);
            } else if (resource instanceof IFile) {
                IFile file = (IFile)resource;
                access.deleteFile(file, config.getName(), monitor);
            } else {
                resource.delete(3, monitor);
            }
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    protected void cleanOutput(IXtextBuilderParticipant.IBuildContext ctx, OutputConfiguration config, EclipseResourceFileSystemAccess2 access, IProgressMonitor monitor) throws CoreException {
        IProject project = ctx.getBuiltProject();
        Set _outputs = this.getOutputs(project, config);
        for (IContainer container : _outputs) {
            boolean _not;
            boolean _exists = container.exists();
            boolean bl = _not = !_exists;
            if (_not) {
                return;
            }
            boolean _canClean = this.canClean(container, config);
            if (_canClean) {
                Functions.Function1<IResource, Boolean> _function = new Functions.Function1<IResource, Boolean>(){

                    public Boolean apply(IResource it) {
                        IPath path = it.getProjectRelativePath();
                        String _string = path.toString();
                        return !Objects.equal((Object)_string, (Object)"src-gen/Makefile");
                    }
                };
                Iterable _filter = IterableExtensions.filter((Iterable)((Iterable)Conversions.doWrapArray((Object)container.members())), (Functions.Function1)_function);
                for (IResource resource : _filter) {
                    try {
                        boolean _not_1;
                        Boolean _isKeepLocalHistory = config.isKeepLocalHistory();
                        boolean bl2 = _not_1 = _isKeepLocalHistory == false;
                        if (_not_1) {
                            resource.delete(1, monitor);
                            continue;
                        }
                        if (access == null) {
                            resource.delete(3, monitor);
                            continue;
                        }
                        this.delete(resource, config, access, monitor);
                    }
                    catch (Throwable _t) {
                        if (_t instanceof ResourceException) {
                            ResourceException e = (ResourceException)_t;
                            StringConcatenation _builder = new StringConcatenation();
                            _builder.append("Couldn't delete ");
                            IPath _location = resource.getLocation();
                            _builder.append((Object)_location);
                            _builder.append(". ");
                            String _message = e.getMessage();
                            _builder.append(_message);
                            logger.warn((Object)_builder);
                            continue;
                        }
                        throw Exceptions.sneakyThrow((Throwable)_t);
                    }
                }
                continue;
            }
            boolean _isCleanUpDerivedResources = config.isCleanUpDerivedResources();
            if (!_isCleanUpDerivedResources) continue;
            Functions.Function1<IFile, Boolean> _function_1 = new Functions.Function1<IFile, Boolean>(){

                public Boolean apply(IFile it) {
                    IPath path = it.getProjectRelativePath();
                    String _string = path.toString();
                    return !Objects.equal((Object)_string, (Object)"src-gen/Makefile");
                }
            };
            Iterable resources = IterableExtensions.filter((Iterable)this.getDerivedResourceMarkers().findDerivedResources(container, null), (Functions.Function1)_function_1);
            for (IFile iFile : resources) {
                boolean _isCanceled = monitor.isCanceled();
                if (_isCanceled) {
                    throw new OperationCanceledException();
                }
                try {
                    if (access != null) {
                        access.deleteFile(iFile, config.getName(), monitor);
                        continue;
                    }
                    iFile.delete(true, config.isKeepLocalHistory().booleanValue(), monitor);
                }
                catch (Throwable _t_1) {
                    if (_t_1 instanceof ResourceException) {
                        ResourceException e_1 = (ResourceException)_t_1;
                        StringConcatenation _builder_1 = new StringConcatenation();
                        _builder_1.append("Couldn't delete ");
                        IPath _location_1 = iFile.getLocation();
                        _builder_1.append((Object)_location_1);
                        _builder_1.append(". ");
                        String _message_1 = e_1.getMessage();
                        _builder_1.append(_message_1);
                        logger.warn((Object)_builder_1);
                        continue;
                    }
                    throw Exceptions.sneakyThrow((Throwable)_t_1);
                }
            }
        }
    }

    private static class NoRebuildBuildContextDecorator
    implements IXtextBuilderParticipant.IBuildContext {
        private final IXtextBuilderParticipant.IBuildContext delegate;

        public NoRebuildBuildContextDecorator(IXtextBuilderParticipant.IBuildContext delegate) {
            this.delegate = delegate;
        }

        public IXtextBuilderParticipant.BuildType getBuildType() {
            return this.delegate.getBuildType();
        }

        public IProject getBuiltProject() {
            return this.delegate.getBuiltProject();
        }

        public List<IResourceDescription.Delta> getDeltas() {
            return this.delegate.getDeltas();
        }

        public ResourceSet getResourceSet() {
            return this.delegate.getResourceSet();
        }

        public boolean isSourceLevelURI(URI uri) {
            return this.delegate.isSourceLevelURI(uri);
        }

        public void needRebuild() {
        }
    }
}

