/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mita.platform.xdk110.platform;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.mita.platform.AbstractSystemResource;
import org.eclipse.mita.platform.Platform;
import org.eclipse.mita.program.EventHandlerDeclaration;
import org.eclipse.mita.program.EventSource;
import org.eclipse.mita.program.SystemEventSource;
import org.eclipse.mita.program.generator.CodeFragment;
import org.eclipse.mita.program.generator.CodeFragmentProvider;
import org.eclipse.mita.program.generator.CompilationContext;
import org.eclipse.mita.program.generator.GeneratorUtils;
import org.eclipse.mita.program.generator.IPlatformStartupGenerator;
import org.eclipse.xtend2.lib.StringConcatenationClient;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class StartupGenerator
implements IPlatformStartupGenerator {
    @Inject
    @Extension
    protected GeneratorUtils _generatorUtils;
    @Inject
    protected CodeFragmentProvider codeFragmentProvider;

    public CodeFragment generateMain(CompilationContext context) {
        CodeFragment _xblockexpression = null;
        Functions.Function1<EventHandlerDeclaration, Boolean> _function = new Functions.Function1<EventHandlerDeclaration, Boolean>(){

            public Boolean apply(EventHandlerDeclaration x) {
                EventSource _event = x.getEvent();
                return _event instanceof SystemEventSource;
            }
        };
        Functions.Function1<EventHandlerDeclaration, Boolean> _function_1 = new Functions.Function1<EventHandlerDeclaration, Boolean>(){

            public Boolean apply(EventHandlerDeclaration x) {
                EventSource _event = x.getEvent();
                AbstractSystemResource _origin = ((SystemEventSource)_event).getOrigin();
                return _origin instanceof Platform;
            }
        };
        Iterable systemEvents = IterableExtensions.filter((Iterable)IterableExtensions.filter((Iterable)context.getAllEventHandlers(), (Functions.Function1)_function), (Functions.Function1)_function_1);
        Functions.Function1<EventHandlerDeclaration, Boolean> _function_2 = new Functions.Function1<EventHandlerDeclaration, Boolean>(){

            public Boolean apply(EventHandlerDeclaration x) {
                EventSource _event = x.getEvent();
                String _name = ((SystemEventSource)_event).getSource().getName();
                return Objects.equal((Object)_name, (Object)"startup");
            }
        };
        final EventHandlerDeclaration startupEvent = (EventHandlerDeclaration)IterableExtensions.findFirst((Iterable)systemEvents, (Functions.Function1)_function_2);
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append((Object)"/* Mapping Default Error Handling function */");
                _builder.newLine();
                _builder.append((Object)"Retcode_T returnValue = Retcode_initialize(DefaultErrorHandlingFunc);");
                _builder.newLine();
                _builder.append((Object)"if (RETCODE_OK == returnValue)");
                _builder.newLine();
                _builder.append((Object)"{");
                _builder.newLine();
                _builder.append((Object)"    ");
                _builder.append((Object)"returnValue = systemStartup();");
                _builder.newLine();
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.append((Object)"if (RETCODE_OK == returnValue)");
                _builder.newLine();
                _builder.append((Object)"{");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"returnValue = CmdProcessor_Initialize(&Mita_EventQueue, (char *) \"EventQueue\", TASK_PRIO_EVENT_LOOP, TASK_STACK_SIZE_EVENT_LOOP, TASK_Q_LEN_EVENT_LOOP);");
                _builder.newLine();
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.append((Object)"if (RETCODE_OK == returnValue)");
                _builder.newLine();
                _builder.append((Object)"{");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"returnValue = CmdProcessor_Enqueue(&Mita_EventQueue, Mita_initialize, NULL, UINT32_C(0));");
                _builder.newLine();
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.append((Object)"if (RETCODE_OK == returnValue)");
                _builder.newLine();
                _builder.append((Object)"{");
                _builder.newLine();
                _builder.append((Object)"    ");
                _builder.append((Object)"returnValue = CmdProcessor_Enqueue(&Mita_EventQueue, Mita_goLive, NULL, UINT32_C(0));");
                _builder.newLine();
                _builder.append((Object)"}");
                _builder.newLine();
                if (startupEvent != null) {
                    _builder.append((Object)"if (RETCODE_OK == returnValue)");
                    _builder.newLine();
                    _builder.append((Object)"{");
                    _builder.newLine();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"returnValue = CmdProcessor_Enqueue(&Mita_EventQueue, ");
                    String _handlerName = StartupGenerator.this._generatorUtils.getHandlerName((EObject)startupEvent);
                    _builder.append((Object)_handlerName, "\t");
                    _builder.append((Object)", NULL, UINT32_C(0));");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"}");
                    _builder.newLine();
                }
                _builder.append((Object)"if (RETCODE_OK != returnValue)");
                _builder.newLine();
                _builder.append((Object)"{");
                _builder.newLine();
                _builder.append((Object)"    ");
                _builder.append((Object)"printf(\"System Startup failed\");");
                _builder.newLine();
                _builder.append((Object)"    ");
                _builder.append((Object)"assert(false);");
                _builder.newLine();
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.append((Object)"/* start scheduler */");
                _builder.newLine();
                _builder.append((Object)"vTaskStartScheduler();");
                _builder.newLine();
            }
        };
        CodeFragment _create = this.codeFragmentProvider.create(_client);
        StringConcatenationClient _client_1 = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.newLine();
                _builder.append((Object)"CmdProcessor_T Mita_EventQueue;");
                _builder.newLine();
                _builder.newLine();
                _builder.append((Object)"/**");
                _builder.newLine();
                _builder.append((Object)" ");
                _builder.append((Object)"* The priority of the event loop task. The default of 1 is just above the idle task");
                _builder.newLine();
                _builder.append((Object)" ");
                _builder.append((Object)"* priority. Note that the platform may use tasks of higher prio, but XDK LIVE programs");
                _builder.newLine();
                _builder.append((Object)" ");
                _builder.append((Object)"* are solely executed in this event loop context.");
                _builder.newLine();
                _builder.append((Object)" ");
                _builder.append((Object)"*/");
                _builder.newLine();
                _builder.append((Object)"#define TASK_PRIO_EVENT_LOOP         (UINT32_C(1))");
                _builder.newLine();
                _builder.newLine();
                _builder.append((Object)"/**");
                _builder.newLine();
                _builder.append((Object)" ");
                _builder.append((Object)"* The stack size of the event loop task in 32-bit words. If you don't know what this");
                _builder.newLine();
                _builder.append((Object)" ");
                _builder.append((Object)"* means, be careful when you change this value. More information can be found here:");
                _builder.newLine();
                _builder.append((Object)" ");
                _builder.append((Object)"* http://www.freertos.org/FAQMem.html#StackSize");
                _builder.newLine();
                _builder.append((Object)" ");
                _builder.append((Object)"*/");
                _builder.newLine();
                _builder.append((Object)"#define TASK_STACK_SIZE_EVENT_LOOP   (UINT16_C(2000))");
                _builder.newLine();
                _builder.newLine();
                _builder.append((Object)"/**");
                _builder.newLine();
                _builder.append((Object)" ");
                _builder.append((Object)"* The maximum number of events the event queue can hold. The default value should");
                _builder.newLine();
                _builder.append((Object)" ");
                _builder.append((Object)"* be sufficient in most cases. If you need to handle a lot of events and have some");
                _builder.newLine();
                _builder.append((Object)" ");
                _builder.append((Object)"* long running computations, you might want to increase this number if you find");
                _builder.newLine();
                _builder.append((Object)" ");
                _builder.append((Object)"* events are missed.");
                _builder.newLine();
                _builder.append((Object)" ");
                _builder.append((Object)"*/");
                _builder.newLine();
                _builder.append((Object)"#define TASK_Q_LEN_EVENT_LOOP        (UINT32_C(10))");
                _builder.newLine();
                _builder.newLine();
            }
        };
        _xblockexpression = _create.setPreamble(_client_1).addHeader("BCDS_Basics.h", true, 1000).addHeader("FreeRTOS.h", true, 750).addHeader("timers.h", true).addHeader("XdkSystemStartup.h", true).addHeader("BCDS_CmdProcessor.h", true).addHeader("stdio.h", true);
        return _xblockexpression;
    }
}

