/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mita.platform.xdk110.connectivity;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.mita.base.expressions.Expression;
import org.eclipse.mita.platform.xdk110.connectivity.ServalPALGenerator;
import org.eclipse.mita.program.SignalInstance;
import org.eclipse.mita.program.generator.AbstractSystemResourceGenerator;
import org.eclipse.mita.program.generator.CodeFragment;
import org.eclipse.mita.program.generator.GeneratorUtils;
import org.eclipse.mita.program.generator.IPlatformLoggingGenerator;
import org.eclipse.mita.program.generator.StatementGenerator;
import org.eclipse.mita.program.inferrer.StaticValueInferrer;
import org.eclipse.mita.program.model.ModelUtils;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtend2.lib.StringConcatenationClient;
import org.eclipse.xtext.generator.IFileSystemAccess2;
import org.eclipse.xtext.generator.trace.node.IGeneratorNode;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;

public class MqttGenerator
extends AbstractSystemResourceGenerator {
    @Inject(optional=true)
    protected IPlatformLoggingGenerator loggingGenerator;
    @Inject
    protected ServalPALGenerator servalpalGenerator;
    @Inject
    @Extension
    protected StatementGenerator statementGenerator;
    @Inject
    protected GeneratorUtils generatorUtils;

    public Iterable<String> generateAdditionalFiles(final IFileSystemAccess2 fsa) {
        try {
            String _string = this.configuration.getString("url");
            URI brokerUri = new URI(_string);
            String _scheme = brokerUri.getScheme();
            boolean isSecure = Objects.equal((Object)_scheme, (Object)"mqtts");
            if (isSecure) {
                String certificateFileLoc = this.configuration.getString("certificatePath");
                final Stream certificate = this.generatorUtils.getFileContents(this.setup.eResource(), certificateFileLoc);
                if (certificate == null) {
                    return Collections.unmodifiableList(CollectionLiterals.newArrayList());
                }
                Procedures.Procedure1<String> _function = new Procedures.Procedure1<String>(){

                    public void apply(String it) {
                        StringConcatenation _builder = new StringConcatenation();
                        _builder.append("#define SERVER_CA \\");
                        _builder.newLine();
                        List _collect = certificate.collect(Collectors.toList());
                        boolean _hasElements = false;
                        for (String line : _collect) {
                            if (!_hasElements) {
                                _hasElements = true;
                            } else {
                                _builder.appendImmediate((Object)" \\", "\t");
                            }
                            _builder.append("\t");
                            _builder.append("\"");
                            _builder.append(line, "\t");
                            _builder.append("\\n\"");
                            _builder.newLineIfNotEmpty();
                        }
                        fsa.generateFile(it, (CharSequence)_builder);
                    }
                };
                String _doubleArrow = (String)ObjectExtensions.operator_doubleArrow((Object)"ServerCA.h", (Procedures.Procedure1)_function);
                return Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new String[]{_doubleArrow}));
            }
            return Collections.unmodifiableList(CollectionLiterals.newArrayList());
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public CodeFragment generateSetup() {
        try {
            String _string = this.configuration.getString("url");
            final URI brokerUri = new URI(_string);
            int brokerPortRaw = brokerUri.getPort();
            String _scheme = brokerUri.getScheme();
            final boolean isSecure = Objects.equal((Object)_scheme, (Object)"mqtts");
            int _xifexpression = 0;
            if (brokerPortRaw < 0) {
                int _xifexpression_1 = 0;
                _xifexpression_1 = isSecure ? 8883 : 1883;
                _xifexpression = _xifexpression_1;
            } else {
                _xifexpression = brokerPortRaw;
            }
            final int brokerPort = _xifexpression;
            String _string_1 = this.configuration.getString("sntpServer");
            final URI sntpUri = new URI(_string_1);
            int _xifexpression_2 = 0;
            int _port = sntpUri.getPort();
            boolean _lessThan = _port < 0;
            _xifexpression_2 = _lessThan ? 123 : sntpUri.getPort();
            final int sntpPort = _xifexpression_2;
            Procedures.Procedure1<EObject> _function = new Procedures.Procedure1<EObject>(){

                public void apply(EObject it) {
                }
            };
            final Object auth = StaticValueInferrer.infer((EObject)this.configuration.getExpression("authentication"), (Procedures.Procedure1)_function);
            StringConcatenationClient _client = new StringConcatenationClient(){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    boolean _isLogin;
                    _builder.append((Object)"Retcode_T exception = RETCODE_OK;");
                    _builder.newLine();
                    if (auth instanceof StaticValueInferrer.SumTypeRepr && (_isLogin = MqttGenerator.this.isLogin((StaticValueInferrer.SumTypeRepr)auth))) {
                        _builder.append((Object)"StringDescr_wrap(&username, usernameBuf);");
                        _builder.newLine();
                        _builder.append((Object)"StringDescr_wrap(&password, passwordBuf);");
                        _builder.newLine();
                    }
                    _builder.newLine();
                    CodeFragment _generateSetup = MqttGenerator.this.servalpalGenerator.generateSetup(isSecure);
                    _builder.append((Object)_generateSetup);
                    _builder.newLineIfNotEmpty();
                    _builder.newLine();
                    if (isSecure) {
                        _builder.append((Object)"exception = SNTP_Setup(&sntpSetup);");
                        _builder.newLine();
                        _builder.newLine();
                        CharSequence _generateExceptionHandler = MqttGenerator.this.generatorUtils.generateExceptionHandler((EObject)MqttGenerator.this.setup, "exception");
                        _builder.append((Object)_generateExceptionHandler);
                        _builder.newLineIfNotEmpty();
                        _builder.newLine();
                        _builder.append((Object)"exception = HTTPRestClientSecurity_Setup();");
                        _builder.newLine();
                        _builder.newLine();
                        CharSequence _generateExceptionHandler_1 = MqttGenerator.this.generatorUtils.generateExceptionHandler((EObject)MqttGenerator.this.setup, "exception");
                        _builder.append((Object)_generateExceptionHandler_1);
                        _builder.newLineIfNotEmpty();
                    }
                    _builder.newLine();
                    _builder.append((Object)"mqttSubscribeHandle = xSemaphoreCreateBinary();");
                    _builder.newLine();
                    _builder.append((Object)"if (NULL == mqttSubscribeHandle)");
                    _builder.newLine();
                    _builder.append((Object)"{");
                    _builder.newLine();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"exception = RETCODE(RETCODE_SEVERITY_ERROR, RETCODE_OUT_OF_RESOURCES);");
                    _builder.newLine();
                    _builder.append((Object)"}");
                    _builder.newLine();
                    _builder.newLine();
                    CharSequence _generateExceptionHandler_2 = MqttGenerator.this.generatorUtils.generateExceptionHandler((EObject)MqttGenerator.this.setup, "exception");
                    _builder.append((Object)_generateExceptionHandler_2);
                    _builder.newLineIfNotEmpty();
                    _builder.newLine();
                    _builder.append((Object)"mqttPublishHandle = xSemaphoreCreateBinary();");
                    _builder.newLine();
                    _builder.append((Object)"if (NULL == mqttPublishHandle)");
                    _builder.newLine();
                    _builder.append((Object)"{");
                    _builder.newLine();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"vSemaphoreDelete(mqttSubscribeHandle);");
                    _builder.newLine();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"exception = RETCODE(RETCODE_SEVERITY_ERROR, RETCODE_OUT_OF_RESOURCES);");
                    _builder.newLine();
                    _builder.append((Object)"}");
                    _builder.newLine();
                    _builder.newLine();
                    CharSequence _generateExceptionHandler_3 = MqttGenerator.this.generatorUtils.generateExceptionHandler((EObject)MqttGenerator.this.setup, "exception");
                    _builder.append((Object)_generateExceptionHandler_3);
                    _builder.newLineIfNotEmpty();
                    _builder.newLine();
                    _builder.append((Object)"mqttSendHandle = xSemaphoreCreateBinary();");
                    _builder.newLine();
                    _builder.append((Object)"if (NULL == mqttSendHandle)");
                    _builder.newLine();
                    _builder.append((Object)"{");
                    _builder.newLine();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"vSemaphoreDelete(mqttSubscribeHandle);");
                    _builder.newLine();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"vSemaphoreDelete(mqttPublishHandle);");
                    _builder.newLine();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"exception = RETCODE(RETCODE_SEVERITY_ERROR, RETCODE_OUT_OF_RESOURCES);");
                    _builder.newLine();
                    _builder.append((Object)"}");
                    _builder.newLine();
                    _builder.newLine();
                    CharSequence _generateExceptionHandler_4 = MqttGenerator.this.generatorUtils.generateExceptionHandler((EObject)MqttGenerator.this.setup, "exception");
                    _builder.append((Object)_generateExceptionHandler_4);
                    _builder.newLineIfNotEmpty();
                    _builder.newLine();
                    _builder.append((Object)"mqttConnectHandle = xSemaphoreCreateBinary();");
                    _builder.newLine();
                    _builder.append((Object)"if (NULL == mqttConnectHandle)");
                    _builder.newLine();
                    _builder.append((Object)"{");
                    _builder.newLine();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"vSemaphoreDelete(mqttSubscribeHandle);");
                    _builder.newLine();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"vSemaphoreDelete(mqttPublishHandle);");
                    _builder.newLine();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"vSemaphoreDelete(mqttSendHandle);");
                    _builder.newLine();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"exception = RETCODE(RETCODE_SEVERITY_ERROR, RETCODE_OUT_OF_RESOURCES);");
                    _builder.newLine();
                    _builder.append((Object)"}");
                    _builder.newLine();
                    _builder.newLine();
                    _builder.append((Object)"return exception;");
                    _builder.newLine();
                }
            };
            CodeFragment _create = this.codeFragmentProvider.create(_client);
            StringConcatenationClient _client_1 = new StringConcatenationClient(){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    _builder.append((Object)"/**");
                    _builder.newLine();
                    _builder.append((Object)" ");
                    _builder.append((Object)"* The client identifier (here: clientID) is a identifier of each MQTT client");
                    _builder.newLine();
                    _builder.append((Object)" ");
                    _builder.append((Object)"* connecting to a MQTT broker. It needs to be unique for the broker to");
                    _builder.newLine();
                    _builder.append((Object)" ");
                    _builder.append((Object)"* know the state of the client.");
                    _builder.newLine();
                    _builder.append((Object)" ");
                    _builder.append((Object)"*");
                    _builder.newLine();
                    _builder.append((Object)" ");
                    _builder.append((Object)"* We define this client ID globally to ensure it's available in memory even");
                    _builder.newLine();
                    _builder.append((Object)" ");
                    _builder.append((Object)"* after it was passed to the Serval stack in the setup method.");
                    _builder.newLine();
                    _builder.append((Object)" ");
                    _builder.append((Object)"*/");
                    _builder.newLine();
                    _builder.append((Object)"static const char* MQTT_CLIENT_ID = \"");
                    String _string = MqttGenerator.this.configuration.getString("clientId");
                    _builder.append((Object)_string);
                    _builder.append((Object)"\";");
                    _builder.newLineIfNotEmpty();
                    _builder.newLine();
                    _builder.append((Object)"static const char* MQTT_BROKER_HOST = \"");
                    String _host = brokerUri.getHost();
                    _builder.append((Object)_host);
                    _builder.append((Object)"\";");
                    _builder.newLineIfNotEmpty();
                    _builder.newLine();
                    _builder.append((Object)"static const uint16_t MQTT_BROKER_PORT = ");
                    _builder.append((Object)brokerPort);
                    _builder.append((Object)";");
                    _builder.newLineIfNotEmpty();
                    _builder.newLine();
                    _builder.append((Object)"/**<  Macro for the non secure serval stack expected MQTT URL format */");
                    _builder.newLine();
                    _builder.append((Object)"#define MQTT_URL_FORMAT          \"");
                    String _scheme = brokerUri.getScheme();
                    _builder.append((Object)_scheme);
                    _builder.append((Object)"://%s:%d\"");
                    _builder.newLineIfNotEmpty();
                    _builder.newLine();
                    _builder.append((Object)"/**< Handle for MQTT subscribe operation  */");
                    _builder.newLine();
                    _builder.append((Object)"static SemaphoreHandle_t mqttSubscribeHandle;");
                    _builder.newLine();
                    _builder.append((Object)"/**< Handle for MQTT publish operation  */");
                    _builder.newLine();
                    _builder.append((Object)"static SemaphoreHandle_t mqttPublishHandle;");
                    _builder.newLine();
                    _builder.append((Object)"/**< Handle for MQTT send operation  */");
                    _builder.newLine();
                    _builder.append((Object)"static SemaphoreHandle_t mqttSendHandle;");
                    _builder.newLine();
                    _builder.append((Object)"/**< Handle for MQTT send operation  */");
                    _builder.newLine();
                    _builder.append((Object)"static SemaphoreHandle_t mqttConnectHandle;");
                    _builder.newLine();
                    _builder.append((Object)"/**< MQTT session instance */");
                    _builder.newLine();
                    _builder.append((Object)"static MqttSession_T mqttSession;");
                    _builder.newLine();
                    _builder.append((Object)"/**< MQTT connection status */");
                    _builder.newLine();
                    _builder.append((Object)"static bool mqttIsConnected = false;");
                    _builder.newLine();
                    _builder.append((Object)"/**< MQTT subscription status */");
                    _builder.newLine();
                    _builder.append((Object)"static bool mqttIsSubscribed = false;");
                    _builder.newLine();
                    _builder.append((Object)"/**< MQTT publish status */");
                    _builder.newLine();
                    _builder.append((Object)"static bool mqttWasPublished = false;");
                    _builder.newLine();
                    _builder.newLine();
                    if (isSecure) {
                        _builder.append((Object)"SNTP_Setup_T sntpSetup = {");
                        _builder.newLine();
                        _builder.append((Object)"\t");
                        _builder.append((Object)".ServerUrl = \"");
                        String _host_1 = sntpUri.getHost();
                        _builder.append((Object)_host_1, "\t");
                        _builder.append((Object)"\",");
                        _builder.newLineIfNotEmpty();
                        _builder.append((Object)"\t");
                        _builder.append((Object)".ServerPort = ");
                        _builder.append((Object)sntpPort, "\t");
                        _builder.newLineIfNotEmpty();
                        _builder.append((Object)"};");
                        _builder.newLine();
                    }
                }
            };
            CodeFragment result = _create.setPreamble(_client_1).addHeader("Serval_Mqtt.h", true, 500).addHeader("stdint.h", true, 750).addHeader("XdkCommonInfo.h", true).addHeader("BCDS_WlanNetworkConfig.h", true);
            if (isSecure) {
                result.addHeader("HTTPRestClientSecurity.h", true);
            }
            return result;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public CodeFragment generateEnable() {
        try {
            Procedures.Procedure1<EObject> _function = new Procedures.Procedure1<EObject>(){

                public void apply(EObject it) {
                }
            };
            final Object auth = StaticValueInferrer.infer((EObject)this.configuration.getExpression("authentication"), (Procedures.Procedure1)_function);
            Procedures.Procedure1<EObject> _function_1 = new Procedures.Procedure1<EObject>(){

                public void apply(EObject it) {
                }
            };
            final Object lastWill = StaticValueInferrer.infer((EObject)this.configuration.getExpression("lastWill"), (Procedures.Procedure1)_function_1);
            String _string = this.configuration.getString("url");
            URI brokerUri = new URI(_string);
            String _scheme = brokerUri.getScheme();
            final boolean isSecure = Objects.equal((Object)_scheme, (Object)"mqtts");
            StringConcatenationClient _client = new StringConcatenationClient(){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    boolean _isLogin;
                    _builder.append((Object)"Retcode_T exception = RETCODE_OK;");
                    _builder.newLine();
                    _builder.newLine();
                    _builder.append((Object)"Ip_Address_T brokerIpAddress = 0UL;");
                    _builder.newLine();
                    _builder.append((Object)"StringDescr_T clientID;");
                    _builder.newLine();
                    _builder.append((Object)"char mqttBrokerURL[30] = { 0 };");
                    _builder.newLine();
                    _builder.append((Object)"char serverIpStringBuffer[16] = { 0 };");
                    _builder.newLine();
                    _builder.newLine();
                    CodeFragment _generateEnable = MqttGenerator.this.servalpalGenerator.generateEnable();
                    _builder.append((Object)_generateEnable);
                    _builder.newLineIfNotEmpty();
                    _builder.newLine();
                    if (isSecure) {
                        _builder.append((Object)"exception = SNTP_Enable();");
                        _builder.newLine();
                        _builder.newLine();
                        _builder.append((Object)"if(RC_OK != MbedTLSAdapter_Initialize())");
                        _builder.newLine();
                        _builder.append((Object)"{");
                        _builder.newLine();
                        _builder.append((Object)"\t");
                        CodeFragment _generateLogStatement = MqttGenerator.this.loggingGenerator.generateLogStatement(IPlatformLoggingGenerator.LogLevel.Error, "MQTT_Enable : unable to initialize Mbedtls.", new CodeFragment[0]);
                        _builder.append((Object)_generateLogStatement, "\t");
                        _builder.newLineIfNotEmpty();
                        _builder.append((Object)"\t");
                        _builder.append((Object)"exception = RETCODE(RETCODE_SEVERITY_ERROR, RETCODE_HTTP_INIT_REQUEST_FAILED);");
                        _builder.newLine();
                        _builder.append((Object)"}");
                        _builder.newLine();
                        _builder.newLine();
                        CharSequence _generateExceptionHandler = MqttGenerator.this.generatorUtils.generateExceptionHandler((EObject)MqttGenerator.this.setup, "exception");
                        _builder.append((Object)_generateExceptionHandler);
                        _builder.newLineIfNotEmpty();
                        _builder.newLine();
                        _builder.append((Object)"uint64_t sntpTimeStampFromServer = 0UL;");
                        _builder.newLine();
                        _builder.newLine();
                        _builder.append((Object)"/* We Synchronize the node with the SNTP server for time-stamp.");
                        _builder.newLine();
                        _builder.append((Object)" ");
                        _builder.append((Object)"* Since there is no point in doing a HTTPS communication without a valid time */");
                        _builder.newLine();
                        _builder.append((Object)"do");
                        _builder.newLine();
                        _builder.append((Object)"{");
                        _builder.newLine();
                        _builder.append((Object)"\t");
                        _builder.append((Object)"exception = SNTP_GetTimeFromServer(&sntpTimeStampFromServer, 1000);");
                        _builder.newLine();
                        _builder.append((Object)"\t");
                        _builder.append((Object)"if ((RETCODE_OK != exception) || (0UL == sntpTimeStampFromServer))");
                        _builder.newLine();
                        _builder.append((Object)"\t");
                        _builder.append((Object)"{");
                        _builder.newLine();
                        _builder.append((Object)"\t\t");
                        CodeFragment _generateLogStatement_1 = MqttGenerator.this.loggingGenerator.generateLogStatement(IPlatformLoggingGenerator.LogLevel.Warning, "MQTT_Enable : SNTP server time was not synchronized. Retrying...", new CodeFragment[0]);
                        _builder.append((Object)_generateLogStatement_1, "\t\t");
                        _builder.newLineIfNotEmpty();
                        _builder.append((Object)"\t\t");
                        _builder.append((Object)"BSP_Board_Delay(1000);");
                        _builder.newLine();
                        _builder.append((Object)"\t");
                        _builder.append((Object)"}");
                        _builder.newLine();
                        _builder.append((Object)"} while (0UL == sntpTimeStampFromServer);");
                        _builder.newLine();
                        _builder.newLine();
                        _builder.append((Object)"struct tm time;");
                        _builder.newLine();
                        _builder.append((Object)"char timezoneISO8601format[40];");
                        _builder.newLine();
                        _builder.append((Object)"TimeStamp_SecsToTm(sntpTimeStampFromServer, &time);");
                        _builder.newLine();
                        _builder.append((Object)"TimeStamp_TmToIso8601(&time, timezoneISO8601format, 40);");
                        _builder.newLine();
                        _builder.newLine();
                        StringConcatenationClient _client = new StringConcatenationClient(){

                            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                                _builder.append((Object)"timezoneISO8601format");
                            }
                        };
                        CodeFragment _generateLogStatement_2 = MqttGenerator.this.loggingGenerator.generateLogStatement(IPlatformLoggingGenerator.LogLevel.Info, "MQTT_Enable : Getting time successful. Current time is %s", new CodeFragment[]{MqttGenerator.this.codeFragmentProvider.create(_client)});
                        _builder.append((Object)_generateLogStatement_2);
                        _builder.newLineIfNotEmpty();
                        _builder.newLine();
                        _builder.append((Object)"BCDS_UNUSED(sntpTimeStampFromServer); /* Copy of sntpTimeStampFromServer will be used be HTTPS for TLS handshake */");
                        _builder.newLine();
                        _builder.newLine();
                        CharSequence _generateExceptionHandler_1 = MqttGenerator.this.generatorUtils.generateExceptionHandler((EObject)MqttGenerator.this.setup, "exception");
                        _builder.append((Object)_generateExceptionHandler_1);
                        _builder.newLineIfNotEmpty();
                    }
                    _builder.newLine();
                    _builder.append((Object)"retcode_t mqttRetcode = RC_OK;");
                    _builder.newLine();
                    _builder.append((Object)"mqttRetcode = Mqtt_initialize();");
                    _builder.newLine();
                    _builder.append((Object)"if (RC_OK != mqttRetcode)");
                    _builder.newLine();
                    _builder.append((Object)"{");
                    _builder.newLine();
                    _builder.append((Object)"\t");
                    StringConcatenationClient _client_1 = new StringConcatenationClient(){

                        protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                            _builder.append((Object)"mqttRetcode");
                        }
                    };
                    CodeFragment _generateLogStatement_3 = MqttGenerator.this.loggingGenerator.generateLogStatement(IPlatformLoggingGenerator.LogLevel.Error, "MQTT_Enable : MQTT init failed: %x", new CodeFragment[]{MqttGenerator.this.codeFragmentProvider.create(_client_1)});
                    _builder.append((Object)_generateLogStatement_3, "\t");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"exception = RETCODE(RETCODE_SEVERITY_ERROR, RETCODE_MQTT_INIT_FAILED);");
                    _builder.newLine();
                    _builder.append((Object)"}");
                    _builder.newLine();
                    _builder.newLine();
                    CharSequence _generateExceptionHandler_2 = MqttGenerator.this.generatorUtils.generateExceptionHandler((EObject)MqttGenerator.this.setup, "exception");
                    _builder.append((Object)_generateExceptionHandler_2);
                    _builder.newLineIfNotEmpty();
                    _builder.newLine();
                    _builder.append((Object)"mqttRetcode = Mqtt_initializeInternalSession(&mqttSession);");
                    _builder.newLine();
                    _builder.append((Object)"if (RC_OK != mqttRetcode)");
                    _builder.newLine();
                    _builder.append((Object)"{");
                    _builder.newLine();
                    _builder.append((Object)"\t");
                    StringConcatenationClient _client_2 = new StringConcatenationClient(){

                        protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                            _builder.append((Object)"mqttRetcode");
                        }
                    };
                    CodeFragment _generateLogStatement_4 = MqttGenerator.this.loggingGenerator.generateLogStatement(IPlatformLoggingGenerator.LogLevel.Error, "MQTT_Enable : MQTT init session failed: %x", new CodeFragment[]{MqttGenerator.this.codeFragmentProvider.create(_client_2)});
                    _builder.append((Object)_generateLogStatement_4, "\t");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"exception = RETCODE(RETCODE_SEVERITY_ERROR, RETCODE_MQTT_INIT_INTERNAL_SESSION_FAILED);");
                    _builder.newLine();
                    _builder.append((Object)"}");
                    _builder.newLine();
                    _builder.newLine();
                    CharSequence _generateExceptionHandler_3 = MqttGenerator.this.generatorUtils.generateExceptionHandler((EObject)MqttGenerator.this.setup, "exception");
                    _builder.append((Object)_generateExceptionHandler_3);
                    _builder.newLineIfNotEmpty();
                    _builder.newLine();
                    _builder.append((Object)"exception = WlanNetworkConfig_GetIpAddress((uint8_t *) MQTT_BROKER_HOST, &brokerIpAddress);");
                    _builder.newLine();
                    _builder.append((Object)"if(RETCODE_OK != exception) {");
                    _builder.newLine();
                    _builder.append((Object)"\t");
                    StringConcatenationClient _client_3 = new StringConcatenationClient(){

                        protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                            _builder.append((Object)"MQTT_BROKER_HOST");
                        }
                    };
                    CodeFragment _generateLogStatement_5 = MqttGenerator.this.loggingGenerator.generateLogStatement(IPlatformLoggingGenerator.LogLevel.Error, "MQTT_Enable : Failed to resolve host: %s", new CodeFragment[]{MqttGenerator.this.codeFragmentProvider.create(_client_3)});
                    _builder.append((Object)_generateLogStatement_5, "\t");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"return exception;");
                    _builder.newLine();
                    _builder.append((Object)"}");
                    _builder.newLine();
                    _builder.newLine();
                    CharSequence _generateExceptionHandler_4 = MqttGenerator.this.generatorUtils.generateExceptionHandler((EObject)MqttGenerator.this.setup, "exception");
                    _builder.append((Object)_generateExceptionHandler_4);
                    _builder.newLineIfNotEmpty();
                    _builder.newLine();
                    _builder.append((Object)"if (0 > Ip_convertAddrToString(&brokerIpAddress, serverIpStringBuffer))");
                    _builder.newLine();
                    _builder.append((Object)"{");
                    _builder.newLine();
                    _builder.append((Object)"\t");
                    CodeFragment _generateLogStatement_6 = MqttGenerator.this.loggingGenerator.generateLogStatement(IPlatformLoggingGenerator.LogLevel.Error, "MQTT_Enable : Failed to convert IP", new CodeFragment[0]);
                    _builder.append((Object)_generateLogStatement_6, "\t");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"exception = RETCODE(RETCODE_SEVERITY_ERROR, RETCODE_MQTT_IPCONIG_FAIL);");
                    _builder.newLine();
                    _builder.append((Object)"}");
                    _builder.newLine();
                    _builder.newLine();
                    CharSequence _generateExceptionHandler_5 = MqttGenerator.this.generatorUtils.generateExceptionHandler((EObject)MqttGenerator.this.setup, "exception");
                    _builder.append((Object)_generateExceptionHandler_5);
                    _builder.newLineIfNotEmpty();
                    _builder.newLine();
                    _builder.append((Object)"mqttSession.MQTTVersion = 4;");
                    _builder.newLine();
                    _builder.append((Object)"mqttSession.keepAliveInterval = 60;");
                    _builder.newLine();
                    _builder.append((Object)"mqttSession.cleanSession = false;");
                    _builder.newLine();
                    if (lastWill instanceof StaticValueInferrer.SumTypeRepr) {
                        boolean _hasLastWill = MqttGenerator.this.hasLastWill((StaticValueInferrer.SumTypeRepr)lastWill);
                        if (_hasLastWill) {
                            _builder.append((Object)"StringDescr_wrap(&lastWillTopic, lastWillTopicBuf);");
                            _builder.newLine();
                            _builder.append((Object)"StringDescr_wrap(&lastWillMessage, lastWillMessageBuf);");
                            _builder.newLine();
                            _builder.append((Object)"mqttSession.will.haveWill = true;");
                            _builder.newLine();
                            _builder.append((Object)"mqttSession.will.topic = lastWillTopic;");
                            _builder.newLine();
                            _builder.append((Object)"mqttSession.will.message = lastWillMessage;");
                            _builder.newLine();
                            _builder.append((Object)"mqttSession.will.retained = true;");
                            _builder.newLine();
                            _builder.append((Object)"mqttSession.will.qos = ");
                            Procedures.Procedure1<EObject> _function = new Procedures.Procedure1<EObject>(){

                                public void apply(EObject it) {
                                }
                            };
                            Object _infer = StaticValueInferrer.infer((EObject)((EObject)((StaticValueInferrer.SumTypeRepr)lastWill).properties.get("qos")), (Procedures.Procedure1)_function);
                            String _qosFromInt = MqttGenerator.this.getQosFromInt((Integer)_infer);
                            _builder.append((Object)_qosFromInt);
                            _builder.append((Object)";");
                            _builder.newLineIfNotEmpty();
                        } else {
                            _builder.append((Object)"mqttSession.will.haveWill = false;");
                            _builder.newLine();
                        }
                    } else {
                        _builder.append((Object)"mqttSession.will.haveWill = false;");
                        _builder.newLine();
                    }
                    _builder.append((Object)"mqttSession.onMqttEvent = MqttEventHandler;");
                    _builder.newLine();
                    if (auth instanceof StaticValueInferrer.SumTypeRepr && (_isLogin = MqttGenerator.this.isLogin((StaticValueInferrer.SumTypeRepr)auth))) {
                        _builder.append((Object)"mqttSession.username = username;");
                        _builder.newLine();
                        _builder.append((Object)"mqttSession.password = password;");
                        _builder.newLine();
                    }
                    _builder.newLine();
                    _builder.append((Object)"StringDescr_wrap(&clientID, MQTT_CLIENT_ID);");
                    _builder.newLine();
                    _builder.append((Object)"mqttSession.clientID = clientID;");
                    _builder.newLine();
                    _builder.newLine();
                    _builder.append((Object)"size_t neccessaryBytes = snprintf(mqttBrokerURL, sizeof(mqttBrokerURL), MQTT_URL_FORMAT, serverIpStringBuffer, MQTT_BROKER_PORT);");
                    _builder.newLine();
                    _builder.append((Object)"if(neccessaryBytes > sizeof(mqttBrokerURL)) {");
                    _builder.newLine();
                    _builder.append((Object)"\t");
                    CodeFragment _generateLogStatement_7 = MqttGenerator.this.loggingGenerator.generateLogStatement(IPlatformLoggingGenerator.LogLevel.Error, "MQTT_Enable : Failed to convert IP", new CodeFragment[0]);
                    _builder.append((Object)_generateLogStatement_7, "\t");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"exception = RETCODE(RETCODE_SEVERITY_ERROR, RETCODE_OUT_OF_RESOURCES);");
                    _builder.newLine();
                    _builder.append((Object)"}");
                    _builder.newLine();
                    _builder.newLine();
                    CharSequence _generateExceptionHandler_6 = MqttGenerator.this.generatorUtils.generateExceptionHandler((EObject)MqttGenerator.this.setup, "exception");
                    _builder.append((Object)_generateExceptionHandler_6);
                    _builder.newLineIfNotEmpty();
                    _builder.newLine();
                    _builder.append((Object)"mqttSession.target.scheme = SERVAL_SCHEME_MQTT;");
                    _builder.newLine();
                    _builder.append((Object)"if (RC_OK == SupportedUrl_fromString((const char *) mqttBrokerURL, (uint16_t) strlen((const char *) mqttBrokerURL), &mqttSession.target))");
                    _builder.newLine();
                    _builder.append((Object)"{");
                    _builder.newLine();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"exception = connectToBackend();");
                    _builder.newLine();
                    _builder.append((Object)"}");
                    _builder.newLine();
                    _builder.append((Object)"else");
                    _builder.newLine();
                    _builder.append((Object)"{");
                    _builder.newLine();
                    _builder.append((Object)"\t");
                    StringConcatenationClient _client_4 = new StringConcatenationClient(){

                        protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                            _builder.append((Object)"mqttBrokerURL");
                        }
                    };
                    CodeFragment _generateLogStatement_8 = MqttGenerator.this.loggingGenerator.generateLogStatement(IPlatformLoggingGenerator.LogLevel.Error, "MQTT_Enable : Failed to parse IP/port: %s", new CodeFragment[]{MqttGenerator.this.codeFragmentProvider.create(_client_4)});
                    _builder.append((Object)_generateLogStatement_8, "\t");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"exception = RETCODE(RETCODE_SEVERITY_ERROR, RETCODE_MQTT_PARSING_ERROR);");
                    _builder.newLine();
                    _builder.append((Object)"}");
                    _builder.newLine();
                    _builder.newLine();
                    _builder.append((Object)"return exception;");
                    _builder.newLine();
                }
            };
            CodeFragment result = this.codeFragmentProvider.create(_client).addHeader("BCDS_BSP_Board.h", true).addHeader("XDK_SNTP.h", true).addHeader("MbedTLSAdapter.h", true).addHeader("HTTPRestClientSecurity.h", true).addHeader("time.h", true).addHeader("XDK_TimeStamp.h", true);
            StringConcatenationClient _client_1 = new StringConcatenationClient(){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    boolean _hasLastWill;
                    boolean _isLogin;
                    if (auth instanceof StaticValueInferrer.SumTypeRepr && (_isLogin = MqttGenerator.this.isLogin((StaticValueInferrer.SumTypeRepr)auth))) {
                        Expression username = (Expression)((StaticValueInferrer.SumTypeRepr)auth).properties.get("username");
                        _builder.newLineIfNotEmpty();
                        Expression password = (Expression)((StaticValueInferrer.SumTypeRepr)auth).properties.get("password");
                        _builder.newLineIfNotEmpty();
                        _builder.append((Object)"StringDescr_T username;");
                        _builder.newLine();
                        _builder.append((Object)"const char* usernameBuf = ");
                        IGeneratorNode _code = null;
                        if (username != null) {
                            _code = MqttGenerator.this.statementGenerator.code((EObject)username);
                        }
                        _builder.append(_code);
                        _builder.append((Object)";");
                        _builder.newLineIfNotEmpty();
                        _builder.newLine();
                        _builder.append((Object)"StringDescr_T password;");
                        _builder.newLine();
                        _builder.append((Object)"const char* passwordBuf = ");
                        IGeneratorNode _code_1 = null;
                        if (password != null) {
                            _code_1 = MqttGenerator.this.statementGenerator.code((EObject)password);
                        }
                        _builder.append(_code_1);
                        _builder.append((Object)";");
                        _builder.newLineIfNotEmpty();
                    }
                    _builder.newLine();
                    if (lastWill instanceof StaticValueInferrer.SumTypeRepr && (_hasLastWill = MqttGenerator.this.hasLastWill((StaticValueInferrer.SumTypeRepr)lastWill))) {
                        _builder.append((Object)"StringDescr_T lastWillTopic;");
                        _builder.newLine();
                        _builder.append((Object)"const char* lastWillTopicBuf = ");
                        Expression _get = (Expression)((StaticValueInferrer.SumTypeRepr)lastWill).properties.get("topic");
                        IGeneratorNode _code_2 = null;
                        if (_get != null) {
                            _code_2 = MqttGenerator.this.statementGenerator.code((EObject)_get);
                        }
                        _builder.append(_code_2);
                        _builder.append((Object)";");
                        _builder.newLineIfNotEmpty();
                        _builder.append((Object)"StringDescr_T lastWillMessage;");
                        _builder.newLine();
                        _builder.append((Object)"const char* lastWillMessageBuf = ");
                        Expression _get_1 = (Expression)((StaticValueInferrer.SumTypeRepr)lastWill).properties.get("message");
                        IGeneratorNode _code_3 = null;
                        if (_get_1 != null) {
                            _code_3 = MqttGenerator.this.statementGenerator.code((EObject)_get_1);
                        }
                        _builder.append(_code_3);
                        _builder.append((Object)";");
                        _builder.newLineIfNotEmpty();
                    }
                }
            };
            result.setPreamble(_client_1).addHeader("Serval_StringDescr.h", true);
            return result;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    protected boolean isLogin(StaticValueInferrer.SumTypeRepr repr) {
        return Objects.equal((Object)repr.name, (Object)"Login");
    }

    protected boolean hasLastWill(StaticValueInferrer.SumTypeRepr repr) {
        return Objects.equal((Object)repr.name, (Object)"LastWill");
    }

    public CodeFragment generateAdditionalImplementation() {
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append((Object)"/**");
                _builder.newLine();
                _builder.append((Object)" ");
                _builder.append((Object)"* @brief Callback function used by the stack to communicate events to the application.");
                _builder.newLine();
                _builder.append((Object)" ");
                _builder.append((Object)"* Each event will bring with it specialized data that will contain more information.");
                _builder.newLine();
                _builder.append((Object)" ");
                _builder.append((Object)"*");
                _builder.newLine();
                _builder.append((Object)" ");
                _builder.append((Object)"* @param[in] session");
                _builder.newLine();
                _builder.append((Object)" ");
                _builder.append((Object)"* MQTT session");
                _builder.newLine();
                _builder.append((Object)" ");
                _builder.append((Object)"*");
                _builder.newLine();
                _builder.append((Object)" ");
                _builder.append((Object)"* @param[in] event");
                _builder.newLine();
                _builder.append((Object)" ");
                _builder.append((Object)"* MQTT event");
                _builder.newLine();
                _builder.append((Object)" ");
                _builder.append((Object)"*");
                _builder.newLine();
                _builder.append((Object)" ");
                _builder.append((Object)"* @param[in] eventData");
                _builder.newLine();
                _builder.append((Object)" ");
                _builder.append((Object)"* MQTT data based on the event");
                _builder.newLine();
                _builder.append((Object)" ");
                _builder.append((Object)"*");
                _builder.newLine();
                _builder.append((Object)" ");
                _builder.append((Object)"*/");
                _builder.newLine();
                _builder.append((Object)"static retcode_t MqttEventHandler(MqttSession_T* session, MqttEvent_t event, const MqttEventData_t* eventData)");
                _builder.newLine();
                _builder.append((Object)"{");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"BCDS_UNUSED(session);");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"BCDS_UNUSED(eventData);");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"Retcode_T exception = RETCODE_OK;");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"switch (event)");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"{");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"case MQTT_CONNECTION_ESTABLISHED:");
                _builder.newLine();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"mqttIsConnected = true;");
                _builder.newLine();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"if (pdTRUE != xSemaphoreGive(mqttConnectHandle))");
                _builder.newLine();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"{");
                _builder.newLine();
                _builder.append((Object)"\t\t\t");
                _builder.append((Object)"exception = RETCODE(RETCODE_SEVERITY_ERROR, RETCODE_SEMAPHORE_ERROR);");
                _builder.newLine();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"break;");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"case MQTT_CONNECTION_ERROR:");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"case MQTT_CONNECT_SEND_FAILED:");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"case MQTT_CONNECT_TIMEOUT:");
                _builder.newLine();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"mqttIsConnected = false;");
                _builder.newLine();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"if (pdTRUE != xSemaphoreGive(mqttConnectHandle))");
                _builder.newLine();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"{");
                _builder.newLine();
                _builder.append((Object)"\t\t\t");
                _builder.append((Object)"exception = RETCODE(RETCODE_SEVERITY_ERROR, RETCODE_SEMAPHORE_ERROR);");
                _builder.newLine();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.newLine();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"break;");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"case MQTT_CONNECTION_CLOSED:");
                _builder.newLine();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"mqttIsConnected = false;");
                _builder.newLine();
                _builder.append((Object)"\t\t");
                CodeFragment _generateLogStatement = MqttGenerator.this.loggingGenerator.generateLogStatement(IPlatformLoggingGenerator.LogLevel.Warning, "MQTT_Event : Disconnected. Will try to reconnect on next send.", new CodeFragment[0]);
                _builder.append((Object)_generateLogStatement, "\t\t");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"break;");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"case MQTT_SUBSCRIPTION_ACKNOWLEDGED:");
                _builder.newLine();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"mqttIsSubscribed = true;");
                _builder.newLine();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"if (pdTRUE != xSemaphoreGive(mqttSubscribeHandle))");
                _builder.newLine();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"{");
                _builder.newLine();
                _builder.append((Object)"\t\t\t");
                _builder.append((Object)"exception = RETCODE(RETCODE_SEVERITY_ERROR, RETCODE_SEMAPHORE_ERROR);");
                _builder.newLine();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"break;");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"case MQTT_SUBSCRIBE_SEND_FAILED:");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"case MQTT_SUBSCRIBE_TIMEOUT:");
                _builder.newLine();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"mqttIsSubscribed = false;");
                _builder.newLine();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"if (pdTRUE != xSemaphoreGive(mqttSubscribeHandle))");
                _builder.newLine();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"{");
                _builder.newLine();
                _builder.append((Object)"\t\t\t");
                _builder.append((Object)"exception = RETCODE(RETCODE_SEVERITY_ERROR, RETCODE_SEMAPHORE_ERROR);");
                _builder.newLine();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"break;");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"case MQTT_SUBSCRIPTION_REMOVED:");
                _builder.newLine();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"exception = RETCODE(RETCODE_SEVERITY_ERROR, RETCODE_MQTT_SUBSCRIBE_REMOVED);");
                _builder.newLine();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"break;");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"case MQTT_INCOMING_PUBLISH:");
                _builder.newLine();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"break;");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"case MQTT_PUBLISHED_DATA:");
                _builder.newLine();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"mqttWasPublished = true;");
                _builder.newLine();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"if (pdTRUE != xSemaphoreGive(mqttPublishHandle))");
                _builder.newLine();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"{");
                _builder.newLine();
                _builder.append((Object)"\t\t\t");
                _builder.append((Object)"exception = RETCODE(RETCODE_SEVERITY_ERROR, RETCODE_SEMAPHORE_ERROR);");
                _builder.newLine();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"break;");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"case MQTT_PUBLISH_SEND_FAILED:");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"case MQTT_PUBLISH_SEND_ACK_FAILED:");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"case MQTT_PUBLISH_TIMEOUT:");
                _builder.newLine();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"mqttWasPublished = false;");
                _builder.newLine();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"if (pdTRUE != xSemaphoreGive(mqttPublishHandle))");
                _builder.newLine();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"{");
                _builder.newLine();
                _builder.append((Object)"\t\t\t");
                _builder.append((Object)"exception = RETCODE(RETCODE_SEVERITY_ERROR, RETCODE_SEMAPHORE_ERROR);");
                _builder.newLine();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"break;");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"default:");
                _builder.newLine();
                _builder.append((Object)"\t\t");
                StringConcatenationClient _client = new StringConcatenationClient(){

                    protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                        _builder.append((Object)"event");
                    }
                };
                CodeFragment _generateLogStatement_1 = MqttGenerator.this.loggingGenerator.generateLogStatement(IPlatformLoggingGenerator.LogLevel.Info, "MqttEventHandler : Unhandled MQTT Event: %x", new CodeFragment[]{MqttGenerator.this.codeFragmentProvider.create(_client)});
                _builder.append((Object)_generateLogStatement_1, "\t\t");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"break;");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"if (RETCODE_OK != exception)");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"{");
                _builder.newLine();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"Retcode_RaiseError(exception);");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"return RC_OK;");
                _builder.newLine();
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.newLine();
                _builder.append((Object)"/**");
                _builder.newLine();
                _builder.append((Object)" ");
                _builder.append((Object)"* Connects to a configured backend.");
                _builder.newLine();
                _builder.append((Object)" ");
                _builder.append((Object)"*/");
                _builder.newLine();
                _builder.append((Object)"Retcode_T connectToBackend(void) {");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"/* This is a dummy take. In case of any callback received");
                _builder.newLine();
                _builder.append((Object)"\t ");
                _builder.append((Object)"* after the previous timeout will be cleared here. */");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"(void) xSemaphoreTake(mqttConnectHandle, 0UL);");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"retcode_t rc = Mqtt_connect(&mqttSession);");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"if(RC_OK != rc) {");
                _builder.newLine();
                _builder.append((Object)"\t\t");
                StringConcatenationClient _client_1 = new StringConcatenationClient(){

                    protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                        _builder.append((Object)"rc");
                    }
                };
                CodeFragment _generateLogStatement_2 = MqttGenerator.this.loggingGenerator.generateLogStatement(IPlatformLoggingGenerator.LogLevel.Error, "MQTT_Connect : Failed to connect MQTT: 0x%d", new CodeFragment[]{MqttGenerator.this.codeFragmentProvider.create(_client_1)});
                _builder.append((Object)_generateLogStatement_2, "\t\t");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"return RETCODE(RETCODE_SEVERITY_ERROR, RETCODE_MQTT_CONNECT_FAILED);");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"if (pdTRUE != xSemaphoreTake(mqttConnectHandle, pdMS_TO_TICKS(30000)))");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"{");
                _builder.newLine();
                _builder.append((Object)"\t\t");
                CodeFragment _generateLogStatement_3 = MqttGenerator.this.loggingGenerator.generateLogStatement(IPlatformLoggingGenerator.LogLevel.Error, "MQTT_Connect : Failed since Post CB was not received", new CodeFragment[0]);
                _builder.append((Object)_generateLogStatement_3, "\t\t");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"return RETCODE(RETCODE_SEVERITY_ERROR, RETCODE_MQTT_CONNECT_CB_NOT_RECEIVED);");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"if (!mqttIsConnected)");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"{");
                _builder.newLine();
                _builder.append((Object)"\t\t");
                CodeFragment _generateLogStatement_4 = MqttGenerator.this.loggingGenerator.generateLogStatement(IPlatformLoggingGenerator.LogLevel.Error, "MQTT_Connect : Failed to connect", new CodeFragment[0]);
                _builder.append((Object)_generateLogStatement_4, "\t\t");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"return RETCODE(RETCODE_SEVERITY_ERROR, RETCODE_MQTT_CONNECT_STATUS_ERROR);");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"return RETCODE_OK;");
                _builder.newLine();
                _builder.append((Object)"}");
                _builder.newLine();
            }
        };
        CodeFragment _create = this.codeFragmentProvider.create(_client);
        StringConcatenationClient _client_1 = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append((Object)"static retcode_t MqttEventHandler(MqttSession_T* session, MqttEvent_t event, const MqttEventData_t* eventData);");
                _builder.newLine();
                _builder.append((Object)"static Retcode_T connectToBackend(void);");
                _builder.newLine();
            }
        };
        return _create.setPreamble(_client_1);
    }

    public String getQosFromInt(int qos) {
        List qosLevel = Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new String[]{"MQTT_QOS_AT_MOST_ONE", "MQTT_QOS_AT_LEAST_ONCE", "MQTT_QOS_EXACTLY_ONCE"}));
        return (String)qosLevel.get(qos);
    }

    public CodeFragment generateSignalInstanceGetter(SignalInstance signalInstance, String resultName) {
        return CodeFragment.EMPTY;
    }

    public CodeFragment generateSignalInstanceSetter(final SignalInstance signalInstance, String resultName) {
        int qosRaw = this.getQosLevel(signalInstance);
        final String qos = this.getQosFromInt(qosRaw);
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append((Object)"Retcode_T exception = RETCODE_OK;");
                _builder.newLine();
                _builder.newLine();
                _builder.append((Object)"if(!mqttIsConnected) {");
                _builder.newLine();
                _builder.append((Object)"\t");
                CodeFragment _generateLogStatement = MqttGenerator.this.loggingGenerator.generateLogStatement(IPlatformLoggingGenerator.LogLevel.Info, "MQTT_Write : Reconnecting...", new CodeFragment[0]);
                _builder.append((Object)_generateLogStatement, "\t");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t");
                _builder.append((Object)"exception = connectToBackend();");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"if(mqttIsConnected) {");
                _builder.newLine();
                _builder.append((Object)"\t\t");
                CodeFragment _generateLogStatement_1 = MqttGenerator.this.loggingGenerator.generateLogStatement(IPlatformLoggingGenerator.LogLevel.Info, "MQTT_Write : Connected.", new CodeFragment[0]);
                _builder.append((Object)_generateLogStatement_1, "\t\t");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t");
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"else {");
                _builder.newLine();
                _builder.append((Object)"\t\t");
                CodeFragment _generateLogStatement_2 = MqttGenerator.this.loggingGenerator.generateLogStatement(IPlatformLoggingGenerator.LogLevel.Error, "MQTT_Write : Connection failed!", new CodeFragment[0]);
                _builder.append((Object)_generateLogStatement_2, "\t\t");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t");
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.append((Object)"}");
                _builder.newLine();
                CharSequence _generateExceptionHandler = MqttGenerator.this.generatorUtils.generateExceptionHandler((EObject)signalInstance, "exception");
                _builder.append((Object)_generateExceptionHandler);
                _builder.newLineIfNotEmpty();
                _builder.newLine();
                _builder.append((Object)"static StringDescr_T publishTopicDescription;");
                _builder.newLine();
                _builder.append((Object)"static char *topic = \"");
                String _topicName = MqttGenerator.this.getTopicName(signalInstance);
                _builder.append((Object)_topicName);
                _builder.append((Object)"\";");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"StringDescr_wrap(&publishTopicDescription, topic);");
                _builder.newLine();
                _builder.newLine();
                _builder.append((Object)"mqttWasPublished = false;");
                _builder.newLine();
                _builder.append((Object)"/* This is a dummy take. In case of any callback received");
                _builder.newLine();
                _builder.append((Object)" ");
                _builder.append((Object)"* after the previous timeout will be cleared here. */");
                _builder.newLine();
                _builder.append((Object)"(void) xSemaphoreTake(mqttPublishHandle, 0UL);");
                _builder.newLine();
                _builder.append((Object)"if (RC_OK != Mqtt_publish(&mqttSession, publishTopicDescription, *value, strlen(*value), (uint8_t) ");
                _builder.append((Object)qos);
                _builder.append((Object)", false))");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"{");
                _builder.newLine();
                _builder.append((Object)"    ");
                _builder.append((Object)"exception = RETCODE(RETCODE_SEVERITY_ERROR, RETCODE_MQTT_PUBLISH_FAILED);");
                _builder.newLine();
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.newLine();
                CharSequence _generateExceptionHandler_1 = MqttGenerator.this.generatorUtils.generateExceptionHandler((EObject)signalInstance, "exception");
                _builder.append((Object)_generateExceptionHandler_1);
                _builder.newLineIfNotEmpty();
                _builder.newLine();
                _builder.append((Object)"if (pdTRUE != xSemaphoreTake(mqttPublishHandle, pdMS_TO_TICKS(5000)))");
                _builder.newLine();
                _builder.append((Object)"{");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"exception = RETCODE(RETCODE_SEVERITY_ERROR, RETCODE_MQTT_SUBSCRIBE_CB_NOT_RECEIVED);");
                _builder.newLine();
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.append((Object)"else");
                _builder.newLine();
                _builder.append((Object)"{");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"if (true != mqttWasPublished)");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"{");
                _builder.newLine();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"exception = RETCODE(RETCODE_SEVERITY_ERROR, RETCODE_MQTT_SUBSCRIBE_STATUS_ERROR);");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.newLine();
                _builder.append((Object)"return exception;");
                _builder.newLine();
            }
        };
        return this.codeFragmentProvider.create(_client);
    }

    protected int getQosLevel(SignalInstance instance) {
        Expression qosRaw = ModelUtils.getArgumentValue((SignalInstance)instance, (String)"qos");
        Integer _xifexpression = null;
        if (qosRaw == null) {
            _xifexpression = null;
        } else {
            Procedures.Procedure1<EObject> _function = new Procedures.Procedure1<EObject>(){

                public void apply(EObject it) {
                }
            };
            Object _infer = StaticValueInferrer.infer((EObject)qosRaw, (Procedures.Procedure1)_function);
            _xifexpression = (Integer)_infer;
        }
        Integer qosRawValue = _xifexpression;
        Integer _elvis = null;
        _elvis = qosRawValue != null ? qosRawValue : Integer.valueOf(0);
        return Math.min(Math.max(_elvis, 0), 3);
    }

    protected String getTopicName(SignalInstance instance) {
        Procedures.Procedure1<EObject> _function = new Procedures.Procedure1<EObject>(){

            public void apply(EObject it) {
            }
        };
        Object _infer = StaticValueInferrer.infer((EObject)ModelUtils.getArgumentValue((SignalInstance)instance, (String)"name"), (Procedures.Procedure1)_function);
        return (String)_infer;
    }
}

