/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mita.platform.xdk110.connectivity;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.mita.base.expressions.Expression;
import org.eclipse.mita.base.types.Enumerator;
import org.eclipse.mita.platform.Signal;
import org.eclipse.mita.program.SignalInstance;
import org.eclipse.mita.program.generator.AbstractSystemResourceGenerator;
import org.eclipse.mita.program.generator.CodeFragment;
import org.eclipse.mita.program.generator.GeneratorUtils;
import org.eclipse.mita.program.generator.StatementGenerator;
import org.eclipse.mita.program.inferrer.StaticValueInferrer;
import org.eclipse.mita.program.model.ModelUtils;
import org.eclipse.xtend2.lib.StringConcatenationClient;
import org.eclipse.xtext.generator.trace.node.IGeneratorNode;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.Pair;
import org.eclipse.xtext.xbase.lib.Procedures;

public class LoraGenerator
extends AbstractSystemResourceGenerator {
    @Inject
    @Extension
    private StatementGenerator statementGenerator;
    @Inject
    @Extension
    private GeneratorUtils generatorUtils;
    protected final Map<String, Map<String, Integer>> defaultValues = Collections.unmodifiableMap(CollectionLiterals.newHashMap((Pair[])new Pair[]{Pair.of((Object)"EU", Collections.unmodifiableMap(CollectionLiterals.newHashMap((Pair[])new Pair[]{Pair.of((Object)"bandFrequency", (Object)868), Pair.of((Object)"rx2Frequency", (Object)869525), Pair.of((Object)"rx2DataRate", (Object)0), Pair.of((Object)"dataRate", (Object)3)}))), Pair.of((Object)"US", Collections.unmodifiableMap(CollectionLiterals.newHashMap((Pair[])new Pair[]{Pair.of((Object)"bandFrequency", (Object)915), Pair.of((Object)"rx2Frequency", (Object)923300), Pair.of((Object)"rx2DataRate", (Object)8), Pair.of((Object)"dataRate", (Object)3)})))}));

    public CodeFragment generateSetup() {
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append((Object)"Retcode_T exception = RETCODE_OK;");
                _builder.newLine();
                _builder.append((Object)"LoraJoinHandle = xSemaphoreCreateBinary();");
                _builder.newLine();
                _builder.append((Object)"if (NULL == LoraJoinHandle)");
                _builder.newLine();
                _builder.append((Object)"{");
                _builder.newLine();
                _builder.append((Object)"    ");
                _builder.append((Object)"vSemaphoreDelete(LoraJoinHandle);");
                _builder.newLine();
                _builder.append((Object)"    ");
                _builder.append((Object)"exception = RETCODE(RETCODE_SEVERITY_ERROR, RETCODE_OUT_OF_RESOURCES);");
                _builder.newLine();
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.append((Object)"else");
                _builder.newLine();
                _builder.append((Object)"{");
                _builder.newLine();
                _builder.append((Object)"    ");
                _builder.append((Object)"LoRaJoinStatus = false;");
                _builder.newLine();
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.append((Object)"return exception;");
                _builder.newLine();
            }
        };
        CodeFragment _create = this.codeFragmentProvider.create(_client);
        StringConcatenationClient _client_1 = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append((Object)"#define JOIN_TIMEOUT 10000");
                _builder.newLine();
                _builder.append((Object)"/**< Handle for LORA join operation  */");
                _builder.newLine();
                _builder.append((Object)"static SemaphoreHandle_t LoraJoinHandle;");
                _builder.newLine();
                _builder.append((Object)"/**< LoRa join status */");
                _builder.newLine();
                _builder.append((Object)"static bool LoRaJoinStatus = false;");
                _builder.newLine();
                _builder.newLine();
                _builder.append((Object)"/**");
                _builder.newLine();
                _builder.append((Object)" ");
                _builder.append((Object)"* @brief   LoRa Network Callback function used by the stack to communicate events to the application");
                _builder.newLine();
                _builder.append((Object)" ");
                _builder.append((Object)"*");
                _builder.newLine();
                _builder.append((Object)" ");
                _builder.append((Object)"* @param[in] flags Currently not used");
                _builder.newLine();
                _builder.append((Object)" ");
                _builder.append((Object)"*");
                _builder.newLine();
                _builder.append((Object)" ");
                _builder.append((Object)"* @param[in] eventInfo Hold the information about the event");
                _builder.newLine();
                _builder.append((Object)" ");
                _builder.append((Object)"*");
                _builder.newLine();
                _builder.append((Object)" ");
                _builder.append((Object)"*/");
                _builder.newLine();
                _builder.append((Object)"static void LoRaCallbackFunc(void *flags, LoRaMacEventInfo_T *eventInfo)");
                _builder.newLine();
                _builder.append((Object)"{");
                _builder.newLine();
                _builder.append((Object)"    ");
                _builder.append((Object)"BCDS_UNUSED(flags);");
                _builder.newLine();
                _builder.append((Object)"    ");
                _builder.append((Object)"Retcode_T retcode = RETCODE_OK;");
                _builder.newLine();
                _builder.append((Object)"    ");
                _builder.append((Object)"switch (eventInfo->event)");
                _builder.newLine();
                _builder.append((Object)"    ");
                _builder.append((Object)"{");
                _builder.newLine();
                _builder.append((Object)"        ");
                _builder.append((Object)"case LORA_NETWORK_JOIN_SUCCESS:");
                _builder.newLine();
                _builder.append((Object)"\t        ");
                _builder.append((Object)"LoRaJoinStatus = true;");
                _builder.newLine();
                _builder.append((Object)"\t        ");
                _builder.append((Object)"if (pdTRUE != xSemaphoreGive(LoraJoinHandle))");
                _builder.newLine();
                _builder.append((Object)"\t        ");
                _builder.append((Object)"{");
                _builder.newLine();
                _builder.append((Object)"\t            ");
                _builder.append((Object)"retcode = RETCODE(RETCODE_SEVERITY_ERROR, RETCODE_SEMAPHORE_ERROR);");
                _builder.newLine();
                _builder.append((Object)"\t        ");
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.append((Object)"\t        ");
                _builder.append((Object)"break;");
                _builder.newLine();
                _builder.append((Object)"        ");
                _builder.append((Object)"case LORA_NETWORK_JOIN_TIMEOUT:");
                _builder.newLine();
                _builder.append((Object)"        ");
                _builder.append((Object)"case LORA_NETWORK_JOIN_FAILURE:");
                _builder.newLine();
                _builder.append((Object)"\t        ");
                _builder.append((Object)"LoRaJoinStatus = false;");
                _builder.newLine();
                _builder.append((Object)"\t        ");
                _builder.append((Object)"printf(\"Lora Network join timeout/failure: %d \\r\\n\", eventInfo->event);");
                _builder.newLine();
                _builder.append((Object)"\t        ");
                _builder.append((Object)"if (pdTRUE != xSemaphoreGive(LoraJoinHandle))");
                _builder.newLine();
                _builder.append((Object)"\t        ");
                _builder.append((Object)"{");
                _builder.newLine();
                _builder.append((Object)"\t            ");
                _builder.append((Object)"retcode = RETCODE(RETCODE_SEVERITY_ERROR, RETCODE_SEMAPHORE_ERROR);");
                _builder.newLine();
                _builder.append((Object)"\t        ");
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.append((Object)"        \t");
                _builder.append((Object)"break;");
                _builder.newLine();
                _builder.append((Object)"        ");
                _builder.append((Object)"case LORA_NETWORK_RECEIVED_PACKET:");
                _builder.newLine();
                _builder.append((Object)"\t        ");
                _builder.append((Object)"printf(\"Lora Network Received Packet \\r\\n\");");
                _builder.newLine();
                _builder.append((Object)"        \t");
                _builder.append((Object)"break;");
                _builder.newLine();
                _builder.append((Object)"        ");
                _builder.append((Object)"case LORA_NETWORK_SEND_FAILED:");
                _builder.newLine();
                _builder.append((Object)"\t        ");
                _builder.append((Object)"printf(\"Lora Network Send Failed \\r\\n\");");
                _builder.newLine();
                _builder.append((Object)"\t        ");
                _builder.append((Object)"break;");
                _builder.newLine();
                _builder.append((Object)"        ");
                _builder.append((Object)"case LORA_NETWORK_RECEIVE_FAILED:");
                _builder.newLine();
                _builder.append((Object)"        \t");
                _builder.append((Object)"printf(\"Lora Join Failed State \\r\\n\");");
                _builder.newLine();
                _builder.append((Object)"        \t");
                _builder.append((Object)"break;");
                _builder.newLine();
                _builder.append((Object)"        ");
                _builder.append((Object)"default:");
                _builder.newLine();
                _builder.append((Object)"        ");
                _builder.append((Object)"break;");
                _builder.newLine();
                _builder.append((Object)"    ");
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.append((Object)"    ");
                _builder.append((Object)"if (RETCODE_OK != retcode)");
                _builder.newLine();
                _builder.append((Object)"    ");
                _builder.append((Object)"{");
                _builder.newLine();
                _builder.append((Object)"        ");
                _builder.append((Object)"Retcode_RaiseError(retcode);");
                _builder.newLine();
                _builder.append((Object)"    ");
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.append((Object)"}");
                _builder.newLine();
                Functions.Function1<SignalInstance, Boolean> _function = new Functions.Function1<SignalInstance, Boolean>(){

                    public Boolean apply(SignalInstance it) {
                        String _name = it.getInstanceOf().getName();
                        return Objects.equal((Object)_name, (Object)"cayenne");
                    }
                };
                boolean _exists = IterableExtensions.exists((Iterable)LoraGenerator.this.setup.getSignalInstances(), (Functions.Function1)_function);
                if (_exists) {
                    _builder.append((Object)"// required data structures for cayenne");
                    _builder.newLine();
                    _builder.append((Object)"// translation CayennePayload_enum -> cayenne used buffer size in bytes");
                    _builder.newLine();
                    _builder.append((Object)"static const uint8_t payloadSizes[] = {");
                    _builder.newLine();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"3, 3, 4, 4, 4, 3, 4, 3, 8, 4, 8, 11");
                    _builder.newLine();
                    _builder.append((Object)"};");
                    _builder.newLine();
                    _builder.append((Object)"// translation CayennePayload_enum -> CayenneLPPSerializer_DataType_T");
                    _builder.newLine();
                    _builder.append((Object)"static const CayenneLPPSerializer_DataType_T cayenneDataTypes[] = {");
                    _builder.newLine();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"CAYENNE_LLP_SERIALIZER_DIGITAL_INPUT,");
                    _builder.newLine();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"CAYENNE_LLP_SERIALIZER_DIGITAL_OUTPUT,");
                    _builder.newLine();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"CAYENNE_LLP_SERIALIZER_ANALOG_INPUT,");
                    _builder.newLine();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"CAYENNE_LLP_SERIALIZER_ANALOG_OUTPUT,");
                    _builder.newLine();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"CAYENNE_LLP_SERIALIZER_ILLUMINANCE_SENSOR,");
                    _builder.newLine();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"CAYENNE_LLP_SERIALIZER_PRESENCE_SENSOR,");
                    _builder.newLine();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"CAYENNE_LLP_SERIALIZER_TEMPERATURE_SENSOR,");
                    _builder.newLine();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"CAYENNE_LLP_SERIALIZER_HUMIDITY_SENSOR,");
                    _builder.newLine();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"CAYENNE_LLP_SERIALIZER_ACCELEROMETER,");
                    _builder.newLine();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"CAYENNE_LLP_SERIALIZER_BAROMETER,");
                    _builder.newLine();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"CAYENNE_LLP_SERIALIZER_GYROMETER,");
                    _builder.newLine();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"CAYENNE_LLP_SERIALIZER_GPS_LOCATION");
                    _builder.newLine();
                    _builder.append((Object)"};");
                    _builder.newLine();
                }
            }
        };
        return _create.setPreamble(_client_1).addHeader("FreeRTOS.h", true, 750).addHeader("semphr.h", true).addHeader("BCDS_LoRaDevice.h", true);
    }

    public CodeFragment generateEnable() {
        Procedures.Procedure1<EObject> _function = new Procedures.Procedure1<EObject>(){

            public void apply(EObject it) {
            }
        };
        final Object appEui = StaticValueInferrer.infer((EObject)this.configuration.getExpression("loraAppEui"), (Procedures.Procedure1)_function);
        Procedures.Procedure1<EObject> _function_1 = new Procedures.Procedure1<EObject>(){

            public void apply(EObject it) {
            }
        };
        final Object appKey = StaticValueInferrer.infer((EObject)this.configuration.getExpression("loraAppKey"), (Procedures.Procedure1)_function_1);
        Procedures.Procedure1<EObject> _function_2 = new Procedures.Procedure1<EObject>(){

            public void apply(EObject it) {
            }
        };
        final Object deviceEui = StaticValueInferrer.infer((EObject)this.configuration.getExpression("loraDeviceEui"), (Procedures.Procedure1)_function_2);
        Enumerator _enumerator = this.configuration.getEnumerator("region");
        String _name = null;
        if (_enumerator != null) {
            _name = _enumerator.getName();
        }
        String regionName = _name;
        Integer _elvis = null;
        Integer _integer = this.configuration.getInteger("bandFrequency");
        if (_integer != null) {
            _elvis = _integer;
        } else {
            Map<String, Integer> _get = this.defaultValues.get(regionName);
            Integer _get_1 = null;
            if (_get != null) {
                _get_1 = _get.get("bandFrequency");
            }
            _elvis = _get_1;
        }
        final Integer bandFrequency = _elvis;
        Integer _elvis_1 = null;
        Integer _integer_1 = this.configuration.getInteger("rx2Frequency");
        if (_integer_1 != null) {
            _elvis_1 = _integer_1;
        } else {
            Map<String, Integer> _get_2 = this.defaultValues.get(regionName);
            Integer _get_3 = null;
            if (_get_2 != null) {
                _get_3 = _get_2.get("rx2Frequency");
            }
            _elvis_1 = _get_3;
        }
        final Integer rx2Frequency = _elvis_1;
        Integer _elvis_2 = null;
        Integer _integer_2 = this.configuration.getInteger("rx2DataRate");
        if (_integer_2 != null) {
            _elvis_2 = _integer_2;
        } else {
            Map<String, Integer> _get_4 = this.defaultValues.get(regionName);
            Integer _get_5 = null;
            if (_get_4 != null) {
                _get_5 = _get_4.get("rx2DataRate");
            }
            _elvis_2 = _get_5;
        }
        final Integer rx2DataRate = _elvis_2;
        Integer _elvis_3 = null;
        Integer _integer_3 = this.configuration.getInteger("dataRate");
        if (_integer_3 != null) {
            _elvis_3 = _integer_3;
        } else {
            Map<String, Integer> _get_6 = this.defaultValues.get(regionName);
            Integer _get_7 = null;
            if (_get_6 != null) {
                _get_7 = _get_6.get("dataRate");
            }
            _elvis_3 = _get_7;
        }
        final Integer dataRate = _elvis_3;
        if (appEui instanceof List && appKey instanceof List) {
            StringConcatenationClient _client = new StringConcatenationClient(){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    _builder.append((Object)"Retcode_T exception = RETCODE_OK;");
                    _builder.newLine();
                    _builder.append((Object)"exception = LoRaDevice_Init(LoRaCallbackFunc, ");
                    _builder.append((Object)bandFrequency);
                    _builder.append((Object)");");
                    _builder.newLineIfNotEmpty();
                    CodeFragment _generateLoggingExceptionHandler = LoraGenerator.this.generatorUtils.generateLoggingExceptionHandler("LoRa", "device init");
                    _builder.append((Object)_generateLoggingExceptionHandler);
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"exception = LoRaDevice_SetRxWindow2(");
                    _builder.append((Object)rx2DataRate);
                    _builder.append((Object)", ");
                    _builder.append((Object)rx2Frequency);
                    _builder.append((Object)"000);");
                    _builder.newLineIfNotEmpty();
                    CodeFragment _generateLoggingExceptionHandler_1 = LoraGenerator.this.generatorUtils.generateLoggingExceptionHandler("LoRa", "set rx window");
                    _builder.append((Object)_generateLoggingExceptionHandler_1);
                    _builder.newLineIfNotEmpty();
                    if (deviceEui instanceof List) {
                        _builder.append((Object)"exception = LoRaDevice_SetDevEUI(devEUI);");
                        _builder.newLine();
                        _builder.append((Object)"if(exception == NO_EXCEPTION)");
                        _builder.newLine();
                        _builder.append((Object)"{");
                        _builder.newLine();
                        _builder.append((Object)"\t");
                        _builder.append((Object)"uint64_t actualDevEUI;");
                        _builder.newLine();
                        _builder.append((Object)"\t");
                        _builder.append((Object)"exception = LoRaDevice_GetDevEUI(&actualDevEUI);");
                        _builder.newLine();
                        _builder.append((Object)"\t");
                        _builder.append((Object)"if(exception != NO_EXCEPTION) {");
                        _builder.newLine();
                        _builder.append((Object)"\t\t");
                        _builder.append((Object)"printf(\"[ERROR, %s:%d] failed to set device eui LoRa\\n\", __FILE__, __LINE__);");
                        _builder.newLine();
                        _builder.append((Object)"\t");
                        _builder.append((Object)"}");
                        _builder.newLine();
                        _builder.append((Object)"\t");
                        _builder.append((Object)"printf(\"[INFO, %s:%d] set device eui LoRa succeeded: %llx\\n\", __FILE__, __LINE__, actualDevEUI);");
                        _builder.newLine();
                        _builder.append((Object)"}");
                        _builder.newLine();
                        _builder.append((Object)"else");
                        _builder.newLine();
                        _builder.append((Object)"{");
                        _builder.newLine();
                        _builder.append((Object)"\t");
                        _builder.append((Object)"printf(\"[ERROR, %s:%d] failed to set device eui LoRa\\n\", __FILE__, __LINE__);");
                        _builder.newLine();
                        _builder.append((Object)"\t");
                        _builder.append((Object)"return exception;");
                        _builder.newLine();
                        _builder.append((Object)"}");
                        _builder.newLine();
                    } else {
                        _builder.append((Object)"uint64_t hwEui = 0;");
                        _builder.newLine();
                        _builder.append((Object)"exception = LoRaDevice_GetHwEUI(&hwEui);");
                        _builder.newLine();
                        CodeFragment _generateLoggingExceptionHandler_2 = LoraGenerator.this.generatorUtils.generateLoggingExceptionHandler("LoRa", "get hw eui");
                        _builder.append((Object)_generateLoggingExceptionHandler_2);
                        _builder.newLineIfNotEmpty();
                        _builder.append((Object)"exception = LoRaDevice_SetDevEUI(hwEui);");
                        _builder.newLine();
                        CodeFragment _generateLoggingExceptionHandler_3 = LoraGenerator.this.generatorUtils.generateLoggingExceptionHandler("LoRa", "set dev eui");
                        _builder.append((Object)_generateLoggingExceptionHandler_3);
                        _builder.newLineIfNotEmpty();
                    }
                    _builder.append((Object)"exception = LoRaDevice_SetAppEUI(0x");
                    Functions.Function1<Object, String> _function = new Functions.Function1<Object, String>(){

                        public String apply(Object it) {
                            return String.format("%02x", it);
                        }
                    };
                    String _join = IterableExtensions.join((Iterable)ListExtensions.map((List)((List)appEui), (Functions.Function1)_function), (CharSequence)"");
                    _builder.append((Object)_join);
                    _builder.append((Object)");");
                    _builder.newLineIfNotEmpty();
                    CodeFragment _generateLoggingExceptionHandler_4 = LoraGenerator.this.generatorUtils.generateLoggingExceptionHandler("LoRa", "set app eui");
                    _builder.append((Object)_generateLoggingExceptionHandler_4);
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"exception = LoRaDevice_SetAppKey(appKey);");
                    _builder.newLine();
                    CodeFragment _generateLoggingExceptionHandler_5 = LoraGenerator.this.generatorUtils.generateLoggingExceptionHandler("LoRa", "set app key");
                    _builder.append((Object)_generateLoggingExceptionHandler_5);
                    _builder.newLineIfNotEmpty();
                    _builder.newLine();
                    _builder.append((Object)"exception = LoRaDevice_SetRadioCodingRate(codingRate);");
                    _builder.newLine();
                    CodeFragment _generateLoggingExceptionHandler_6 = LoraGenerator.this.generatorUtils.generateLoggingExceptionHandler("LoRa", "set radio coding rate");
                    _builder.append((Object)_generateLoggingExceptionHandler_6);
                    _builder.newLineIfNotEmpty();
                    _builder.newLine();
                    _builder.append((Object)"exception = LoRaDevice_SetADR(");
                    IGeneratorNode _code = LoraGenerator.this.statementGenerator.code((EObject)LoraGenerator.this.configuration.getExpression("adaptiveDataRate"));
                    _builder.append((Object)_code);
                    _builder.append((Object)");");
                    _builder.newLineIfNotEmpty();
                    CodeFragment _generateLoggingExceptionHandler_7 = LoraGenerator.this.generatorUtils.generateLoggingExceptionHandler("LoRa", "set adaptive data rate");
                    _builder.append((Object)_generateLoggingExceptionHandler_7);
                    _builder.newLineIfNotEmpty();
                    _builder.newLine();
                    _builder.append((Object)"exception = LoRaDevice_SaveConfig();");
                    _builder.newLine();
                    CodeFragment _generateLoggingExceptionHandler_8 = LoraGenerator.this.generatorUtils.generateLoggingExceptionHandler("LoRa", "save config");
                    _builder.append((Object)_generateLoggingExceptionHandler_8);
                    _builder.newLineIfNotEmpty();
                    _builder.newLine();
                    _builder.append((Object)"exception = LoRa_Join();");
                    _builder.newLine();
                    _builder.append((Object)"if(exception == NO_EXCEPTION)");
                    _builder.newLine();
                    _builder.append((Object)"{");
                    _builder.newLine();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"printf(\"[INFO, %s:%d] joining network LoRa succeeded\\n\", __FILE__, __LINE__);");
                    _builder.newLine();
                    _builder.append((Object)"}");
                    _builder.newLine();
                    _builder.append((Object)"else");
                    _builder.newLine();
                    _builder.append((Object)"{");
                    _builder.newLine();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"printf(\"[ERROR, %s:%d] failed to join network LoRa\\n\", __FILE__, __LINE__);");
                    _builder.newLine();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"Retcode_RaiseError(exception);");
                    _builder.newLine();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"return exception;");
                    _builder.newLine();
                    _builder.append((Object)"}");
                    _builder.newLine();
                    _builder.newLine();
                    _builder.append((Object)"if (RETCODE_OK == exception)");
                    _builder.newLine();
                    _builder.append((Object)"{");
                    _builder.newLine();
                    _builder.append((Object)"    ");
                    _builder.append((Object)"printf(\"LoRa_Enable: LoRa Join Success...\\r\\n\");");
                    _builder.newLine();
                    _builder.append((Object)"    ");
                    _builder.append((Object)"do");
                    _builder.newLine();
                    _builder.append((Object)"    ");
                    _builder.append((Object)"{");
                    _builder.newLine();
                    _builder.append((Object)"        ");
                    _builder.append((Object)"exception = LoRa_SetDataRate(0);");
                    _builder.newLine();
                    _builder.append((Object)"        ");
                    _builder.append((Object)"if (RETCODE_OK == exception)");
                    _builder.newLine();
                    _builder.append((Object)"        ");
                    _builder.append((Object)"{");
                    _builder.newLine();
                    _builder.append((Object)"            ");
                    _builder.append((Object)"/*to avoid losing the first frame sent to the gateway: gateway duplicate error message */");
                    _builder.newLine();
                    _builder.append((Object)"            ");
                    _builder.append((Object)"exception = LoRa_SendUnconfirmed(UINT8_C(1), (void*) 'X', UINT16_C(1));");
                    _builder.newLine();
                    _builder.append((Object)"        ");
                    _builder.append((Object)"}");
                    _builder.newLine();
                    _builder.append((Object)"        ");
                    _builder.append((Object)"if (RETCODE_OK == exception)");
                    _builder.newLine();
                    _builder.append((Object)"        ");
                    _builder.append((Object)"{");
                    _builder.newLine();
                    _builder.append((Object)"            ");
                    _builder.append((Object)"// Set Data Rate to 3 (increase amount of data to send) and send the data via LoRa");
                    _builder.newLine();
                    _builder.append((Object)"            ");
                    _builder.append((Object)"exception = LoRa_SetDataRate(");
                    _builder.append((Object)dataRate, "            ");
                    _builder.append((Object)");");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"        ");
                    _builder.append((Object)"}");
                    _builder.newLine();
                    _builder.append((Object)"        ");
                    _builder.append((Object)"if (RETCODE_OK != exception)");
                    _builder.newLine();
                    _builder.append((Object)"        ");
                    _builder.append((Object)"{");
                    _builder.newLine();
                    _builder.append((Object)"            ");
                    _builder.append((Object)"printf(\"LoRa enable: Sending first frame to gateway failed Retrying  ...\\r\\n\");");
                    _builder.newLine();
                    _builder.append((Object)"        ");
                    _builder.append((Object)"}");
                    _builder.newLine();
                    _builder.append((Object)"    ");
                    _builder.append((Object)"} while (RETCODE_OK != exception);");
                    _builder.newLine();
                    _builder.append((Object)"}");
                    _builder.newLine();
                    CodeFragment _generateLoggingExceptionHandler_9 = LoraGenerator.this.generatorUtils.generateLoggingExceptionHandler("LoRa", "enable");
                    _builder.append((Object)_generateLoggingExceptionHandler_9);
                    _builder.newLineIfNotEmpty();
                    _builder.newLine();
                    _builder.append((Object)"return exception;");
                    _builder.newLine();
                }
            };
            CodeFragment _create = this.codeFragmentProvider.create(_client);
            StringConcatenationClient _client_1 = new StringConcatenationClient(){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    _builder.append((Object)"const uint8_t appKey[16] = { ");
                    Functions.Function1<Object, String> _function = new Functions.Function1<Object, String>(){

                        public String apply(Object it) {
                            return String.format("0x%02x", it);
                        }
                    };
                    String _join = IterableExtensions.join((Iterable)ListExtensions.map((List)((List)appKey), (Functions.Function1)_function), (CharSequence)", ");
                    _builder.append((Object)_join);
                    _builder.append((Object)" };");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"const char* codingRate = \"4/5\";");
                    _builder.newLine();
                    if (deviceEui instanceof List) {
                        _builder.append((Object)"const uint64_t devEUI = 0x");
                        Functions.Function1<Object, String> _function_1 = new Functions.Function1<Object, String>(){

                            public String apply(Object it) {
                                return String.format("%02x", it);
                            }
                        };
                        String _join_1 = IterableExtensions.join((Iterable)ListExtensions.map((List)((List)deviceEui), (Functions.Function1)_function_1), (CharSequence)"");
                        _builder.append((Object)_join_1);
                        _builder.append((Object)";");
                        _builder.newLineIfNotEmpty();
                    }
                    _builder.newLine();
                    _builder.append((Object)"static Retcode_T LoRa_Join(void)");
                    _builder.newLine();
                    _builder.append((Object)"{");
                    _builder.newLine();
                    _builder.append((Object)"    ");
                    _builder.append((Object)"Retcode_T retcode = RETCODE_OK;");
                    _builder.newLine();
                    _builder.newLine();
                    _builder.append((Object)"    ");
                    _builder.append((Object)"// This is a dummy semaphore take");
                    _builder.newLine();
                    _builder.append((Object)"    ");
                    _builder.append((Object)"(void)xSemaphoreTake(LoraJoinHandle, 0);");
                    _builder.newLine();
                    _builder.append((Object)"    ");
                    _builder.append((Object)"retcode = LoRaDevice_Join(LORA_JOIN_OTAA);");
                    _builder.newLine();
                    _builder.append((Object)"    ");
                    _builder.append((Object)"if (RETCODE_OK == retcode)");
                    _builder.newLine();
                    _builder.append((Object)"    ");
                    _builder.append((Object)"{");
                    _builder.newLine();
                    _builder.append((Object)"        ");
                    _builder.append((Object)"if ((pdTRUE != xSemaphoreTake(LoraJoinHandle, pdMS_TO_TICKS(JOIN_TIMEOUT)) || (false == LoRaJoinStatus)))");
                    _builder.newLine();
                    _builder.append((Object)"        ");
                    _builder.append((Object)"{");
                    _builder.newLine();
                    _builder.append((Object)"            ");
                    _builder.append((Object)"retcode = RETCODE(RETCODE_SEVERITY_ERROR, RETCODE_LORA_JOIN_FAILED);");
                    _builder.newLine();
                    _builder.append((Object)"        ");
                    _builder.append((Object)"}");
                    _builder.newLine();
                    _builder.append((Object)"    ");
                    _builder.append((Object)"}");
                    _builder.newLine();
                    _builder.append((Object)"    ");
                    _builder.append((Object)"return (retcode);");
                    _builder.newLine();
                    _builder.append((Object)"}");
                    _builder.newLine();
                    _builder.newLine();
                    _builder.append((Object)"static Retcode_T LoRa_SendUnconfirmed(uint8_t LoRaPort, uint8_t *dataBuffer, uint32_t dataBufferSize)");
                    _builder.newLine();
                    _builder.append((Object)"{");
                    _builder.newLine();
                    _builder.append((Object)"    ");
                    _builder.append((Object)"Retcode_T retcode = RETCODE_OK;");
                    _builder.newLine();
                    _builder.append((Object)"    ");
                    _builder.append((Object)"if (NULL == dataBuffer)");
                    _builder.newLine();
                    _builder.append((Object)"    ");
                    _builder.append((Object)"{");
                    _builder.newLine();
                    _builder.append((Object)"        ");
                    _builder.append((Object)"return (RETCODE(RETCODE_SEVERITY_ERROR, RETCODE_NULL_POINTER));");
                    _builder.newLine();
                    _builder.append((Object)"    ");
                    _builder.append((Object)"}");
                    _builder.newLine();
                    _builder.append((Object)"    ");
                    _builder.append((Object)"retcode = LoRaDevice_SendUnconfirmed(LoRaPort, dataBuffer, (uint16_t) dataBufferSize);");
                    _builder.newLine();
                    _builder.append((Object)"    ");
                    _builder.append((Object)"return (retcode);");
                    _builder.newLine();
                    _builder.append((Object)"}");
                    _builder.newLine();
                    _builder.newLine();
                    _builder.append((Object)"static Retcode_T LoRa_SendConfirmed(uint8_t LoRaPort, uint8_t *dataBuffer, uint32_t dataBufferSize)");
                    _builder.newLine();
                    _builder.append((Object)"{");
                    _builder.newLine();
                    _builder.append((Object)"    ");
                    _builder.append((Object)"Retcode_T retcode = RETCODE_OK;");
                    _builder.newLine();
                    _builder.append((Object)"    ");
                    _builder.append((Object)"if (NULL == dataBuffer)");
                    _builder.newLine();
                    _builder.append((Object)"    ");
                    _builder.append((Object)"{");
                    _builder.newLine();
                    _builder.append((Object)"        ");
                    _builder.append((Object)"return (RETCODE(RETCODE_SEVERITY_ERROR, RETCODE_NULL_POINTER));");
                    _builder.newLine();
                    _builder.append((Object)"    ");
                    _builder.append((Object)"}");
                    _builder.newLine();
                    _builder.append((Object)"    ");
                    _builder.append((Object)"retcode = LoRaDevice_SendConfirmed(LoRaPort, dataBuffer, (uint16_t) dataBufferSize);");
                    _builder.newLine();
                    _builder.append((Object)"    ");
                    _builder.append((Object)"return (retcode);");
                    _builder.newLine();
                    _builder.append((Object)"}");
                    _builder.newLine();
                }
            };
            return _create.setPreamble(_client_1).addHeader("FreeRTOS.h", true, 750).addHeader("semphr.h", true).addHeader("BCDS_LoRaDevice.h", true).addHeader("XdkCommonInfo.h", true);
        }
        StringConcatenationClient _client_2 = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append((Object)"ERROR: expected value not array literal!");
            }
        };
        return this.codeFragmentProvider.create(_client_2);
    }

    public CodeFragment generateSignalInstanceGetter(SignalInstance signalInstance, String valueVariableName) {
        return CodeFragment.EMPTY;
    }

    public CodeFragment generateSignalInstanceSetter(SignalInstance signalInstance, final String valueVariableName) {
        Signal signal = signalInstance.getInstanceOf();
        Procedures.Procedure1<EObject> _function = new Procedures.Procedure1<EObject>(){

            public void apply(EObject it) {
            }
        };
        Object confirmation = StaticValueInferrer.infer((EObject)ModelUtils.getArgumentValue((SignalInstance)signalInstance, (String)"confirmation"), (Procedures.Procedure1)_function);
        if (confirmation instanceof Enumerator) {
            final Expression portNum = ModelUtils.getArgumentValue((SignalInstance)signalInstance, (String)"portNum");
            String _name = ((Enumerator)confirmation).getName();
            final String sendName = "LoRa_Send" + _name;
            String _name_1 = signal.getName();
            boolean _equals = Objects.equal((Object)_name_1, (Object)"raw");
            if (_equals) {
                StringConcatenationClient _client = new StringConcatenationClient(){

                    protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                        _builder.append((Object)"return ");
                        _builder.append((Object)sendName);
                        _builder.append((Object)"(");
                        IGeneratorNode _code = LoraGenerator.this.statementGenerator.code((EObject)portNum);
                        _builder.append((Object)_code);
                        _builder.append((Object)", ");
                        _builder.append((Object)valueVariableName);
                        _builder.append((Object)"->data, ");
                        _builder.append((Object)valueVariableName);
                        _builder.append((Object)"->length);");
                        _builder.newLineIfNotEmpty();
                    }
                };
                return this.codeFragmentProvider.create(_client);
            }
            StringConcatenationClient _client_1 = new StringConcatenationClient(){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    _builder.append((Object)"Retcode_T exception = NO_EXCEPTION;");
                    _builder.newLine();
                    _builder.append((Object)"CayenneLPPSerializer_Input_T cayenneLPPSerializerInput;");
                    _builder.newLine();
                    _builder.append((Object)"CayenneLPPSerializer_Output_T cayenneLPPSerializerOutput;");
                    _builder.newLine();
                    _builder.append((Object)"size_t bufferEntries = ");
                    _builder.append((Object)valueVariableName);
                    _builder.append((Object)"->length;");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"size_t bufferSize = 0;");
                    _builder.newLine();
                    _builder.append((Object)"for(size_t i = 0; i < bufferEntries; i++) {");
                    _builder.newLine();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"bufferSize += payloadSizes[");
                    _builder.append((Object)valueVariableName, "\t");
                    _builder.append((Object)"->data[i].tag];");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"}");
                    _builder.newLine();
                    _builder.append((Object)"uint8_t dataBuffer[bufferSize];");
                    _builder.newLine();
                    _builder.newLine();
                    _builder.append((Object)"cayenneLPPSerializerOutput.BufferPointer = dataBuffer;");
                    _builder.newLine();
                    _builder.append((Object)"for(size_t i = 0; i < bufferEntries; i++) {");
                    _builder.newLine();
                    _builder.append((Object)"\t ");
                    _builder.append((Object)"cayenneLPPSerializerInput.DataType = cayenneDataTypes[");
                    _builder.append((Object)valueVariableName, "\t ");
                    _builder.append((Object)"->data[i].tag];");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t ");
                    _builder.append((Object)"cayenneLPPSerializerInput.DataChannel = ");
                    _builder.append((Object)valueVariableName, "\t ");
                    _builder.append((Object)"->data[i].tag; // todo actually use some kind of channel here?");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t ");
                    _builder.append((Object)"switch(");
                    _builder.append((Object)valueVariableName, "\t ");
                    _builder.append((Object)"->data[i].tag) {");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t \t");
                    _builder.append((Object)"case CayennePayload_DigitalInput_e:");
                    _builder.newLine();
                    _builder.append((Object)"\t \t\t");
                    _builder.append((Object)"cayenneLPPSerializerInput.Data.DigitalInput.DigitalInputValue = ");
                    _builder.append((Object)valueVariableName, "\t \t\t");
                    _builder.append((Object)"->data[i].data.DigitalInput;");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t \t\t");
                    _builder.append((Object)"break;");
                    _builder.newLine();
                    _builder.append((Object)"\t \t");
                    _builder.append((Object)"case CayennePayload_DigitalOutput_e:");
                    _builder.newLine();
                    _builder.append((Object)"\t \t\t");
                    _builder.append((Object)"cayenneLPPSerializerInput.Data.DigitalOutput.DigitalOutputValue = ");
                    _builder.append((Object)valueVariableName, "\t \t\t");
                    _builder.append((Object)"->data[i].data.DigitalOutput;");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t \t\t");
                    _builder.append((Object)"break;");
                    _builder.newLine();
                    _builder.append((Object)"\t \t");
                    _builder.append((Object)"case CayennePayload_AnalogInput_e:");
                    _builder.newLine();
                    _builder.append((Object)"\t \t\t");
                    _builder.append((Object)"cayenneLPPSerializerInput.Data.AnalogInput.AnalogInputValue = ");
                    _builder.append((Object)valueVariableName, "\t \t\t");
                    _builder.append((Object)"->data[i].data.AnalogInput;");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t \t\t");
                    _builder.append((Object)"break;");
                    _builder.newLine();
                    _builder.append((Object)"\t \t");
                    _builder.append((Object)"case CayennePayload_AnalogOutput_e:");
                    _builder.newLine();
                    _builder.append((Object)"\t \t\t");
                    _builder.append((Object)"cayenneLPPSerializerInput.Data.AnalogOutput.AnalogOutputValue = ");
                    _builder.append((Object)valueVariableName, "\t \t\t");
                    _builder.append((Object)"->data[i].data.AnalogOutput;");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t \t\t");
                    _builder.append((Object)"break;");
                    _builder.newLine();
                    _builder.append((Object)"\t \t");
                    _builder.append((Object)"case CayennePayload_IlluminanceSensor_e:");
                    _builder.newLine();
                    _builder.append((Object)"\t \t\t");
                    _builder.append((Object)"cayenneLPPSerializerInput.Data.IlluminanceSensor.IlluminanceSensorValue = ");
                    _builder.append((Object)valueVariableName, "\t \t\t");
                    _builder.append((Object)"->data[i].data.IlluminanceSensor;");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t \t\t");
                    _builder.append((Object)"break;");
                    _builder.newLine();
                    _builder.append((Object)"\t \t");
                    _builder.append((Object)"case CayennePayload_PresenceSensor_e:");
                    _builder.newLine();
                    _builder.append((Object)"\t \t\t");
                    _builder.append((Object)"cayenneLPPSerializerInput.Data.PresenceSensor.PresenceSensorValue = ");
                    _builder.append((Object)valueVariableName, "\t \t\t");
                    _builder.append((Object)"->data[i].data.PresenceSensor;");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t \t\t");
                    _builder.append((Object)"break;");
                    _builder.newLine();
                    _builder.append((Object)"\t \t");
                    _builder.append((Object)"case CayennePayload_TemperatureSensor_e:");
                    _builder.newLine();
                    _builder.append((Object)"\t \t\t");
                    _builder.append((Object)"cayenneLPPSerializerInput.Data.TemperatureSensor.TemperatureSensorValue = ");
                    _builder.append((Object)valueVariableName, "\t \t\t");
                    _builder.append((Object)"->data[i].data.TemperatureSensor;");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t \t\t");
                    _builder.append((Object)"break;");
                    _builder.newLine();
                    _builder.append((Object)"\t \t");
                    _builder.append((Object)"case CayennePayload_HumiditySensor_e:");
                    _builder.newLine();
                    _builder.append((Object)"\t \t\t");
                    _builder.append((Object)"cayenneLPPSerializerInput.Data.HumiditySensor.HumiditySensorValue = ");
                    _builder.append((Object)valueVariableName, "\t \t\t");
                    _builder.append((Object)"->data[i].data.HumiditySensor;");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t \t\t");
                    _builder.append((Object)"break;");
                    _builder.newLine();
                    _builder.append((Object)"\t \t");
                    _builder.append((Object)"case CayennePayload_Accelerometer_e:");
                    _builder.newLine();
                    _builder.append((Object)"\t \t\t");
                    _builder.append((Object)"cayenneLPPSerializerInput.Data.Accelerometer.AccelerometerXValue = ");
                    _builder.append((Object)valueVariableName, "\t \t\t");
                    _builder.append((Object)"->data[i].data.Accelerometer._0;");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t \t\t");
                    _builder.append((Object)"cayenneLPPSerializerInput.Data.Accelerometer.AccelerometerYValue = ");
                    _builder.append((Object)valueVariableName, "\t \t\t");
                    _builder.append((Object)"->data[i].data.Accelerometer._1;");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t \t\t");
                    _builder.append((Object)"cayenneLPPSerializerInput.Data.Accelerometer.AccelerometerZValue = ");
                    _builder.append((Object)valueVariableName, "\t \t\t");
                    _builder.append((Object)"->data[i].data.Accelerometer._2;");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t \t\t");
                    _builder.append((Object)"break;");
                    _builder.newLine();
                    _builder.append((Object)"\t \t");
                    _builder.append((Object)"case CayennePayload_Barometer_e:");
                    _builder.newLine();
                    _builder.append((Object)"\t \t\t");
                    _builder.append((Object)"cayenneLPPSerializerInput.Data.Barometer.BarometerValue = ");
                    _builder.append((Object)valueVariableName, "\t \t\t");
                    _builder.append((Object)"->data[i].data.Barometer;");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t \t\t");
                    _builder.append((Object)"break;");
                    _builder.newLine();
                    _builder.append((Object)"\t \t");
                    _builder.append((Object)"case CayennePayload_Gyrometer_e:");
                    _builder.newLine();
                    _builder.append((Object)"\t \t\t");
                    _builder.append((Object)"cayenneLPPSerializerInput.Data.Gyrometer.GyrometerXValue = ");
                    _builder.append((Object)valueVariableName, "\t \t\t");
                    _builder.append((Object)"->data[i].data.Gyrometer._0;");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t \t\t");
                    _builder.append((Object)"cayenneLPPSerializerInput.Data.Gyrometer.GyrometerYValue = ");
                    _builder.append((Object)valueVariableName, "\t \t\t");
                    _builder.append((Object)"->data[i].data.Gyrometer._1;");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t \t\t");
                    _builder.append((Object)"cayenneLPPSerializerInput.Data.Gyrometer.GyrometerZValue = ");
                    _builder.append((Object)valueVariableName, "\t \t\t");
                    _builder.append((Object)"->data[i].data.Gyrometer._2;");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t \t\t");
                    _builder.append((Object)"break;");
                    _builder.newLine();
                    _builder.append((Object)"\t \t");
                    _builder.append((Object)"case CayennePayload_GpsLocation_e:");
                    _builder.newLine();
                    _builder.append((Object)"\t \t\t");
                    _builder.append((Object)"cayenneLPPSerializerInput.Data.GPSLocation.Latitude = ");
                    _builder.append((Object)valueVariableName, "\t \t\t");
                    _builder.append((Object)"->data[i].data.GpsLocation.Latitude; ");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t \t\t");
                    _builder.append((Object)"cayenneLPPSerializerInput.Data.GPSLocation.Longitude = ");
                    _builder.append((Object)valueVariableName, "\t \t\t");
                    _builder.append((Object)"->data[i].data.GpsLocation.Longitude; ");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t \t\t");
                    _builder.append((Object)"cayenneLPPSerializerInput.Data.GPSLocation.Altitude = ");
                    _builder.append((Object)valueVariableName, "\t \t\t");
                    _builder.append((Object)"->data[i].data.GpsLocation.Altitude; ");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t \t\t");
                    _builder.append((Object)"break;");
                    _builder.newLine();
                    _builder.append((Object)"\t ");
                    _builder.append((Object)"}");
                    _builder.newLine();
                    _builder.append((Object)"\t ");
                    _builder.append((Object)"exception = CayenneLPPSerializer_SingleInstance(&cayenneLPPSerializerInput, &cayenneLPPSerializerOutput);");
                    _builder.newLine();
                    _builder.append((Object)"\t ");
                    _builder.append((Object)"cayenneLPPSerializerOutput.BufferPointer += cayenneLPPSerializerOutput.BufferFilledLength;");
                    _builder.newLine();
                    _builder.append((Object)"}");
                    _builder.newLine();
                    _builder.append((Object)"return ");
                    _builder.append((Object)sendName);
                    _builder.append((Object)"(");
                    IGeneratorNode _code = LoraGenerator.this.statementGenerator.code((EObject)portNum);
                    _builder.append((Object)_code);
                    _builder.append((Object)", dataBuffer, bufferSize);");
                    _builder.newLineIfNotEmpty();
                }
            };
            return this.codeFragmentProvider.create(_client_1).addHeader("xdk110Types.h", false).addHeader("XDK_CayenneLPPSerializer.h", true);
        }
        return null;
    }
}

