/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mita.platform.xdk110.buses;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.mita.base.expressions.Expression;
import org.eclipse.mita.base.types.Enumerator;
import org.eclipse.mita.platform.xdk110.platform.ExceptionGenerator;
import org.eclipse.mita.program.ConfigurationItemValue;
import org.eclipse.mita.program.SignalInstance;
import org.eclipse.mita.program.SystemResourceSetup;
import org.eclipse.mita.program.generator.AbstractSystemResourceGenerator;
import org.eclipse.mita.program.generator.CodeFragment;
import org.eclipse.mita.program.generator.GeneratorUtils;
import org.eclipse.mita.program.generator.StatementGenerator;
import org.eclipse.mita.program.inferrer.StaticValueInferrer;
import org.eclipse.mita.program.model.ModelUtils;
import org.eclipse.xtend2.lib.StringConcatenationClient;
import org.eclipse.xtext.generator.trace.node.IGeneratorNode;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;

public class I2CGenerator
extends AbstractSystemResourceGenerator {
    @Inject
    @Extension
    private StatementGenerator statementGenerator;
    @Inject
    @Extension
    private GeneratorUtils generatorUtils;
    @Inject
    private ExceptionGenerator exceptionGenerator;

    public CodeFragment generateSetup() {
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append((Object)"Retcode_T exception = RETCODE_OK;");
                _builder.newLine();
                _builder.newLine();
                _builder.append((Object)"Board_EnablePowerSupply3V3(EXTENSION_BOARD);");
                _builder.newLine();
                _builder.append((Object)"Board_WakeupPowerSupply2V5(EXTENSION_BOARD);");
                _builder.newLine();
                _builder.newLine();
                _builder.append((Object)"BSP_Board_Delay(5);");
                _builder.newLine();
                _builder.newLine();
                _builder.append((Object)"exception = BSP_ExtensionPort_ConnectI2c();");
                _builder.newLine();
                _builder.append((Object)"if(RETCODE_OK != exception) {");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"printf(\"connect failed\\n\");");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"return exception;");
                _builder.newLine();
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.newLine();
                _builder.append((Object)"handle = BSP_ExtensionPort_GetI2cHandle();");
                _builder.newLine();
                _builder.append((Object)"if(NULL == handle) {");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"printf(\"handle null\\n\");");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"return EXCEPTION_NOVALUEEXCEPTION;");
                _builder.newLine();
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.append((Object)"exception = I2CTransceiver_Init(&tranceiverStruct, handle);");
                _builder.newLine();
                _builder.append((Object)"if(RETCODE_OK != exception) {");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"printf(\"i2ctransceiver_init failed\\n\");");
                _builder.newLine();
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.newLine();
                _builder.append((Object)"exception = MCU_I2C_Initialize(handle, &i2cCallback);");
                _builder.newLine();
                _builder.append((Object)"if(RETCODE_OK != exception) {");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"printf(\"MCU_I2C_Initialize failed\\n\");");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"return exception;");
                _builder.newLine();
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.append((Object)"\t\t");
                _builder.newLine();
                _builder.append((Object)"exception = BSP_ExtensionPort_EnableI2c();");
                _builder.newLine();
                _builder.newLine();
                _builder.append((Object)"return exception;");
                _builder.newLine();
            }
        };
        CodeFragment _addHeader = this.codeFragmentProvider.create(_client).addHeader("BSP_ExtensionPort.h", true).addHeader("BCDS_MCU_I2C.h", true).addHeader("BCDS_I2CTransceiver.h", true).addHeader("FreeRTOS.h", true, 10000).addHeader("semphr.h", true).addHeader("BSP_BoardType.h", true).addHeader("BSP_BoardShared.h", true);
        StringConcatenationClient _client_1 = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append((Object)"static HWHandle_T handle;");
                _builder.newLine();
                _builder.append((Object)"static struct I2cTranceiverHandle_S tranceiverStruct;");
                _builder.newLine();
                _builder.newLine();
                _builder.append((Object)"static void i2cCallback(I2C_T i2c, struct MCU_I2C_Event_S event) {");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"I2CTransceiver_LoopCallback(&tranceiverStruct, event);");
                _builder.newLine();
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.newLine();
                _builder.append((Object)"static void swapByteOrder(uint8_t* buffer, size_t objectSize, size_t objectCount) {");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"for(uint32_t i = 0; i < objectCount; i++) {");
                _builder.newLine();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"for(uint32_t off = 0; off < (objectSize >> 1); off++) {");
                _builder.newLine();
                _builder.append((Object)"\t\t\t");
                _builder.append((Object)"uint8_t left  = buffer[objectSize*i + off];");
                _builder.newLine();
                _builder.append((Object)"\t\t\t");
                _builder.append((Object)"uint8_t right = buffer[objectSize*(i+1) - off - 1];");
                _builder.newLine();
                _builder.newLine();
                _builder.append((Object)"\t\t\t");
                _builder.append((Object)"buffer[objectSize*i + off] = right;");
                _builder.newLine();
                _builder.append((Object)"\t\t\t");
                _builder.append((Object)"buffer[objectSize*(i+1) - off - 1] = left;");
                _builder.newLine();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.append((Object)"}");
                _builder.newLine();
            }
        };
        return _addHeader.setPreamble(_client_1);
    }

    public CodeFragment generateEnable() {
        return CodeFragment.EMPTY;
    }

    private int getWidth(String register_width) {
        int _xblockexpression = 0;
        String _xifexpression = null;
        boolean _startsWith = register_width.startsWith("array_");
        _xifexpression = _startsWith ? register_width.substring("array_register_".length()) : register_width.substring("register_".length());
        String regName = _xifexpression;
        int _switchResult = 0;
        boolean _matched = false;
        if (Objects.equal((Object)regName, (Object)"int8")) {
            _matched = true;
            _switchResult = 1;
        }
        if (!_matched && Objects.equal((Object)regName, (Object)"uint8")) {
            _matched = true;
            _switchResult = 1;
        }
        if (!_matched && Objects.equal((Object)regName, (Object)"int16")) {
            _matched = true;
            _switchResult = 2;
        }
        if (!_matched && Objects.equal((Object)regName, (Object)"uint16")) {
            _matched = true;
            _switchResult = 2;
        }
        if (!_matched && Objects.equal((Object)regName, (Object)"int32")) {
            _matched = true;
            _switchResult = 4;
        }
        if (!_matched && Objects.equal((Object)regName, (Object)"uint32")) {
            _matched = true;
            _switchResult = 4;
        }
        _xblockexpression = _switchResult;
        return _xblockexpression;
    }

    private Boolean shouldSwapByteOrder(SignalInstance sigInst) {
        Procedures.Procedure1<EObject> _function_1;
        Expression byteOrder;
        Object enumVal;
        EObject _eContainer = sigInst.eContainer();
        SystemResourceSetup setup = (SystemResourceSetup)_eContainer;
        Functions.Function1<ConfigurationItemValue, Boolean> _function = new Functions.Function1<ConfigurationItemValue, Boolean>(){

            public Boolean apply(ConfigurationItemValue it) {
                String _name = it.getItem().getName();
                return Objects.equal((Object)_name, (Object)"byteOrder");
            }
        };
        ConfigurationItemValue _findFirst = (ConfigurationItemValue)IterableExtensions.findFirst((Iterable)setup.getConfigurationItemValues(), (Functions.Function1)_function);
        Expression _value = null;
        if (_findFirst != null) {
            _value = _findFirst.getValue();
        }
        if ((enumVal = StaticValueInferrer.infer((EObject)(byteOrder = _value), (Procedures.Procedure1)(_function_1 = new Procedures.Procedure1<EObject>(){

            public void apply(EObject it) {
            }
        }))) instanceof Enumerator) {
            String _name = ((Enumerator)enumVal).getName();
            return Objects.equal((Object)_name, (Object)"BigEndian");
        }
        return false;
    }

    private ByteOrderInfo swapByteOrder(SignalInstance sigInst, final CodeFragment elementSize, final CodeFragment elementCount, final CodeFragment dataHandle, final Boolean copy) {
        boolean _not;
        Boolean _shouldSwapByteOrder = this.shouldSwapByteOrder(sigInst);
        boolean bl = _not = _shouldSwapByteOrder == false;
        if (_not) {
            return new ByteOrderInfo(dataHandle);
        }
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append((Object)"data_asBytes");
            }
        };
        final CodeFragment dh = this.codeFragmentProvider.create(_client);
        StringConcatenationClient _client_1 = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                if (copy.booleanValue()) {
                    _builder.append((Object)"uint8_t ");
                    _builder.append((Object)dh);
                    _builder.append((Object)"[");
                    _builder.append((Object)elementCount);
                    _builder.append((Object)" * ");
                    _builder.append((Object)elementSize);
                    _builder.append((Object)"];");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"memcpy(");
                    _builder.append((Object)dh);
                    _builder.append((Object)", ");
                    _builder.append((Object)dataHandle);
                    _builder.append((Object)", ");
                    _builder.append((Object)elementCount);
                    _builder.append((Object)" * ");
                    _builder.append((Object)elementSize);
                    _builder.append((Object)");");
                    _builder.newLineIfNotEmpty();
                } else {
                    _builder.append((Object)"uint8_t* ");
                    _builder.append((Object)dh);
                    _builder.append((Object)" = ");
                    _builder.append((Object)dataHandle);
                    _builder.append((Object)";");
                    _builder.newLineIfNotEmpty();
                }
            }
        };
        CodeFragment dd = this.codeFragmentProvider.create(_client_1);
        StringConcatenationClient _client_2 = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append((Object)"swapByteOrder(");
                _builder.append((Object)dh);
                _builder.append((Object)", ");
                _builder.append((Object)elementSize);
                _builder.append((Object)", ");
                _builder.append((Object)elementCount);
                _builder.append((Object)");");
                _builder.newLineIfNotEmpty();
            }
        };
        CodeFragment bos = this.codeFragmentProvider.create(_client_2);
        return new ByteOrderInfo(dh, dd, bos);
    }

    public CodeFragment generateSignalInstanceSetter(final SignalInstance signalInstance, final String resultName) {
        CodeFragment _xblockexpression = null;
        final Expression busAddress = this.setup.getConfigurationItemValue("deviceAddress");
        final Expression registerAddress = ModelUtils.getArgumentValue((SignalInstance)signalInstance, (String)"address");
        Procedures.Procedure1<EObject> _function = new Procedures.Procedure1<EObject>(){

            public void apply(EObject it) {
            }
        };
        Object mode = StaticValueInferrer.infer((EObject)ModelUtils.getArgumentValue((SignalInstance)signalInstance, (String)"mode"), (Procedures.Procedure1)_function);
        if (mode instanceof Enumerator) {
            boolean _contains = ((Enumerator)mode).getName().contains("Write");
            boolean bl = !_contains;
        }
        final String signalName = signalInstance.getInstanceOf().getName();
        boolean isArray = signalName.startsWith("array_register");
        CodeFragment _xifexpression = null;
        if (isArray) {
            StringConcatenationClient _client = new StringConcatenationClient(){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    _builder.append((Object)"if(");
                    _builder.append((Object)resultName);
                    _builder.append((Object)"->length != ");
                    IGeneratorNode _noTerminator = I2CGenerator.this.generatorUtils.noTerminator(I2CGenerator.this.statementGenerator.code((EObject)ModelUtils.getArgumentValue((SignalInstance)signalInstance, (String)"length")));
                    _builder.append((Object)_noTerminator);
                    _builder.append((Object)") {");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"return EXCEPTION_INDEXOUTOFBOUNDSEXCEPTION;");
                    _builder.newLine();
                    _builder.append((Object)"}");
                    _builder.newLine();
                }
            };
            _xifexpression = this.codeFragmentProvider.create(_client);
        } else {
            _xifexpression = CodeFragment.EMPTY;
        }
        final CodeFragment preamble = _xifexpression;
        CodeFragment _xifexpression_1 = null;
        if (isArray) {
            StringConcatenationClient _client_1 = new StringConcatenationClient(){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    _builder.append((Object)"(uint8_t*) ");
                    _builder.append((Object)resultName);
                    _builder.append((Object)"->data");
                }
            };
            _xifexpression_1 = this.codeFragmentProvider.create(_client_1);
        } else {
            StringConcatenationClient _client_2 = new StringConcatenationClient(){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    _builder.append((Object)resultName);
                }
            };
            _xifexpression_1 = this.codeFragmentProvider.create(_client_2);
        }
        CodeFragment data = _xifexpression_1;
        CodeFragment _xifexpression_2 = null;
        if (isArray) {
            StringConcatenationClient _client_3 = new StringConcatenationClient(){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    _builder.append((Object)resultName);
                    _builder.append((Object)"->length");
                }
            };
            _xifexpression_2 = this.codeFragmentProvider.create(_client_3);
        } else {
            StringConcatenationClient _client_4 = new StringConcatenationClient(){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    _builder.append((Object)"1");
                }
            };
            _xifexpression_2 = this.codeFragmentProvider.create(_client_4);
        }
        CodeFragment dataCount = _xifexpression_2;
        CodeFragment _xifexpression_3 = null;
        if (isArray) {
            StringConcatenationClient _client_5 = new StringConcatenationClient(){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    _builder.append((Object)resultName);
                    _builder.append((Object)"->length * ");
                    int _width = I2CGenerator.this.getWidth(signalName);
                    _builder.append((Object)_width);
                }
            };
            _xifexpression_3 = this.codeFragmentProvider.create(_client_5);
        } else {
            StringConcatenationClient _client_6 = new StringConcatenationClient(){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    int _width = I2CGenerator.this.getWidth(signalName);
                    _builder.append((Object)_width);
                }
            };
            _xifexpression_3 = this.codeFragmentProvider.create(_client_6);
        }
        final CodeFragment byteCount = _xifexpression_3;
        StringConcatenationClient _client_7 = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                int _width = I2CGenerator.this.getWidth(signalName);
                _builder.append((Object)_width);
            }
        };
        final ByteOrderInfo boi = this.swapByteOrder(signalInstance, this.codeFragmentProvider.create(_client_7), dataCount, data, true);
        StringConcatenationClient _client_8 = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append((Object)preamble);
                _builder.newLineIfNotEmpty();
                _builder.append((Object)boi.bufferDeclaration);
                _builder.newLineIfNotEmpty();
                _builder.append((Object)boi.byteOrderSwap);
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"return I2CTransceiver_Write(&tranceiverStruct, ");
                IGeneratorNode _noTerminator = I2CGenerator.this.generatorUtils.noTerminator(I2CGenerator.this.statementGenerator.code((EObject)busAddress));
                _builder.append((Object)_noTerminator);
                _builder.append((Object)", ");
                IGeneratorNode _noTerminator_1 = I2CGenerator.this.generatorUtils.noTerminator(I2CGenerator.this.statementGenerator.code((EObject)registerAddress));
                _builder.append((Object)_noTerminator_1);
                _builder.append((Object)", ");
                _builder.append((Object)boi.bufferName);
                _builder.append((Object)", ");
                _builder.append((Object)byteCount);
                _builder.append((Object)");");
                _builder.newLineIfNotEmpty();
            }
        };
        _xblockexpression = this.codeFragmentProvider.create(_client_8).addHeader("MitaExceptions.h", false).addHeader("MitaGeneratedTypes.h", false);
        return _xblockexpression;
    }

    public CodeFragment generateSignalInstanceGetter(final SignalInstance signalInstance, final String resultName) {
        CodeFragment _xblockexpression = null;
        final Expression busAddress = this.setup.getConfigurationItemValue("deviceAddress");
        final Expression registerAddress = ModelUtils.getArgumentValue((SignalInstance)signalInstance, (String)"address");
        Procedures.Procedure1<EObject> _function = new Procedures.Procedure1<EObject>(){

            public void apply(EObject it) {
            }
        };
        Object mode = StaticValueInferrer.infer((EObject)ModelUtils.getArgumentValue((SignalInstance)signalInstance, (String)"mode"), (Procedures.Procedure1)_function);
        if (mode instanceof Enumerator) {
            boolean _contains = ((Enumerator)mode).getName().contains("Read");
            boolean bl = !_contains;
        }
        final String signalName = signalInstance.getInstanceOf().getName();
        boolean isArray = signalName.startsWith("array_register");
        CodeFragment _xifexpression = null;
        if (isArray) {
            StringConcatenationClient _client = new StringConcatenationClient(){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    _builder.append((Object)"if(");
                    _builder.append((Object)resultName);
                    _builder.append((Object)"->length != ");
                    IGeneratorNode _noTerminator = I2CGenerator.this.generatorUtils.noTerminator(I2CGenerator.this.statementGenerator.code((EObject)ModelUtils.getArgumentValue((SignalInstance)signalInstance, (String)"length")));
                    _builder.append((Object)_noTerminator);
                    _builder.append((Object)") {");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"return EXCEPTION_INDEXOUTOFBOUNDSEXCEPTION;");
                    _builder.newLine();
                    _builder.append((Object)"}");
                    _builder.newLine();
                }
            };
            _xifexpression = this.codeFragmentProvider.create(_client);
        } else {
            _xifexpression = CodeFragment.EMPTY;
        }
        final CodeFragment preamble = _xifexpression;
        CodeFragment _xifexpression_1 = null;
        if (isArray) {
            StringConcatenationClient _client_1 = new StringConcatenationClient(){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    _builder.append((Object)"(uint8_t*) ");
                    _builder.append((Object)resultName);
                    _builder.append((Object)"->data");
                }
            };
            _xifexpression_1 = this.codeFragmentProvider.create(_client_1);
        } else {
            StringConcatenationClient _client_2 = new StringConcatenationClient(){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    _builder.append((Object)"(uint8_t*) ");
                    _builder.append((Object)resultName);
                }
            };
            _xifexpression_1 = this.codeFragmentProvider.create(_client_2);
        }
        CodeFragment data = _xifexpression_1;
        CodeFragment _xifexpression_2 = null;
        if (isArray) {
            StringConcatenationClient _client_3 = new StringConcatenationClient(){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    _builder.append((Object)resultName);
                    _builder.append((Object)"->length");
                }
            };
            _xifexpression_2 = this.codeFragmentProvider.create(_client_3);
        } else {
            StringConcatenationClient _client_4 = new StringConcatenationClient(){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    _builder.append((Object)"1");
                }
            };
            _xifexpression_2 = this.codeFragmentProvider.create(_client_4);
        }
        CodeFragment dataCount = _xifexpression_2;
        CodeFragment _xifexpression_3 = null;
        if (isArray) {
            StringConcatenationClient _client_5 = new StringConcatenationClient(){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    _builder.append((Object)resultName);
                    _builder.append((Object)"->length * ");
                    int _width = I2CGenerator.this.getWidth(signalName);
                    _builder.append((Object)_width);
                }
            };
            _xifexpression_3 = this.codeFragmentProvider.create(_client_5);
        } else {
            StringConcatenationClient _client_6 = new StringConcatenationClient(){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    int _width = I2CGenerator.this.getWidth(signalName);
                    _builder.append((Object)_width);
                }
            };
            _xifexpression_3 = this.codeFragmentProvider.create(_client_6);
        }
        final CodeFragment byteCount = _xifexpression_3;
        StringConcatenationClient _client_7 = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                int _width = I2CGenerator.this.getWidth(signalName);
                _builder.append((Object)_width);
            }
        };
        final ByteOrderInfo boi = this.swapByteOrder(signalInstance, this.codeFragmentProvider.create(_client_7), dataCount, data, false);
        StringConcatenationClient _client_8 = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                CodeFragment _exceptionType = I2CGenerator.this.exceptionGenerator.getExceptionType();
                _builder.append((Object)_exceptionType);
                _builder.append((Object)" exception = ");
                IGeneratorNode _noTerminator = I2CGenerator.this.generatorUtils.noTerminator((IGeneratorNode)I2CGenerator.this.exceptionGenerator.getNoExceptionStatement());
                _builder.append((Object)_noTerminator);
                _builder.append((Object)";");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)preamble);
                _builder.newLineIfNotEmpty();
                _builder.append((Object)boi.bufferDeclaration);
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"exception = I2CTransceiver_Read(&tranceiverStruct, ");
                IGeneratorNode _noTerminator_1 = I2CGenerator.this.generatorUtils.noTerminator(I2CGenerator.this.statementGenerator.code((EObject)busAddress));
                _builder.append((Object)_noTerminator_1);
                _builder.append((Object)", ");
                IGeneratorNode _noTerminator_2 = I2CGenerator.this.generatorUtils.noTerminator(I2CGenerator.this.statementGenerator.code((EObject)registerAddress));
                _builder.append((Object)_noTerminator_2);
                _builder.append((Object)", ");
                _builder.append((Object)boi.bufferName);
                _builder.append((Object)", ");
                _builder.append((Object)byteCount);
                _builder.append((Object)");");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)boi.byteOrderSwap);
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"return exception;");
                _builder.newLine();
            }
        };
        _xblockexpression = this.codeFragmentProvider.create(_client_8).addHeader("MitaExceptions.h", false).addHeader("MitaGeneratedTypes.h", false);
        return _xblockexpression;
    }

    private static class ByteOrderInfo {
        public final CodeFragment bufferName;
        public final CodeFragment bufferDeclaration;
        public final CodeFragment byteOrderSwap;

        public ByteOrderInfo(CodeFragment bn, CodeFragment bd, CodeFragment bos) {
            this.bufferName = bn;
            this.bufferDeclaration = bd;
            this.byteOrderSwap = bos;
        }

        public ByteOrderInfo(CodeFragment bn) {
            this.bufferName = bn;
            this.bufferDeclaration = CodeFragment.EMPTY;
            this.byteOrderSwap = CodeFragment.EMPTY;
        }
    }
}

