/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mita.platform.xdk110.buses;

import java.util.Collections;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.mita.base.types.Enumerator;
import org.eclipse.mita.program.SignalInstance;
import org.eclipse.mita.program.generator.AbstractSystemResourceGenerator;
import org.eclipse.mita.program.generator.CodeFragment;
import org.eclipse.mita.program.inferrer.StaticValueInferrer;
import org.eclipse.mita.program.model.ModelUtils;
import org.eclipse.xtend2.lib.StringConcatenationClient;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Pair;
import org.eclipse.xtext.xbase.lib.Procedures;

public class GPIOGenerator
extends AbstractSystemResourceGenerator {
    private final Map<String, String> modeTable = Collections.unmodifiableMap(CollectionLiterals.newHashMap((Pair[])new Pair[]{Pair.of((Object)"NoPull", (Object)"BSP_EXTENSIONPORT_INPUT_NOPULL"), Pair.of((Object)"PullUp", (Object)"BSP_EXTENSIONPORT_INPUT_PULLUP"), Pair.of((Object)"PullDown", (Object)"BSP_EXTENSIONPORT_INPUT_PULLDOWN"), Pair.of((Object)"PullUpFilter", (Object)"BSP_EXTENSIONPORT_INPUTPULLFILTER")}));
    private final Map<String, Boolean> defaultValues = Collections.unmodifiableMap(CollectionLiterals.newHashMap((Pair[])new Pair[]{Pair.of((Object)"NoPull", (Object)false), Pair.of((Object)"PullUp", (Object)true), Pair.of((Object)"PullDown", (Object)false), Pair.of((Object)"PullUpFilter", (Object)true)}));

    public CodeFragment generateSetup() {
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append((Object)"Retcode_T exception = RETCODE_OK;");
                _builder.newLine();
                _builder.newLine();
                _builder.append((Object)"BSP_Board_Delay(2000);");
                _builder.newLine();
                _builder.newLine();
                _builder.append((Object)"exception = BSP_ExtensionPort_Connect();");
                _builder.newLine();
                _builder.append((Object)"if(RETCODE_OK != exception) {");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"printf(\"ExtensionPort_Connect failed\");");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"return exception;");
                _builder.newLine();
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.newLine();
                _builder.append((Object)"BSP_Board_Delay(5);");
                _builder.newLine();
                _builder.newLine();
                EList _signalInstances = GPIOGenerator.this.setup.getSignalInstances();
                for (SignalInstance sigInst : _signalInstances) {
                    _builder.append((Object)"exception = BSP_ExtensionPort_ConnectGpio(");
                    CodeFragment _pin = GPIOGenerator.this.getPin(sigInst);
                    _builder.append((Object)_pin);
                    _builder.append((Object)");");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"if(RETCODE_OK != exception) {");
                    _builder.newLine();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"printf(\"connection of pin ");
                    CodeFragment _pinName = GPIOGenerator.this.getPinName(sigInst);
                    _builder.append((Object)_pinName, "\t");
                    _builder.append((Object)" failed\\n\");");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"return exception;");
                    _builder.newLine();
                    _builder.append((Object)"}");
                    _builder.newLine();
                    _builder.newLine();
                    _builder.append((Object)"exception = BSP_ExtensionPort_SetGpioConfig(");
                    CodeFragment _pin_1 = GPIOGenerator.this.getPin(sigInst);
                    _builder.append((Object)_pin_1);
                    _builder.append((Object)", BSP_EXTENSIONPORT_GPIO_PINMODE, ");
                    CodeFragment _pinMode = GPIOGenerator.this.getPinMode(sigInst);
                    _builder.append((Object)_pinMode);
                    _builder.append((Object)", NULL);");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"if(RETCODE_OK != exception) {");
                    _builder.newLine();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"printf(\"configuring pin mode for pin ");
                    CodeFragment _pinName_1 = GPIOGenerator.this.getPinName(sigInst);
                    _builder.append((Object)_pinName_1, "\t");
                    _builder.append((Object)" failed\\n\");");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"return exception;");
                    _builder.newLine();
                    _builder.append((Object)"}");
                    _builder.newLine();
                    _builder.newLine();
                    _builder.append((Object)"exception = BSP_ExtensionPort_SetGpioConfig(");
                    CodeFragment _pin_2 = GPIOGenerator.this.getPin(sigInst);
                    _builder.append((Object)_pin_2);
                    _builder.append((Object)", BSP_EXTENSIONPORT_GPIO_PINVALUE, ");
                    CodeFragment _pinValue = GPIOGenerator.this.getPinValue(sigInst);
                    _builder.append((Object)_pinValue);
                    _builder.append((Object)", NULL);");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"if(RETCODE_OK != exception) {");
                    _builder.newLine();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"printf(\"configuring pin value for pin ");
                    CodeFragment _pinName_2 = GPIOGenerator.this.getPinName(sigInst);
                    _builder.append((Object)_pinName_2, "\t");
                    _builder.append((Object)" failed\\n\");");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"return exception;");
                    _builder.newLine();
                    _builder.append((Object)"}");
                    _builder.newLine();
                    _builder.newLine();
                    _builder.append((Object)"exception = BSP_ExtensionPort_EnableGpio(");
                    CodeFragment _pin_3 = GPIOGenerator.this.getPin(sigInst);
                    _builder.append((Object)_pin_3);
                    _builder.append((Object)");");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"if(RETCODE_OK != exception) {");
                    _builder.newLine();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"printf(\"enabling pin ");
                    CodeFragment _pinName_3 = GPIOGenerator.this.getPinName(sigInst);
                    _builder.append((Object)_pinName_3, "\t");
                    _builder.append((Object)" failed\\n\");");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"return exception;");
                    _builder.newLine();
                    _builder.append((Object)"}");
                    _builder.newLine();
                    _builder.newLine();
                }
                _builder.newLine();
                _builder.append((Object)"return exception;");
                _builder.newLine();
            }
        };
        return this.codeFragmentProvider.create(_client).addHeader("BSP_ExtensionPort.h", true).addHeader("BCDS_MCU_GPIO.h", true).addHeader("BSP_BoardShared.h", true);
    }

    public CodeFragment getPinMode(SignalInstance sigInst) {
        boolean isOutput = sigInst.getInstanceOf().getName().contains("Out");
        if (isOutput) {
            StringConcatenationClient _client = new StringConcatenationClient(){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    _builder.append((Object)"BSP_EXTENSIONPORT_PUSHPULL");
                }
            };
            return this.codeFragmentProvider.create(_client);
        }
        Procedures.Procedure1<EObject> _function = new Procedures.Procedure1<EObject>(){

            public void apply(EObject it) {
            }
        };
        final Object mode = StaticValueInferrer.infer((EObject)ModelUtils.getArgumentValue((SignalInstance)sigInst, (String)"mode"), (Procedures.Procedure1)_function);
        if (mode instanceof Enumerator) {
            StringConcatenationClient _client_1 = new StringConcatenationClient(){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    String _orDefault = GPIOGenerator.this.modeTable.getOrDefault(((Enumerator)mode).getName(), "ERROR_INVALID_ENUM_VALUE");
                    _builder.append((Object)_orDefault);
                }
            };
            return this.codeFragmentProvider.create(_client_1);
        }
        return CodeFragment.EMPTY;
    }

    public CodeFragment getPinValue(SignalInstance sigInst) {
        boolean isOutput = sigInst.getInstanceOf().getName().contains("Out");
        if (isOutput) {
            Procedures.Procedure1<EObject> _function = new Procedures.Procedure1<EObject>(){

                public void apply(EObject it) {
                }
            };
            final Object defaultVal = StaticValueInferrer.infer((EObject)ModelUtils.getArgumentValue((SignalInstance)sigInst, (String)"initialValue"), (Procedures.Procedure1)_function);
            if (defaultVal instanceof Boolean) {
                StringConcatenationClient _client = new StringConcatenationClient(){

                    protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                        _builder.append((Object)"BSP_EXTENSIONPORT_GPIO_PIN_");
                        String _xifexpression = null;
                        _xifexpression = (Boolean)defaultVal != false ? "HIGH" : "LOW";
                        _builder.append((Object)_xifexpression);
                    }
                };
                return this.codeFragmentProvider.create(_client);
            }
        } else {
            Boolean defaultVal_1;
            Procedures.Procedure1<EObject> _function_1 = new Procedures.Procedure1<EObject>(){

                public void apply(EObject it) {
                }
            };
            Object mode = StaticValueInferrer.infer((EObject)ModelUtils.getArgumentValue((SignalInstance)sigInst, (String)"mode"), (Procedures.Procedure1)_function_1);
            if (mode instanceof Enumerator && (defaultVal_1 = this.defaultValues.get(((Enumerator)mode).getName())) != null) {
                StringConcatenationClient _client_1 = new StringConcatenationClient(){

                    protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                        _builder.append((Object)"BSP_EXTENSIONPORT_GPIO_PIN_");
                        String _xifexpression = null;
                        _xifexpression = defaultVal_1 != false ? "HIGH" : "LOW";
                        _builder.append((Object)_xifexpression);
                    }
                };
                return this.codeFragmentProvider.create(_client_1);
            }
        }
        return CodeFragment.EMPTY;
    }

    public CodeFragment getPinName(SignalInstance sigInst) {
        Procedures.Procedure1<EObject> _function = new Procedures.Procedure1<EObject>(){

            public void apply(EObject it) {
            }
        };
        final Object enumValue = StaticValueInferrer.infer((EObject)ModelUtils.getArgumentValue((SignalInstance)sigInst, (String)"pin"), (Procedures.Procedure1)_function);
        if (enumValue instanceof Enumerator) {
            StringConcatenationClient _client = new StringConcatenationClient(){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    String _name = ((Enumerator)enumValue).getName();
                    _builder.append((Object)_name);
                }
            };
            return this.codeFragmentProvider.create(_client);
        }
        return CodeFragment.EMPTY;
    }

    public CodeFragment getPin(final SignalInstance sigInst) {
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append((Object)"BSP_EXTENSIONPORT_GPIO_");
                CodeFragment _pinName = GPIOGenerator.this.getPinName(sigInst);
                _builder.append((Object)_pinName);
            }
        };
        return this.codeFragmentProvider.create(_client);
    }

    public CodeFragment generateEnable() {
        return CodeFragment.EMPTY;
    }

    public CodeFragment generateSignalInstanceGetter(final SignalInstance sigInst, final String resultName) {
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append((Object)"return BSP_ExtensionPort_ReadGpio(");
                CodeFragment _pin = GPIOGenerator.this.getPin(sigInst);
                _builder.append((Object)_pin);
                _builder.append((Object)", ");
                _builder.append((Object)resultName);
                _builder.append((Object)");");
            }
        };
        return this.codeFragmentProvider.create(_client);
    }

    public CodeFragment generateSignalInstanceSetter(final SignalInstance sigInst, final String valueVariableName) {
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append((Object)"if(*");
                _builder.append((Object)valueVariableName);
                _builder.append((Object)") {");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t");
                _builder.append((Object)"return BSP_ExtensionPort_SetGpio(");
                CodeFragment _pin = GPIOGenerator.this.getPin(sigInst);
                _builder.append((Object)_pin, "\t");
                _builder.append((Object)");");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"} else {");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"return BSP_ExtensionPort_ClearGpio(");
                CodeFragment _pin_1 = GPIOGenerator.this.getPin(sigInst);
                _builder.append((Object)_pin_1, "\t");
                _builder.append((Object)");");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"}");
                _builder.newLine();
            }
        };
        return this.codeFragmentProvider.create(_client);
    }
}

