/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mita.base.types.validation;

import com.google.inject.Inject;
import java.util.List;
import org.eclipse.mita.base.types.ComplexType;
import org.eclipse.mita.base.types.inferrer.ITypeSystemInferrer;
import org.eclipse.mita.base.types.typesystem.ITypeSystem;
import org.eclipse.mita.base.types.validation.IValidationIssueAcceptor;

public class TypeValidator {
    @Inject
    protected ITypeSystem registry;

    public void assertNotType(ITypeSystemInferrer.InferenceResult currentResult, String msg_finalParam_, IValidationIssueAcceptor acceptor, ITypeSystemInferrer.InferenceResult ... candidates) {
        String msg = msg_finalParam_;
        if (currentResult == null) {
            return;
        }
        ITypeSystemInferrer.InferenceResult[] inferenceResultArray = candidates;
        int n = candidates.length;
        int n2 = 0;
        while (n2 < n) {
            ITypeSystemInferrer.InferenceResult type = inferenceResultArray[n2];
            boolean _isSame = this.registry.isSame(currentResult.getType(), type.getType());
            if (_isSame) {
                String _xifexpression = null;
                _xifexpression = msg != null ? msg : String.format("Expected type is not %s.", currentResult);
                msg = _xifexpression;
                IValidationIssueAcceptor.ValidationIssue _validationIssue = new IValidationIssueAcceptor.ValidationIssue(IValidationIssueAcceptor.ValidationIssue.Severity.ERROR, msg, "NotType");
                acceptor.accept(_validationIssue);
            }
            ++n2;
        }
    }

    public void assertSame(ITypeSystemInferrer.InferenceResult result1, ITypeSystemInferrer.InferenceResult result2, String msg_finalParam_, IValidationIssueAcceptor acceptor) {
        boolean _not;
        String msg = msg_finalParam_;
        if (result1 == null || result2 == null) {
            return;
        }
        boolean _isSame = this.registry.isSame(result1.getType(), result2.getType());
        boolean bl = _not = !_isSame;
        if (_not) {
            String _xifexpression = null;
            _xifexpression = msg != null ? msg : String.format("Expected types %s and %s are same.", result1, result2);
            msg = _xifexpression;
            IValidationIssueAcceptor.ValidationIssue _validationIssue = new IValidationIssueAcceptor.ValidationIssue(IValidationIssueAcceptor.ValidationIssue.Severity.ERROR, msg, "NotSame");
            acceptor.accept(_validationIssue);
            return;
        }
        this.assertTypeBindingsSame(result1, result2, msg, acceptor);
    }

    public void assertCompatible(ITypeSystemInferrer.InferenceResult result1, ITypeSystemInferrer.InferenceResult result2, String msg_finalParam_, IValidationIssueAcceptor acceptor) {
        boolean _not;
        String msg = msg_finalParam_;
        if (result1 == null || result2 == null || this.isNullOnComplexType(result1, result2) || this.isNullOnComplexType(result2, result1)) {
            return;
        }
        boolean _haveCommonType = this.registry.haveCommonType(result1.getType(), result2.getType());
        boolean bl = _not = !_haveCommonType;
        if (_not) {
            String _xifexpression = null;
            _xifexpression = msg != null ? msg : String.format("Incompatible types %s and %s.", result1, result2);
            msg = _xifexpression;
            IValidationIssueAcceptor.ValidationIssue _validationIssue = new IValidationIssueAcceptor.ValidationIssue(IValidationIssueAcceptor.ValidationIssue.Severity.ERROR, msg, "IncompatibleTypes");
            acceptor.accept(_validationIssue);
            return;
        }
        this.assertTypeBindingsSame(result1, result2, msg, acceptor);
    }

    public void assertAssignable(ITypeSystemInferrer.InferenceResult varResult, ITypeSystemInferrer.InferenceResult valueResult, String msg_finalParam_, IValidationIssueAcceptor acceptor) {
        boolean _not;
        String msg = msg_finalParam_;
        if (varResult == null || valueResult == null || this.isNullOnComplexType(varResult, valueResult)) {
            return;
        }
        boolean _isSuperType = this.registry.isSuperType(valueResult.getType(), varResult.getType());
        boolean bl = _not = !_isSuperType;
        if (_not) {
            String _xifexpression = null;
            _xifexpression = msg != null ? msg : String.format("Incompatible types %s and %s.", varResult, valueResult);
            msg = _xifexpression;
            IValidationIssueAcceptor.ValidationIssue _validationIssue = new IValidationIssueAcceptor.ValidationIssue(IValidationIssueAcceptor.ValidationIssue.Severity.ERROR, msg, "IncompatibleTypes");
            acceptor.accept(_validationIssue);
            return;
        }
        this.assertTypeBindingsSame(varResult, valueResult, msg, acceptor);
    }

    public void assertTypeBindingsSame(ITypeSystemInferrer.InferenceResult result1, ITypeSystemInferrer.InferenceResult result2, String msg_finalParam_, IValidationIssueAcceptor acceptor) {
        boolean _tripleNotEquals;
        String msg = msg_finalParam_;
        List<ITypeSystemInferrer.InferenceResult> bindings1 = result1.getBindings();
        List<ITypeSystemInferrer.InferenceResult> bindings2 = result2.getBindings();
        String _xifexpression = null;
        _xifexpression = msg != null ? msg : String.format("Incompatible types %s and %s.", result1, result2);
        msg = _xifexpression;
        int _size = bindings1.size();
        int _size_1 = bindings2.size();
        boolean bl = _tripleNotEquals = _size != _size_1;
        if (_tripleNotEquals) {
            IValidationIssueAcceptor.ValidationIssue _validationIssue = new IValidationIssueAcceptor.ValidationIssue(IValidationIssueAcceptor.ValidationIssue.Severity.ERROR, msg, "IncompatibleTypes");
            acceptor.accept(_validationIssue);
            return;
        }
        int i = 0;
        while (i < bindings1.size()) {
            this.assertSame(bindings1.get(i), bindings2.get(i), msg, acceptor);
            ++i;
        }
    }

    public void assertIsSubType(ITypeSystemInferrer.InferenceResult subResult, ITypeSystemInferrer.InferenceResult superResult, String msg_finalParam_, IValidationIssueAcceptor acceptor) {
        boolean _not;
        String msg = msg_finalParam_;
        if (subResult == null || superResult == null) {
            return;
        }
        boolean _isSuperType = this.registry.isSuperType(subResult.getType(), superResult.getType());
        boolean bl = _not = !_isSuperType;
        if (_not) {
            String _xifexpression = null;
            _xifexpression = msg != null ? msg : String.format("Incompatible types %s and %s.", subResult, superResult);
            msg = _xifexpression;
            IValidationIssueAcceptor.ValidationIssue _validationIssue = new IValidationIssueAcceptor.ValidationIssue(IValidationIssueAcceptor.ValidationIssue.Severity.ERROR, msg, "IncompatibleTypes");
            acceptor.accept(_validationIssue);
        }
    }

    public boolean isNullOnComplexType(ITypeSystemInferrer.InferenceResult result1, ITypeSystemInferrer.InferenceResult result2) {
        return result1.getType() instanceof ComplexType && this.registry.isSame(result2.getType(), this.registry.getType("null"));
    }
}

