/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mita.base.types.resource;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.mita.base.types.EnumerationType;
import org.eclipse.mita.base.types.Package;
import org.eclipse.mita.base.types.TypeAlias;
import org.eclipse.mita.base.types.TypedElement;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.EObjectDescription;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.impl.DefaultResourceDescriptionStrategy;
import org.eclipse.xtext.util.IAcceptor;

public class TypedResourceDescriptionStrategy
extends DefaultResourceDescriptionStrategy {
    public static final String HAS_UNKNOWN_TYPE = "has_unknown_type";
    public static final String IS_VISIBLE_TYPE = "is_visible_type";
    public static final String IS_ALIAS_ON_ENUM = "is_alias_on_enum";
    public static final String HAS_COMPLEX_TYPE = "has_complex_type";

    public boolean createEObjectDescriptions(EObject eObject, IAcceptor<IEObjectDescription> acceptor) {
        if (this.getQualifiedNameProvider() == null) {
            return false;
        }
        try {
            QualifiedName qualifiedName = this.getQualifiedNameProvider().getFullyQualifiedName(eObject);
            if (qualifiedName != null) {
                HashMap userData = Maps.newHashMap();
                this.defineUserData(eObject, userData);
                acceptor.accept((Object)EObjectDescription.create((QualifiedName)qualifiedName, (EObject)eObject, (Map)userData));
            }
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
        return eObject instanceof Package;
    }

    protected void defineUserData(EObject eObject, Map<String, String> userData) {
        if (eObject instanceof TypedElement) {
            userData.put(HAS_UNKNOWN_TYPE, String.valueOf(this.isUnknownType((TypedElement)eObject)));
            userData.put(HAS_COMPLEX_TYPE, String.valueOf(this.hasComplexType((TypedElement)eObject)));
        }
        if (eObject instanceof TypeAlias && ((TypeAlias)eObject).getOriginType() instanceof EnumerationType) {
            userData.put(IS_ALIAS_ON_ENUM, String.valueOf(true));
        }
    }

    protected boolean isUnknownType(TypedElement element) {
        return false;
    }

    protected boolean hasComplexType(TypedElement element) {
        return false;
    }
}

