/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mita.program.generator.transformation;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Consumer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.mita.base.types.inferrer.ITypeSystemInferrer;
import org.eclipse.mita.base.types.typesystem.ITypeSystem;
import org.eclipse.mita.program.AbstractStatement;
import org.eclipse.mita.program.Program;
import org.eclipse.mita.program.ProgramBlock;
import org.eclipse.mita.program.generator.GeneratorUtils;
import org.eclipse.mita.program.generator.internal.ProgramCopier;
import org.eclipse.mita.program.generator.transformation.ITransformationPipelineInfoProvider;
import org.eclipse.xtext.scoping.IScopeProvider;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Procedures;

public abstract class AbstractTransformationStage {
    @Inject
    @Extension
    protected ProgramCopier copier;
    @Inject
    protected ITypeSystemInferrer typeInferrer;
    @Inject
    protected ITypeSystem typeSystem;
    @Inject
    protected IScopeProvider scopeProvider;
    @Inject
    @Extension
    protected GeneratorUtils _generatorUtils;
    protected ITransformationPipelineInfoProvider pipelineInfoProvider;
    private final List<Procedures.Procedure1<? super EObject>> postTransformations = new LinkedList<Procedures.Procedure1<? super EObject>>();
    public static final int ORDER_VERY_EARLY = 100;
    public static final int ORDER_EARLY = 300;
    public static final int ORDER_INBETWEEN = 500;
    public static final int ORDER_LATE = 700;
    public static final int ORDER_VERY_LATE = 900;
    public static final int ORDER_CUSTOM_STUFF = 1100;

    public Program transform(ITransformationPipelineInfoProvider pipeline, Program program) {
        this.pipelineInfoProvider = pipeline;
        this.doTransform((EObject)program);
        this.doPostTransformations(program);
        return program;
    }

    protected void doPostTransformations(final Program program) {
        Consumer<Procedures.Procedure1<? super EObject>> _function = new Consumer<Procedures.Procedure1<? super EObject>>(){

            @Override
            public void accept(Procedures.Procedure1<? super EObject> x) {
                x.apply((Object)program);
            }
        };
        this.postTransformations.forEach(_function);
    }

    public int getOrder() {
        return 1100;
    }

    protected void addPostTransformation(Procedures.Procedure1<? super EObject> func) {
        this.postTransformations.add(func);
    }

    protected void _doTransform(EObject obj) {
        this.transformChildren(obj);
    }

    protected void transformChildren(EObject obj) {
        EList _eContents = obj.eContents();
        for (EObject child : _eContents) {
            this.doTransform(child);
        }
    }

    protected void insertNextToParentBlock(EObject context, boolean insertBefore, AbstractStatement ... content) {
        ProgramBlock block = null;
        EObject current = context;
        while (block == null && current != null) {
            EObject parent = current.eContainer();
            if (parent instanceof ProgramBlock) {
                block = (ProgramBlock)parent;
                continue;
            }
            current = parent;
        }
        if (block != null && current != null) {
            int insertionPosition = block.getContent().indexOf((Object)current);
            if (insertBefore) {
                block.getContent().addAll(insertionPosition, (Collection)Conversions.doWrapArray((Object)content));
            } else {
                block.getContent().addAll(insertionPosition + 1, (Collection)Conversions.doWrapArray((Object)content));
            }
        }
    }

    protected int findPositionOfAncestor(ProgramBlock block, EObject ref) {
        int _xblockexpression = 0;
        EObject refAncestor = null;
        EObject current = ref;
        boolean _while = current != null && refAncestor == null;
        while (_while) {
            boolean _equals;
            EObject _eContainer = null;
            if (current != null) {
                _eContainer = current.eContainer();
            }
            if (_equals = Objects.equal((Object)_eContainer, (Object)block)) {
                refAncestor = current;
            }
            EObject _eContainer_1 = null;
            if (current != null) {
                _eContainer_1 = current.eContainer();
            }
            boolean bl = _while = (current = _eContainer_1) != null && refAncestor == null;
        }
        int _xifexpression = 0;
        if (refAncestor == null) {
            return -1;
        }
        _xblockexpression = _xifexpression = block.getContent().indexOf(refAncestor);
        return _xblockexpression;
    }

    protected void replaceWith(EObject target, EObject replacement) {
        EObject container = target.eContainer();
        if (container == null) {
            return;
        }
        this.copier.linkOrigin(replacement, target);
        boolean _isMany = target.eContainingFeature().isMany();
        if (_isMany) {
            Object _eGet = container.eGet((EStructuralFeature)target.eContainmentFeature());
            List containerList = (List)_eGet;
            int index = containerList.indexOf(target);
            if (index < 0) {
                return;
            }
            containerList.set(index, replacement);
        } else {
            container.eSet(target.eContainingFeature(), (Object)replacement);
        }
    }

    protected void doTransform(EObject obj) {
        this._doTransform(obj);
    }
}

