/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mita.program.generator.internal;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.inject.Inject;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.mita.base.expressions.ElementReferenceExpression;
import org.eclipse.mita.base.types.EnumerationType;
import org.eclipse.mita.base.types.PackageAssociation;
import org.eclipse.mita.base.types.StructureType;
import org.eclipse.mita.base.types.SumType;
import org.eclipse.mita.platform.SystemSpecification;
import org.eclipse.mita.program.EventHandlerDeclaration;
import org.eclipse.mita.program.FunctionDefinition;
import org.eclipse.mita.program.NativeFunctionDefinition;
import org.eclipse.mita.program.Program;
import org.eclipse.mita.program.VariableDeclaration;
import org.eclipse.mita.program.generator.CodeFragment;
import org.eclipse.mita.program.generator.CodeFragmentProvider;
import org.eclipse.mita.program.generator.CompilationContext;
import org.eclipse.mita.program.generator.GeneratorUtils;
import org.eclipse.mita.program.generator.IPlatformEventLoopGenerator;
import org.eclipse.mita.program.generator.IPlatformExceptionGenerator;
import org.eclipse.mita.program.generator.StatementGenerator;
import org.eclipse.mita.program.generator.internal.ProgramCopier;
import org.eclipse.xtend2.lib.StringConcatenationClient;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.generator.trace.node.CompositeGeneratorNode;
import org.eclipse.xtext.generator.trace.node.IGeneratorNode;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

public class UserCodeFileGenerator {
    @Inject
    @Extension
    protected GeneratorUtils _generatorUtils;
    @Inject
    @Extension
    protected ProgramCopier _programCopier;
    @Inject(optional=true)
    protected IPlatformEventLoopGenerator eventLoopGenerator;
    @Inject(optional=true)
    protected IPlatformExceptionGenerator exceptionGenerator;
    @Inject
    protected CodeFragmentProvider codeFragmentProvider;
    @Inject
    protected StatementGenerator statementGenerator;

    public CompositeGeneratorNode generateHeader(CompilationContext context, final Program program) {
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                Iterable _filter = Iterables.filter(program.getFunctionDefinitions(), FunctionDefinition.class);
                for (FunctionDefinition function : _filter) {
                    IGeneratorNode _header = UserCodeFileGenerator.this.statementGenerator.header((EObject)function);
                    _builder.append((Object)_header);
                    _builder.newLineIfNotEmpty();
                }
                CodeFragment _exceptionType = UserCodeFileGenerator.this.exceptionGenerator.getExceptionType();
                _builder.append((Object)_exceptionType);
                _builder.append((Object)" ");
                String _globalInitName = UserCodeFileGenerator.this._generatorUtils.getGlobalInitName(program);
                _builder.append((Object)_globalInitName);
                _builder.append((Object)"();");
                _builder.newLineIfNotEmpty();
            }
        };
        CodeFragment _create = this.codeFragmentProvider.create(_client);
        String _resourceTypesName = UserCodeFileGenerator.getResourceTypesName(program);
        String _plus = String.valueOf(_resourceTypesName) + ".h";
        CodeFragment _addHeader = _create.addHeader(_plus, false);
        String _upperCase = UserCodeFileGenerator.getResourceBaseName(program).toUpperCase();
        String _plus_1 = String.valueOf(_upperCase) + "_H";
        return _addHeader.toHeader(context, _plus_1);
    }

    public CompositeGeneratorNode generateTypes(CompilationContext context, Program program) {
        return this.generateTypes(context, program, (Iterable<? extends EObject>)program.getTypes());
    }

    public CompositeGeneratorNode generateTypes(CompilationContext context, SystemSpecification platform) {
        return this.generateTypes(context, (PackageAssociation)platform, (Iterable<? extends EObject>)platform.getTypes());
    }

    public CompositeGeneratorNode generateTypes(CompilationContext context, PackageAssociation rootElement, final Iterable<? extends EObject> types) {
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                Iterable _filter = Iterables.filter((Iterable)types, StructureType.class);
                for (StructureType struct : _filter) {
                    IGeneratorNode _header = UserCodeFileGenerator.this.statementGenerator.header((EObject)struct);
                    _builder.append((Object)_header);
                    _builder.newLineIfNotEmpty();
                }
                _builder.newLine();
                Iterable _filter_1 = Iterables.filter((Iterable)types, EnumerationType.class);
                for (EnumerationType enumType : _filter_1) {
                    IGeneratorNode _header_1 = UserCodeFileGenerator.this.statementGenerator.header((EObject)enumType);
                    _builder.append((Object)_header_1);
                    _builder.newLineIfNotEmpty();
                }
                _builder.newLine();
                Iterable _filter_2 = Iterables.filter((Iterable)types, SumType.class);
                for (SumType sumType : _filter_2) {
                    IGeneratorNode _header_2 = UserCodeFileGenerator.this.statementGenerator.header((EObject)sumType);
                    _builder.append((Object)_header_2);
                    _builder.newLineIfNotEmpty();
                }
            }
        };
        CodeFragment _create = this.codeFragmentProvider.create(_client);
        String _upperCase = UserCodeFileGenerator.getResourceTypesName(rootElement).toUpperCase();
        String _plus = String.valueOf(_upperCase) + "_H";
        return _create.toHeader(context, _plus);
    }

    public CompositeGeneratorNode generateImplementation(final CompilationContext context, final Program program) {
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                CodeFragment _generateGlobalVariables = UserCodeFileGenerator.this.generateGlobalVariables(program);
                _builder.append((Object)_generateGlobalVariables);
                _builder.newLineIfNotEmpty();
                _builder.newLine();
                CodeFragment _generateEventHandlers = UserCodeFileGenerator.this.generateEventHandlers(context, program);
                _builder.append((Object)_generateEventHandlers);
                _builder.newLineIfNotEmpty();
                CodeFragment _generateFunctions = UserCodeFileGenerator.this.generateFunctions(program);
                _builder.append((Object)_generateFunctions);
                _builder.newLineIfNotEmpty();
            }
        };
        CodeFragment _create = this.codeFragmentProvider.create(_client);
        String _resourceBaseName = UserCodeFileGenerator.getResourceBaseName(program);
        String _plus = String.valueOf(_resourceBaseName) + ".h";
        return _create.addHeader(_plus, false).addHeader((CodeFragment.IncludePath[])Conversions.unwrapArray(this.getContextIncludes(context, program), CodeFragment.IncludePath.class)).toImplementation(context);
    }

    public static String getResourceBaseName(PackageAssociation program) {
        Resource resource = ProgramCopier.getOrigin((EObject)program).eResource();
        String _last = (String)IterableExtensions.last((Iterable)((Iterable)Conversions.doWrapArray((Object)resource.getURI().segments())));
        String _fileExtension = resource.getURI().fileExtension();
        String _plus = "." + _fileExtension;
        return _last.replace(_plus, "");
    }

    public static String getResourceTypesName(PackageAssociation program) {
        String _resourceBaseName = UserCodeFileGenerator.getResourceBaseName(program);
        return String.valueOf(_resourceBaseName) + "Types";
    }

    protected Iterable<CodeFragment.IncludePath> getContextIncludes(final CompilationContext context, final Program program) {
        Iterable _xblockexpression = null;
        List allrefs = IteratorExtensions.toList((Iterator)Iterators.filter((Iterator)program.eAllContents(), ElementReferenceExpression.class));
        Functions.Function1<ElementReferenceExpression, Program> _function = new Functions.Function1<ElementReferenceExpression, Program>(){

            public Program apply(ElementReferenceExpression it) {
                return (Program)EcoreUtil2.getContainerOfType((EObject)it.getReference(), Program.class);
            }
        };
        List allprogs = IterableExtensions.toList((Iterable)ListExtensions.map((List)allrefs, (Functions.Function1)_function));
        Functions.Function1<Program, Boolean> _function_1 = new Functions.Function1<Program, Boolean>(){

            public Boolean apply(final Program p) {
                return !Objects.equal((Object)p, (Object)program) && IterableExtensions.exists(context.getAllUnits(), (Functions.Function1)new Functions.Function1<Program, Boolean>(){

                    public Boolean apply(Program pu) {
                        EObject _origin = ProgramCopier.getOrigin((EObject)pu);
                        return Objects.equal((Object)_origin, (Object)p);
                    }
                });
            }
        };
        List allintprogs = IterableExtensions.toList((Iterable)IterableExtensions.filter((Iterable)allprogs, (Functions.Function1)_function_1));
        Functions.Function1<Program, String> _function_2 = new Functions.Function1<Program, String>(){

            public String apply(Program it) {
                String _resourceBaseName = UserCodeFileGenerator.getResourceBaseName(it);
                return String.valueOf(_resourceBaseName) + ".h";
            }
        };
        Functions.Function1<String, CodeFragment.IncludePath> _function_3 = new Functions.Function1<String, CodeFragment.IncludePath>(){

            public CodeFragment.IncludePath apply(String it) {
                return new CodeFragment.IncludePath(it, false);
            }
        };
        _xblockexpression = IterableExtensions.map((Iterable)IterableExtensions.toSet((Iterable)ListExtensions.map((List)allintprogs, (Functions.Function1)_function_2)), (Functions.Function1)_function_3);
        return _xblockexpression;
    }

    public CodeFragment generateGlobalVariables(final Program program) {
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                EList<VariableDeclaration> _globalVariables = program.getGlobalVariables();
                for (VariableDeclaration variable : _globalVariables) {
                    IGeneratorNode _code = UserCodeFileGenerator.this.statementGenerator.code(variable);
                    _builder.append((Object)_code);
                    _builder.newLineIfNotEmpty();
                }
                _builder.newLine();
                CodeFragment _exceptionType = UserCodeFileGenerator.this.exceptionGenerator.getExceptionType();
                _builder.append((Object)_exceptionType);
                _builder.append((Object)" ");
                String _globalInitName = UserCodeFileGenerator.this._generatorUtils.getGlobalInitName(program);
                _builder.append((Object)_globalInitName);
                _builder.append((Object)"() {");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t");
                CodeFragment _exceptionType_1 = UserCodeFileGenerator.this.exceptionGenerator.getExceptionType();
                _builder.append((Object)_exceptionType_1, "\t");
                _builder.append((Object)" exception = ");
                CodeFragment _noExceptionStatement = UserCodeFileGenerator.this.exceptionGenerator.getNoExceptionStatement();
                _builder.append((Object)_noExceptionStatement, "\t");
                _builder.append((Object)";");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t");
                _builder.newLine();
                EList<VariableDeclaration> _globalVariables_1 = program.getGlobalVariables();
                for (VariableDeclaration variable_1 : _globalVariables_1) {
                    _builder.append((Object)"\t");
                    IGeneratorNode _initializationCode = UserCodeFileGenerator.this.statementGenerator.initializationCode(variable_1);
                    _builder.append((Object)_initializationCode, "\t");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t");
                    CharSequence _generateExceptionHandler = UserCodeFileGenerator.this._generatorUtils.generateExceptionHandler(null, "exception");
                    _builder.append((Object)_generateExceptionHandler, "\t");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t");
                    _builder.newLine();
                }
                _builder.append((Object)"\t");
                _builder.append((Object)"return exception;");
                _builder.newLine();
                _builder.append((Object)"}");
                _builder.newLine();
            }
        };
        return this.codeFragmentProvider.create(_client);
    }

    private CodeFragment generateEventHandlers(final CompilationContext context, final Program program) {
        final CodeFragment exceptionType = this.exceptionGenerator.getExceptionType();
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                EList<EventHandlerDeclaration> _eventHandlers = program.getEventHandlers();
                for (EventHandlerDeclaration handler : _eventHandlers) {
                    _builder.append((Object)exceptionType);
                    _builder.append((Object)" ");
                    String _handlerName = UserCodeFileGenerator.this._generatorUtils.getHandlerName(handler);
                    _builder.append((Object)_handlerName);
                    _builder.append((Object)"(");
                    CodeFragment _generateEventLoopHandlerSignature = UserCodeFileGenerator.this.eventLoopGenerator.generateEventLoopHandlerSignature(context);
                    _builder.append((Object)_generateEventLoopHandlerSignature);
                    _builder.append((Object)")");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"{");
                    _builder.newLine();
                    _builder.append((Object)"\t");
                    _builder.newLine();
                    _builder.append((Object)"\t");
                    CodeFragment _generateEventLoopHandlerPreamble = UserCodeFileGenerator.this.eventLoopGenerator.generateEventLoopHandlerPreamble(context, handler);
                    _builder.append((Object)_generateEventLoopHandlerPreamble, "\t");
                    _builder.newLineIfNotEmpty();
                    IGeneratorNode _noBraces = UserCodeFileGenerator.this._generatorUtils.noBraces(UserCodeFileGenerator.this.statementGenerator.code(handler.getBlock()));
                    _builder.append((Object)_noBraces);
                    _builder.append((Object)" ");
                    _builder.newLineIfNotEmpty();
                    _builder.newLine();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"return NO_EXCEPTION;");
                    _builder.newLine();
                    _builder.append((Object)"}");
                    _builder.newLine();
                    _builder.newLine();
                }
            }
        };
        return this.codeFragmentProvider.create(_client).addHeader("MitaExceptions.h", false);
    }

    private CodeFragment generateFunctions(final Program program) {
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                Iterable _filter = Iterables.filter(program.getFunctionDefinitions(), FunctionDefinition.class);
                for (FunctionDefinition function : _filter) {
                    IGeneratorNode _code = UserCodeFileGenerator.this.statementGenerator.code((EObject)function);
                    _builder.append((Object)_code);
                    _builder.newLineIfNotEmpty();
                    _builder.newLine();
                }
                Iterable _filter_1 = Iterables.filter(program.getFunctionDefinitions(), NativeFunctionDefinition.class);
                for (NativeFunctionDefinition function_1 : _filter_1) {
                    StringConcatenationClient _client = new StringConcatenationClient(){

                        protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                        }
                    };
                    CodeFragment _addHeader = UserCodeFileGenerator.this.codeFragmentProvider.create(_client).addHeader(function_1.getHeader(), true, 0);
                    _builder.append((Object)_addHeader);
                    _builder.newLineIfNotEmpty();
                }
            }
        };
        return this.codeFragmentProvider.create(_client);
    }
}

